/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.jcajce.spec.McElieceKeyGenParameterSpec;

public class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    McElieceKeyPairGenerator kpg;

    public McElieceKeyPairGeneratorSpi() {
        super("McEliece");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceKeyPairGenerator();
        super.initialize(algorithmParameterSpec);
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = (McElieceKeyGenParameterSpec)algorithmParameterSpec;
        McElieceKeyGenerationParameters mcElieceKeyGenerationParameters = new McElieceKeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new McElieceParameters(mcElieceKeyGenParameterSpec.getM(), mcElieceKeyGenParameterSpec.getT()));
        this.kpg.init(mcElieceKeyGenerationParameters);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        McElieceKeyGenParameterSpec mcElieceKeyGenParameterSpec = new McElieceKeyGenParameterSpec();
        try {
            this.initialize(mcElieceKeyGenParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
        McEliecePrivateKeyParameters mcEliecePrivateKeyParameters = (McEliecePrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        McEliecePublicKeyParameters mcEliecePublicKeyParameters = (McEliecePublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        return new KeyPair(new BCMcEliecePublicKey(mcEliecePublicKeyParameters), new BCMcEliecePrivateKey(mcEliecePrivateKeyParameters));
    }
}

