/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece;

import java.security.SecureRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.Digest;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.digests.SHA1Digest;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithRandom;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.prng.DigestRandomGenerator;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.MessageEncryptor;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.Conversions;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Primitives;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.crypto.mceliece.Utils;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import macromedia.oracleutil.externals.org.bouncycastle.pqc.math.linearalgebra.GF2Vector;

public class McElieceFujisakiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.1";
    private static final String DEFAULT_PRNG_NAME = "SHA1PRNG";
    private Digest messDigest;
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    McElieceCCA2KeyParameters key;
    private boolean forEncryption;

    public void init(boolean bl2, dda dda2) {
        this.forEncryption = bl2;
        if (bl2) {
            if (dda2 instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)dda2;
                this.sr = parametersWithRandom.getRandom();
                this.key = (McElieceCCA2PublicKeyParameters)parametersWithRandom.getParameters();
                McElieceFujisakiCipher mcElieceFujisakiCipher = this;
                mcElieceFujisakiCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)mcElieceFujisakiCipher.key);
            } else {
                this.sr = CryptoServicesRegistrar.getSecureRandom();
                this.key = (McElieceCCA2PublicKeyParameters)dda2;
                McElieceFujisakiCipher mcElieceFujisakiCipher = this;
                mcElieceFujisakiCipher.initCipherEncrypt((McElieceCCA2PublicKeyParameters)mcElieceFujisakiCipher.key);
            }
        } else {
            this.key = (McElieceCCA2PrivateKeyParameters)dda2;
            McElieceFujisakiCipher mcElieceFujisakiCipher = this;
            mcElieceFujisakiCipher.initCipherDecrypt((McElieceCCA2PrivateKeyParameters)mcElieceFujisakiCipher.key);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters mcElieceCCA2KeyParameters) throws IllegalArgumentException {
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        if (mcElieceCCA2KeyParameters instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)mcElieceCCA2KeyParameters).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private final void initCipherEncrypt(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.sr = this.sr != null ? this.sr : CryptoServicesRegistrar.getSecureRandom();
        this.messDigest = Utils.getDigest(mcElieceCCA2PublicKeyParameters.getDigest());
        this.n = mcElieceCCA2PublicKeyParameters.getN();
        this.k = mcElieceCCA2PublicKeyParameters.getK();
        this.t = mcElieceCCA2PublicKeyParameters.getT();
    }

    private final void initCipherDecrypt(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.messDigest = Utils.getDigest(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.n = mcElieceCCA2PrivateKeyParameters.getN();
        this.t = mcElieceCCA2PrivateKeyParameters.getT();
    }

    public byte[] messageEncrypt(byte[] byArray) {
        if (!this.forEncryption) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        GF2Vector gF2Vector = new GF2Vector(this.k, this.sr);
        byte[] byArray2 = gF2Vector.getEncoded();
        byte[] byArray3 = ByteUtils.concatenate(byArray2, byArray);
        this.messDigest.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(byArray4, 0);
        GF2Vector gF2Vector2 = Conversions.encode(this.n, this.t, byArray4);
        byte[] byArray5 = McElieceCCA2Primitives.encryptionPrimitive((McElieceCCA2PublicKeyParameters)this.key, gF2Vector, gF2Vector2).getEncoded();
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray2);
        byte[] byArray6 = new byte[byArray.length];
        digestRandomGenerator.nextBytes(byArray6);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2;
            byArray6[n2] = (byte)(byArray6[n2] ^ byArray[i2]);
        }
        return ByteUtils.concatenate(byArray5, byArray6);
    }

    public byte[] messageDecrypt(byte[] byArray) throws InvalidCipherTextException {
        if (this.forEncryption) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.n + 7 >> 3;
        int n3 = byArray.length - n2;
        byte[][] byArray2 = ByteUtils.split(byArray, n2);
        byte[] byArray3 = byArray2[0];
        byte[] byArray4 = byArray2[1];
        GF2Vector gF2Vector = GF2Vector.OS2VP(this.n, byArray3);
        GF2Vector[] gF2VectorArray = McElieceCCA2Primitives.decryptionPrimitive((McElieceCCA2PrivateKeyParameters)this.key, gF2Vector);
        byte[] byArray5 = gF2VectorArray[0].getEncoded();
        GF2Vector gF2Vector2 = gF2VectorArray[1];
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray5);
        byte[] byArray6 = new byte[n3];
        digestRandomGenerator.nextBytes(byArray6);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            byArray6[n4] = (byte)(byArray6[n4] ^ byArray4[i2]);
        }
        byte[] byArray7 = ByteUtils.concatenate(byArray5, byArray6);
        byte[] byArray8 = new byte[this.messDigest.getDigestSize()];
        this.messDigest.update(byArray7, 0, byArray7.length);
        this.messDigest.doFinal(byArray8, 0);
        gF2Vector = Conversions.encode(this.n, this.t, byArray8);
        if (!gF2Vector.equals(gF2Vector2)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return byArray6;
    }
}

