/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.math.ec;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.AbstractECMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.PreCompCallback;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.Tnaf;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.WTauNafPreCompInfo;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ZTauElement;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.dda;

public class WTauNafMultiplier
extends AbstractECMultiplier {
    static final String PRECOMP_NAME = "bc_wtnaf";

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (!(eCPoint instanceof ECPoint.AbstractF2m)) {
            throw new IllegalArgumentException("Only ECPoint.AbstractF2m can be used in WTauNafMultiplier");
        }
        ECPoint.AbstractF2m abstractF2m = (ECPoint.AbstractF2m)eCPoint;
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        int n2 = abstractF2m2.getFieldSize();
        byte by2 = abstractF2m2.getA().toBigInteger().byteValue();
        byte by3 = Tnaf.getMu(by2);
        BigInteger[] bigIntegerArray = abstractF2m2.getSi();
        ZTauElement zTauElement = Tnaf.partModReduction(bigInteger, n2, by2, bigIntegerArray, by3, (byte)10);
        return this.multiplyWTnaf(abstractF2m, zTauElement, by2, by3);
    }

    private final ECPoint.AbstractF2m multiplyWTnaf(ECPoint.AbstractF2m abstractF2m, ZTauElement zTauElement, byte by2, byte by3) {
        ZTauElement[] zTauElementArray = by2 == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger bigInteger = Tnaf.getTw(by3, 4);
        byte[] byArray = Tnaf.tauAdicWNaf(by3, zTauElement, (byte)4, BigInteger.valueOf(16L), bigInteger, zTauElementArray);
        return WTauNafMultiplier.multiplyFromWTnaf(abstractF2m, byArray);
    }

    private static ECPoint.AbstractF2m multiplyFromWTnaf(final ECPoint.AbstractF2m abstractF2m, byte[] byArray) {
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        final byte by2 = abstractF2m2.getA().toBigInteger().byteValue();
        WTauNafPreCompInfo wTauNafPreCompInfo = (WTauNafPreCompInfo)abstractF2m2.precompute(abstractF2m, PRECOMP_NAME, new PreCompCallback(){

            public dda precompute(dda dda2) {
                if (dda2 instanceof WTauNafPreCompInfo) {
                    return dda2;
                }
                WTauNafPreCompInfo wTauNafPreCompInfo = new WTauNafPreCompInfo();
                wTauNafPreCompInfo.setPreComp(Tnaf.getPreComp(abstractF2m, by2));
                return wTauNafPreCompInfo;
            }
        });
        ECPoint.AbstractF2m[] abstractF2mArray = wTauNafPreCompInfo.getPreComp();
        ECPoint.AbstractF2m[] abstractF2mArray2 = new ECPoint.AbstractF2m[abstractF2mArray.length];
        for (int i2 = 0; i2 < abstractF2mArray.length; ++i2) {
            abstractF2mArray2[i2] = (ECPoint.AbstractF2m)abstractF2mArray[i2].negate();
        }
        ECPoint.AbstractF2m abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m.getCurve().getInfinity();
        int n2 = 0;
        for (int i3 = byArray.length - 1; i3 >= 0; --i3) {
            ++n2;
            byte by3 = byArray[i3];
            if (by3 == 0) continue;
            abstractF2m3 = abstractF2m3.tauPow(n2);
            n2 = 0;
            ECPoint.AbstractF2m abstractF2m4 = by3 > 0 ? abstractF2mArray[by3 >>> 1] : abstractF2mArray2[-by3 >>> 1];
            abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m3.add(abstractF2m4);
        }
        if (n2 > 0) {
            abstractF2m3 = abstractF2m3.tauPow(n2);
        }
        return abstractF2m3;
    }
}

