/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.math.ec;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.SimpleBigDecimal;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ZTauElement;

class Tnaf {
    private static final BigInteger MINUS_ONE = ECConstants.ONE.negate();
    private static final BigInteger MINUS_TWO = ECConstants.TWO.negate();
    private static final BigInteger MINUS_THREE = ECConstants.THREE.negate();
    public static final byte WIDTH = 4;
    public static final byte POW_2_WIDTH = 16;
    public static final ZTauElement[] alpha0;
    public static final byte[][] alpha0Tnaf;
    public static final ZTauElement[] alpha1;
    public static final byte[][] alpha1Tnaf;

    Tnaf() {
    }

    public static BigInteger norm(byte by2, ZTauElement zTauElement) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = zTauElement.u;
        BigInteger bigInteger3 = bigInteger2.multiply(bigInteger2);
        BigInteger bigInteger4 = zTauElement.u.multiply(zTauElement.v);
        BigInteger bigInteger5 = zTauElement.v;
        BigInteger bigInteger6 = bigInteger5.multiply(bigInteger5).shiftLeft(1);
        if (by2 == 1) {
            bigInteger = bigInteger3.add(bigInteger4).add(bigInteger6);
        } else if (by2 == -1) {
            bigInteger = bigInteger3.subtract(bigInteger4).add(bigInteger6);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return bigInteger;
    }

    public static SimpleBigDecimal norm(byte by2, SimpleBigDecimal simpleBigDecimal, SimpleBigDecimal simpleBigDecimal2) {
        SimpleBigDecimal simpleBigDecimal3;
        SimpleBigDecimal simpleBigDecimal4 = simpleBigDecimal;
        SimpleBigDecimal simpleBigDecimal5 = simpleBigDecimal4.multiply(simpleBigDecimal4);
        SimpleBigDecimal simpleBigDecimal6 = simpleBigDecimal.multiply(simpleBigDecimal2);
        SimpleBigDecimal simpleBigDecimal7 = simpleBigDecimal2;
        SimpleBigDecimal simpleBigDecimal8 = simpleBigDecimal7.multiply(simpleBigDecimal7).shiftLeft(1);
        if (by2 == 1) {
            simpleBigDecimal3 = simpleBigDecimal5.add(simpleBigDecimal6).add(simpleBigDecimal8);
        } else if (by2 == -1) {
            simpleBigDecimal3 = simpleBigDecimal5.subtract(simpleBigDecimal6).add(simpleBigDecimal8);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return simpleBigDecimal3;
    }

    public static ZTauElement round(SimpleBigDecimal simpleBigDecimal, SimpleBigDecimal simpleBigDecimal2, byte by2) {
        SimpleBigDecimal simpleBigDecimal3;
        SimpleBigDecimal simpleBigDecimal4;
        int n2 = simpleBigDecimal.getScale();
        if (simpleBigDecimal2.getScale() != n2) {
            throw new IllegalArgumentException("lambda0 and lambda1 do not have same scale");
        }
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger bigInteger = simpleBigDecimal.round();
        BigInteger bigInteger2 = simpleBigDecimal2.round();
        SimpleBigDecimal simpleBigDecimal5 = simpleBigDecimal.subtract(bigInteger);
        SimpleBigDecimal simpleBigDecimal6 = simpleBigDecimal2.subtract(bigInteger2);
        SimpleBigDecimal simpleBigDecimal7 = simpleBigDecimal5;
        SimpleBigDecimal simpleBigDecimal8 = simpleBigDecimal7.add(simpleBigDecimal7);
        simpleBigDecimal8 = by2 == 1 ? simpleBigDecimal8.add(simpleBigDecimal6) : simpleBigDecimal8.subtract(simpleBigDecimal6);
        SimpleBigDecimal simpleBigDecimal9 = simpleBigDecimal6;
        SimpleBigDecimal simpleBigDecimal10 = simpleBigDecimal9.add(simpleBigDecimal9).add(simpleBigDecimal6);
        SimpleBigDecimal simpleBigDecimal11 = simpleBigDecimal10.add(simpleBigDecimal6);
        if (by2 == 1) {
            simpleBigDecimal4 = simpleBigDecimal5.subtract(simpleBigDecimal10);
            simpleBigDecimal3 = simpleBigDecimal5.add(simpleBigDecimal11);
        } else {
            simpleBigDecimal4 = simpleBigDecimal5.add(simpleBigDecimal10);
            simpleBigDecimal3 = simpleBigDecimal5.subtract(simpleBigDecimal11);
        }
        int n3 = 0;
        byte by3 = 0;
        if (simpleBigDecimal8.compareTo(ECConstants.ONE) >= 0) {
            if (simpleBigDecimal4.compareTo(MINUS_ONE) < 0) {
                by3 = by2;
            } else {
                n3 = 1;
            }
        } else if (simpleBigDecimal3.compareTo(ECConstants.TWO) >= 0) {
            by3 = by2;
        }
        if (simpleBigDecimal8.compareTo(MINUS_ONE) < 0) {
            if (simpleBigDecimal4.compareTo(ECConstants.ONE) >= 0) {
                by3 = -by2;
            } else {
                n3 = -1;
            }
        } else if (simpleBigDecimal3.compareTo(MINUS_TWO) < 0) {
            by3 = -by2;
        }
        BigInteger bigInteger3 = bigInteger.add(BigInteger.valueOf(n3));
        BigInteger bigInteger4 = bigInteger2.add(BigInteger.valueOf(by3));
        return new ZTauElement(bigInteger3, bigInteger4);
    }

    public static SimpleBigDecimal approximateDivisionByN(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte by2, int n2, int n3) {
        int n4 = (n2 + 5) / 2 + n3;
        BigInteger bigInteger4 = bigInteger.shiftRight(n2 - n4 - 2 + by2);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger5.shiftRight(n2);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger5.add(bigInteger7);
        BigInteger bigInteger9 = bigInteger8.shiftRight(n4 - n3);
        if (bigInteger8.testBit(n4 - n3 - 1)) {
            bigInteger9 = bigInteger9.add(ECConstants.ONE);
        }
        return new SimpleBigDecimal(bigInteger9, n3);
    }

    public static byte[] tauAdicNaf(byte by2, ZTauElement zTauElement) {
        Object object;
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger bigInteger = Tnaf.norm(by2, zTauElement);
        int n2 = bigInteger.bitLength();
        int n3 = n2 > 30 ? n2 + 4 : 34;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        BigInteger bigInteger2 = zTauElement.u;
        BigInteger bigInteger3 = zTauElement.v;
        while (!bigInteger2.equals(ECConstants.ZERO) || !bigInteger3.equals(ECConstants.ZERO)) {
            if (bigInteger2.testBit(0)) {
                byArray[n4] = (byte)ECConstants.TWO.subtract(bigInteger2.subtract(bigInteger3.shiftLeft(1)).mod(ECConstants.FOUR)).intValue();
                bigInteger2 = byArray[n4] == 1 ? bigInteger2.clearBit(0) : bigInteger2.add(ECConstants.ONE);
                n5 = n4;
            } else {
                byArray[n4] = 0;
            }
            object = bigInteger2;
            BigInteger bigInteger4 = bigInteger2.shiftRight(1);
            bigInteger2 = by2 == 1 ? bigInteger3.add(bigInteger4) : bigInteger3.subtract(bigInteger4);
            bigInteger3 = ((BigInteger)object).shiftRight(1).negate();
            ++n4;
        }
        object = new byte[++n5];
        System.arraycopy(byArray, 0, object, 0, n5);
        return object;
    }

    public static ECPoint.AbstractF2m tau(ECPoint.AbstractF2m abstractF2m) {
        return abstractF2m.tau();
    }

    public static byte getMu(ECCurve.AbstractF2m abstractF2m) {
        if (!abstractF2m.isKoblitz()) {
            throw new IllegalArgumentException("No Koblitz curve (ABC), TNAF multiplication not possible");
        }
        if (abstractF2m.getA().isZero()) {
            return -1;
        }
        return 1;
    }

    public static byte getMu(ECFieldElement eCFieldElement) {
        return (byte)(eCFieldElement.isZero() ? -1 : 1);
    }

    public static byte getMu(int n2) {
        return (byte)(n2 == 0 ? -1 : 1);
    }

    public static BigInteger[] getLucas(byte by2, int n2, boolean bl2) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        if (bl2) {
            bigInteger2 = ECConstants.TWO;
            bigInteger = BigInteger.valueOf(by2);
        } else {
            bigInteger2 = ECConstants.ZERO;
            bigInteger = ECConstants.ONE;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            BigInteger bigInteger3 = null;
            bigInteger3 = by2 == 1 ? bigInteger : bigInteger.negate();
            BigInteger bigInteger4 = bigInteger3.subtract(bigInteger2.shiftLeft(1));
            bigInteger2 = bigInteger;
            bigInteger = bigInteger4;
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger2, bigInteger};
        return bigIntegerArray;
    }

    public static BigInteger getTw(byte by2, int n2) {
        if (n2 == 4) {
            if (by2 == 1) {
                return BigInteger.valueOf(6L);
            }
            return BigInteger.valueOf(10L);
        }
        BigInteger[] bigIntegerArray = Tnaf.getLucas(by2, n2, false);
        BigInteger bigInteger = ECConstants.ZERO.setBit(n2);
        BigInteger bigInteger2 = bigIntegerArray[1].modInverse(bigInteger);
        BigInteger bigInteger3 = ECConstants.TWO.multiply(bigIntegerArray[0]).multiply(bigInteger2).mod(bigInteger);
        return bigInteger3;
    }

    public static BigInteger[] getSi(ECCurve.AbstractF2m abstractF2m) {
        if (!abstractF2m.isKoblitz()) {
            throw new IllegalArgumentException("si is defined for Koblitz curves only");
        }
        int n2 = abstractF2m.getFieldSize();
        int n3 = abstractF2m.getA().toBigInteger().intValue();
        byte by2 = Tnaf.getMu(n3);
        int n4 = Tnaf.getShiftsForCofactor(abstractF2m.getCofactor());
        int n5 = n2 + 3 - n3;
        BigInteger[] bigIntegerArray = Tnaf.getLucas(by2, n5, false);
        if (by2 == 1) {
            bigIntegerArray[0] = bigIntegerArray[0].negate();
            bigIntegerArray[1] = bigIntegerArray[1].negate();
        }
        BigInteger bigInteger = ECConstants.ONE.add(bigIntegerArray[1]).shiftRight(n4);
        BigInteger bigInteger2 = ECConstants.ONE.add(bigIntegerArray[0]).shiftRight(n4).negate();
        return new BigInteger[]{bigInteger, bigInteger2};
    }

    public static BigInteger[] getSi(int n2, int n3, BigInteger bigInteger) {
        byte by2 = Tnaf.getMu(n3);
        int n4 = Tnaf.getShiftsForCofactor(bigInteger);
        int n5 = n2 + 3 - n3;
        BigInteger[] bigIntegerArray = Tnaf.getLucas(by2, n5, false);
        if (by2 == 1) {
            bigIntegerArray[0] = bigIntegerArray[0].negate();
            bigIntegerArray[1] = bigIntegerArray[1].negate();
        }
        BigInteger bigInteger2 = ECConstants.ONE.add(bigIntegerArray[1]).shiftRight(n4);
        BigInteger bigInteger3 = ECConstants.ONE.add(bigIntegerArray[0]).shiftRight(n4).negate();
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    protected static int getShiftsForCofactor(BigInteger bigInteger) {
        if (bigInteger != null) {
            if (bigInteger.equals(ECConstants.TWO)) {
                return 1;
            }
            if (bigInteger.equals(ECConstants.FOUR)) {
                return 2;
            }
        }
        throw new IllegalArgumentException("h (Cofactor) must be 2 or 4");
    }

    public static ZTauElement partModReduction(BigInteger bigInteger, int n2, byte by2, BigInteger[] bigIntegerArray, byte by3, byte by4) {
        BigInteger bigInteger2 = by3 == 1 ? bigIntegerArray[0].add(bigIntegerArray[1]) : bigIntegerArray[0].subtract(bigIntegerArray[1]);
        BigInteger[] bigIntegerArray2 = Tnaf.getLucas(by3, n2, true);
        BigInteger bigInteger3 = bigIntegerArray2[1];
        SimpleBigDecimal simpleBigDecimal = Tnaf.approximateDivisionByN(bigInteger, bigIntegerArray[0], bigInteger3, by2, n2, by4);
        SimpleBigDecimal simpleBigDecimal2 = Tnaf.approximateDivisionByN(bigInteger, bigIntegerArray[1], bigInteger3, by2, n2, by4);
        ZTauElement zTauElement = Tnaf.round(simpleBigDecimal, simpleBigDecimal2, by3);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2.multiply(zTauElement.u)).subtract(BigInteger.valueOf(2L).multiply(bigIntegerArray[1]).multiply(zTauElement.v));
        BigInteger bigInteger5 = bigIntegerArray[1].multiply(zTauElement.u).subtract(bigIntegerArray[0].multiply(zTauElement.v));
        return new ZTauElement(bigInteger4, bigInteger5);
    }

    public static ECPoint.AbstractF2m multiplyRTnaf(ECPoint.AbstractF2m abstractF2m, BigInteger bigInteger) {
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        int n2 = abstractF2m2.getFieldSize();
        int n3 = abstractF2m2.getA().toBigInteger().intValue();
        byte by2 = Tnaf.getMu(n3);
        BigInteger[] bigIntegerArray = abstractF2m2.getSi();
        ZTauElement zTauElement = Tnaf.partModReduction(bigInteger, n2, (byte)n3, bigIntegerArray, by2, (byte)10);
        return Tnaf.multiplyTnaf(abstractF2m, zTauElement);
    }

    public static ECPoint.AbstractF2m multiplyTnaf(ECPoint.AbstractF2m abstractF2m, ZTauElement zTauElement) {
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        byte by2 = Tnaf.getMu(abstractF2m2.getA());
        byte[] byArray = Tnaf.tauAdicNaf(by2, zTauElement);
        ECPoint.AbstractF2m abstractF2m3 = Tnaf.multiplyFromTnaf(abstractF2m, byArray);
        return abstractF2m3;
    }

    public static ECPoint.AbstractF2m multiplyFromTnaf(ECPoint.AbstractF2m abstractF2m, byte[] byArray) {
        ECCurve eCCurve = abstractF2m.getCurve();
        ECPoint.AbstractF2m abstractF2m2 = (ECPoint.AbstractF2m)eCCurve.getInfinity();
        ECPoint.AbstractF2m abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m.negate();
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            ++n2;
            byte by2 = byArray[i2];
            if (by2 == 0) continue;
            abstractF2m2 = abstractF2m2.tauPow(n2);
            n2 = 0;
            ECPoint.AbstractF2m abstractF2m4 = by2 > 0 ? abstractF2m : abstractF2m3;
            abstractF2m2 = (ECPoint.AbstractF2m)abstractF2m2.add(abstractF2m4);
        }
        if (n2 > 0) {
            abstractF2m2 = abstractF2m2.tauPow(n2);
        }
        return abstractF2m2;
    }

    public static byte[] tauAdicWNaf(byte by2, ZTauElement zTauElement, byte by3, BigInteger bigInteger, BigInteger bigInteger2, ZTauElement[] zTauElementArray) {
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger bigInteger3 = Tnaf.norm(by2, zTauElement);
        int n2 = bigInteger3.bitLength();
        int n3 = n2 > 30 ? n2 + 4 + by3 : 34 + by3;
        byte[] byArray = new byte[n3];
        BigInteger bigInteger4 = bigInteger.shiftRight(1);
        BigInteger bigInteger5 = zTauElement.u;
        BigInteger bigInteger6 = zTauElement.v;
        int n4 = 0;
        while (!bigInteger5.equals(ECConstants.ZERO) || !bigInteger6.equals(ECConstants.ZERO)) {
            BigInteger bigInteger7;
            if (bigInteger5.testBit(0)) {
                bigInteger7 = bigInteger5.add(bigInteger6.multiply(bigInteger2)).mod(bigInteger);
                byte by4 = bigInteger7.compareTo(bigInteger4) >= 0 ? (byte)bigInteger7.subtract(bigInteger).intValue() : (byte)bigInteger7.intValue();
                byArray[n4] = by4;
                boolean bl2 = true;
                if (by4 < 0) {
                    bl2 = false;
                    by4 = -by4;
                }
                if (bl2) {
                    bigInteger5 = bigInteger5.subtract(zTauElementArray[by4].u);
                    bigInteger6 = bigInteger6.subtract(zTauElementArray[by4].v);
                } else {
                    bigInteger5 = bigInteger5.add(zTauElementArray[by4].u);
                    bigInteger6 = bigInteger6.add(zTauElementArray[by4].v);
                }
            } else {
                byArray[n4] = 0;
            }
            bigInteger7 = bigInteger5;
            bigInteger5 = by2 == 1 ? bigInteger6.add(bigInteger5.shiftRight(1)) : bigInteger6.subtract(bigInteger5.shiftRight(1));
            bigInteger6 = bigInteger7.shiftRight(1).negate();
            ++n4;
        }
        return byArray;
    }

    public static ECPoint.AbstractF2m[] getPreComp(ECPoint.AbstractF2m abstractF2m, byte by2) {
        byte[][] byArray = by2 == 0 ? alpha0Tnaf : alpha1Tnaf;
        ECPoint[] eCPointArray = new ECPoint.AbstractF2m[byArray.length + 1 >>> 1];
        eCPointArray[0] = abstractF2m;
        int n2 = byArray.length;
        for (int i2 = 3; i2 < n2; i2 += 2) {
            eCPointArray[i2 >>> 1] = Tnaf.multiplyFromTnaf(abstractF2m, byArray[i2]);
        }
        abstractF2m.getCurve().normalizeAll(eCPointArray);
        return eCPointArray;
    }

    static {
        ZTauElement[] zTauElementArray = new ZTauElement[9];
        zTauElementArray[0] = null;
        zTauElementArray[1] = new ZTauElement(ECConstants.ONE, ECConstants.ZERO);
        zTauElementArray[2] = null;
        zTauElementArray[3] = new ZTauElement(MINUS_THREE, MINUS_ONE);
        zTauElementArray[4] = null;
        BigInteger bigInteger = MINUS_ONE;
        zTauElementArray[5] = new ZTauElement(bigInteger, bigInteger);
        zTauElementArray[6] = null;
        zTauElementArray[7] = new ZTauElement(ECConstants.ONE, MINUS_ONE);
        zTauElementArray[8] = null;
        alpha0 = zTauElementArray;
        alpha0Tnaf = new byte[][]{null, {1}, null, {-1, 0, 1}, null, {1, 0, 1}, null, {-1, 0, 0, 1}};
        ZTauElement[] zTauElementArray2 = new ZTauElement[9];
        zTauElementArray2[0] = null;
        zTauElementArray2[1] = new ZTauElement(ECConstants.ONE, ECConstants.ZERO);
        zTauElementArray2[2] = null;
        zTauElementArray2[3] = new ZTauElement(MINUS_THREE, ECConstants.ONE);
        zTauElementArray2[4] = null;
        zTauElementArray2[5] = new ZTauElement(MINUS_ONE, ECConstants.ONE);
        zTauElementArray2[6] = null;
        BigInteger bigInteger2 = ECConstants.ONE;
        zTauElementArray2[7] = new ZTauElement(bigInteger2, bigInteger2);
        zTauElementArray2[8] = null;
        alpha1 = zTauElementArray2;
        alpha1Tnaf = new byte[][]{null, {1}, null, {-1, 0, 1}, null, {1, 0, 1}, null, {-1, 0, 0, -1}};
    }
}

