/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.math.ec;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.AbstractECMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.WNafUtil;

public class MixedNafR2LMultiplier
extends AbstractECMultiplier {
    protected int additionCoord;
    protected int doublingCoord;

    public MixedNafR2LMultiplier() {
        this(2, 4);
    }

    public MixedNafR2LMultiplier(int n2, int n3) {
        this.additionCoord = n2;
        this.doublingCoord = n3;
    }

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        ECCurve eCCurve = eCPoint.getCurve();
        ECCurve eCCurve2 = this.configureCurve(eCCurve, this.additionCoord);
        ECCurve eCCurve3 = this.configureCurve(eCCurve, this.doublingCoord);
        int[] nArray = WNafUtil.generateCompactNaf(bigInteger);
        ECPoint eCPoint2 = eCCurve2.getInfinity();
        ECPoint eCPoint3 = eCCurve3.importPoint(eCPoint);
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            int n4 = n3 >> 16;
            eCPoint3 = eCPoint3.timesPow2(n2 += n3 & 0xFFFF);
            ECPoint eCPoint4 = eCCurve2.importPoint(eCPoint3);
            if (n4 < 0) {
                eCPoint4 = eCPoint4.negate();
            }
            eCPoint2 = eCPoint2.add(eCPoint4);
            n2 = 1;
        }
        return eCCurve.importPoint(eCPoint2);
    }

    protected ECCurve configureCurve(ECCurve eCCurve, int n2) {
        if (eCCurve.getCoordinateSystem() == n2) {
            return eCCurve;
        }
        if (!eCCurve.supportsCoordinateSystem(n2)) {
            throw new IllegalArgumentException("Coordinate system " + n2 + " not supported by this curve");
        }
        return eCCurve.configure().setCoordinateSystem(n2).create();
    }
}

