/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.jce.provider;

import java.security.Permission;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.DHParameterSpec;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.DHParameters;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.DSAParameters;
import macromedia.oracleutil.externals.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import macromedia.oracleutil.externals.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import macromedia.oracleutil.externals.org.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import macromedia.oracleutil.externals.org.bouncycastle.jcajce.spec.DHDomainParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission("BC", "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission("BC", "DhDefaultParams");
    private static Permission BC_EC_CURVE_PERMISSION = new ProviderConfigurationPermission("BC", "acceptableEcCurves");
    private static Permission BC_ADDITIONAL_EC_CURVE_PERMISSION = new ProviderConfigurationPermission("BC", "additionalEcParameters");
    private ThreadLocal ecThreadSpec = new ThreadLocal();
    private ThreadLocal dhThreadSpec = new ThreadLocal();
    private volatile macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;
    private volatile Set acceptableNamedCurves = new HashSet();
    private volatile Map additionalECParameters = new HashMap();

    BouncyCastleProviderConfiguration() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void setParameter(String string, Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.equals("threadLocalEcImplicitlyCa")) {
            macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((eCParameterSpec = object instanceof macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec || object == null ? (macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec)object : EC5Util.convertSpec((ECParameterSpec)object, false)) == null) {
                this.ecThreadSpec.remove();
                return;
            } else {
                this.ecThreadSpec.set(eCParameterSpec);
            }
            return;
        } else if (string.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            this.ecImplicitCaParams = object instanceof macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec || object == null ? (macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec)object : EC5Util.convertSpec((ECParameterSpec)object, false);
            return;
        } else if (string.equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && !(object instanceof DHParameterSpec[]) && object != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            Object object2 = object;
            if (object2 == null) {
                this.dhThreadSpec.remove();
                return;
            } else {
                this.dhThreadSpec.set(object2);
            }
            return;
        } else if (string.equals("DhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (!(object instanceof DHParameterSpec) && !(object instanceof DHParameterSpec[]) && object != null) throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            this.dhDefaultParams = object;
            return;
        } else if (string.equals("acceptableEcCurves")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_CURVE_PERMISSION);
            }
            this.acceptableNamedCurves = (Set)object;
            return;
        } else {
            if (!string.equals("additionalEcParameters")) return;
            if (securityManager != null) {
                securityManager.checkPermission(BC_ADDITIONAL_EC_CURVE_PERMISSION);
            }
            this.additionalECParameters = (Map)object;
        }
    }

    public macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec getEcImplicitlyCa() {
        macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (macromedia.oracleutil.externals.org.bouncycastle.jce.spec.ECParameterSpec)this.ecThreadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return this.ecImplicitCaParams;
    }

    public DHParameterSpec getDHDefaultParameters(int n2) {
        Object object;
        Object object2 = this.dhThreadSpec.get();
        if (object2 == null) {
            object2 = this.dhDefaultParams;
        }
        if (object2 instanceof DHParameterSpec) {
            object = (DHParameterSpec[])object2;
            if (object.getP().bitLength() == n2) {
                return object;
            }
        } else if (object2 instanceof DHParameterSpec[]) {
            object = (DHParameterSpec[])object2;
            for (int i2 = 0; i2 != ((DHParameterSpec[])object).length; ++i2) {
                if (object[i2].getP().bitLength() != n2) continue;
                return object[i2];
            }
        }
        if ((object = (DHParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DH_DEFAULT_PARAMS, n2)) != null) {
            return new DHDomainParameterSpec((DHParameters)object);
        }
        return null;
    }

    public DSAParameterSpec getDSADefaultParameters(int n2) {
        DSAParameters dSAParameters = (DSAParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DSA_DEFAULT_PARAMS, n2);
        if (dSAParameters != null) {
            return new DSAParameterSpec(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG());
        }
        return null;
    }

    public Set getAcceptableNamedCurves() {
        return Collections.unmodifiableSet(this.acceptableNamedCurves);
    }

    public Map getAdditionalECParameters() {
        return Collections.unmodifiableMap(this.additionalECParameters);
    }
}

