/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.jcajce.provider.symmetric.util;

import java.security.spec.KeySpec;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.PBEParametersGenerator;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.KeyParameter;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithIV;

public class BCPBEKey
implements PBEKey {
    String algorithm;
    ASN1ObjectIdentifier oid;
    int type;
    int digest;
    int keySize;
    int ivSize;
    dda param;
    PBEKeySpec pbeKeySpec;
    boolean tryWrong = false;

    public BCPBEKey(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, int n3, int n4, int n5, PBEKeySpec pBEKeySpec, dda dda2) {
        this.algorithm = string;
        this.oid = aSN1ObjectIdentifier;
        this.type = n2;
        this.digest = n3;
        this.keySize = n4;
        this.ivSize = n5;
        this.pbeKeySpec = pBEKeySpec;
        this.param = dda2;
    }

    public BCPBEKey(String string, KeySpec keySpec, dda dda2) {
        this.algorithm = string;
        this.param = dda2;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        if (this.param != null) {
            KeyParameter keyParameter = this.param instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)this.param).getParameters() : (KeyParameter)this.param;
            return keyParameter.getKey();
        }
        if (this.type == 2) {
            return PBEParametersGenerator.PKCS12PasswordToBytes(this.pbeKeySpec.getPassword());
        }
        if (this.type == 5) {
            return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.pbeKeySpec.getPassword());
        }
        return PBEParametersGenerator.PKCS5PasswordToBytes(this.pbeKeySpec.getPassword());
    }

    final int getType() {
        return this.type;
    }

    final int getDigest() {
        return this.digest;
    }

    final int getKeySize() {
        return this.keySize;
    }

    public int getIvSize() {
        return this.ivSize;
    }

    public dda getParam() {
        return this.param;
    }

    public char[] getPassword() {
        return this.pbeKeySpec.getPassword();
    }

    public byte[] getSalt() {
        return this.pbeKeySpec.getSalt();
    }

    public int getIterationCount() {
        return this.pbeKeySpec.getIterationCount();
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public void setTryWrongPKCS12Zero(boolean bl2) {
        this.tryWrong = bl2;
    }

    final boolean shouldTryWrongPKCS12() {
        return this.tryWrong;
    }
}

