/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.NameType;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.ServerName;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsFatalAlert;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsUtils;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;
import macromedia.oracleutil.externals.org.bouncycastle.util.io.Streams;

public class ServerNameList {
    protected Vector serverNameList;

    public ServerNameList(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("'serverNameList' must not be null");
        }
        this.serverNameList = vector;
    }

    public Vector getServerNameList() {
        return this.serverNameList;
    }

    public void encode(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        short[] sArray = new short[]{};
        for (int i2 = 0; i2 < this.serverNameList.size(); ++i2) {
            ServerName serverName = (ServerName)this.serverNameList.elementAt(i2);
            if ((sArray = ServerNameList.checkNameType(sArray, serverName.getNameType())) == null) {
                throw new TlsFatalAlert(80);
            }
            serverName.encode(byteArrayOutputStream);
        }
        TlsUtils.checkUint16(byteArrayOutputStream.size());
        TlsUtils.writeUint16(byteArrayOutputStream.size(), outputStream);
        Streams.writeBufTo(byteArrayOutputStream, outputStream);
    }

    public static ServerNameList parse(InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint16(inputStream);
        if (n2 < 1) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully(n2, inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        short[] sArray = new short[]{};
        Vector<ServerName> vector = new Vector<ServerName>();
        while (byteArrayInputStream.available() > 0) {
            ServerName serverName = ServerName.parse(byteArrayInputStream);
            if ((sArray = ServerNameList.checkNameType(sArray, serverName.getNameType())) == null) {
                throw new TlsFatalAlert(47);
            }
            vector.addElement(serverName);
        }
        return new ServerNameList(vector);
    }

    private static short[] checkNameType(short[] sArray, short s2) {
        if (!NameType.isValid(s2) || Arrays.contains(sArray, s2)) {
            return null;
        }
        return Arrays.append(sArray, s2);
    }
}

