/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.tls;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.DTLSReplayWindow;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.tls.TlsCipher;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private long sequenceNumber = 0L;

    DTLSEpoch(int n2, TlsCipher tlsCipher) {
        if (n2 < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (tlsCipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = n2;
        this.cipher = tlsCipher;
    }

    final long allocateSequenceNumber() {
        return this.sequenceNumber++;
    }

    final TlsCipher getCipher() {
        return this.cipher;
    }

    final int getEpoch() {
        return this.epoch;
    }

    final DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    final long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

