/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.gcm;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;
import macromedia.oracleutil.externals.org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int i2 = 0; i2 < 16; ++i2) {
            long[][] lArray = this.T[i2];
            if (i2 == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.T[i2 - 1][1], lArray[1]);
            }
            for (int i3 = 2; i3 < 256; i3 += 2) {
                GCMUtil.divideP(lArray[i3 >> 1], lArray[i3]);
                GCMUtil.xor(lArray[i3], lArray[1], lArray[i3 + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l2 = lArray[0];
        long l3 = lArray[1];
        for (int i2 = 14; i2 >= 0; --i2) {
            lArray = this.T[i2][byArray[i2] & 0xFF];
            l2 ^= lArray[0];
            l3 ^= lArray[1];
        }
        Pack.longToBigEndian(l2, byArray, 0);
        Pack.longToBigEndian(l3, byArray, 8);
    }
}

