/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.modes;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.OutputLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.StreamBlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithIV;
import macromedia.oracleutil.externals.org.bouncycastle.util.Arrays;

public class KCTRBlockCipher
extends StreamBlockCipher {
    private byte[] iv;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private boolean initialised;
    private BlockCipher engine;

    public KCTRBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.engine = blockCipher;
        this.iv = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    public void init(boolean bl2, dda dda2) throws IllegalArgumentException {
        this.initialised = true;
        if (!(dda2 instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("invalid parameter passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)dda2;
        byte[] byArray = parametersWithIV.getIV();
        int n2 = this.iv.length - byArray.length;
        Arrays.fill(this.iv, (byte)0);
        System.arraycopy(byArray, 0, this.iv, n2, byArray.length);
        dda2 = parametersWithIV.getParameters();
        if (dda2 != null) {
            this.engine.init(true, dda2);
        }
        this.reset();
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KCTR";
    }

    public int getBlockSize() {
        return this.engine.getBlockSize();
    }

    protected byte calculateByte(byte by2) {
        if (this.byteCount == 0) {
            this.incrementCounterAt(0);
            this.checkCounter();
            this.engine.processBlock(this.ofbV, 0, this.ofbOutV, 0);
            return (byte)(this.ofbOutV[this.byteCount++] ^ by2);
        }
        byte by3 = (byte)(this.ofbOutV[this.byteCount++] ^ by2);
        if (this.byteCount == this.ofbV.length) {
            this.byteCount = 0;
        }
        return by3;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (byArray.length - n2 < this.getBlockSize()) {
            throw new DataLengthException("input buffer too short");
        }
        if (byArray2.length - n3 < this.getBlockSize()) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBytes(byArray, n2, this.getBlockSize(), byArray2, n3);
        return this.getBlockSize();
    }

    public void reset() {
        if (this.initialised) {
            this.engine.processBlock(this.iv, 0, this.ofbV, 0);
        }
        this.engine.reset();
        this.byteCount = 0;
    }

    private final void incrementCounterAt(int n2) {
        int n3 = n2;
        while (n3 < this.ofbV.length) {
            int n4 = n3++;
            this.ofbV[n4] = (byte)(this.ofbV[n4] + 1);
            if (this.ofbV[n4] == 0) continue;
            break;
        }
    }

    private final void checkCounter() {
    }
}

