/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.modes;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.BlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.StreamBlockCipher;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.ParametersWithIV;

public class GOFBBlockCipher
extends StreamBlockCipher {
    private byte[] IV;
    private byte[] ofbV;
    private byte[] ofbOutV;
    private int byteCount;
    private final int blockSize;
    private final BlockCipher cipher;
    boolean firstStep = true;
    int N3;
    int N4;
    static final int C1 = 0x1010104;
    static final int C2 = 0x1010101;

    public GOFBBlockCipher(BlockCipher blockCipher) {
        super(blockCipher);
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        if (this.blockSize != 8) {
            throw new IllegalArgumentException("GCTR only for 64 bit block ciphers");
        }
        this.IV = new byte[blockCipher.getBlockSize()];
        this.ofbV = new byte[blockCipher.getBlockSize()];
        this.ofbOutV = new byte[blockCipher.getBlockSize()];
    }

    public void init(boolean bl2, dda dda2) throws IllegalArgumentException {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        if (dda2 instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)dda2;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.IV.length) {
                System.arraycopy(byArray, 0, this.IV, this.IV.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.IV.length - byArray.length; ++i2) {
                    this.IV[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.cipher.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (dda2 != null) {
                this.cipher.init(true, dda2);
            }
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCTR";
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.blockSize, byArray2, n3);
        return this.blockSize;
    }

    public void reset() {
        this.firstStep = true;
        this.N3 = 0;
        this.N4 = 0;
        System.arraycopy(this.IV, 0, this.ofbV, 0, this.IV.length);
        this.byteCount = 0;
        this.cipher.reset();
    }

    private final int bytesToint(byte[] byArray, int n2) {
        return (byArray[n2 + 3] << 24 & 0xFF000000) + (byArray[n2 + 2] << 16 & 0xFF0000) + (byArray[n2 + 1] << 8 & 0xFF00) + (byArray[n2] & 0xFF);
    }

    private final void intTobytes(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)(n2 >>> 24);
        byArray[n3 + 2] = (byte)(n2 >>> 16);
        byArray[n3 + 1] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }

    protected byte calculateByte(byte by2) {
        if (this.byteCount == 0) {
            if (this.firstStep) {
                this.firstStep = false;
                this.cipher.processBlock(this.ofbV, 0, this.ofbOutV, 0);
                GOFBBlockCipher gOFBBlockCipher = this;
                gOFBBlockCipher.N3 = gOFBBlockCipher.bytesToint(gOFBBlockCipher.ofbOutV, 0);
                GOFBBlockCipher gOFBBlockCipher2 = this;
                gOFBBlockCipher2.N4 = gOFBBlockCipher2.bytesToint(gOFBBlockCipher2.ofbOutV, 4);
            }
            this.N3 += 0x1010101;
            this.N4 += 0x1010104;
            if (this.N4 < 0x1010104 && this.N4 > 0) {
                ++this.N4;
            }
            GOFBBlockCipher gOFBBlockCipher = this;
            gOFBBlockCipher.intTobytes(gOFBBlockCipher.N3, this.ofbV, 0);
            GOFBBlockCipher gOFBBlockCipher3 = this;
            gOFBBlockCipher3.intTobytes(gOFBBlockCipher3.N4, this.ofbV, 4);
            this.cipher.processBlock(this.ofbV, 0, this.ofbOutV, 0);
        }
        byte by3 = (byte)(this.ofbOutV[this.byteCount++] ^ by2);
        if (this.byteCount == this.blockSize) {
            this.byteCount = 0;
            System.arraycopy(this.ofbV, this.blockSize, this.ofbV, 0, this.ofbV.length - this.blockSize);
            System.arraycopy(this.ofbOutV, 0, this.ofbV, this.ofbV.length - this.blockSize, this.blockSize);
        }
        return by3;
    }
}

