/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.crypto.engines;

import macromedia.oracleutil.externals.org.bouncycastle.crypto.DataLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.OutputLengthException;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.dda;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.engines.DESEngine;
import macromedia.oracleutil.externals.org.bouncycastle.crypto.params.KeyParameter;

public class DESedeEngine
extends DESEngine {
    protected static final int BLOCK_SIZE = 8;
    private int[] workingKey1 = null;
    private int[] workingKey2 = null;
    private int[] workingKey3 = null;
    private boolean forEncryption;

    public void init(boolean bl2, dda dda2) {
        if (!(dda2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + dda2.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)dda2).getKey();
        if (byArray.length != 24 && byArray.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.forEncryption = bl2;
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        this.workingKey1 = this.generateWorkingKey(bl2, byArray2);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
        this.workingKey2 = this.generateWorkingKey(!bl2, byArray3);
        if (byArray.length == 24) {
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 16, byArray4, 0, byArray4.length);
            this.workingKey3 = this.generateWorkingKey(bl2, byArray4);
        } else {
            this.workingKey3 = this.workingKey1;
        }
    }

    public String getAlgorithmName() {
        return "DESede";
    }

    public int getBlockSize() {
        return 8;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.workingKey1 == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (n2 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray3 = new byte[8];
        if (this.forEncryption) {
            DESedeEngine dESedeEngine = this;
            dESedeEngine.desFunc(dESedeEngine.workingKey1, byArray, n2, byArray3, 0);
            DESedeEngine dESedeEngine2 = this;
            dESedeEngine2.desFunc(dESedeEngine2.workingKey2, byArray3, 0, byArray3, 0);
            DESedeEngine dESedeEngine3 = this;
            dESedeEngine3.desFunc(dESedeEngine3.workingKey3, byArray3, 0, byArray2, n3);
        } else {
            DESedeEngine dESedeEngine = this;
            dESedeEngine.desFunc(dESedeEngine.workingKey3, byArray, n2, byArray3, 0);
            DESedeEngine dESedeEngine4 = this;
            dESedeEngine4.desFunc(dESedeEngine4.workingKey2, byArray3, 0, byArray3, 0);
            DESedeEngine dESedeEngine5 = this;
            dESedeEngine5.desFunc(dESedeEngine5.workingKey1, byArray3, 0, byArray2, n3);
        }
        return 8;
    }

    public void reset() {
    }
}

