/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Integer;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1OctetString;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERBitString;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERSequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x9.X9FieldElement;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x9.X9FieldID;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.oracleutil.externals.org.bouncycastle.math.ec.ECCurve;

public class X9Curve
extends ASN1Object
implements X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;
    private ASN1ObjectIdentifier fieldIdentifier = null;

    public X9Curve(ECCurve eCCurve) {
        this.curve = eCCurve;
        this.seed = null;
        this.setFieldIdentifier();
    }

    public X9Curve(ECCurve eCCurve, byte[] byArray) {
        this.curve = eCCurve;
        this.seed = byArray;
        this.setFieldIdentifier();
    }

    public X9Curve(X9FieldID x9FieldID, ASN1Sequence aSN1Sequence) {
        this(x9FieldID, null, null, aSN1Sequence);
    }

    public X9Curve(X9FieldID x9FieldID, BigInteger bigInteger, BigInteger bigInteger2, ASN1Sequence aSN1Sequence) {
        this.fieldIdentifier = x9FieldID.getIdentifier();
        if (this.fieldIdentifier.equals(X9ObjectIdentifiers.prime_field)) {
            BigInteger bigInteger3 = ((ASN1Integer)x9FieldID.getParameters()).getValue();
            BigInteger bigInteger4 = new BigInteger(1, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets());
            BigInteger bigInteger5 = new BigInteger(1, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
            this.curve = new ECCurve.Fp(bigInteger3, bigInteger4, bigInteger5, bigInteger, bigInteger2);
        } else if (this.fieldIdentifier.equals(X9ObjectIdentifiers.characteristic_two_field)) {
            Object object;
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(x9FieldID.getParameters());
            int n2 = ((ASN1Integer)aSN1Sequence2.getObjectAt(0)).getValue().intValue();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(1);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (aSN1ObjectIdentifier.equals(X9ObjectIdentifiers.tpBasis)) {
                n3 = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(2)).getValue().intValue();
            } else if (aSN1ObjectIdentifier.equals(X9ObjectIdentifiers.ppBasis)) {
                object = ASN1Sequence.getInstance(aSN1Sequence2.getObjectAt(2));
                n3 = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(0)).getValue().intValue();
                n4 = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(1)).getValue().intValue();
                n5 = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(2)).getValue().intValue();
            } else {
                throw new IllegalArgumentException("This type of EC basis is not implemented");
            }
            object = new BigInteger(1, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets());
            BigInteger bigInteger6 = new BigInteger(1, ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
            this.curve = new ECCurve.F2m(n2, n3, n4, n5, (BigInteger)object, bigInteger6, bigInteger, bigInteger2);
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
        if (aSN1Sequence.size() == 3) {
            this.seed = ((DERBitString)aSN1Sequence.getObjectAt(2)).getBytes();
        }
    }

    private final void setFieldIdentifier() {
        if (ECAlgorithms.isFpCurve(this.curve)) {
            this.fieldIdentifier = X9ObjectIdentifiers.prime_field;
        } else if (ECAlgorithms.isF2mCurve(this.curve)) {
            this.fieldIdentifier = X9ObjectIdentifiers.characteristic_two_field;
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.fieldIdentifier.equals(X9ObjectIdentifiers.prime_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).toASN1Primitive());
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).toASN1Primitive());
        } else if (this.fieldIdentifier.equals(X9ObjectIdentifiers.characteristic_two_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).toASN1Primitive());
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).toASN1Primitive());
        }
        if (this.seed != null) {
            aSN1EncodableVector.add(new DERBitString(this.seed));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

