/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.asn1.dvcs;

import java.util.Arrays;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Boolean;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Object;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERSequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.DERTaggedObject;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.x509.PolicyInformation;

public class PathProcInput
extends ASN1Object {
    private PolicyInformation[] acceptablePolicySet;
    private boolean inhibitPolicyMapping = false;
    private boolean explicitPolicyReqd = false;
    private boolean inhibitAnyPolicy = false;

    public PathProcInput(PolicyInformation[] policyInformationArray) {
        this.acceptablePolicySet = policyInformationArray;
    }

    public PathProcInput(PolicyInformation[] policyInformationArray, boolean bl2, boolean bl3, boolean bl4) {
        this.acceptablePolicySet = policyInformationArray;
        this.inhibitPolicyMapping = bl2;
        this.explicitPolicyReqd = bl3;
        this.inhibitAnyPolicy = bl4;
    }

    private static PolicyInformation[] fromSequence(ASN1Sequence aSN1Sequence) {
        PolicyInformation[] policyInformationArray = new PolicyInformation[aSN1Sequence.size()];
        for (int i2 = 0; i2 != policyInformationArray.length; ++i2) {
            policyInformationArray[i2] = PolicyInformation.getInstance(aSN1Sequence.getObjectAt(i2));
        }
        return policyInformationArray;
    }

    public static PathProcInput getInstance(Object object) {
        if (object instanceof PathProcInput) {
            return (PathProcInput)object;
        }
        if (object != null) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(object);
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
            PathProcInput pathProcInput = new PathProcInput(PathProcInput.fromSequence(aSN1Sequence2));
            block4: for (int i2 = 1; i2 < aSN1Sequence.size(); ++i2) {
                ASN1Primitive aSN1Primitive;
                ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(i2);
                if (aSN1Encodable instanceof ASN1Boolean) {
                    aSN1Primitive = ASN1Boolean.getInstance(aSN1Encodable);
                    pathProcInput.setInhibitPolicyMapping(((ASN1Boolean)aSN1Primitive).isTrue());
                    continue;
                }
                if (!(aSN1Encodable instanceof ASN1TaggedObject)) continue;
                aSN1Primitive = ASN1TaggedObject.getInstance(aSN1Encodable);
                switch (((ASN1TaggedObject)aSN1Primitive).getTagNo()) {
                    case 0: {
                        ASN1Boolean aSN1Boolean = ASN1Boolean.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        pathProcInput.setExplicitPolicyReqd(aSN1Boolean.isTrue());
                        continue block4;
                    }
                    case 1: {
                        ASN1Boolean aSN1Boolean = ASN1Boolean.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        pathProcInput.setInhibitAnyPolicy(aSN1Boolean.isTrue());
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown tag encountered: " + ((ASN1TaggedObject)aSN1Primitive).getTagNo());
                    }
                }
            }
            return pathProcInput;
        }
        return null;
    }

    public static PathProcInput getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return PathProcInput.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.acceptablePolicySet.length; ++i2) {
            aSN1EncodableVector2.add(this.acceptablePolicySet[i2]);
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.inhibitPolicyMapping) {
            aSN1EncodableVector.add(ASN1Boolean.getInstance(this.inhibitPolicyMapping));
        }
        if (this.explicitPolicyReqd) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, ASN1Boolean.getInstance(this.explicitPolicyReqd)));
        }
        if (this.inhibitAnyPolicy) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, ASN1Boolean.getInstance(this.inhibitAnyPolicy)));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "PathProcInput: {\nacceptablePolicySet: " + Arrays.asList(this.acceptablePolicySet) + "\ninhibitPolicyMapping: " + this.inhibitPolicyMapping + "\nexplicitPolicyReqd: " + this.explicitPolicyReqd + "\ninhibitAnyPolicy: " + this.inhibitAnyPolicy + "\n}\n";
    }

    public PolicyInformation[] getAcceptablePolicySet() {
        return this.acceptablePolicySet;
    }

    public boolean isInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    private final void setInhibitPolicyMapping(boolean bl2) {
        this.inhibitPolicyMapping = bl2;
    }

    public boolean isExplicitPolicyReqd() {
        return this.explicitPolicyReqd;
    }

    private final void setExplicitPolicyReqd(boolean bl2) {
        this.explicitPolicyReqd = bl2;
    }

    public boolean isInhibitAnyPolicy() {
        return this.inhibitAnyPolicy;
    }

    private final void setInhibitAnyPolicy(boolean bl2) {
        this.inhibitAnyPolicy = bl2;
    }
}

