/*
 * Decompiled with CFR 0.152.
 */
package macromedia.oracleutil.externals.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1EncodableVector;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.ASN1Sequence;
import macromedia.oracleutil.externals.org.bouncycastle.asn1.StreamUtil;

public class DLSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public DLSequence() {
    }

    public DLSequence(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DLSequence(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector);
    }

    public DLSequence(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray);
    }

    private final int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int n2 = 0;
            Enumeration enumeration = this.getObjects();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                n2 += ((ASN1Encodable)e2).toASN1Primitive().toDLObject().encodedLength();
            }
            this.bodyLength = n2;
        }
        return this.bodyLength;
    }

    final int encodedLength() throws IOException {
        int n2 = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(n2) + n2;
    }

    final void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        ASN1OutputStream aSN1OutputStream2 = aSN1OutputStream.getDLSubStream();
        int n2 = this.getBodyLength();
        aSN1OutputStream.write(48);
        aSN1OutputStream.writeLength(n2);
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            aSN1OutputStream2.writeObject((ASN1Encodable)e2);
        }
    }
}

