/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;

class JRDoubleCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRDoubleCountIncrementer mainInstance = new JRDoubleCountIncrementer();

    private JRDoubleCountIncrementer() {
    }

    public static JRDoubleCountIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (expressionValue == null) {
            if (variable.isInitialized()) {
                return JRDoubleIncrementerFactory.ZERO;
            }
            return value;
        }
        if (value == null) {
            value = variable.getValue() == null ? (Number)JRDoubleIncrementerFactory.ZERO : (Number)((Number)variable.getValue());
        }
        return new Double(value.doubleValue() + 1.0);
    }

    @Override
    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null) {
            value = calculable.getValue() == null ? (Number)JRDoubleIncrementerFactory.ZERO : (Number)((Number)calculable.getValue());
        }
        if (combineValue == null) {
            return value;
        }
        return new Double(value.doubleValue() + combineValue.doubleValue());
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRDoubleIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

