/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculator;
import net.sf.jasperreports.crosstabs.fill.JRPercentageCalculatorFactory;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;

public class JRVerifier {
    private static String[] textFieldClassNames = null;
    private static String[] imageClassNames = null;
    private static String[] subreportClassNames = null;
    private JasperDesign jasperDesign = null;
    private Collection brokenRules = null;
    private JRExpressionCollector expressionCollector;

    protected JRVerifier(JasperDesign jrDesign) {
        this(jrDesign, null);
    }

    protected JRVerifier(JasperDesign jrDesign, JRExpressionCollector expressionCollector) {
        this.jasperDesign = jrDesign;
        this.brokenRules = new ArrayList();
        this.expressionCollector = expressionCollector != null ? expressionCollector : JRExpressionCollector.collector(this.jasperDesign);
    }

    public static Collection verifyDesign(JasperDesign jasperDesign, JRExpressionCollector expressionCollector) {
        JRVerifier verifier = new JRVerifier(jasperDesign, expressionCollector);
        return verifier.verifyDesign();
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) {
        return JRVerifier.verifyDesign(jasperDesign, null);
    }

    protected Collection verifyDesign() {
        this.jasperDesign.preprocess();
        this.verifyDesignAttributes();
        this.verifyReportFonts();
        this.verifyDataset(this.jasperDesign.getMainDesignDataset());
        this.verifyDatasets();
        this.verifyStyles();
        this.verifyBand(this.jasperDesign.getBackground());
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifyBand(this.jasperDesign.getDetail());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getLastPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        return this.brokenRules;
    }

    private void verifyDesignAttributes() {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.brokenRules.add("Report name is missing.");
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.brokenRules.add("Column count must be greater than zero.");
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.brokenRules.add("Page width must be positive.");
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.brokenRules.add("Page height must be positive.");
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.brokenRules.add("Column width must be positive.");
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.brokenRules.add("Column spacing must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.brokenRules.add("Left margin must be positive.");
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.brokenRules.add("Right margin must be positive.");
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.brokenRules.add("Top margin must be positive.");
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.brokenRules.add("Bottom margin must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.brokenRules.add("The columns and the margins do not fit the page width.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getBackground() != null ? this.jasperDesign.getBackground().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The background section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The title section and the margins do not fit the page height.");
            }
        } else if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The title section, the page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getLastPageFooter() != null ? this.jasperDesign.getLastPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the last page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getSummary() != null ? this.jasperDesign.getSummary().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The summary section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getDetail() != null ? this.jasperDesign.getDetail().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The detail section, the page and column headers and footers and the margins do not fit the page height.");
        }
    }

    private void verifyQuery(JRDesignDataset dataset) {
        JRQuery query = dataset.getQuery();
        if (query != null) {
            String language = query.getLanguage();
            JRQueryExecuterFactory queryExecuterFactory = null;
            if (language == null || language.length() == 0) {
                this.brokenRules.add("Query language not set.");
            } else {
                try {
                    queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(query.getLanguage());
                }
                catch (JRException e1) {
                    this.brokenRules.add("Query executer factory for " + language + " cannot be created.");
                }
            }
            JRQueryChunk[] chunks = query.getChunks();
            if (chunks != null && chunks.length > 0) {
                Map parametersMap = dataset.getParametersMap();
                block6: for (int j = 0; j < chunks.length; ++j) {
                    JRQueryChunk queryChunk = chunks[j];
                    switch (queryChunk.getType()) {
                        case 2: {
                            JRParameter parameter = (JRParameter)parametersMap.get(queryChunk.getText());
                            if (parameter == null) {
                                this.brokenRules.add("Query parameter not found : " + queryChunk.getText());
                                continue block6;
                            }
                            if (queryExecuterFactory == null || queryExecuterFactory.supportsQueryParameterType(parameter.getValueClassName())) continue block6;
                            this.brokenRules.add("Parameter type not supported in query : " + queryChunk.getText() + " class " + parameter.getValueClassName());
                            continue block6;
                        }
                        case 3: {
                            if (parametersMap.containsKey(queryChunk.getText())) continue block6;
                            this.brokenRules.add("Query parameter not found : " + queryChunk.getText());
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(List expressions, Map parametersMap, Map fieldsMap, Map variablesMap) {
        if (expressions != null && expressions.size() > 0) {
            for (JRExpression expression : expressions) {
                JRExpressionChunk[] chunks = expression.getChunks();
                if (chunks == null || chunks.length <= 0) continue;
                block6: for (int j = 0; j < chunks.length; ++j) {
                    JRExpressionChunk expressionChunk = chunks[j];
                    switch (expressionChunk.getType()) {
                        case 4: {
                            if (variablesMap.containsKey(expressionChunk.getText())) continue block6;
                            this.brokenRules.add("Variable not found : " + expressionChunk.getText());
                            continue block6;
                        }
                        case 3: {
                            if (fieldsMap.containsKey(expressionChunk.getText())) continue block6;
                            this.brokenRules.add("Field not found : " + expressionChunk.getText());
                            continue block6;
                        }
                        case 2: {
                            if (parametersMap.containsKey(expressionChunk.getText())) continue block6;
                            this.brokenRules.add("Parameter not found : " + expressionChunk.getText());
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyExpressions(JRDesignDataset dataset) {
        this.verifyExpressions(this.expressionCollector.getExpressions(dataset), dataset.getParametersMap(), dataset.getFieldsMap(), dataset.getVariablesMap());
    }

    private void verifyReportFonts() {
        JRReportFont[] fonts = this.jasperDesign.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int index = 0; index < fonts.length; ++index) {
                JRReportFont font = fonts[index];
                if (font.getName() != null && font.getName().trim().length() != 0) continue;
                this.brokenRules.add("Report font name missing.");
            }
        }
    }

    private void verifyStyles() {
        JRStyle[] styles = this.jasperDesign.getStyles();
        if (styles != null && styles.length > 0) {
            for (int index = 0; index < styles.length; ++index) {
                JRStyle style = styles[index];
                if (style.getName() != null && style.getName().trim().length() != 0) continue;
                this.brokenRules.add("Report style name missing.");
            }
        }
    }

    private void verifyParameters(JRDesignDataset dataset) {
        JRParameter[] parameters = dataset.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRParameter parameter = parameters[index];
                if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                    this.brokenRules.add("Parameter name missing.");
                }
                if (parameter.getValueClassName() == null) {
                    this.brokenRules.add("Class not set for parameter : " + parameter.getName());
                    continue;
                }
                JRExpression expression = parameter.getDefaultValueExpression();
                if (expression == null) continue;
                if (expression.getValueClass() == null) {
                    this.brokenRules.add("No value class defined for the expression in parameter: " + parameter.getName());
                    continue;
                }
                if (parameter.getValueClass().isAssignableFrom(expression.getValueClass())) continue;
                this.brokenRules.add("The parameter default value expression class is not compatible with the parameter's class : " + parameter.getName());
            }
        }
    }

    private void verifyFields(JRDesignDataset dataset) {
        JRField[] fields = dataset.getFields();
        if (fields != null && fields.length > 0) {
            for (int index = 0; index < fields.length; ++index) {
                String className;
                JRField field = fields[index];
                if (field.getName() == null || field.getName().trim().length() == 0) {
                    this.brokenRules.add("Field name missing.");
                }
                if ((className = field.getValueClassName()) != null) continue;
                this.brokenRules.add("Class not set for field : " + field.getName());
            }
        }
    }

    private void verifyVariables(JRDesignDataset dataset) {
        JRVariable[] variables = dataset.getVariables();
        if (variables != null && variables.length > 0) {
            boolean isMainDataset = dataset.isMainDataset();
            for (int index = 0; index < variables.length; ++index) {
                byte incrementType;
                Class valueClass;
                JRVariable variable = variables[index];
                if (variable.getName() == null || variable.getName().trim().length() == 0) {
                    this.brokenRules.add("Variable name missing.");
                }
                if ((valueClass = variable.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for variable : " + variable.getName());
                } else {
                    JRExpression expression = variable.getExpression();
                    if (expression != null) {
                        if (expression.getValueClass() == null) {
                            this.brokenRules.add("No value class for the expression has been set in variable: " + variable.getName());
                        } else if (variable.getCalculation() != 1 && variable.getCalculation() != 10 && variable.getCalculation() != 8 && !valueClass.isAssignableFrom(expression.getValueClass())) {
                            this.brokenRules.add("The variable expression class is not compatible with the variable's class : " + variable.getName());
                        }
                    }
                    if (variable.getInitialValueExpression() != null && !valueClass.isAssignableFrom(variable.getInitialValueExpression().getValueClass())) {
                        this.brokenRules.add("The initial value class is not compatible with the variable's class : " + variable.getName());
                    }
                }
                byte resetType = variable.getResetType();
                if (resetType == 4) {
                    if (variable.getResetGroup() == null) {
                        this.brokenRules.add("Reset group missing for variable : " + variable.getName());
                    } else {
                        Map groupsMap = dataset.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getResetGroup().getName())) {
                            this.brokenRules.add("Reset group \"" + variable.getResetGroup().getName() + "\" not found for variable : " + variable.getName());
                        }
                    }
                }
                if ((incrementType = variable.getIncrementType()) == 4) {
                    if (variable.getIncrementGroup() == null) {
                        this.brokenRules.add("Increment group missing for variable : " + variable.getName());
                    } else {
                        Map groupsMap = dataset.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getIncrementGroup().getName())) {
                            this.brokenRules.add("Increment group \"" + variable.getIncrementGroup().getName() + "\" not found for variable : " + variable.getName());
                        }
                    }
                }
                if (isMainDataset) continue;
                if (resetType == 3 || resetType == 2) {
                    this.brokenRules.add("Variable " + variable.getName() + " of dataset " + dataset.getName() + " cannot have Column or Page reset type.");
                }
                if (incrementType != 3 && incrementType != 2) continue;
                this.brokenRules.add("Variable " + variable.getName() + " of dataset " + dataset.getName() + " cannot have Column or Page increment type.");
            }
        }
    }

    private void verifyGroups(JRDesignDataset dataset) {
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            boolean isMainDataset = dataset.isMainDataset();
            for (int index = 0; index < groups.length; ++index) {
                Class clazz;
                JRGroup group = groups[index];
                if (group.getName() == null || group.getName().trim().length() == 0) {
                    this.brokenRules.add("Group name missing.");
                }
                if (isMainDataset) {
                    this.verifyGroupHeaderAndFooter(group);
                } else if (group.getGroupHeader() != null || group.getGroupFooter() != null) {
                    this.brokenRules.add("Group " + group.getName() + " cannot have header or footer sections.");
                }
                JRExpression expression = group.getExpression();
                if (expression != null && (clazz = expression.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for group expression : " + group.getName());
                }
                if (!isMainDataset) continue;
                this.verifyBand(group.getGroupHeader());
                this.verifyBand(group.getGroupFooter());
            }
        }
    }

    private void verifyGroupHeaderAndFooter(JRGroup group) {
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + group.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.");
            }
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + group.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.");
            }
        } else {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + group.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.");
            }
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The '" + group.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.");
            }
        }
    }

    private void verifyBand(JRBand band) {
        JRElement[] elements;
        if (band != null && (elements = band.getElements()) != null && elements.length > 0) {
            JRExpression expression = band.getPrintWhenExpression();
            if (expression != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for band \"print when\" expression.");
                } else if (!Boolean.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for band \"print when\" expression. Use java.lang.Boolean instead.");
                }
            }
            for (int index = 0; index < elements.length; ++index) {
                JRElement element = elements[index];
                this.verifyPrintWhenExpr(element);
                if (!band.getIsStretchWithOverflow() && element.getY() + element.getHeight() > band.getHeight()) {
                    this.brokenRules.add("Warning : Element bottom reaches outside band area : y=" + element.getY() + " height=" + element.getHeight() + " band-height=" + band.getHeight());
                }
                this.verifyElement(element);
            }
        }
    }

    protected void verifyElement(JRElement element) {
        if (element instanceof JRStaticText) {
            this.verifyStaticText((JRStaticText)element);
        } else if (element instanceof JRTextField) {
            this.verifyTextField((JRTextField)element);
        } else if (element instanceof JRImage) {
            this.verifyImage((JRImage)element);
        } else if (element instanceof JRSubreport) {
            this.verifySubreport((JRSubreport)element);
        } else if (element instanceof JRCrosstab) {
            this.verifyCrosstab((JRDesignCrosstab)element);
        } else if (element instanceof JRFrame) {
            this.verifyFrame((JRFrame)element);
        }
    }

    private void verifyPrintWhenExpr(JRElement element) {
        JRExpression expression = element.getPrintWhenExpression();
        if (expression != null) {
            Class clazz = expression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for element \"print when\" expression.");
            } else if (!Boolean.class.isAssignableFrom(clazz)) {
                this.brokenRules.add("Class " + clazz + " not supported for element \"print when\" expression. Use java.lang.Boolean instead.");
            }
        }
    }

    private void verifyStaticText(JRStaticText staticText) {
        this.verifyFont(staticText);
    }

    private void verifyTextField(JRTextField textField) {
        JRExpression expression;
        this.verifyFont(textField);
        this.verifyAnchor(textField);
        this.verifyHyperlink(textField);
        if (textField != null && (expression = textField.getExpression()) != null) {
            String className = expression.getValueClassName();
            if (className == null) {
                this.brokenRules.add("Class not set for text field expression.");
            } else if (Arrays.binarySearch(JRVerifier.getTextFieldClassNames(), className) < 0) {
                this.brokenRules.add("Class \"" + className + "\" not supported for text field expression.");
            }
        }
    }

    private void verifyFont(JRFont font) {
        Map fontsMap;
        JRReportFont reportFont = font.getReportFont();
        if (reportFont != null && reportFont.getName() != null && !(fontsMap = this.jasperDesign.getFontsMap()).containsKey(reportFont.getName())) {
            this.brokenRules.add("Report font not found : " + reportFont.getName());
        }
    }

    private void verifyAnchor(JRAnchor anchor) {
        if (anchor != null) {
            JRExpression expression = anchor.getAnchorNameExpression();
            if (expression != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for anchor name expression.");
                } else if (!String.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for anchor name expression. Use java.lang.String instead.");
                }
            }
            if (anchor.getBookmarkLevel() != 0 && anchor.getBookmarkLevel() < 1) {
                this.brokenRules.add("Bookmark level should be 0 or greater than 0");
            }
        }
    }

    private void verifyHyperlink(JRHyperlink hyperlink) {
        if (hyperlink != null) {
            JRHyperlinkParameter[] parameters;
            Class clazz;
            JRExpression expression = hyperlink.getHyperlinkReferenceExpression();
            if (expression != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink reference expression.");
                } else if (!String.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink reference expression. Use java.lang.String instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkAnchorExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink anchor expression.");
                } else if (!String.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink anchor expression. Use java.lang.String instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkPageExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink page expression.");
                } else if (!Integer.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink page expression. Use java.lang.Integer instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkTooltipExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink tooltip expression.");
                } else if (!String.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink tooltip expression. Use java.lang.String instead.");
                }
            }
            if ((parameters = hyperlink.getHyperlinkParameters()) != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    JRHyperlinkParameter parameter = parameters[i];
                    this.verifyHyperlinkParameter(parameter);
                }
            }
        }
    }

    protected void verifyHyperlinkParameter(JRHyperlinkParameter parameter) {
        String name;
        if (parameter != null && ((name = parameter.getName()) == null || name.length() == 0)) {
            this.brokenRules.add("Hyperlink parameter name missing.");
        }
    }

    private void verifyImage(JRImage image) {
        JRExpression expression;
        this.verifyAnchor(image);
        this.verifyHyperlink(image);
        if (image != null && (expression = image.getExpression()) != null) {
            String className = expression.getValueClassName();
            if (className == null) {
                this.brokenRules.add("Class not set for image expression.");
            } else if (Arrays.binarySearch(JRVerifier.getImageClassNames(), className) < 0) {
                this.brokenRules.add("Class \"" + className + "\" not supported for image expression.");
            }
        }
    }

    private void verifySubreport(JRSubreport subreport) {
        if (subreport != null) {
            JRSubreportReturnValue[] returnValues;
            JRSubreportParameter[] parameters;
            JRExpression expression = subreport.getExpression();
            if (expression != null) {
                String className = expression.getValueClassName();
                if (className == null) {
                    this.brokenRules.add("Class not set for subreport expression.");
                } else if (Arrays.binarySearch(JRVerifier.getSubreportClassNames(), className) < 0) {
                    this.brokenRules.add("Class \"" + className + "\" not supported for subreport expression.");
                }
            }
            if ((expression = subreport.getParametersMapExpression()) != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport parameters map expression.");
                } else if (!Map.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport parameters map expression. Use java.util.Map instead.");
                }
            }
            if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
                for (int index = 0; index < parameters.length; ++index) {
                    Class clazz;
                    JRSubreportParameter parameter = parameters[index];
                    if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                        this.brokenRules.add("Subreport parameter name missing.");
                    }
                    if ((expression = parameter.getExpression()) == null || (clazz = expression.getValueClass()) != null) continue;
                    this.brokenRules.add("Class not set for subreport parameter expression : " + parameter.getName() + ". Use java.lang.Object class.");
                }
            }
            if (subreport.getConnectionExpression() != null && subreport.getDataSourceExpression() != null) {
                this.brokenRules.add("Subreport cannot have both connection expresion and data source expression.");
            }
            if ((expression = subreport.getConnectionExpression()) != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport connection expression.");
                } else if (!Connection.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport connection expression. Use java.sql.Connection instead.");
                }
            }
            if ((expression = subreport.getDataSourceExpression()) != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport data source expression.");
                } else if (!JRDataSource.class.isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.");
                }
            }
            if ((returnValues = subreport.getReturnValues()) != null && returnValues.length > 0) {
                for (int i = 0; i < returnValues.length; ++i) {
                    JRSubreportReturnValue returnValue = returnValues[i];
                    if (returnValue.getSubreportVariable() == null || returnValue.getSubreportVariable().trim().length() == 0) {
                        this.brokenRules.add("Subreport return value variable name missing.");
                    }
                    if (returnValue.getToVariable() == null || returnValue.getToVariable().trim().length() == 0) {
                        this.brokenRules.add("Subreport return value to variable name missing.");
                    }
                    if (this.jasperDesign.getVariablesMap().containsKey(returnValue.getToVariable())) continue;
                    this.brokenRules.add("Subreport return value to variable not found.");
                }
            }
        }
    }

    private static synchronized String[] getTextFieldClassNames() {
        if (textFieldClassNames == null) {
            textFieldClassNames = new String[]{Boolean.class.getName(), Byte.class.getName(), Date.class.getName(), Timestamp.class.getName(), Time.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), BigDecimal.class.getName(), Number.class.getName(), String.class.getName()};
            Arrays.sort(textFieldClassNames);
        }
        return textFieldClassNames;
    }

    private static synchronized String[] getImageClassNames() {
        if (imageClassNames == null) {
            imageClassNames = new String[]{String.class.getName(), File.class.getName(), URL.class.getName(), InputStream.class.getName(), Image.class.getName(), JRRenderable.class.getName()};
            Arrays.sort(imageClassNames);
        }
        return imageClassNames;
    }

    private static synchronized String[] getSubreportClassNames() {
        if (subreportClassNames == null) {
            subreportClassNames = new String[]{String.class.getName(), File.class.getName(), URL.class.getName(), InputStream.class.getName(), JasperReport.class.getName()};
            Arrays.sort(subreportClassNames);
        }
        return subreportClassNames;
    }

    private void verifyCrosstab(JRDesignCrosstab crosstab) {
        this.verifyParameters(crosstab);
        JRCrosstabDataset dataset = crosstab.getDataset();
        if (dataset == null) {
            this.brokenRules.add("Crosstab dataset missing.");
        } else {
            this.verifyElementDataset(dataset);
        }
        this.verifyCellContents(crosstab.getHeaderCell(), "crosstab cell");
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        if (rowGroups == null || rowGroups.length == 0) {
            this.brokenRules.add("Crosstab should have at least one row group.");
        } else {
            for (int i = 0; i < rowGroups.length; ++i) {
                this.verifyCrosstabRowGroup(rowGroups[i]);
            }
        }
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        if (colGroups == null || colGroups.length == 0) {
            this.brokenRules.add("Crosstab should have at least one column group.");
        } else {
            for (int i = 0; i < colGroups.length; ++i) {
                this.verifyCrosstabColumnGroup(colGroups[i]);
            }
        }
        JRCrosstabMeasure[] measures = crosstab.getMeasures();
        if (measures == null || measures.length == 0) {
            this.brokenRules.add("Crosstab should have at least one measure.");
        } else {
            for (int i = 0; i < measures.length; ++i) {
                this.verifyCrosstabMeasure(measures[i]);
            }
        }
        this.verifyCrosstabCells(crosstab);
        this.verifyCellContents(crosstab.getWhenNoDataCell(), "when no data cell");
        this.verifyExpressions(crosstab);
    }

    private void verifyParameters(JRDesignCrosstab crosstab) {
        JRCrosstabParameter[] parameters;
        JRExpression paramMapExpression = crosstab.getParametersMapExpression();
        if (paramMapExpression != null) {
            Class clazz = paramMapExpression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for crosstab parameters map expression.");
            } else if (!Map.class.isAssignableFrom(clazz)) {
                this.brokenRules.add("Class " + clazz + " not supported for crosstab parameters map expression. Use java.util.Map instead.");
            }
        }
        if ((parameters = crosstab.getParameters()) != null) {
            for (int i = 0; i < parameters.length; ++i) {
                Class valueClass;
                JRCrosstabParameter parameter = parameters[i];
                String paramName = parameter.getName();
                if (paramName == null || paramName.length() == 0) {
                    this.brokenRules.add("Missing parameter name for crosstab.");
                }
                JRExpression expression = parameter.getExpression();
                Class expressionClass = null;
                if (expression != null && (expressionClass = expression.getValueClass()) == null) {
                    this.brokenRules.add("Expression class not set for crosstab parameter " + paramName + ".");
                }
                if ((valueClass = parameter.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for crosstab parameter " + paramName + ".");
                    continue;
                }
                if (expressionClass == null || valueClass.isAssignableFrom(expressionClass)) continue;
                this.brokenRules.add("Incompatible expression class for crosstab parameter " + paramName + ".");
            }
        }
    }

    private void verifyCrosstabRowGroup(JRCrosstabRowGroup group) {
        this.verifyCrosstabGroup(group);
    }

    private void verifyCrosstabColumnGroup(JRCrosstabColumnGroup group) {
        this.verifyCrosstabGroup(group);
    }

    private void verifyCrosstabGroup(JRCrosstabGroup group) {
        String groupName = group.getName();
        if (groupName == null || groupName.length() == 0) {
            this.brokenRules.add("Crosstab group name missing.");
        }
        this.verifyCrosstabBucket(group);
        this.verifyCellContents(group.getHeader(), groupName + " header");
        if (group.hasTotal()) {
            this.verifyCellContents(group.getTotalHeader(), groupName + " total header");
        }
    }

    private void verifyCrosstabBucket(JRCrosstabGroup group) {
        Class valueClass;
        JRCrosstabBucket bucket = group.getBucket();
        JRExpression expression = bucket.getExpression();
        Class expressionClass = null;
        if (expression == null) {
            this.brokenRules.add("Crosstab bucket expression missing for group " + group.getName() + ".");
        } else {
            expressionClass = expression.getValueClass();
            if (expressionClass == null) {
                this.brokenRules.add("Crosstab bucket expression class missing for group " + group.getName() + ".");
            }
        }
        Class clazz = valueClass = expression == null ? null : expression.getValueClass();
        if (valueClass == null) {
            this.brokenRules.add("Crosstab bucket value class missing for group " + group.getName() + ".");
        } else if (expressionClass != null && !valueClass.isAssignableFrom(expressionClass)) {
            this.brokenRules.add("The class of the expression is not compatible with the class of the crosstab bucket for group " + group.getName() + ".");
        }
        JRExpression comparatorExpression = bucket.getComparatorExpression();
        if (comparatorExpression == null) {
            if (valueClass != null && !Comparable.class.isAssignableFrom(valueClass)) {
                this.brokenRules.add("No comparator expression specified and the value class is not comparable for crosstab group " + group.getName() + ".");
            }
        } else {
            Class comparatorClass = comparatorExpression.getValueClass();
            if (comparatorClass == null) {
                this.brokenRules.add("Crosstab bucket comparator expression class missing for group " + group.getName() + ".");
            } else if (!Comparator.class.isAssignableFrom(comparatorClass)) {
                this.brokenRules.add("The comparator expression should be compatible with java.util.Comparator for crosstab group " + group.getName() + ".");
            }
        }
    }

    private void verifyCrosstabCells(JRDesignCrosstab crosstab) {
        JRCrosstabColumnGroup[] columnGroups;
        JRCrosstabRowGroup[] rowGroups;
        JRCrosstabCell[][] cells = crosstab.getCells();
        JRCrosstabCell baseCell = cells[(rowGroups = crosstab.getRowGroups()).length][(columnGroups = crosstab.getColumnGroups()).length];
        if (baseCell == null || baseCell.getWidth() == null) {
            this.brokenRules.add("Crosstab base cell width not specified.");
        }
        if (baseCell == null || baseCell.getHeight() == null) {
            this.brokenRules.add("Crosstab base cell height not specified.");
        }
        for (int i = rowGroups.length; i >= 0; --i) {
            for (int j = columnGroups.length; j >= 0; --j) {
                JRCrosstabCell rowCell;
                JRCrosstabCell colCell;
                JRCrosstabCell cell = cells[i][j];
                String cellText = this.getCrosstabCellText(rowGroups, columnGroups, i, j);
                if (cell == null) continue;
                JRCellContents contents = cell.getContents();
                if (i < rowGroups.length && (colCell = cells[rowGroups.length][j]) != null && colCell.getContents().getWidth() != contents.getWidth()) {
                    this.brokenRules.add("Crosstab " + cellText + " width should be " + colCell.getContents().getWidth() + ".");
                }
                if (j < columnGroups.length && (rowCell = cells[i][columnGroups.length]) != null && rowCell.getContents().getHeight() != contents.getHeight()) {
                    this.brokenRules.add("Crosstab " + cellText + " height should be " + rowCell.getContents().getHeight() + ".");
                }
                this.verifyCellContents(contents, cellText);
            }
        }
    }

    private String getCrosstabCellText(JRCrosstabRowGroup[] rowGroups, JRCrosstabColumnGroup[] columnGroups, int rowIndex, int columnIndex) {
        String text = rowIndex == rowGroups.length ? (columnIndex == columnGroups.length ? "cell" : columnGroups[columnIndex].getName() + " total cell") : (columnIndex == columnGroups.length ? rowGroups[rowIndex].getName() + " total cell" : rowGroups[rowIndex].getName() + "," + columnGroups[columnIndex].getName() + " total cell");
        return text;
    }

    private void verifyCrosstabMeasure(JRCrosstabMeasure measure) {
        Class incrementerFactoryClass;
        byte calculation;
        String measureName = measure.getName();
        if (measureName == null || measureName.trim().length() == 0) {
            this.brokenRules.add("Measure name missing.");
        }
        if ((calculation = measure.getCalculation()) == 8) {
            this.brokenRules.add("Crosstab mesures cannot have system calculation");
        }
        JRExpression valueExpression = measure.getValueExpression();
        Class expressionClass = null;
        if (valueExpression == null) {
            this.brokenRules.add("Missing expression for measure " + measureName);
        } else {
            expressionClass = valueExpression.getValueClass();
            if (expressionClass == null) {
                this.brokenRules.add("Crosstab measure expression class missing for " + measureName + ".");
            }
        }
        Class valueClass = measure.getValueClass();
        if (valueClass == null) {
            this.brokenRules.add("Measure value class missing.");
        } else if (expressionClass != null && calculation != 1 && calculation != 10 && !valueClass.isAssignableFrom(expressionClass)) {
            this.brokenRules.add("The class of the expression is not compatible with the class of the measure " + measureName + ".");
        }
        if (measure.getPercentageOfType() != 0) {
            Class percentageCalculatorClass = measure.getPercentageCalculatorClass();
            if (percentageCalculatorClass == null) {
                if (valueClass != null && !JRPercentageCalculatorFactory.hasBuiltInCalculator(valueClass)) {
                    this.brokenRules.add("Percentage calculator class needs to be specified for measure " + measureName + ".");
                }
            } else if (!JRPercentageCalculator.class.isAssignableFrom(percentageCalculatorClass)) {
                this.brokenRules.add("Incompatible percentage calculator class for measure " + measureName + ".");
            }
        }
        if ((incrementerFactoryClass = measure.getIncrementerFactoryClass()) != null && !JRExtendedIncrementerFactory.class.isAssignableFrom(incrementerFactoryClass)) {
            this.brokenRules.add("Crosstab measures need extended incrementers (net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory).");
        }
    }

    private void verifyExpressions(JRDesignCrosstab crosstab) {
        this.verifyExpressions(this.expressionCollector.getExpressions(crosstab), crosstab.getParametersMap(), new HashMap(), crosstab.getVariablesMap());
    }

    private void verifyCellContents(JRCellContents contents, String cellText) {
        JRElement[] elements;
        if (contents != null && (elements = contents.getElements()) != null && elements.length > 0) {
            int cellWidth;
            int topPadding = 0;
            int leftPadding = 0;
            int bottomPadding = 0;
            int rightPadding = 0;
            JRBox box = contents.getBox();
            if (box != null) {
                topPadding = box.getTopPadding();
                leftPadding = box.getLeftPadding();
                bottomPadding = box.getBottomPadding();
                rightPadding = box.getRightPadding();
            }
            boolean widthCalculated = (cellWidth = contents.getWidth()) != Integer.MIN_VALUE;
            int avlblWidth = cellWidth - leftPadding - rightPadding;
            int cellHeight = contents.getHeight();
            boolean heightCalculated = cellHeight != Integer.MIN_VALUE;
            int avlblHeight = cellHeight - topPadding - bottomPadding;
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                this.verifyPrintWhenExpr(element);
                if (widthCalculated && element.getX() + element.getWidth() > avlblWidth) {
                    this.brokenRules.add("Element reaches outside " + cellText + " width: x=" + element.getX() + ", width=" + element.getWidth() + ", available width=" + avlblWidth + ".");
                }
                if (heightCalculated && element.getY() + element.getHeight() > avlblHeight) {
                    this.brokenRules.add("Element reaches outside " + cellText + " height: y=" + element.getY() + ", height=" + element.getHeight() + ", available height=" + avlblHeight + ".");
                }
                if (element instanceof JRStaticText) {
                    this.verifyStaticText((JRStaticText)element);
                    continue;
                }
                if (element instanceof JRTextField) {
                    JRTextField textField = (JRTextField)element;
                    if (textField.getEvaluationTime() != 1) {
                        this.brokenRules.add("Elements with delayed evaluation time are not supported inside crosstab cells.");
                    }
                    this.verifyTextField(textField);
                    continue;
                }
                if (element instanceof JRImage) {
                    JRImage image = (JRImage)element;
                    if (image.getEvaluationTime() != 1) {
                        this.brokenRules.add("Elements with delayed evaluation time are not supported inside crosstab cells.");
                    }
                    this.verifyImage(image);
                    continue;
                }
                if (element instanceof JRFrame) {
                    this.verifyFrame((JRFrame)element);
                    continue;
                }
                if (element instanceof JRSubreport) {
                    this.brokenRules.add("Subreports are not allowed inside crosstab cells.");
                    continue;
                }
                if (!(element instanceof JRCrosstab)) continue;
                this.brokenRules.add("Crosstabs are not allowed inside crosstab cells.");
            }
        }
    }

    private void verifyElementDataset(JRElementDataset dataset) {
        JRExpression incrementWhenExpression;
        JRDatasetRun datasetRun = dataset.getDatasetRun();
        if (datasetRun != null) {
            byte resetType;
            byte incrementType = dataset.getIncrementType();
            if (incrementType == 2 || incrementType == 3) {
                this.brokenRules.add("Chart datasets with dataset run cannont have Column or Page increment type.");
            }
            if ((resetType = dataset.getResetType()) == 2 || resetType == 3) {
                this.brokenRules.add("Chart datasets with dataset run cannont have Column or Page reset type.");
            } else if (resetType != 1) {
                // empty if block
            }
            this.verifyDatasetRun(datasetRun);
        }
        if ((incrementWhenExpression = dataset.getIncrementWhenExpression()) != null) {
            Class valueClass = incrementWhenExpression.getValueClass();
            if (valueClass == null) {
                this.brokenRules.add("Class not set for data set \"increment when\" expression.");
            } else if (!Boolean.class.isAssignableFrom(valueClass)) {
                this.brokenRules.add("Class " + valueClass + " not supported for dataset \"increment when\" expression. Use java.lang.Boolean instead.");
            }
        }
    }

    private void verifyDatasetRun(JRDatasetRun datasetRun) {
        Class clazz;
        JRDatasetParameter[] parameters;
        JRDesignDataset dataset = null;
        String datasetName = datasetRun.getDatasetName();
        if (datasetName == null || datasetName.length() == 0) {
            this.brokenRules.add("Dataset name is missing for dataset run.");
        } else {
            dataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(datasetName);
            if (dataset == null) {
                this.brokenRules.add("Unknown dataset name " + datasetName + ".");
            }
        }
        JRExpression parametersMapExpression = datasetRun.getParametersMapExpression();
        if (parametersMapExpression != null) {
            Class clazz2 = parametersMapExpression.getValueClass();
            if (clazz2 == null) {
                this.brokenRules.add("Class not set for dataset " + datasetName + " parameters map expression.");
            } else if (!Map.class.isAssignableFrom(clazz2)) {
                this.brokenRules.add("Class " + clazz2 + " not supported for dataset " + datasetName + " parameters map expression. Use java.util.Map instead.");
            }
        }
        if ((parameters = datasetRun.getParameters()) != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                JRExpression expression;
                JRDatasetParameter parameter = parameters[index];
                String paramName = parameter.getName();
                if (paramName == null || paramName.trim().length() == 0) {
                    this.brokenRules.add("Dataset " + datasetName + " parameter name missing.");
                }
                JRParameter datasetParam = null;
                if (dataset != null && (datasetParam = (JRParameter)dataset.getParametersMap().get(paramName)) == null) {
                    this.brokenRules.add("Unknown parameter " + paramName + " in dataset " + datasetName + ".");
                }
                if ((expression = parameter.getExpression()) == null) continue;
                Class clazz3 = expression.getValueClass();
                if (clazz3 == null) {
                    this.brokenRules.add("Class not set for dataset " + datasetName + " parameter expression : " + paramName + ".");
                    continue;
                }
                if (datasetParam == null || datasetParam.getValueClass().isAssignableFrom(clazz3)) continue;
                this.brokenRules.add("Class " + clazz3 + " not supported for parameter " + paramName + " of dataset " + datasetName + ". Use " + datasetParam.getValueClass() + " instead.");
            }
        }
        JRExpression connectionExpression = datasetRun.getConnectionExpression();
        JRExpression dataSourceExpression = datasetRun.getDataSourceExpression();
        if (connectionExpression != null && dataSourceExpression != null) {
            this.brokenRules.add("Dataset " + datasetName + " cannot have both connection expresion and data source expression.");
        }
        if (connectionExpression != null) {
            clazz = connectionExpression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for dataset " + datasetName + " connection expression.");
            } else if (!Connection.class.isAssignableFrom(clazz)) {
                this.brokenRules.add("Class " + clazz + " not supported for dataset " + datasetName + " connection expression. Use java.sql.Connection instead.");
            }
        }
        if (dataSourceExpression != null) {
            clazz = dataSourceExpression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for dataset " + datasetName + " data source expression.");
            } else if (!JRDataSource.class.isAssignableFrom(clazz)) {
                this.brokenRules.add("Class " + clazz + " not supported for dataset " + datasetName + " data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.");
            }
        }
    }

    private void verifyDatasets() {
        JRDataset[] datasets = this.jasperDesign.getDatasets();
        if (datasets != null && datasets.length > 0) {
            for (int i = 0; i < datasets.length; ++i) {
                JRDesignDataset dataset = (JRDesignDataset)datasets[i];
                if (dataset.getName() == null || dataset.getName().trim().length() == 0) {
                    this.brokenRules.add("Dataset name is missing.");
                }
                this.verifyDataset(dataset);
            }
        }
    }

    private void verifyDataset(JRDesignDataset dataset) {
        this.verifyExpressions(dataset);
        this.verifyParameters(dataset);
        this.verifyQuery(dataset);
        this.verifyFields(dataset);
        this.verifyVariables(dataset);
        this.verifyGroups(dataset);
        JRExpression filterExpression = dataset.getFilterExpression();
        if (filterExpression != null) {
            Class valueClass = filterExpression.getValueClass();
            if (valueClass == null) {
                this.brokenRules.add("Class not set for filter expression.");
            } else if (!Boolean.class.isAssignableFrom(valueClass)) {
                this.brokenRules.add("Class " + valueClass + " not supported for filter expression. Use java.lang.Boolean instead.");
            }
        }
    }

    private void verifyFrame(JRFrame frame) {
        JRElement[] elements = frame.getElements();
        if (elements != null && elements.length > 0) {
            int topPadding = frame.getTopPadding();
            int leftPadding = frame.getLeftPadding();
            int bottomPadding = frame.getBottomPadding();
            int rightPadding = frame.getRightPadding();
            int avlblWidth = frame.getWidth() - leftPadding - rightPadding;
            int avlblHeight = frame.getHeight() - topPadding - bottomPadding;
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element.getX() + element.getWidth() > avlblWidth) {
                    this.brokenRules.add("Element reaches outside frame width: x=" + element.getX() + ", width=" + element.getWidth() + ", available width=" + avlblWidth + ".");
                }
                if (element.getY() + element.getHeight() > avlblHeight) {
                    this.brokenRules.add("Element reaches outside frame height: y=" + element.getY() + ", height=" + element.getHeight() + ", available height=" + avlblHeight + ".");
                }
                this.verifyElement(element);
            }
        }
    }
}

