/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob;

import coldfusion.azure.blob.ContainerReference;
import coldfusion.cloud.CloudServiceName;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.jsp.PageContext;

@GenerateCFNamedInvoke
public class ContainerAsRootReference
implements NamedInvokable {
    private final ContainerReference containerReference;
    private final String VERSION_ID = "versionId";
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.AZURE_BLOB.name());
    private static InvokeNamedMethodInvocationMap<ContainerAsRootReference> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public ContainerAsRootReference(CloudBlobContainer container, CloudBlobClient client, OperationContext context) {
        this.containerReference = new ContainerReference(container, client, context);
    }

    public Struct listAll() {
        Struct struct = this.containerReference.listAll();
        List structs = (List)struct.getOrDefault((Object)"response", new LinkedList());
        structs.forEach(this::transformToCommonStorageCloudResponse);
        return this.transformToCommonStorageCloudResponse(struct);
    }

    public Struct listAll(Map listRequest) {
        this.transformToAzureBlobRequest(listRequest);
        Struct struct = this.containerReference.listAll(listRequest);
        List structs = (List)struct.getOrDefault((Object)"response", new LinkedList());
        structs.forEach(this::transformToCommonStorageCloudResponse);
        return this.transformToCommonStorageCloudResponse(struct);
    }

    public void putPolicy(Map policyRequest) {
        this.transformToCommonStorageCloudResponse(this.containerReference.putPolicy(policyRequest));
    }

    public Struct getPolicies() {
        return this.transformToCommonStorageCloudResponse(this.getPolicies(null));
    }

    public Struct getPolicies(Map getPolicyRequest) {
        this.transformToAzureBlobRequest(getPolicyRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.getPolicies(getPolicyRequest));
    }

    public Struct deletePolicies() {
        return this.transformToCommonStorageCloudResponse(this.containerReference.deletePolicies());
    }

    public Struct uploadFile(Map uploadRequest) {
        this.transformToAzureBlobRequest(uploadRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.uploadFile(uploadRequest));
    }

    public Struct downloadToFile(Map downloadRequest) {
        this.transformToAzureBlobRequest(downloadRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.downloadToFile(downloadRequest));
    }

    public Struct uploadObject(Map uploadRequest) {
        this.transformToAzureBlobRequest(uploadRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.uploadObject(uploadRequest));
    }

    public Struct downloadObject(Map downloadRequest) {
        this.transformToAzureBlobRequest(downloadRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.downloadObject(downloadRequest));
    }

    public Struct delete(Object key) {
        if (key instanceof Struct) {
            return this.delete((Map)((Struct)key));
        }
        return this.delete(String.valueOf(key));
    }

    private Struct delete(String key) {
        return this.transformToCommonStorageCloudResponse(this.containerReference.delete((Object)key));
    }

    private Struct delete(Map deleteRequest) {
        this.transformToAzureBlobRequest(deleteRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.delete((Object)deleteRequest));
    }

    public Struct copy(Map copyRequest) {
        this.transformToAzureBlobRequest(copyRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.copy(copyRequest));
    }

    public Struct createVersion(Map createVersionRequest) {
        this.transformToAzureBlobRequest(createVersionRequest);
        Struct response = this.containerReference.createSnapshot(createVersionRequest);
        return this.transformToCommonStorageCloudResponse(response);
    }

    public Struct uploadDirectory(Map uploadDirectoryRequest) {
        this.transformToAzureBlobRequest(uploadDirectoryRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.uploadDirectory(uploadDirectoryRequest));
    }

    public Struct parallelUploadFile(Map parallelUploadRequest) {
        this.transformToAzureBlobRequest(parallelUploadRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.parallelUploadFile(parallelUploadRequest));
    }

    public Struct parallelDownloadFile(Map parallelDownloadRequest) {
        this.transformToAzureBlobRequest(parallelDownloadRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.parallelDownloadFile(parallelDownloadRequest));
    }

    public Struct uploadMetadata(Map metadataRequest) {
        this.transformToAzureBlobRequest(metadataRequest);
        return this.transformToCommonStorageCloudResponse(this.containerReference.uploadMetadata(metadataRequest));
    }

    private void transformToAzureBlobRequest(Map request) {
        Object object;
        if (Objects.isNull(request)) {
            return;
        }
        if (request.containsKey("key")) {
            object = request.get("key");
            request.remove("key");
            request.put("blobName", object);
        }
        if (request.containsKey("versionId")) {
            object = request.get("versionId");
            request.remove("versionId");
            request.put("snapshotID", object);
        }
    }

    private Struct transformToCommonStorageCloudResponse(Struct response) {
        Object object;
        if (response.containsKey((Object)"snapshotID")) {
            object = response.get((Object)"snapshotID");
            response.remove((Object)"snapshotID");
            response.put((Object)"versionId", object);
        }
        if (response.containsKey((Object)"blobName")) {
            object = response.get((Object)"blobName");
            response.remove((Object)"blobName");
            response.put((Object)"key", object);
        }
        return response;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"listAll", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listAll();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"listRequest"}, args);
                    return obj.listAll(Cast._Map((Object)argColl.get((Object)"listRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAll", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putPolicy", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"policyRequest"}, args);
                    obj.putPolicy(Cast._Map((Object)argColl.get((Object)"policyRequest")));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putPolicy", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPolicies", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPolicies();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"getPolicyRequest"}, args);
                    return obj.getPolicies(Cast._Map((Object)argColl.get((Object)"getPolicyRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPolicies", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deletePolicies", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.deletePolicies();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deletePolicies", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadRequest"}, args);
                    return obj.uploadFile(Cast._Map((Object)argColl.get((Object)"uploadRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"downloadToFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"downloadRequest"}, args);
                    return obj.downloadToFile(Cast._Map((Object)argColl.get((Object)"downloadRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("downloadToFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadObject", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadRequest"}, args);
                    return obj.uploadObject(Cast._Map((Object)argColl.get((Object)"uploadRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadObject", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"downloadObject", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"downloadRequest"}, args);
                    return obj.downloadObject(Cast._Map((Object)argColl.get((Object)"downloadRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("downloadObject", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"key"}, args);
                    return obj.delete(argColl.get((Object)"key"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"copy", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"copyRequest"}, args);
                    return obj.copy(Cast._Map((Object)argColl.get((Object)"copyRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("copy", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"createVersion", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"createVersionRequest"}, args);
                    return obj.createVersion(Cast._Map((Object)argColl.get((Object)"createVersionRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("createVersion", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadDirectory", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadDirectoryRequest"}, args);
                    return obj.uploadDirectory(Cast._Map((Object)argColl.get((Object)"uploadDirectoryRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadDirectory", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"parallelUploadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"parallelUploadRequest"}, args);
                    return obj.parallelUploadFile(Cast._Map((Object)argColl.get((Object)"parallelUploadRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("parallelUploadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"parallelDownloadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"parallelDownloadRequest"}, args);
                    return obj.parallelDownloadFile(Cast._Map((Object)argColl.get((Object)"parallelDownloadRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("parallelDownloadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadMetadata", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"metadataRequest"}, args);
                    return obj.uploadMetadata(Cast._Map((Object)argColl.get((Object)"metadataRequest")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadMetadata", obj);
        });
    }
}

