/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.jsp.JavaCompiler;
import coldfusion.runtime.Array;
import coldfusion.runtime.ListFunc;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.XmlRpcService;
import coldfusion.util.Utils;
import coldfusion.xml.rpc.Constants;
import coldfusion.xml.rpc.ServiceInfo;
import coldfusion.xml.rpc.ServiceInfoGeneratorStrategy;
import coldfusion.xml.rpc.ServiceStubGenerationException;
import coldfusion.xml.rpc.module.Axis1ServiceInfo;
import coldfusion.xml.rpc.module.CFEmitter;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.w3c.dom.Document;

public class Axis1ServiceInfoGeneratorStrategy
extends ServiceInfoGeneratorStrategy {
    public Axis1ServiceInfoGeneratorStrategy(XmlRpcService service, boolean saveJava) {
        super(service, saveJava);
    }

    public ServiceInfo generateServiceInfo(String name, final String outputdir, String username, String password, final String wsdl, final Document wsdlDocument, String w2jargs, Map config) {
        Axis1ServiceInfo serviceInfo = null;
        CFEmitter cfe = new CFEmitter();
        final Emitter emitter = cfe.getEmitter();
        if (w2jargs != null) {
            Array l = ListFunc.ListToArray((String)w2jargs, (String)" ");
            try {
                String[] args = new String[l.size()];
                l.toArray(args);
                cfe.processArgs(args);
            }
            catch (Exception e) {
                throw new ServiceInfoGeneratorStrategy.BadWSDL2JavaSwitchException((ServiceInfoGeneratorStrategy)this, e.getMessage(), w2jargs);
            }
        }
        emitter.setOutputDir(outputdir);
        if (username != null && username.length() > 0) {
            emitter.setUsername(username);
            emitter.setPassword(password);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    emitter.run(wsdl, wsdlDocument);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ServiceStubGenerationException(name, wsdl, e);
        }
        final GeneratedFileInfo fileinfo = emitter.getGeneratedFileInfo();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JavaCompiler compiler = new JavaCompiler();
                    if (Axis1ServiceInfoGeneratorStrategy.this.service.getClassPath() != null) {
                        compiler.setClasspath(Axis1ServiceInfoGeneratorStrategy.this.service.getClassPath());
                    }
                    compiler.setOutputDirectory(outputdir);
                    compiler.setSaveJava("true");
                    List list = fileinfo.getList();
                    Iterator it = list.iterator();
                    ArrayList<String> fileList = new ArrayList<String>();
                    while (it.hasNext()) {
                        GeneratedFileInfo.Entry entry = (GeneratedFileInfo.Entry)it.next();
                        String sourceFile = entry.fileName;
                        fileList.add(sourceFile);
                    }
                    compiler.compileClass(fileList, true);
                    if (!Axis1ServiceInfoGeneratorStrategy.this.saveJava) {
                        for (GeneratedFileInfo.Entry entry : list) {
                            File f = new File(entry.fileName);
                            f.delete();
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceRuntimeException((Throwable)pex.getException());
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
        try {
            URLClassLoader loader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader parent = Thread.currentThread().getContextClassLoader();
                    if (parent == null) {
                        parent = this.getClass().getClassLoader();
                    }
                    return new URLClassLoader(new URL[]{Utils.getCanonicalFile((String)outputdir).toURL()}, parent);
                }
            });
            List service_list = fileinfo.findType("service");
            if (service_list == null) {
                throw new ServiceInfoGeneratorStrategy.ServiceStubDiscoveryException(name, wsdl);
            }
            boolean found = false;
            HashMap portMap = new HashMap();
            int size = service_list.size();
            for (int i = 0; i < size; ++i) {
                Method getPorts;
                GeneratedFileInfo.Entry entry = (GeneratedFileInfo.Entry)service_list.get(i);
                String classname = entry.className;
                final Class<?> locator = loader.loadClass(classname);
                if (!classname.endsWith("Locator") || (getPorts = locator.getMethod("getPorts", Constants.EMPTY_CLASS_ARRAY)) == null) continue;
                found = true;
                Object serviceObj = null;
                serviceObj = System.getSecurityManager() == null ? locator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return locator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                });
                Iterator portIt = (Iterator)getPorts.invoke(serviceObj, Constants.EMPTY_OBJECT_ARRAY);
                while (portIt.hasNext()) {
                    QName qName = (QName)portIt.next();
                    String portName = qName.getLocalPart();
                    portMap.put(portName, locator);
                }
            }
            serviceInfo = new Axis1ServiceInfo(name, portMap);
            if (!found) {
                throw new ServiceInfoGeneratorStrategy.ServiceStubDiscoveryException(name, wsdl);
            }
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceRuntimeException((Throwable)pex.getException());
        }
        catch (ServiceStubGenerationException ex) {
            throw ex;
        }
        catch (ServiceInfoGeneratorStrategy.ServiceStubDiscoveryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException((Throwable)ex);
        }
        return serviceInfo;
    }

    public int getVersion() {
        return 1;
    }
}

