/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.UnitSpan;

public final class Rect {
    public static final Rect ZERO = new Rect();
    private final UnitSpan mLeft;
    private final UnitSpan mTop;
    private final UnitSpan mRight;
    private final UnitSpan mBottom;

    public Rect() {
        this.mLeft = UnitSpan.ZERO;
        this.mTop = UnitSpan.ZERO;
        this.mRight = UnitSpan.ZERO;
        this.mBottom = UnitSpan.ZERO;
    }

    public Rect(Rect source) {
        this(source.mLeft, source.mTop, source.mRight, source.mBottom);
    }

    public Rect(CoordPair topLeft, CoordPair bottomRight) {
        this(topLeft.x(), topLeft.y(), bottomRight.x(), bottomRight.y());
    }

    public Rect(UnitSpan left, UnitSpan top, UnitSpan right, UnitSpan bottom) {
        if (left.lte(right)) {
            this.mLeft = left;
            this.mRight = right;
        } else {
            this.mLeft = right;
            this.mRight = left;
        }
        if (top.lte(bottom)) {
            this.mTop = top;
            this.mBottom = bottom;
        } else {
            this.mTop = bottom;
            this.mBottom = top;
        }
    }

    public UnitSpan left() {
        return this.mLeft;
    }

    public UnitSpan top() {
        return this.mTop;
    }

    public UnitSpan right() {
        return this.mRight;
    }

    public UnitSpan bottom() {
        return this.mBottom;
    }

    public Rect leftRight(UnitSpan newLeft, UnitSpan newRight) {
        return new Rect(newLeft, this.mTop, newRight, this.mBottom);
    }

    public Rect topBottom(UnitSpan newTop, UnitSpan newBottom) {
        return new Rect(this.mLeft, newTop, this.mRight, newBottom);
    }

    public Rect leftWidth(UnitSpan newLeft, UnitSpan newWidth) {
        return this.leftRight(newLeft, newLeft.add(newWidth));
    }

    public Rect rightWidth(UnitSpan newRight, UnitSpan newWidth) {
        return this.leftRight(newRight.subtract(newWidth), newRight);
    }

    public Rect topHeight(UnitSpan newTop, UnitSpan newHeight) {
        return this.topBottom(newTop, newTop.add(newHeight));
    }

    public Rect bottomHeight(UnitSpan newBottom, UnitSpan newHeight) {
        return this.topBottom(newBottom.subtract(newHeight), newBottom);
    }

    public CoordPair topLeft() {
        return new CoordPair(this.mLeft, this.mTop);
    }

    public CoordPair topRight() {
        return new CoordPair(this.mRight, this.mTop);
    }

    public CoordPair bottomLeft() {
        return new CoordPair(this.mLeft, this.mBottom);
    }

    public CoordPair bottomRight() {
        return new CoordPair(this.mRight, this.mBottom);
    }

    public Rect changeUnits(int eNewUnits) {
        return new Rect(this.mLeft.changeUnits(eNewUnits), this.mTop.changeUnits(eNewUnits), this.mRight.changeUnits(eNewUnits), this.mBottom.changeUnits(eNewUnits));
    }

    public Rect topLeft(CoordPair newTopLeft) {
        return new Rect(newTopLeft.x(), newTopLeft.y(), this.mRight, this.mBottom);
    }

    public Rect topRight(CoordPair newTopRight) {
        return new Rect(this.mLeft, newTopRight.y(), newTopRight.x(), this.mBottom);
    }

    public Rect bottomLeft(CoordPair newBottomLeft) {
        return new Rect(newBottomLeft.x(), this.mTop, this.mRight, newBottomLeft.y());
    }

    public Rect bottomRight(CoordPair newBottomRight) {
        return new Rect(this.mLeft, this.mTop, newBottomRight.x(), newBottomRight.y());
    }

    public UnitSpan height() {
        return this.mBottom.subtract(this.mTop);
    }

    public UnitSpan width() {
        return this.mRight.subtract(this.mLeft);
    }

    public Rect height(UnitSpan newHeight, boolean bStretchTop) {
        return bStretchTop ? this.bottomHeight(this.mBottom, newHeight) : this.topHeight(this.mTop, newHeight);
    }

    public Rect width(UnitSpan newWidth, boolean bStretchLeft) {
        return bStretchLeft ? this.rightWidth(this.mRight, newWidth) : this.leftWidth(this.mLeft, newWidth);
    }

    public CoordPair centre() {
        return new CoordPair(this.mLeft.add(this.mRight).divide(2), this.mTop.add(this.mBottom).divide(2));
    }

    public boolean contains(CoordPair point) {
        return point.x().gte(this.mLeft) && point.x().lte(this.mRight) && point.y().gte(this.mTop) && point.y().lte(this.mBottom);
    }

    public boolean contains(Rect rect) {
        return this.contains(rect.topLeft()) && this.contains(rect.bottomRight());
    }

    public boolean overlaps(Rect rect) {
        return rect.mRight.gte(this.mLeft) && rect.mLeft.lte(this.mRight) && rect.mBottom.gte(this.mTop) && rect.mTop.lte(this.mBottom);
    }

    public boolean disjoint(Rect rect) {
        return rect.mRight.lte(this.mLeft) || rect.mLeft.gte(this.mRight) || rect.mBottom.lte(this.mTop) || rect.mTop.gte(this.mBottom);
    }

    public boolean isDegenerate() {
        return this.mRight.lte(this.mLeft) || this.mBottom.lte(this.mTop);
    }

    public Rect rotate(CoordPair point, Angle angle) {
        if (angle.degrees() == 0) {
            return this;
        }
        CoordPair rTopLeft = this.topLeft().rotatePoint(point, angle);
        CoordPair rTopRight = this.topRight().rotatePoint(point, angle);
        CoordPair rBottomLeft = this.bottomLeft().rotatePoint(point, angle);
        CoordPair rBottomRight = this.bottomRight().rotatePoint(point, angle);
        return new Rect(this.minUnit(rTopLeft.x(), rTopRight.x(), rBottomLeft.x(), rBottomRight.x()), this.minUnit(rTopLeft.y(), rTopRight.y(), rBottomLeft.y(), rBottomRight.y()), this.maxUnit(rTopLeft.x(), rTopRight.x(), rBottomLeft.x(), rBottomRight.x()), this.maxUnit(rTopLeft.y(), rTopRight.y(), rBottomLeft.y(), rBottomRight.y()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Rect cmp = (Rect)object;
        return this.mLeft.equals(cmp.mLeft) && this.mTop.equals(cmp.mTop) && this.mRight.equals(cmp.mRight) && this.mBottom.equals(cmp.mBottom);
    }

    public int hashCode() {
        int hash = 13;
        hash = hash * 31 ^ this.mLeft.hashCode();
        hash = hash * 31 ^ this.mTop.hashCode();
        hash = hash * 31 ^ this.mRight.hashCode();
        hash = hash * 31 ^ this.mBottom.hashCode();
        return hash;
    }

    public boolean notEquals(Object compare) {
        return !this.equals(compare);
    }

    public Rect add(CoordPair add) {
        return new Rect(this.mLeft.add(add.x()), this.mTop.add(add.y()), this.mRight.add(add.x()), this.mBottom.add(add.y()));
    }

    public Rect subtract(CoordPair subtract) {
        return new Rect(this.mLeft.subtract(subtract.x()), this.mTop.subtract(subtract.y()), this.mRight.subtract(subtract.x()), this.mBottom.subtract(subtract.y()));
    }

    public Rect union(Rect union) {
        return new Rect(this.minUnit(this.mLeft, union.mLeft), this.minUnit(this.mTop, union.mTop), this.maxUnit(this.mRight, union.mRight), this.maxUnit(this.mBottom, union.mBottom));
    }

    public Rect intersection(Rect intersect) {
        UnitSpan left = this.maxUnit(this.mLeft, intersect.mLeft);
        UnitSpan top = this.maxUnit(this.mTop, intersect.mTop);
        UnitSpan right = this.minUnit(this.mRight, intersect.mRight);
        UnitSpan bottom = this.minUnit(this.mBottom, intersect.mBottom);
        return left.gt(right) || top.gt(bottom) ? ZERO : new Rect(left, top, right, bottom);
    }

    public static Rect zero() {
        return ZERO;
    }

    private UnitSpan minUnit(UnitSpan point1, UnitSpan point2) {
        return point1.lt(point2) ? point1 : point2;
    }

    private UnitSpan maxUnit(UnitSpan point1, UnitSpan point2) {
        return point1.gt(point2) ? point1 : point2;
    }

    private UnitSpan minUnit(UnitSpan point1, UnitSpan point2, UnitSpan point3, UnitSpan point4) {
        return this.minUnit(this.minUnit(point1, point2), this.minUnit(point3, point4));
    }

    private UnitSpan maxUnit(UnitSpan point1, UnitSpan point2, UnitSpan point3, UnitSpan point4) {
        return this.maxUnit(this.maxUnit(point1, point2), this.maxUnit(point3, point4));
    }
}

