/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.markup.MarkupAttr;
import com.adobe.xfa.text.markup.MarkupIn;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.UnitSpan;

public abstract class MarkupEngineIn
extends MarkupIn {
    protected static final int STATE_TEXT = 0;
    protected static final int STATE_COMMAND = 1;
    protected static final int STATE_COMMAND_UNKNOWN = 2;
    protected static final int STATE_QUOTE = 3;
    protected static final int DEFAULT_UNITS_PER_POINT = 20;
    protected int meState;
    protected final boolean mbBlockScoping;
    protected final char mcBlockPrefix;
    protected final char mcBlockSuffix;
    protected final char mcCommandPrefix;
    protected TextAttr moCurrentAttr;
    protected final Storage<TextAttr> moAttrList;
    protected TextAttr moAmbientAttr;
    protected int mnIndex;
    protected String mpStrSource;
    protected static final UnitSpan DEFAULT_FONT_SIZE = new UnitSpan(19, 12000);
    protected static final String DEFAULT_TYPEFACE_NAME = "Courier Std";
    private final MarkupAttr mpMarkupAttr;
    private int mnTextStart;
    private int mePendingTab = 0;

    @Override
    public void translate() {
        int CR = 13;
        StringBuilder oStrCommand = new StringBuilder();
        while (this.mnIndex < this.mpStrSource.length()) {
            char c = this.mpStrSource.charAt(this.mnIndex);
            switch (this.meState) {
                case 0: {
                    int eTag;
                    if (c == this.mcCommandPrefix) {
                        if (this.mpStrSource.substring(this.mnIndex, this.mnIndex + 2).equals(this.mpMarkupAttr.lookup(24))) {
                            if (this.mnIndex > this.mnTextStart) {
                                this.flushText();
                            }
                            oStrCommand.setLength(0);
                            oStrCommand.append(this.mpStrSource, this.mnIndex + 1, this.mnIndex + 4);
                            this.mnIndex += 3;
                            eTag = this.mpMarkupAttr.extractTag(oStrCommand);
                            this.onCommand(eTag, oStrCommand.toString());
                            this.meState = 0;
                            oStrCommand.setLength(0);
                            this.restartTextCollection();
                            break;
                        }
                        this.flushText();
                        oStrCommand.setLength(0);
                        this.meState = 1;
                        break;
                    }
                    if (c == '\r') {
                        this.flushText();
                        oStrCommand.setLength(0);
                        this.restartTextCollection();
                        break;
                    }
                    if (!this.mbBlockScoping) break;
                    if (c == this.mcBlockPrefix) {
                        this.parseBlock();
                        oStrCommand.setLength(0);
                        break;
                    }
                    if (c != this.mcBlockSuffix) break;
                    this.flushText();
                    this.restartTextCollection();
                    return;
                }
                case 1: {
                    int eTag;
                    if (this.mpMarkupAttr.isDelimiter(c)) {
                        if (oStrCommand.length() == 0) {
                            String cc = "";
                            cc = c == '~' ? cc + '\u00a0' : cc + c;
                            this.text(cc);
                            this.restartTextCollection();
                            this.meState = 0;
                            break;
                        }
                        eTag = this.mpMarkupAttr.extractTag(oStrCommand);
                        if (!this.onCommand(eTag, oStrCommand.toString())) {
                            this.restartTextCollection();
                            this.meState = 0;
                        } else {
                            if (this.skipThisCommand(eTag)) {
                                this.mnIndex = this.skipBlock(this.mnIndex, this.mpStrSource);
                                this.restartTextCollection();
                                return;
                            }
                            this.meState = 0;
                        }
                        if (eTag == 25) {
                            c = this.mpStrSource.charAt(this.mnIndex);
                        }
                        oStrCommand.setLength(0);
                        this.restartTextCollection();
                        if (c == this.mcCommandPrefix) {
                            this.meState = 1;
                            if (!this.mpStrSource.substring(this.mnIndex, this.mnIndex + 2).equals(this.mpMarkupAttr.lookup(24))) break;
                            if (this.mnIndex > this.mnTextStart) {
                                this.flushText();
                            }
                            oStrCommand.setLength(0);
                            oStrCommand.append(this.mpStrSource, this.mnIndex + 1, this.mnIndex + 4);
                            this.mnIndex += 3;
                            eTag = this.mpMarkupAttr.extractTag(oStrCommand);
                            this.onCommand(eTag, oStrCommand.toString());
                            this.meState = 0;
                            oStrCommand.setLength(0);
                            this.restartTextCollection();
                            break;
                        }
                        if (!this.mbBlockScoping) break;
                        if (c == this.mcBlockPrefix) {
                            this.parseBlock();
                            break;
                        }
                        if (c != this.mcBlockSuffix) break;
                        this.commitPending(true);
                        return;
                    }
                    if (c == '\"') {
                        this.meState = 3;
                        break;
                    }
                    oStrCommand.append(c);
                    break;
                }
                case 2: {
                    if (c == this.mcCommandPrefix) {
                        this.meState = 1;
                    } else if (this.mbBlockScoping) {
                        if (c == this.mcBlockPrefix) {
                            this.parseBlock();
                        } else if (c == this.mcBlockSuffix) {
                            return;
                        }
                    }
                    this.restartTextCollection();
                    break;
                }
                case 3: {
                    if (c == '\"') {
                        this.meState = 1;
                        break;
                    }
                    oStrCommand.append(c);
                }
            }
            ++this.mnIndex;
        }
        switch (this.meState) {
            case 0: {
                this.flushText();
                break;
            }
            case 1: 
            case 3: {
                if (oStrCommand.length() <= 0) break;
                this.onCommand(this.mpMarkupAttr.extractTag(oStrCommand), oStrCommand.toString());
            }
        }
    }

    public void setSourceText(String sStrSource) {
        this.mpStrSource = sStrSource;
        this.reset();
    }

    protected MarkupEngineIn(String sStrSource, MarkupAttr pMarkupAttr) {
        this.mpStrSource = sStrSource;
        this.mpMarkupAttr = pMarkupAttr;
        this.mbBlockScoping = pMarkupAttr.hasBlockScoping();
        this.mcBlockPrefix = pMarkupAttr.blockPrefix();
        this.mcBlockSuffix = pMarkupAttr.blockSuffix();
        this.mcCommandPrefix = pMarkupAttr.commandPrefix();
        this.moAttrList = new Storage();
        this.moCurrentAttr = new TextAttr();
        this.moAmbientAttr = new TextAttr();
        this.reset();
    }

    protected abstract boolean onCommand(int var1, String var2);

    protected String sourceText() {
        return this.mpStrSource;
    }

    protected TextAttr textAttr() {
        return this.moCurrentAttr;
    }

    protected MarkupAttr markupAttr() {
        return this.mpMarkupAttr;
    }

    protected void flushAttr() {
        if (!this.moCurrentAttr.isEmpty()) {
            this.attr(this.moCurrentAttr);
        }
        this.mePendingTab = 0;
    }

    protected void flushText() {
        if (this.hasPendingMBText()) {
            this.flushAttr();
            this.text(this.mbText());
        }
        if (this.mnIndex > this.mnTextStart) {
            this.flushAttr();
            this.text(this.mpStrSource.substring(this.mnTextStart, this.mnIndex));
        }
    }

    protected UnitSpan loadNumber(String oStrSource) {
        return this.loadNumber(oStrSource, UnitSpan.defaultUnits(), 20);
    }

    protected UnitSpan loadNumber(String oStrSource, int eUnits) {
        return this.loadNumber(oStrSource, eUnits, 20);
    }

    protected UnitSpan loadNumber(String oStrSource, int eUnits, int nUnitsPerPoint) {
        StringBuilder oStrTemp = new StringBuilder(oStrSource);
        while (oStrTemp.length() > 0 && this.mpMarkupAttr.isDelimiter(oStrTemp.charAt(0))) {
            oStrTemp.deleteCharAt(0);
        }
        int nValue = Integer.parseInt(oStrTemp.toString());
        nValue *= 1000;
        nValue = Math.round((float)nValue * 1000.0f / (float)nUnitsPerPoint);
        return new UnitSpan(eUnits, 19, nValue);
    }

    protected void parseBlock() {
        this.startBlock();
        int eStateSaved = this.meState;
        int ePendingTabSaved = this.mePendingTab;
        this.flushText();
        this.flushAttr();
        this.pushAttr();
        this.restartTextCollection();
        ++this.mnIndex;
        this.meState = 0;
        this.translate();
        this.flushText();
        this.restartTextCollection();
        this.endBlock();
        this.popAttr();
        this.flushAttr();
        this.commitPending(true);
        this.meState = eStateSaved;
        this.mePendingTab = ePendingTabSaved;
    }

    protected void pendingTab(int ePendingTab) {
        this.mePendingTab = ePendingTab;
    }

    protected int pendingTab() {
        return this.mePendingTab;
    }

    protected void restartTextCollection() {
        this.mnTextStart = this.mnIndex + 1;
    }

    protected boolean skipThisCommand(int eTag) {
        return false;
    }

    protected UnitSpan defaultFontSize() {
        return DEFAULT_FONT_SIZE;
    }

    protected String defaultTypeface() {
        return DEFAULT_TYPEFACE_NAME;
    }

    protected int skipBlock(int nStart, String sRTF) {
        int nIndex;
        int nBraceLevel = 1;
        for (nIndex = nStart; nIndex < sRTF.length(); ++nIndex) {
            char c = sRTF.charAt(nIndex);
            if (c == this.mcBlockPrefix) {
                ++nBraceLevel;
            } else if (c == this.mcBlockSuffix) {
                --nBraceLevel;
            }
            if (nBraceLevel == 0) break;
        }
        return nIndex;
    }

    protected void startBlock() {
    }

    protected void endBlock() {
    }

    protected void reset() {
        this.meState = 0;
        this.mnIndex = 0;
        this.mnTextStart = 0;
        this.moCurrentAttr.setDefault(true);
        this.moCurrentAttr.typefaceEnable(false);
        this.moCurrentAttr.sizeEnable(false);
        this.moCurrentAttr.specialEnable(false);
        this.moCurrentAttr.justifyVEnable(false);
        this.moCurrentAttr.justifyHEnable(false);
        this.moCurrentAttr.tabsEnable(false);
        this.moCurrentAttr.spacingEnable(false);
        this.moCurrentAttr.spaceBeforeEnable(false);
        this.moCurrentAttr.spaceAfterEnable(false);
        this.moCurrentAttr.marginLEnable(false);
        this.moCurrentAttr.marginREnable(false);
        this.moCurrentAttr.colourBgEnable(false);
        this.moAttrList.clear();
        this.pushAttr();
    }

    protected void popAttr() {
        this.moCurrentAttr = this.moAttrList.last();
        this.moAttrList.removeLast();
        TextAttr oNonParaAttrs = new TextAttr(this.moCurrentAttr);
        oNonParaAttrs.isolatePara(false, false);
        this.attr(oNonParaAttrs);
    }

    protected void pushAttr() {
        this.moAttrList.add(new TextAttr(this.moCurrentAttr));
    }
}

