/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TraditionalFrame;
import com.adobe.xfa.ut.UnitSpan;

class RegionFrame
extends TraditionalFrame {
    private UnitSpan moMinWidth;
    private UnitSpan moMinHeight;
    private UnitSpan moMaxWidth;
    private UnitSpan moMaxHeight;
    private UnitSpan moAlignmentWidth;
    private UnitSpan moAlignmentHeight;
    private boolean mbTestFitSize;
    private static final UnitSpan DEFAULT_SIZE = new UnitSpan(3, 72000);

    RegionFrame() {
        this.mbTestFitSize = true;
    }

    RegionFrame(RegionFrame oSource) {
        this.copyFrom(oSource);
    }

    void setMinWidth(UnitSpan oMinWidth) {
        this.moMinWidth = oMinWidth;
    }

    void setMinHeight(UnitSpan oMinHeight) {
        this.moMinHeight = oMinHeight;
    }

    void setMaxWidth(UnitSpan oMaxWidth) {
        this.moMaxWidth = oMaxWidth;
    }

    void setMaxHeight(UnitSpan oMaxHeight) {
        this.moMaxHeight = oMaxHeight;
    }

    void setAlignmentWidth(UnitSpan oAlignmentWidth) {
        this.moAlignmentWidth = oAlignmentWidth;
    }

    void setAlignmentHeight(UnitSpan oAlignmentHeight) {
        this.moAlignmentHeight = oAlignmentHeight;
    }

    void setTestFitSize(boolean bTestFitSize) {
        this.mbTestFitSize = bTestFitSize;
    }

    @Override
    public UnitSpan minWidth() {
        return this.moMinWidth == null ? DEFAULT_SIZE : this.moMinWidth;
    }

    @Override
    public UnitSpan minHeight() {
        return this.moMinHeight == null ? DEFAULT_SIZE : this.moMinHeight;
    }

    @Override
    public UnitSpan maxWidth() {
        return this.moMaxWidth == null ? DEFAULT_SIZE : this.moMaxWidth;
    }

    @Override
    public UnitSpan maxHeight() {
        return this.moMaxHeight == null ? DEFAULT_SIZE : this.moMaxHeight;
    }

    @Override
    UnitSpan alignmentWidth() {
        return this.moAlignmentWidth;
    }

    @Override
    boolean enforceAlignmentWidth() {
        return this.moAlignmentWidth != null;
    }

    @Override
    UnitSpan alignmentHeight() {
        return this.moAlignmentHeight;
    }

    @Override
    boolean enforceAlignmentHeight() {
        return this.moAlignmentHeight != null;
    }

    @Override
    boolean testFitSize() {
        return this.mbTestFitSize;
    }

    @Override
    boolean enforceDisplayExtent() {
        return true;
    }

    void copyFrom(RegionFrame oSource) {
        if (this != oSource) {
            this.moMinWidth = oSource.moMinWidth;
            this.moMinHeight = oSource.moMinHeight;
            this.moMaxWidth = oSource.moMaxWidth;
            this.moMaxHeight = oSource.moMaxHeight;
            this.moAlignmentWidth = oSource.moAlignmentWidth;
            this.moAlignmentHeight = oSource.moAlignmentHeight;
            this.mbTestFitSize = oSource.mbTestFitSize;
        }
    }

    boolean equals(RegionFrame oCompare) {
        return RegionFrame.compareUnits(this.moMinWidth, oCompare.moMinWidth) && RegionFrame.compareUnits(this.moMinHeight, oCompare.moMinHeight) && RegionFrame.compareUnits(this.moMaxWidth, oCompare.moMaxWidth) && RegionFrame.compareUnits(this.moMaxHeight, oCompare.moMaxHeight) && RegionFrame.compareUnits(this.moAlignmentWidth, oCompare.moAlignmentWidth) && RegionFrame.compareUnits(this.moAlignmentHeight, oCompare.moAlignmentHeight);
    }

    private static boolean compareUnits(UnitSpan a, UnitSpan b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

