/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.AFEFixedAttr;
import com.adobe.xfa.text.AFEVarAttr;
import com.adobe.xfa.text.AFEVarAttrTest;
import com.adobe.xfa.text.DispRun;
import com.adobe.xfa.text.TextContext;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

class AFEAttrMap {
    private final TextContext mContext;
    private final Map<Object, Integer> mAFEIndexMap = new HashMap<Object, Integer>();
    private final SortedMap<AFEFixedAttr, AFEFixedAttr> mFixedAttrs = new TreeMap<AFEFixedAttr, AFEFixedAttr>();
    private final SortedMap<AFEVarAttr, AFEVarAttr> mVarAttrs = new TreeMap<AFEVarAttr, AFEVarAttr>();
    private AFEFixedAttr mFixedTest;
    private final AFEVarAttrTest mVarTest;
    private Object[] mAFEKeys;
    private final AFEVarAttr mEmptyVarAttr;

    AFEAttrMap(TextContext context) {
        this.mContext = context;
        this.mVarTest = new AFEVarAttrTest(this);
        this.mEmptyVarAttr = new AFEVarAttr(this);
    }

    TextContext getContext() {
        return this.mContext;
    }

    int getAFEIndexCount() {
        return this.mAFEIndexMap.size();
    }

    Object[] getAFEKeys() {
        if (this.mAFEKeys == null) {
            this.mAFEKeys = new Object[this.mAFEIndexMap.size()];
            for (Map.Entry<Object, Integer> entry : this.mAFEIndexMap.entrySet()) {
                this.mAFEKeys[entry.getValue().intValue()] = entry.getKey();
            }
        }
        return this.mAFEKeys;
    }

    AFEVarAttr getEmptyVarAttr() {
        return this.mEmptyVarAttr;
    }

    int mapAFEIndex(Object attribute) {
        int result;
        Integer i = this.mAFEIndexMap.get(attribute);
        if (i == null) {
            result = this.mAFEIndexMap.size();
            this.mAFEIndexMap.put(attribute, result);
            this.mAFEKeys = null;
        } else {
            result = i;
        }
        return result;
    }

    AFEFixedAttr mapFixedAttr(DispRun dispRun, int bidiLevel) {
        if (this.mFixedTest == null) {
            this.mFixedTest = new AFEFixedAttr(this);
        }
        this.mFixedTest.populate(dispRun, bidiLevel);
        AFEFixedAttr result = (AFEFixedAttr)this.mFixedAttrs.get(this.mFixedTest);
        if (result != null) {
            return result;
        }
        result = this.mFixedTest;
        this.mFixedTest = null;
        this.mFixedAttrs.put(result, result);
        return result;
    }

    AFEVarAttr mapVarAttr(AFEVarAttr base, Object key, Object value) {
        this.mVarTest.setup(base, key, value);
        AFEVarAttr result = (AFEVarAttr)this.mVarAttrs.get(this.mVarTest);
        if (result != null) {
            return result;
        }
        result = this.mVarTest.create();
        this.mVarAttrs.put(result, result);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Pooled attributes:\n\tFixed:");
        for (AFEFixedAttr aFEFixedAttr : this.mFixedAttrs.values()) {
            result.append("\n\t\t");
            result.append(aFEFixedAttr.toString());
        }
        result.append("\n\tVariable:");
        for (AFEVarAttr aFEVarAttr : this.mVarAttrs.values()) {
            result.append("\n\t\t");
            result.append(aFEVarAttr.toString());
        }
        return result.toString();
    }
}

