/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Chars;
import com.adobe.xfa.Comment;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.dom.CommentImpl;
import com.adobe.xfa.dom.DocumentImpl;
import com.adobe.xfa.dom.ElementImpl;
import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.ParentNode;
import com.adobe.xfa.dom.ProcessingInstructionImpl;
import com.adobe.xfa.dom.TextImpl;

public abstract class XFANodeHolder
extends NodeImpl {
    private final Node mXFANode;

    public Node getmXFANode() {
        return this.mXFANode;
    }

    XFANodeHolder(ParentNode parent, Node newNode) {
        super(parent);
        if (newNode instanceof Element.DualDomNode) {
            newNode = ((Element.DualDomNode)((Object)newNode)).getXmlPeer();
        }
        this.mXFANode = newNode;
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        XFANodeHolder result = this.forceNext();
        return result;
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        XFANodeHolder result = this.forcePrev();
        return result;
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node other) {
        if (!(other instanceof XFANodeHolder)) {
            return false;
        }
        XFANodeHolder otherXFANodeHolder = (XFANodeHolder)other;
        return this.mXFANode == otherXFANodeHolder.mXFANode;
    }

    XFANodeHolder forceNext() {
        NodeImpl nextNode = this.getNext();
        if (nextNode != null) {
            assert (nextNode instanceof XFANodeHolder);
            return (XFANodeHolder)nextNode;
        }
        ParentNode parent = this.getParent();
        return parent != null ? parent.forceNext(this) : null;
    }

    XFANodeHolder forcePrev() {
        NodeImpl prevNode = this.getPrev();
        if (prevNode != null) {
            assert (prevNode instanceof XFANodeHolder);
            return (XFANodeHolder)prevNode;
        }
        ParentNode parent = this.getParent();
        return parent != null ? parent.forcePrev(this) : null;
    }

    final Node getXFANode() {
        return this.mXFANode;
    }

    static final Element getXFAParent(Node node) {
        Element parent = node.getXMLParent();
        if (parent instanceof Element.DualDomNode) {
            parent = (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer();
        }
        return parent;
    }

    static XFANodeHolder createNode(ParentNode parent, Node source) {
        if (source instanceof Element.DualDomNode) {
            source = ((Element.DualDomNode)((Object)source)).getXmlPeer();
        }
        if (source instanceof Chars) {
            return new TextImpl(parent, (Chars)source);
        }
        if (source instanceof Comment) {
            return new CommentImpl(parent, (Comment)source);
        }
        if (source instanceof Document) {
            return new DocumentImpl((Document)source);
        }
        if (source instanceof Element) {
            return new ElementImpl(parent, (Element)source);
        }
        if (source instanceof ProcessingInstruction) {
            return new ProcessingInstructionImpl(parent, (ProcessingInstruction)source);
        }
        assert (false);
        return null;
    }
}

