/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.connectionset;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Generator;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.Schema;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.connectionset.ConnectionSetModelFactory;
import com.adobe.xfa.connectionset.ConnectionSetSchema;
import com.adobe.xfa.connectionset.proxies.ConnectionSetProxy;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.Numeric;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConnectionSetModel
extends Model {
    private static final ConnectionSetSchema gConnectionSetSchema = new ConnectionSetSchema();
    private static final String gsConnectionSetUri = "http://www.xfa.org/schema/xfa-connection-set/2.8/";
    Storage<ConnectionSetProxy> mProxyArray = new Storage();

    public ConnectionSetModel(Element parent, Node prevSibling) {
        super(parent, prevSibling, gsConnectionSetUri, "connectionSet", "connectionSet", "$connectionSet", XFA.CONNECTIONSETTAG, "connectionSet", ConnectionSetModel.getModelSchema());
        this.setModel(this);
    }

    public static String connectionSetNS() {
        return gsConnectionSetUri;
    }

    public static ConnectionSetModel getConnectionSetModel(AppModel appModel, boolean bCreateIfNotFound) {
        ConnectionSetModel model = (ConnectionSetModel)Model.getNamedModel(appModel, "connectionSet");
        if (bCreateIfNotFound && model == null) {
            ConnectionSetModelFactory factory = new ConnectionSetModelFactory();
            model = (ConnectionSetModel)factory.createDOM((Element)appModel.getXmlPeer());
            model.setDocument(appModel.getDocument());
            model.loadChildren(model, new Generator("", ""));
            appModel.notifyPeers(4, "connectionSet", model);
        }
        return model;
    }

    protected static Schema getModelSchema() {
        return gConnectionSetSchema;
    }

    @Override
    public Node createNode(int eTag, Element parent, String aName, String aNS, boolean bDoVersionCheck) {
        assert (aName != null);
        assert (aNS != null);
        Element retVal = this.getSchema().getInstance(eTag, this, parent, null, bDoVersionCheck);
        if (aName != "") {
            retVal.setName(aName);
        }
        return retVal;
    }

    public Node doLoadNode(Node parent, Node node, Generator genTag) {
        if (node instanceof Element && ((Element)node).getNS() == "http://schemas.xmlsoap.org/ws/2004/09/policy") {
            return null;
        }
        return this.doLoadNode(parent, node, genTag);
    }

    public boolean execute(Element oConnectionNode, boolean bDynamicMerge) {
        for (int i = 0; i < this.mProxyArray.size(); ++i) {
            if (!((ConnectionSetProxy)this.mProxyArray.get(i)).handlesConnection(XFA.WSDLCONNECTIONTAG)) continue;
            return ((ConnectionSetProxy)this.mProxyArray.get(i)).execute(oConnectionNode, bDynamicMerge);
        }
        return false;
    }

    public boolean execute(String sConnectionName, boolean bDynamicMerge) {
        Node oExecuteNode = this.getNamedConnection(sConnectionName, XFA.WSDLCONNECTIONTAG);
        if (!(oExecuteNode instanceof Element)) {
            return false;
        }
        return this.execute((Element)oExecuteNode, bDynamicMerge);
    }

    @Override
    public String getBaseNS() {
        return "http://www.xfa.org/schema/xfa-connection-set/";
    }

    public String getDataDescriptionName(String sConnectionName) {
        Attribute oDDAttr;
        String sDDName = null;
        Node oConnection = this.getNamedConnection(sConnectionName);
        if (oConnection instanceof Element && (oDDAttr = ((Element)oConnection).getAttribute(XFA.DATADESCRIPTIONTAG, true, false)) != null) {
            sDDName = oDDAttr.toString();
        }
        return sDDName;
    }

    public Node getDefaultDataConnection() {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!child.isSameClass(XFA.XSDCONNECTIONTAG) && !child.isSameClass(XFA.XMLCONNECTIONTAG)) continue;
            return child;
        }
        return null;
    }

    boolean getEventDispatch() {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "ConnectionSetModel#getEventDispatch");
    }

    @Override
    public String getHeadNS() {
        return ConnectionSetModel.connectionSetNS();
    }

    @Override
    public int getHeadVersion() {
        return 28;
    }

    protected Node getNamedConnection(String sConnectionName) {
        if (sConnectionName == null) {
            return null;
        }
        String aConnectionName = sConnectionName.intern();
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getName() != aConnectionName) continue;
            return child;
        }
        return null;
    }

    public Node getNamedConnection(String sConnectionName, int eClass) {
        if (sConnectionName == null) {
            return null;
        }
        String aConnectionName = sConnectionName.intern();
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!child.isSameClass(eClass) || child.getName() != aConnectionName) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getNS() {
        int nVersion = this.getCurrentVersion();
        AppModel appModel = this.getAppModel();
        if (appModel != null) {
            for (Node child = appModel.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!(child instanceof TemplateModel)) continue;
                nVersion = ((TemplateModel)child).getCurrentVersion();
                break;
            }
        }
        if (nVersion > 0) {
            if (nVersion >= 28) {
                nVersion = 28;
            } else if (nVersion > 25 && nVersion < 28) {
                nVersion = 24;
            } else if (nVersion <= 25) {
                nVersion = 21;
            }
            double dVersion = (double)nVersion / 10.0;
            String sNS = this.getBaseNS() + Numeric.doubleToString(dVersion, 1, false) + '/';
            return sNS.intern();
        }
        return super.getNS();
    }

    public void loadChildren(Node startNode, Generator genTag) {
        this.isLoading(true);
        this.resolveProtos(false);
        this.isLoading(false);
    }

    public void loadNode(Node parent, Node node, Generator genTag) {
        this.doLoadNode(parent, node, genTag);
    }

    @Override
    protected void postLoad() {
        AppModel oApp = this.getAppModel();
        List<ModelFactory> factories = oApp.factories();
        for (int i = 0; i < factories.size(); ++i) {
            ModelFactory oFactory = factories.get(i);
            if (!oFactory.isRootName(this.getLocalName())) continue;
            assert (oFactory instanceof ConnectionSetModelFactory);
            ConnectionSetModelFactory factory = (ConnectionSetModelFactory)oFactory;
            for (int j = 0; j < factory.mProxyArray.size(); ++j) {
                this.registerProxy((ConnectionSetProxy)factory.mProxyArray.get(j));
            }
        }
    }

    @Override
    public boolean publish(Model.Publisher publisher) {
        HashMap<String, String> fileRefCache = new HashMap<String, String>();
        this.publishNode(publisher, this, fileRefCache);
        return super.publish(publisher);
    }

    private void publishNode(Model.Publisher publisher, Node node, Map<String, String> fileRefCache) {
        String sNewFileRef;
        String sFileRef;
        TextNode textNode;
        Node child;
        if (node.isSameClass(XFA.URITAG)) {
            child = node.getFirstXFAChild();
            if (child instanceof TextNode) {
                textNode = (TextNode)node.getFirstXFAChild();
                sFileRef = textNode.getValue();
                sNewFileRef = fileRefCache.get(sFileRef);
                if (StringUtils.isEmpty(sNewFileRef)) {
                    sNewFileRef = publisher.updateExternalRef(node, XFA.TEXTNODETAG, sFileRef);
                    fileRefCache.put(sFileRef, sNewFileRef);
                }
                if (!sFileRef.equals(sNewFileRef)) {
                    textNode.setValue(sNewFileRef, true, false);
                }
            }
        } else if (node.isSameClass(XFA.WSDLADDRESSTAG) && (child = node.getFirstXFAChild()) instanceof TextNode && new File(sFileRef = (textNode = (TextNode)child).getValue()).isFile()) {
            sNewFileRef = fileRefCache.get(sFileRef);
            if (StringUtils.isEmpty(sNewFileRef)) {
                sNewFileRef = publisher.updateExternalRef(node, XFA.TEXTNODETAG, sFileRef);
                fileRefCache.put(sFileRef, sNewFileRef);
            }
            if (!sFileRef.equals(sNewFileRef)) {
                textNode.setValue(sNewFileRef, true, false);
            }
        }
        for (child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            this.publishNode(publisher, child, fileRefCache);
        }
    }

    public void registerProxy(ConnectionSetProxy oProxy) {
        ConnectionSetProxy oClone = oProxy.clone();
        oClone.moOwner = this;
        this.mProxyArray.add(oClone);
    }

    void setEventDispatch(boolean state) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "ConnectionSetModel#setEventDispatch");
    }

    protected boolean supportsSaveProtoInformation() {
        return true;
    }
}

