/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.LogPseudoModelScript;
import com.adobe.xfa.PseudoModel;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.trace.Trace;
import com.adobe.xfa.ut.trace.TraceHandler;

class LogPseudoModel
extends PseudoModel {
    private final AppModel moAppModel;

    public LogPseudoModel(AppModel oAppModel) {
        this.moAppModel = oAppModel;
        this.setClass("logPseudoModel");
    }

    @Override
    public String getClassAtom() {
        return super.getClassName();
    }

    @Override
    public ScriptTable getScriptTable() {
        return LogPseudoModelScript.moScriptTable;
    }

    public void message(int nNewResId, String sMessage, String sSeverity) {
        int eSeverity = 2;
        if (sSeverity.length() > 0) {
            switch (sSeverity.charAt(0)) {
                case 'w': {
                    eSeverity = 3;
                    break;
                }
                case 'f': {
                    eSeverity = 6;
                    break;
                }
                case 't': {
                    eSeverity = 1;
                    break;
                }
            }
        }
        ExFull oMsg = new ExFull(nNewResId, sMessage);
        this.moAppModel.addErrorList(oMsg, eSeverity, null);
    }

    public void traceActivate(String sNamesAndLevels) {
        TraceHandler.getTraceHandler().activate(sNamesAndLevels);
    }

    public void traceDeactivate(String sName) {
        TraceHandler.getTraceHandler().deactivate(sName);
    }

    public void trace(String sName, int nLevel, int nId, String sMsg) {
        Trace.trace(sName, nLevel, nId, sMsg);
    }

    @Override
    public boolean validateUsage(int nVersion, int nAvailability, boolean bUpdateVersion) {
        if (this.moAppModel != null) {
            return this.moAppModel.validateUsage(nVersion, nAvailability, bUpdateVersion);
        }
        return super.validateUsage(nVersion, nAvailability, bUpdateVersion);
    }

    @Override
    public boolean validateUsageFailedIsFatal(int nVersion, int nAvailability) {
        if (this.moAppModel != null) {
            return this.moAppModel.validateUsageFailedIsFatal(nVersion, nAvailability);
        }
        return super.validateUsageFailedIsFatal(nVersion, nAvailability);
    }

    @Override
    public void sendMessenge(ExFull error, int eSeverity) {
        if (this.moAppModel != null) {
            this.moAppModel.addErrorList(error, eSeverity, null);
        }
    }
}

