/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.security;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityKeyPKIInterface;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.security.SecurityLocation;
import com.adobe.internal.pdftoolkit.services.security.SecurityProviders;
import java.util.Map;

public class SecurityKeyPKI
implements SecurityKey {
    SecurityKeyPKIInterface mRealKey;

    private SecurityKeyPKI(SecurityKeyPKIInterface realKey) {
        this.mRealKey = realKey;
    }

    public static SecurityKeyPKI newInstance(PDFDocument pdfDoc, Credentials recipient) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException {
        SecurityKeyPKIInterface securityKeyHandle = SecurityLocation.getSecurityKeyPKI();
        Map<String, Object> encryptParams = pdfDoc.getEncryption().getEncryptParameters();
        return new SecurityKeyPKI(securityKeyHandle.makeSecurityKey(recipient, encryptParams, null));
    }

    public static SecurityKeyPKI newInstance(PDFDocument pdfDoc, Credentials recipient, SecurityProviders providers) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException {
        SecurityKeyPKIInterface securityKeyHandle = SecurityLocation.getSecurityKeyPKI();
        Map<String, Object> encryptParams = pdfDoc.getEncryption().getEncryptParameters();
        return new SecurityKeyPKI(securityKeyHandle.makeSecurityKey(recipient, encryptParams, providers));
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mRealKey.getSecurityManager();
    }
}

