/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.readingorder.impl;

import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.services.readingorder.impl.BeforeAfter;
import com.adobe.internal.pdftoolkit.services.readingorder.impl.Boundary;
import com.adobe.internal.pdftoolkit.services.readingorder.impl.Break;
import com.adobe.internal.pdftoolkit.services.readingorder.impl.Group;
import com.adobe.internal.pdftoolkit.services.readingorder.impl.RangeEntry;
import com.adobe.internal.pdftoolkit.services.readingorder.impl.SortedWord;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FindHVBreaks {
    public TreeMap<String, Group> allGroupsWithPrior = new TreeMap();
    ArrayList<Break> bestBreaks = new ArrayList();
    static final double columnAdjacencyFactor = 0.7;
    Map<Double, Integer> sHighFreqs = new LinkedHashMap<Double, Integer>();
    private static final double MARGIN_FACTOR = 0.04;
    private static final double GROUP_FACTOR = 0.25;
    int offset = 0;
    List<Word> wordsInLine = new ArrayList<Word>();
    List<List<List<Word>>> wordsInPage = new ArrayList<List<List<Word>>>();
    List<List<Word>> wordsInPara = new ArrayList<List<Word>>();
    boolean prevWordHyphenation = false;
    boolean resolveHyphenation = false;
    String prevWordWithHyphen = "";
    public boolean bLog;

    private void processDetermineBreaksDebug(ArrayList<Group> groups, TreeMap<Double, RangeEntry> vRanges, TreeMap<Double, RangeEntry> hRanges) {
        if (!this.bLog) {
            return;
        }
        System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ", vRanges: ");
        for (Map.Entry<Double, RangeEntry> t_VRangeEntry : vRanges.entrySet()) {
            RangeEntry t_RangeEntry = t_VRangeEntry.getValue();
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". " + t_VRangeEntry.getKey() + ": " + t_RangeEntry + ". nlowAverage: " + t_RangeEntry.lowAverage + ", highAverage: " + t_RangeEntry.highAverage);
        }
        System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ", hRanges: ");
        for (Map.Entry<Double, RangeEntry> t_HRangeEntry : hRanges.entrySet()) {
            RangeEntry t_RangeEntry = t_HRangeEntry.getValue();
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". " + t_HRangeEntry.getKey() + ": " + t_RangeEntry + ". nlowAverage: " + t_RangeEntry.lowAverage + ", highAverage: " + t_RangeEntry.highAverage);
        }
        System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". groups: " + groups);
    }

    public void processDetermineBreaks(TreeMap<Double, SortedWord> vline, TreeMap<Double, SortedWord> hline) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TreeMap<Double, RangeEntry> vRanges = new TreeMap<Double, RangeEntry>();
        TreeMap<Double, RangeEntry> hRanges = new TreeMap<Double, RangeEntry>();
        this.determineRanges(vline, vRanges, true);
        this.determineRanges(hline, hRanges, false);
        ArrayList<Group> groups = this.makeGroups(vRanges, hRanges, "");
        if (this.bLog) {
            this.processDetermineBreaksDebug(groups, vRanges, hRanges);
        }
        if (groups.isEmpty()) {
            Iterator<Map.Entry<Double, RangeEntry>> iter = vRanges.entrySet().iterator();
            TreeMap<Double, SortedWord> words = new TreeMap<Double, SortedWord>();
            while (iter.hasNext()) {
                Map.Entry<Double, RangeEntry> ent = iter.next();
                words.putAll(ent.getValue().rangeWords());
            }
            Group g1 = new Group(vRanges, hRanges, words);
            this.allGroupsWithPrior.put("1", g1);
            return;
        }
        if (this.bLog) {
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". PRE findBreakRecursively. allGroupsWithPrior: " + this.allGroupsWithPrior);
        }
        this.findBreakRecursively(groups, 0);
        if (this.bLog) {
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". POST findBreakRecursively. allGroupsWithPrior: " + this.allGroupsWithPrior);
        }
    }

    private void findBreakRecursively(ArrayList<Group> groups, int recursionLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ++recursionLevel;
        for (int i = 0; i < groups.size(); ++i) {
            Group tt = groups.get(i);
            if (tt.getVRanges().size() <= 0 || tt.getHRanges().size() <= 0) continue;
            ArrayList<Group> subGroups = this.makeGroups(tt.getVRanges(), tt.getHRanges(), tt.getGroupPrior());
            if (this.bLog) {
                System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". recurn: " + recursionLevel + ". grpNum: " + i + ". group: " + tt + ". subGroups.size: " + subGroups.size());
            }
            if (!groups.isEmpty() && subGroups.size() == 1) {
                this.allGroupsWithPrior.put(tt.getGroupPrior(), tt);
            } else {
                this.findBreakRecursively(subGroups, recursionLevel);
            }
            if (!subGroups.isEmpty()) continue;
            this.allGroupsWithPrior.put(tt.getGroupPrior(), tt);
        }
    }

    private ArrayList<Group> makeGroups(TreeMap<Double, RangeEntry> vRanges, TreeMap<Double, RangeEntry> hRanges, String prior) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Break bestBreak = null;
        TreeMap<Double, Break> simBBreak = this.findBestHorizontalVerticalBreaks(vRanges, hRanges, bestBreak);
        ArrayList<Group> groups = new ArrayList<Group>();
        if (simBBreak != null) {
            Iterator<Map.Entry<Double, Break>> it = simBBreak.entrySet().iterator();
            Group second = null;
            boolean trueBreak = false;
            while (it.hasNext()) {
                Map.Entry<Double, Break> entry = it.next();
                bestBreak = entry.getValue();
                trueBreak = this.verifyBreak(bestBreak);
                if (!trueBreak) continue;
                this.bestBreaks.add(bestBreak);
                second = this.breakIntoGroups(bestBreak, vRanges, hRanges, groups, prior);
                prior = second.getGroupPrior();
                if (bestBreak.getVertical()) {
                    vRanges = second.getVRanges();
                    continue;
                }
                hRanges = second.getHRanges();
            }
            this.processLastOne(second, groups);
        }
        return groups;
    }

    private void processLastOne(Group second, ArrayList<Group> groups) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (second != null) {
            TreeMap<Double, RangeEntry> hRanges = new TreeMap<Double, RangeEntry>();
            TreeMap<Double, RangeEntry> vRanges = new TreeMap<Double, RangeEntry>();
            this.determineRanges(this.alignWords(second.getWords(), false), hRanges, false);
            this.determineRanges(this.alignWords(second.getWords(), true), vRanges, true);
            if (!vRanges.isEmpty() && !hRanges.isEmpty()) {
                Group lastGroup = new Group(vRanges, hRanges, second.getWords());
                lastGroup.setGroupPrior(second.getGroupPrior());
                lastGroup.setWordAlignVertical(second.wordAlignVertical());
                groups.add(lastGroup);
            }
        }
    }

    private TreeMap<Double, Break> findBestHorizontalVerticalBreaks(TreeMap<Double, RangeEntry> Group1_vRanges, TreeMap<Double, RangeEntry> Group1_hRanges, Break bestBreak) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TreeMap<Double, Break> simBBreak;
        Boundary bd = this.boundaries(Group1_vRanges, Group1_hRanges);
        TreeMap<Double, Break> temp_vertical = simBBreak = this.findBestBreak(Group1_vRanges, true, bestBreak, bd);
        if (!simBBreak.isEmpty()) {
            simBBreak = this.findBestBreak(Group1_hRanges, false, simBBreak.get(simBBreak.firstKey()), bd);
            return simBBreak;
        }
        simBBreak = this.findBestBreak(Group1_hRanges, false, bestBreak, bd);
        if (simBBreak.isEmpty() || !this.verifyAllBreaks(simBBreak)) {
            if (!temp_vertical.isEmpty()) {
                return temp_vertical;
            }
            return null;
        }
        return simBBreak;
    }

    protected TreeMap<Double, Break> findBestBreak(TreeMap<Double, RangeEntry> Ranges, boolean vertical, Break bestBreak, Boundary bd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<Map.Entry<Double, RangeEntry>> itt = Ranges.entrySet().iterator();
        double bend = -1.0;
        Word bword = null;
        RangeEntry bre = null;
        ArrayList<Break> allBreaks = new ArrayList<Break>();
        if (bestBreak != null && this.verifyBreak(bestBreak)) {
            allBreaks.add(bestBreak);
        }
        while (itt.hasNext()) {
            Map.Entry<Double, RangeEntry> entry = itt.next();
            Double ss = entry.getKey();
            RangeEntry ee = entry.getValue();
            if (bend != -1.0) {
                double bwidth = ss - bend;
                Break br = new Break(bwidth, bend, ss, vertical, bword, ee.sWord(), bd);
                if (vertical) {
                    br.setLtopw(bre.getRtop());
                    br.setLbottomw(bre.getRbottom());
                    br.setRtopw(ee.getLtop());
                    br.setRbottomw(ee.getLbottom());
                } else {
                    br.setLtopw(bre.getLbottom());
                    br.setRtopw(bre.getRbottom());
                    br.setLbottomw(ee.getLtop());
                    br.setRbottomw(ee.getRtop());
                }
                if (bestBreak == null) {
                    bestBreak = br;
                } else if (bestBreak.breakSize() < bwidth) {
                    bestBreak = br;
                }
                allBreaks.add(br);
            }
            bend = ee.end();
            bword = ee.eWord();
            bre = ee;
        }
        TreeMap<Double, Break> simBBreak = new TreeMap<Double, Break>();
        if (bestBreak != null) {
            int bbreak_round = Math.round((float)bestBreak.breakSize());
            for (int i = 0; i < allBreaks.size(); ++i) {
                Break btemp = (Break)allBreaks.get(i);
                int tsize_round = Math.round((float)btemp.breakSize());
                if (tsize_round != bbreak_round || btemp.getVertical() != bestBreak.getVertical()) continue;
                simBBreak.put(btemp.getStart(), btemp);
            }
        }
        return simBBreak;
    }

    protected TreeMap<Double, SortedWord> alignWords(TreeMap<Double, SortedWord> groupWords, boolean vertical) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double DELTA = 1.0E-5;
        Iterator<Map.Entry<Double, SortedWord>> it = groupWords.entrySet().iterator();
        TreeMap<Double, SortedWord> align = new TreeMap<Double, SortedWord>();
        while (it.hasNext()) {
            Map.Entry<Double, SortedWord> entry = it.next();
            SortedWord nword = entry.getValue();
            Word word = nword.word();
            ASCoordinate topLeft = this.topLeft(word);
            if (topLeft == null) continue;
            double lowKey = -1.0;
            lowKey = vertical ? topLeft.x() : topLeft.y();
            Double key = lowKey;
            while (align.containsKey(key)) {
                key = lowKey += 1.0E-5;
            }
            align.put(key, nword);
        }
        return align;
    }

    protected boolean verifyBreak(Break bestBreak) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (bestBreak == null) {
            return false;
        }
        double breakSize = bestBreak.breakSize();
        boolean vertical = bestBreak.getVertical();
        Word beforeWord = bestBreak.beforeWord();
        if (beforeWord.getBoundingQuads().size() > 1) {
            return false;
        }
        double beforeCharWidth = this.charW(beforeWord);
        double beforeCharHeight = this.charH(beforeWord);
        if (beforeCharWidth < 0.0 || beforeCharHeight < 0.0) {
            return false;
        }
        Word afterWord = bestBreak.afterWord();
        if (afterWord.getBoundingQuads().size() > 1) {
            return false;
        }
        double afterCharWidth = this.charW(afterWord);
        double afterCharHeight = this.charH(afterWord);
        if (afterCharWidth < 0.0 || afterCharHeight < 0.0) {
            return false;
        }
        if (vertical) {
            if (beforeCharHeight > 0.0 && afterCharHeight > 0.0 && (breakSize > beforeCharWidth * 2.0 || breakSize > afterCharWidth * 2.0)) {
                return true;
            }
        } else {
            try {
                if (beforeCharHeight > 0.0 && afterCharHeight > 0.0 && (breakSize > beforeCharHeight * 0.7 || breakSize > afterCharHeight * 0.7 || (breakSize > beforeCharHeight * 0.7 || breakSize > afterCharHeight * 0.7) && (beforeWord.getUarray().get(0).getFont().getAFEFont() == null || !beforeWord.getUarray().get(0).getFont().getAFEFont().equals(afterWord.getUarray().get(0).getFont().getAFEFont())))) {
                    return true;
                }
            }
            catch (FontLoadingException e) {
                throw new PDFInvalidDocumentException(e);
            }
        }
        return false;
    }

    protected Group breakIntoGroups(Break bestBreak, TreeMap<Double, RangeEntry> vRanges, TreeMap<Double, RangeEntry> hRanges, ArrayList<Group> Groups, String prior) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TreeMap<Double, RangeEntry> Group1_vRanges = new TreeMap<Double, RangeEntry>();
        TreeMap<Double, RangeEntry> Group2_vRanges = new TreeMap<Double, RangeEntry>();
        TreeMap<Double, SortedWord> group1Words = new TreeMap<Double, SortedWord>();
        TreeMap<Double, SortedWord> group2Words = new TreeMap<Double, SortedWord>();
        TreeMap<Double, RangeEntry> Group1_hRanges = new TreeMap<Double, RangeEntry>();
        TreeMap<Double, RangeEntry> Group2_hRanges = new TreeMap<Double, RangeEntry>();
        if (bestBreak.getVertical()) {
            this.separateWords(bestBreak, vRanges, Group1_vRanges, Group2_vRanges, group1Words, group2Words);
            this.determineRanges(this.alignWords(group1Words, !bestBreak.getVertical()), Group1_hRanges, false);
            Group g1 = new Group(Group1_vRanges, Group1_hRanges, group1Words);
            g1.setWordAlignVertical(bestBreak.getVertical());
            g1.setGroupPrior(prior + "1");
            Groups.add(g1);
            this.determineRanges(this.alignWords(group2Words, !bestBreak.getVertical()), Group2_hRanges, false);
            Group g2 = new Group(Group2_vRanges, Group2_hRanges, group2Words);
            g2.setWordAlignVertical(bestBreak.getVertical());
            g2.setGroupPrior(prior + "2");
            return g2;
        }
        this.separateWords(bestBreak, hRanges, Group1_hRanges, Group2_hRanges, group1Words, group2Words);
        this.determineRanges(this.alignWords(group1Words, !bestBreak.getVertical()), Group1_vRanges, true);
        Group g1 = new Group(Group1_vRanges, Group1_hRanges, group1Words);
        g1.setWordAlignVertical(bestBreak.getVertical());
        g1.setGroupPrior(prior + "1");
        this.determineRanges(this.alignWords(group2Words, !bestBreak.getVertical()), Group2_vRanges, true);
        Group g2 = new Group(Group2_vRanges, Group2_hRanges, group2Words);
        g2.setWordAlignVertical(bestBreak.getVertical());
        g2.setGroupPrior(prior + "2");
        Groups.add(g2);
        return g1;
    }

    private void separateWords(Break bestBreak, TreeMap<Double, RangeEntry> Ranges, TreeMap<Double, RangeEntry> Group1_Ranges, TreeMap<Double, RangeEntry> Group2_Ranges, TreeMap<Double, SortedWord> group1Words, TreeMap<Double, SortedWord> group2Words) {
        for (Map.Entry<Double, RangeEntry> re : Ranges.entrySet()) {
            double startingKey = re.getValue().end();
            double breakMiddle = (bestBreak.getEnd() + bestBreak.getStart()) / 2.0;
            boolean comparison = false;
            if (bestBreak.getVertical()) {
                comparison = startingKey < breakMiddle;
            } else {
                boolean bl = comparison = startingKey > breakMiddle;
            }
            if (comparison) {
                Group1_Ranges.put(re.getKey(), re.getValue());
                group1Words.putAll(re.getValue().rangeWords());
                continue;
            }
            Group2_Ranges.put(re.getKey(), re.getValue());
            group2Words.putAll(re.getValue().rangeWords());
        }
    }

    private boolean verifyAllBreaks(TreeMap<Double, Break> breaks) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (Map.Entry<Double, Break> entry : breaks.entrySet()) {
            Break b = entry.getValue();
            boolean trueBreak = this.verifyBreak(b);
            if (trueBreak) continue;
            return false;
        }
        return true;
    }

    private void determineEdgeWords(RangeEntry re) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<Map.Entry<Double, SortedWord>> itw = re.rangeWords().entrySet().iterator();
        ASCoordinate prevWTopLeft = null;
        Word prevWord = null;
        ASCoordinate wtopLeft = null;
        Word lineStartWord = null;
        Word ltw = null;
        Word rtw = null;
        Word lbw = null;
        Word rbw = null;
        boolean firstline = false;
        while (itw.hasNext()) {
            Map.Entry<Double, SortedWord> ent = itw.next();
            SortedWord value = ent.getValue();
            wtopLeft = this.topLeft(value.word());
            if (prevWord == null) {
                ltw = value.word();
                firstline = true;
            } else if (wtopLeft.x() < prevWTopLeft.x()) {
                lineStartWord = value.word();
                if (firstline) {
                    rtw = prevWord;
                    firstline = false;
                }
            }
            prevWTopLeft = wtopLeft;
            prevWord = value.word();
        }
        rbw = prevWord;
        lbw = lineStartWord;
        re.setLtop(ltw);
        re.setRtop(rtw);
        re.setLbottom(lbw);
        re.setRbottom(rbw);
    }

    protected void determineRanges(TreeMap<Double, SortedWord> projectedWords, TreeMap<Double, RangeEntry> ranges, boolean vertical) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<Map.Entry<Double, SortedWord>> it = projectedWords.entrySet().iterator();
        TreeMap<Double, SortedWord> rangeWords = new TreeMap<Double, SortedWord>();
        double start = -1.0;
        double end = -1.0;
        Word sword = null;
        Word eword = null;
        Word word = null;
        while (it.hasNext()) {
            double low;
            Map.Entry<Double, SortedWord> entry = it.next();
            SortedWord nword = entry.getValue();
            word = nword.word();
            ASCoordinate topLeft = this.topLeft(word);
            ASCoordinate bottomRight = this.bottomRight(word);
            double high = -1.0;
            if (vertical) {
                low = topLeft.x();
                high = bottomRight.x();
            } else {
                low = topLeft.y();
                high = bottomRight.y();
            }
            if (start == -1.0 && end == -1.0) {
                sword = word;
                eword = word;
                start = low;
                end = high;
            } else if (low > end) {
                RangeEntry re = new RangeEntry(end, sword, eword, rangeWords);
                this.determineEdgeWords(re);
                ranges.put(start, re);
                rangeWords = new TreeMap();
                sword = word;
                eword = word;
                start = low;
                end = high;
            } else if (low == end) {
                end = high;
                eword = word;
            } else if (high > end) {
                end = high;
                eword = word;
            }
            Double key = nword.gibsonOrder();
            rangeWords.put(key, nword);
        }
        if (eword != null && sword != null) {
            RangeEntry re = new RangeEntry(end, sword, eword, rangeWords);
            this.determineEdgeWords(re);
            ranges.put(new Double(start), re);
        }
    }

    public void setStartingFrequency(Map<Double, Integer> sF) {
        this.sHighFreqs = sF;
        if (this.bLog) {
            this.someDebugging();
        }
    }

    private void someDebugging() {
        double sHighFreqAvg = 0.0;
        int intVal = -1;
        if (!this.sHighFreqs.isEmpty()) {
            intVal = (Integer)this.sHighFreqs.values().toArray()[0];
        }
        if (this.sHighFreqs.size() > 0) {
            int sum = 0;
            Iterator<Map.Entry<Double, Integer>> ift = this.sHighFreqs.entrySet().iterator();
            while (ift.hasNext()) {
                sum += ift.next().getValue().intValue();
            }
            sHighFreqAvg = sum / this.sHighFreqs.size();
        } else {
            sHighFreqAvg = 0.0;
        }
        System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". sHighFreqs: " + this.sHighFreqs + ". sHighFreqAvg: " + sHighFreqAvg + ". intVal: " + intVal);
    }

    public void breakWithStartingFreqs(TreeMap<String, Group> allGroups) {
        if (this.sHighFreqs.isEmpty()) {
            return;
        }
        int lc = 0;
        Iterator<Map.Entry<String, Group>> it = allGroups.entrySet().iterator();
        while (it.hasNext()) {
            ++lc;
            Map.Entry<String, Group> entry = it.next();
            Group g = entry.getValue();
            if (this.bLog) {
                this.breakWithStartingFreqsDebug(g, lc);
            }
            double groupWordSizeWithFactor = (double)g.getWords().size() * 0.25;
            Double lastKey = g.getVRanges().lastKey();
            double gStart = g.getVRanges().firstKey();
            double gEnd = g.getVRanges().get(lastKey).end();
            Iterator<Map.Entry<Double, Integer>> ift = this.sHighFreqs.entrySet().iterator();
            double bestMatchLoc = -1.0;
            double bestMatchDistance = -1.0;
            int numMatches = 0;
            while (ift.hasNext()) {
                boolean isValid;
                Map.Entry<Double, Integer> ent = ift.next();
                double xLoc = ent.getKey();
                double gmid = (gStart + gEnd) / 2.0;
                double gap = 0.04 * Math.abs(gEnd - gStart);
                int ttt = ent.getValue();
                if (!(groupWordSizeWithFactor > (double)ttt && xLoc > gmid - gap && xLoc < gmid + gap && (isValid = this.isValidBreak(g, xLoc)))) continue;
                double distance = Math.abs(xLoc - gmid);
                if (numMatches > 0) {
                    if (!(distance < bestMatchDistance)) continue;
                    bestMatchLoc = xLoc;
                    bestMatchDistance = distance;
                    continue;
                }
                numMatches = 1;
                bestMatchLoc = xLoc;
                bestMatchDistance = distance;
            }
            if (numMatches <= 0) continue;
            if (this.bLog) {
                System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". SETTING BREAK. bestMatchLoc: " + bestMatchLoc + ", numMatches: " + numMatches);
            }
            g.setStartingFreqLoc(bestMatchLoc - 2.0);
            allGroups.put(entry.getKey(), g);
        }
    }

    private boolean isValidBreak(Group g, double location) {
        try {
            if (this.bLog) {
                System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". Find if break is valid for location: " + location);
            }
            TreeMap<Double, RangeEntry> t_vRanges = g.getVRanges();
            Iterator<Map.Entry<Double, RangeEntry>> t_itVRanges = t_vRanges.entrySet().iterator();
            HashMap<Double, BeforeAfter> beforeAfter = new HashMap<Double, BeforeAfter>();
            int numOfLines = 0;
            int numCrossWords = 0;
            while (t_itVRanges.hasNext()) {
                Map.Entry<Double, RangeEntry> t_VRangeEntry = t_itVRanges.next();
                RangeEntry t_RangeEntry = t_VRangeEntry.getValue();
                TreeMap<Double, SortedWord> t_RangeWords = t_RangeEntry.rangeWords();
                for (Map.Entry<Double, SortedWord> t_RangeWordEntry : t_RangeWords.entrySet()) {
                    SortedWord t_sw = t_RangeWordEntry.getValue();
                    List<ASQuad> t_lasq = t_sw.word().getBoundingQuads();
                    for (ASQuad t_asq : t_lasq) {
                        double x1 = t_asq.p1().x();
                        double y1 = t_asq.p1().y();
                        double x2 = t_asq.p2().x();
                        double y2 = t_asq.p2().y();
                        if (Math.abs(y1 - y2) > 0.5) continue;
                        BeforeAfter ba = (BeforeAfter)beforeAfter.get(y2);
                        if (ba == null) {
                            ba = new BeforeAfter();
                            ba.justBefore = Double.MIN_VALUE;
                            ba.justAfter = Double.MAX_VALUE;
                            ++numOfLines;
                        }
                        if (x2 < location && ba.justBefore < x2) {
                            ba.justBefore = x2;
                        }
                        if (x1 > location && ba.justAfter > x1) {
                            ba.justAfter = x1;
                        }
                        if (x1 < location - 2.0 && x2 > location + 2.0) {
                            ++numCrossWords;
                        }
                        beforeAfter.put(y2, ba);
                    }
                }
            }
            if (beforeAfter.size() == 0) {
                throw new Exception("beforeAfter.size() == 0. this should not have happened.");
            }
            double averageBefore = 0.0;
            int numEntriesBefore = 0;
            double averageAfter = 0.0;
            int numEntriesAfter = 0;
            for (Map.Entry elem : beforeAfter.entrySet()) {
                if (((BeforeAfter)elem.getValue()).justBefore > Double.MIN_VALUE) {
                    averageBefore += ((BeforeAfter)elem.getValue()).justBefore;
                    ++numEntriesBefore;
                }
                if (!(((BeforeAfter)elem.getValue()).justAfter < Double.MAX_VALUE)) continue;
                averageAfter += ((BeforeAfter)elem.getValue()).justAfter;
                ++numEntriesAfter;
            }
            if (numEntriesBefore > 0) {
                averageBefore /= (double)numEntriesBefore;
            } else {
                return true;
            }
            if (numEntriesAfter > 0) {
                averageAfter /= (double)numEntriesAfter;
            } else {
                return true;
            }
            Iterator itBeforeAfter = beforeAfter.entrySet().iterator();
            double errBefore = 0.0;
            double errAfter = 0.0;
            while (itBeforeAfter.hasNext()) {
                Map.Entry elem = itBeforeAfter.next();
                if (((BeforeAfter)elem.getValue()).justBefore > Double.MIN_VALUE) {
                    errBefore += Math.abs(((BeforeAfter)elem.getValue()).justBefore - averageBefore);
                }
                if (!(((BeforeAfter)elem.getValue()).justAfter < Double.MAX_VALUE)) continue;
                errAfter += Math.abs(((BeforeAfter)elem.getValue()).justAfter - averageAfter);
            }
            errBefore /= (double)numEntriesBefore;
            errAfter /= (double)numEntriesAfter;
            boolean isValid = false;
            if ((double)numCrossWords < 0.4 * (double)numOfLines) {
                isValid = true;
            }
            if (this.bLog) {
                System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". Find if break is valid , errBefore: " + errBefore + ", errAfter: " + errAfter + ", numCrossWords: " + numCrossWords + ", numOfLines: " + numOfLines + ", isValid: " + isValid);
            }
            return isValid;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void breakWithStartingFreqsDebug(Group g, int lc) {
        if (!this.bLog) {
            return;
        }
        try {
            int pos = g.toString().indexOf("Sign Up for");
            if (pos >= 0 && pos < 50) {
                pos = 1;
            }
            double groupWordSizeWithFactor = (double)g.getWords().size() * 0.25;
            TreeMap<Double, RangeEntry> vRanges = g.getVRanges();
            Iterator<Map.Entry<Double, RangeEntry>> t_itVRanges = vRanges.entrySet().iterator();
            double t_SumLow = 0.0;
            double t_SumHigh = 0.0;
            int t_NumEntries = 0;
            double lowAvg = 0.0;
            double highAvg = 0.0;
            while (t_itVRanges.hasNext()) {
                Map.Entry<Double, RangeEntry> t_VRangeEntry = t_itVRanges.next();
                RangeEntry t_RangeEntry = t_VRangeEntry.getValue();
                t_NumEntries += t_RangeEntry.numEntriesInAverage;
                t_SumLow += (double)t_RangeEntry.numEntriesInAverage * t_RangeEntry.lowAverage;
                t_SumHigh += (double)t_RangeEntry.numEntriesInAverage * t_RangeEntry.highAverage;
            }
            if (t_NumEntries > 0) {
                lowAvg = t_SumLow / (double)t_NumEntries;
                highAvg = t_SumHigh / (double)t_NumEntries;
            }
            Double lastKey = vRanges.lastKey();
            double gStart = vRanges.firstKey();
            RangeEntry reLast = vRanges.get(lastKey);
            double gEnd = reLast.end();
            double gmid = (gStart + gEnd) / 2.0;
            double gap = 0.04 * Math.abs(gEnd - gStart);
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". lc: " + lc + ". groupWordSizeWithFactor: " + groupWordSizeWithFactor + ". vRanges size: " + vRanges.size() + ", gStart: " + gStart + ", gEnd: " + gEnd + ", gmid: " + gmid + ", gap: " + gap + ". lowAvg: " + lowAvg + ". highAvg: " + highAvg + ". Avg: " + (lowAvg + highAvg) / 2.0 + ". \ng: " + g);
            if (this.sHighFreqs.isEmpty()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<List<List<Word>>> getWordsInPage() {
        return this.wordsInPage;
    }

    public void printReadingOrderText(TreeMap<String, Group> allGroups, List<Word> writer) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bLog) {
            System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". allGroups: " + allGroups);
        }
        Iterator<Map.Entry<String, Group>> it = allGroups.entrySet().iterator();
        Word prevWord = null;
        while (it.hasNext()) {
            Map.Entry<String, Group> entry = it.next();
            Group g = entry.getValue();
            this.wordsInPara = new ArrayList<List<Word>>();
            Iterator<Map.Entry<Double, SortedWord>> itw = g.getWords().entrySet().iterator();
            ASCoordinate prevWTopLeft = null;
            if (this.resolveHyphenation && this.prevWordHyphenation && prevWord != null) {
                writer.add(prevWord);
                this.offset += prevWord.toString().length();
                this.wordsInLine.add(prevWord);
                this.prevWordHyphenation = false;
            }
            ASCoordinate wtopLeft = null;
            while (itw.hasNext()) {
                Map.Entry<Double, SortedWord> ent = itw.next();
                SortedWord value = ent.getValue();
                if (g.startingFreqLoc() != -1.0) {
                    if (this.bottomRight(value.word()).x() < g.startingFreqLoc()) {
                        wtopLeft = this.writeText(writer, prevWTopLeft, prevWord, value);
                    } else if (this.bLog) {
                        String stt = value.toString();
                        double dtt = g.startingFreqLoc();
                        double dtt2 = this.bottomRight(value.word()).x();
                        System.out.println("TID: " + Thread.currentThread().getName() + Thread.currentThread().getId() + ". Skipping word: " + stt + ". startingFreqLoc: " + dtt + ". bottomRight: " + dtt2);
                    }
                } else {
                    wtopLeft = this.writeText(writer, prevWTopLeft, prevWord, value);
                }
                prevWTopLeft = wtopLeft;
                prevWord = value.word();
            }
            if (g.startingFreqLoc() != -1.0) {
                if (writer != null && prevWord != null) {
                    writer.add(new Word(null, "\n", prevWord.getPageNumber()));
                    this.wordsInLine.add(new Word(null, "\n", prevWord.getPageNumber()));
                    this.wordsInPara.add(this.wordsInLine);
                    this.wordsInLine = new ArrayList<Word>();
                }
                if (this.resolveHyphenation && this.prevWordHyphenation && prevWord != null) {
                    writer.add(prevWord);
                    this.offset += prevWord.toString().length();
                    this.wordsInLine.add(prevWord);
                    this.prevWordHyphenation = false;
                }
                Iterator<Map.Entry<Double, SortedWord>> itw2 = g.getWords().entrySet().iterator();
                prevWTopLeft = null;
                prevWord = null;
                wtopLeft = null;
                while (itw2.hasNext()) {
                    Map.Entry<Double, SortedWord> ent = itw2.next();
                    SortedWord value = ent.getValue();
                    if (this.bottomRight(value.word()).x() >= g.startingFreqLoc()) {
                        wtopLeft = this.writeText(writer, prevWTopLeft, prevWord, value);
                    }
                    prevWTopLeft = wtopLeft;
                    prevWord = value.word();
                }
            }
            if (writer != null && prevWord != null) {
                writer.add(new Word(null, "\n\n", prevWord.getPageNumber()));
                this.wordsInLine.add(new Word(null, "\n\n", prevWord.getPageNumber()));
                this.wordsInPara.add(this.wordsInLine);
                this.wordsInLine = new ArrayList<Word>();
            }
            this.wordsInPage.add(this.wordsInPara);
        }
    }

    public void setResolveHyphenation(boolean val) {
        this.resolveHyphenation = val;
    }

    void resolveHyphenation(Word prevWord, Word currentWord, BufferedWriter writer) {
        String prevwordStr = prevWord.toString().length() == 1 ? this.prevWordWithHyphen.toLowerCase().trim() : prevWord.toString().toLowerCase().trim();
        String currentwordStr = currentWord.toString();
        if ("pre-".equals(prevwordStr) && (currentwordStr.charAt(0) == 'e' || "owned".equals(currentwordStr) || Character.isUpperCase(currentwordStr.charAt(0))) || "semi-".equals(prevwordStr) && (currentwordStr.charAt(0) == 'i' || "antique".equals(currentwordStr) || Character.isUpperCase(currentwordStr.charAt(0))) || "multi-".equals(prevwordStr) && (currentwordStr.charAt(0) == 'i' || Character.isUpperCase(currentwordStr.charAt(0))) || "non-".equals(prevwordStr) && ("oil".equals(currentwordStr) || "euclidean".equals(currentwordStr) || "nonsense".equals(currentwordStr) || "U".equals(currentwordStr) || "no".equals(currentwordStr) || Character.isUpperCase(currentwordStr.charAt(0))) || "anti-".equals(prevwordStr) && (currentwordStr.charAt(0) == 'i' || "art".equals(currentwordStr) || "utopia".equals(currentwordStr) || "utopian".equals(currentwordStr) || Character.isUpperCase(currentwordStr.charAt(0))) || "post-".equals(prevwordStr) && ("Kantian".equals(currentwordStr) || "obit".equals(currentwordStr) || Character.isUpperCase(currentwordStr.charAt(0))) || "self-".equals(prevwordStr) || "all-".equals(prevwordStr) || "intra-".equals(prevwordStr) && "arterial".equals(currentwordStr) || "para-".equals(prevwordStr) && "aminobenzoic".equals(currentwordStr) || "para-".equals(prevwordStr) && "aminosalicylic".equals(currentwordStr)) {
            try {
                writer.write(prevWord + currentwordStr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.offset = this.offset + prevWord.toString().length() + currentwordStr.length();
        } else {
            int lastIndex = prevWord.toString().length();
            try {
                writer.write(prevWord.toString().substring(0, lastIndex - 1) + currentwordStr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.offset = this.offset + lastIndex - 1 + currentwordStr.length();
        }
        this.wordsInLine.add(prevWord);
        this.wordsInLine.add(currentWord);
    }

    private ASCoordinate writeText(List<Word> writer, ASCoordinate prevWTopLeft, Word prevWord, SortedWord value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double delta;
        ASCoordinate wtopLeft = this.topLeft(value.word());
        BreakIterator.getAvailableLocales();
        if (!(prevWord == null || Math.round(delta = this.topLeft(value.word()).x() - this.bottomRight(prevWord).x()) == 0L || delta > 0.0 && delta < this.charW(value.word()) * 0.28 || delta >= -1.0 && delta < 0.0 && -delta < this.charW(value.word()) * 0.5)) {
            if (prevWTopLeft != null && wtopLeft.x() - prevWTopLeft.x() < 0.0) {
                if (writer != null) {
                    writer.add(new Word(null, "\n", prevWord.getPageNumber()));
                    this.wordsInLine.add(new Word(null, " ", prevWord.getPageNumber()));
                    this.wordsInPara.add(this.wordsInLine);
                    this.wordsInLine = new ArrayList<Word>();
                }
                ++this.offset;
            } else {
                if (writer != null && this.wordsInLine != null) {
                    writer.add(new Word(null, " ", prevWord.getPageNumber()));
                    this.wordsInLine.add(new Word(null, " ", prevWord.getPageNumber()));
                }
                ++this.offset;
            }
        }
        if (writer != null) {
            writer.add(value.word());
            this.wordsInLine.add(value.word());
        }
        this.offset += value.word().toString().length();
        return wtopLeft;
    }

    private Boundary boundaries(TreeMap<Double, RangeEntry> vRanges, TreeMap<Double, RangeEntry> hRanges) {
        double vstart = vRanges.firstKey();
        double vend = vRanges.get(vRanges.lastKey()).end();
        double hstart = hRanges.firstKey();
        double hend = hRanges.get(hRanges.lastKey()).end();
        return new Boundary(vstart, vend, hstart, hend);
    }

    public ArrayList<Break> getBestBreaks() {
        return this.bestBreaks;
    }

    protected ASCoordinate topLeft(Word word) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<ASQuad> quads = word.getBoundingQuads();
        if (quads != null && !quads.isEmpty()) {
            return quads.get(0).p1();
        }
        return null;
    }

    protected ASCoordinate bottomRight(Word word) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<ASQuad> quads = word.getBoundingQuads();
        if (quads != null && !quads.isEmpty()) {
            return quads.get(0).p3();
        }
        return null;
    }

    protected double charW(Word word) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate topLeft = this.topLeft(word);
        ASCoordinate bottomRight = this.bottomRight(word);
        return (bottomRight.x() - topLeft.x()) / (double)word.toString().length();
    }

    protected double charH(Word word) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate topLeft = this.topLeft(word);
        ASCoordinate bottomRight = this.bottomRight(word);
        return bottomRight.y() - topLeft.y();
    }
}

