/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingComposite;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTilingContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterXobject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.HashMap;

public class RasterGraphicsState
extends GraphicsState {
    private RasterXobject softmask = null;
    private Area backDropArea = null;

    @Override
    public <W extends DocumentContext> void writeToDisplayArea(W contentItemWriter) {
        RasterDocumentContext context = (RasterDocumentContext)contentItemWriter;
        GeneralPath clipPath = null;
        Area area = this.getClipPath();
        if (area != null) {
            clipPath = new GeneralPath(area);
            if (context.getIsScaled()) {
                AffineTransform transform = new AffineTransform();
                transform.scale(context.getWidthScalingFactor(), context.getHeightScalingFactor());
                clipPath.transform(transform);
            }
        }
        this.install(context.getGraphics2d(), context.getPageHeight());
        if (context instanceof RasterTilingContext || context.getIsGSSoftMask()) {
            return;
        }
        Shape currentClipShape = context.getGraphics2d().getClip();
        if (clipPath != null && !(context instanceof RasterTilingContext)) {
            context.getTransformedPath(clipPath, context.getPageHeight());
        }
        if (currentClipShape == null || !(currentClipShape instanceof GeneralPath) || !GraphicsUtils.equalPaths(clipPath, (GeneralPath)currentClipShape)) {
            context.getGraphics2d().setClip(clipPath);
        }
        if (this.getBackDropArea() != null) {
            context.getGraphics2d().setClip(this.getBackDropArea());
        }
    }

    void install(Graphics2D g2, double pageHeight) {
        double[] array = this.getDashArray();
        float[] dashArray = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            dashArray[i] = (float)array[i];
        }
        int o = this.getLineCap().getValue();
        int l = 0;
        if (this.getLineJoin() != null) {
            l = this.getLineJoin().getValue();
        }
        float miterLimit = (float)this.getMiterLimit();
        float dashPhase = this.getDashPhase();
        if (dashPhase >= 0.0f && dashArray.length != 0) {
            g2.setStroke(new BasicStroke((float)this.getLineWidth(), o, l, miterLimit, dashArray, this.getDashPhase()));
        } else {
            g2.setStroke(new BasicStroke((float)this.getLineWidth(), o, l, miterLimit));
        }
    }

    Composite getComposite(GraphicsState.BlendingMode mode, float alpha) {
        return new RasterBlendingComposite(mode, alpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySoftMask(RasterDocumentContext context) {
        int width = context.getWidth();
        int height = context.getPageHeight();
        double[] bBox = this.softmask.getBBox();
        Rectangle2D.Double softMaskRectangle = new Rectangle2D.Double(bBox[0], (double)height - bBox[1], Math.abs(bBox[2] - bBox[0]), Math.abs(bBox[3] - bBox[1]));
        BufferedImage xObjectForm = new BufferedImage(width, height, 2);
        Graphics2D oldGraphics2d = context.getGraphics2d();
        Rectangle currentClipArea = context.getGraphics2d().getClipBounds();
        Rectangle2D intersectArea = new Rectangle2D.Double();
        intersectArea = ((Rectangle2D)currentClipArea).createIntersection(softMaskRectangle);
        if (intersectArea.getWidth() < 0.0 || intersectArea.getHeight() < 0.0) {
            intersectArea.setRect(currentClipArea);
        }
        oldGraphics2d.setClip(intersectArea);
        BufferedImage oldImage = context.getImage();
        Area backdropArea = new Area();
        int backDropColor = this.getBackdropColor();
        Color bcColor = new Color(backDropColor);
        int red = bcColor.getRed();
        int green = bcColor.getGreen();
        int blue = bcColor.getBlue();
        try {
            Graphics2D graphics2d = xObjectForm.createGraphics();
            context.setGraphics2d(graphics2d);
            context.setIsGSSoftMask(true);
            this.softmask.writeToDisplayArea(context);
        }
        finally {
            context.setIsGSSoftMask(false);
            context.setGraphics2d(oldGraphics2d);
            context.setImage(oldImage);
        }
        int startX = (int)softMaskRectangle.getMinX();
        int startY = (int)softMaskRectangle.getMinY();
        startX = startX < 0 ? 0 : startX;
        startY = startY < 0 ? 0 : startY;
        int[] imgData = new int[width * height];
        int[] maskData = new int[width * height];
        imgData = ((DataBufferInt)oldImage.getRaster().getDataBuffer()).getData();
        maskData = ((DataBufferInt)xObjectForm.getRaster().getDataBuffer()).getData();
        HashMap<Integer, int[]> partialAreaStore = new HashMap<Integer, int[]>();
        for (int y = startY; (double)y < (double)startY + intersectArea.getHeight() && y < height; ++y) {
            for (int x = startX; (double)x < (double)startX + intersectArea.getWidth() && x < width; ++x) {
                int[] xPair;
                int index = y * width + x;
                if (maskData[index] == backDropColor) continue;
                int color = imgData[index] & 0xFFFFFF;
                int maskColor = (maskData[index] - backDropColor & 0xFF0000) << 8;
                imgData[index] = color |= maskColor;
                if (partialAreaStore.containsKey(y)) {
                    xPair = (int[])partialAreaStore.get(y);
                    if (x == xPair[1] + 1) {
                        xPair[1] = x;
                        partialAreaStore.put(y, xPair);
                    } else {
                        Area pixelArea = new Area(new Rectangle2D.Double(xPair[0], y, xPair[1] + 1 - xPair[0], 1.0));
                        backdropArea.add(pixelArea);
                        partialAreaStore.remove(y);
                    }
                }
                if (partialAreaStore.containsKey(y)) continue;
                xPair = new int[]{x, x};
                partialAreaStore.put(y, xPair);
            }
            if (!partialAreaStore.containsKey(y)) continue;
            int[] xPair = (int[])partialAreaStore.get(y);
            Area pixelArea = new Area(new Rectangle2D.Double(xPair[0], y, xPair[1] + 1 - xPair[0], 1.0));
            backdropArea.add(pixelArea);
        }
        partialAreaStore.clear();
        this.setBackDropArea(backdropArea);
        oldGraphics2d.setClip(backdropArea);
    }

    private boolean getColourDistance(int imageMaskColor, int red, int green, int blue) {
        int b;
        double weightB;
        int g;
        double weightG;
        int r;
        Color maskColor = new Color(imageMaskColor);
        double rmean = (red + maskColor.getRed()) / 2;
        double weightR = 2.0 + rmean / 256.0;
        double colorDistance = Math.sqrt(weightR * (double)(r = red - maskColor.getRed()) * (double)r + (weightG = 4.0) * (double)(g = green - maskColor.getGreen()) * (double)g + (weightB = 2.0 + (255.0 - rmean) / 256.0) * (double)(b = blue - maskColor.getBlue()) * (double)b);
        return colorDistance <= 0.0 || colorDistance > 800.0;
    }

    @Override
    public void setGraphicsStateSoftMask(ContentItem softmask) {
        this.softmask = (RasterXobject)softmask;
    }

    @Override
    public ContentItem getGraphicsStateSoftMask() {
        return this.softmask;
    }

    Area getBackDropArea() {
        return this.backDropArea;
    }

    void setBackDropArea(Area backdropArea) {
        this.backDropArea = backdropArea;
    }
}

