/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMovie;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationScreen;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractAnnotationErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorAFEntryInAnnotationNotValid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionGoTo3DViewNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionHideNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionImportDataNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionJavaScriptNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionLaunchNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionMovieNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionNoOpNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionRenditionNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionResetFormNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionSetOCGStateNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionSetStateNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionSoundNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorActionTransNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorAdditionalActionsNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorAppearanceNotPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagHiddenSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagInvisibleSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagNoRotateNotSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagNoViewSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagNoZoomNotSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagPrintNotSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagToggleNoViewSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorFlagsMissing;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorNonNormalAppearancesPresent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorNonPermittedNamedActionFound;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorNormalAppearanceAsStreamExpected;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorNormalAppearanceAsSubDictionaryExpected;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorNormalAppearanceMissing;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AnnotationErrorUnknownUsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TransparencyState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.XObjectProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class AnnotationProcessor {
    private static HashSet<ASName> allowedAnnotTypes = new HashSet();

    AnnotationProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean process(PDFPage page, DocumentProcessor docProcessor, PDFResources parentResources, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException {
        if (page == null) {
            return true;
        }
        if (!validationHandler.beginAnnotationsScan()) {
            return false;
        }
        try {
            PDFAnnotationIterator iter = page.getAnnotationsIterator();
            while (iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                transparencyInfo.setAnnotationBeingProcessed(true);
                try {
                    if (AnnotationProcessor.process(annot, iter, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, transparencyInfo)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    transparencyInfo.setAnnotationBeingProcessed(false);
                }
            }
            return validationHandler.endAnnotationsScan();
        }
        catch (PDFInvalidDocumentException e) {
            if (validationHandler.annotationError(new PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode>(new PDFA2AnnotationErrorPDFGeneralFailure(null, 0, 0, 0)))) return validationHandler.endAnnotationsScan();
            return false;
        }
        catch (NoSuchElementException e) {
            if (!(e.getCause() instanceof PDFCosParseException)) throw e;
            if (validationHandler.annotationError(new PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode>(new PDFA2AnnotationErrorPDFGeneralFailure(null, 0, 0, 0)))) return validationHandler.endAnnotationsScan();
            return false;
        }
    }

    static boolean process(PDFAnnotation annot, PDFAnnotationIterator annotsIter, DocumentProcessor docProcessor, PDFResources parentResources, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, TransparencyState transparencyInfo) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (annot == null) {
            return true;
        }
        if (!validationHandler.beginAnnotationScan(annot)) {
            return false;
        }
        PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode>();
        int objectNumber = annot.getCosObject().getObjNum();
        int genNumber = annot.getCosObject().getObjGen();
        int flags = -1;
        String subType = null;
        try {
            flags = annot.getFlags();
            String string = subType = annot.getSubtype() != null ? annot.getSubtype().asString() : null;
            if (conformance == PDFA2ConformanceLevel.Level_3b && !docProcessor.checkAndAddToAssociatedFileSet(annot.getAssociatedFiles())) {
                errorCodes.addErrorCode(new PDFA2AnnotationErrorAFEntryInAnnotationNotValid(subType, flags, objectNumber, genNumber));
            }
            if (!allowedAnnotTypes.contains(annot.getSubtype())) {
                if (conversionHandler != null && conversionOptions.getRemoveIllegalAnnotations()) {
                    annotsIter.remove();
                    if (!conversionHandler.illegalAnnotationRemoved(annot)) {
                        return false;
                    }
                    return validationHandler.endAnnotationScan();
                }
                if (annot instanceof PDFAnnotationSound || annot instanceof PDFAnnotationMovie || annot instanceof PDFAnnotation3D || annot instanceof PDFAnnotationScreen) {
                    errorCodes.addErrorCode(new PDFA2AnnotationErrorNotAllowed(subType, flags, objectNumber, genNumber));
                } else {
                    errorCodes.addErrorCode(new PDFA2AnnotationErrorUnknownUsed(subType, flags, objectNumber, genNumber));
                }
            } else {
                PDFAdditionalActions aa;
                if (annot.getSubtype() != ASName.k_Popup && !annot.hasFlags()) {
                    if (conversionHandler != null && conversionOptions.getOverrideAnnotationFlags()) {
                        if (!AnnotationProcessor.overrideAnnotFlags(annot, 0, conversionHandler)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2AnnotationErrorFlagsMissing(subType, flags, objectNumber, genNumber));
                    }
                } else if (annot.hasFlags()) {
                    int oldFlags = flags;
                    boolean removeAnnot = false;
                    PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode> flagsErrorCodes = new PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode>();
                    if ((oldFlags & 4) != 4) {
                        if (conversionHandler != null && conversionOptions.getRemoveNonPrintableAnnots()) {
                            removeAnnot = true;
                        } else {
                            flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagPrintNotSet(subType, flags, objectNumber, genNumber));
                        }
                    }
                    if ((oldFlags & 1) == 1) {
                        if (conversionHandler != null && conversionOptions.getRemoveInvisibleAnnots()) {
                            removeAnnot = true;
                        } else {
                            flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagInvisibleSet(subType, flags, objectNumber, genNumber));
                        }
                    }
                    if ((oldFlags & 2) == 2) {
                        if (conversionHandler != null && conversionOptions.getRemoveHiddenAnnots()) {
                            removeAnnot = true;
                        } else {
                            flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagHiddenSet(subType, flags, objectNumber, genNumber));
                        }
                    }
                    if ((oldFlags & 0x100) == 256) {
                        if (conversionHandler != null && conversionOptions.getRemoveToggleNoViewAnnots()) {
                            removeAnnot = true;
                        } else {
                            flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagToggleNoViewSet(subType, flags, objectNumber, genNumber));
                        }
                    }
                    if ((oldFlags & 0x20) == 32) {
                        if (conversionHandler != null && conversionOptions.getRemoveNoViewAnnots()) {
                            removeAnnot = true;
                        } else {
                            flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagNoViewSet(subType, flags, objectNumber, genNumber));
                        }
                    }
                    if (annot instanceof PDFAnnotationText) {
                        if ((oldFlags & 8) != 8) {
                            if (conversionHandler != null && conversionOptions.getRemoveTextAnnotsWithZoom()) {
                                removeAnnot = true;
                            } else {
                                flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagNoZoomNotSet(subType, flags, objectNumber, genNumber));
                            }
                        }
                        if ((oldFlags & 0x10) != 16) {
                            if (conversionHandler != null && conversionOptions.getRemoveTextAnnotsWithRotate()) {
                                removeAnnot = true;
                            } else {
                                flagsErrorCodes.addErrorCode(new PDFA2AnnotationErrorFlagNoRotateNotSet(subType, flags, objectNumber, genNumber));
                            }
                        }
                    }
                    if (removeAnnot) {
                        annotsIter.remove();
                        if (!conversionHandler.annotWithInvalidFlagValueRemoved(annot)) {
                            return false;
                        }
                        return validationHandler.endAnnotationScan();
                    }
                    if (flagsErrorCodes.hasErrors() && conversionHandler != null && conversionOptions.getOverrideAnnotationFlags()) {
                        if (!AnnotationProcessor.overrideAnnotFlags(annot, oldFlags, conversionHandler)) {
                            return false;
                        }
                    } else {
                        errorCodes.mergeErrorSet(flagsErrorCodes);
                    }
                }
                PDFRectangle annotRect = annot.getRect();
                double[] rectVertices = annotRect.getValues();
                PDFAppearance ap = annot.getAppearance();
                if (annot.getSubtype() != ASName.k_Popup && annot.getSubtype() != ASName.k_Link && (rectVertices[0] != rectVertices[2] || rectVertices[1] != rectVertices[3]) && ap == null) {
                    PDFAppearance appearance = PDFAppearance.newInstance(annot.getPDFDocument());
                    if (conversionHandler != null && conversionHandler.getAnnotationAppearance(annot, appearance)) {
                        annot.setAppearance(appearance);
                        if (!conversionHandler.annotationAppearanceSet(annot)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2AnnotationErrorAppearanceNotPresent(subType, flags, objectNumber, genNumber));
                    }
                } else if (ap != null) {
                    boolean appearanceReset = false;
                    if (ap.isEmpty() && (annot.getSubtype() == ASName.k_Popup || annot.getSubtype() == ASName.k_Link || rectVertices[0] == rectVertices[2] && rectVertices[1] == rectVertices[3]) && conversionHandler != null) {
                        annot.removeAppearance();
                    } else if (!ap.dictionaryContains(ASName.k_N)) {
                        PDFAppearance appearance = PDFAppearance.newInstance(annot.getPDFDocument());
                        if (conversionHandler != null && conversionHandler.getAnnotationAppearance(annot, appearance)) {
                            annot.setAppearance(appearance);
                            appearanceReset = true;
                            if (!conversionHandler.annotationAppearanceSet(annot)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(new PDFA2AnnotationErrorNormalAppearanceMissing(subType, flags, objectNumber, genNumber));
                        }
                    } else {
                        PDFXObjectForm xObject;
                        CosObject nObj = ap.getCosDictionary().get(ASName.k_N);
                        if (annot.getSubtype() == ASName.k_Widget && ((PDFAnnotationWidget)annot).getField() instanceof PDFFieldButton) {
                            if (nObj.getType() != 6) {
                                if (conversionHandler != null) {
                                    PDFAppearance newAppearance = PDFAppearance.newInstance(annot.getPDFDocument());
                                    newAppearance.setAppearance(ASName.k_N, ASName.create("Off"), PDFXObjectForm.getInstance(nObj));
                                    annot.setAppearance(newAppearance);
                                    annot.setAppearanceState(false);
                                    if (!conversionHandler.normalAPStreamConvertedToDictForButton(annot)) {
                                        return false;
                                    }
                                } else {
                                    errorCodes.addErrorCode(new PDFA2AnnotationErrorNormalAppearanceAsSubDictionaryExpected(subType, flags, objectNumber, genNumber));
                                }
                            } else {
                                CosDictionary nObjDict = (CosDictionary)nObj;
                                Iterator<ASName> nObjKeysIter = nObjDict.keyIterator();
                                while (nObjKeysIter.hasNext()) {
                                    PDFXObjectForm xObject2;
                                    ASName nObjKey = nObjKeysIter.next();
                                    CosObject nObjValue = nObjDict.get(nObjKey);
                                    if (nObjValue.getType() != 7 || XObjectProcessor.process(nObjKey, xObject2 = PDFXObjectForm.getInstance(nObjValue), docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null, transparencyInfo)) continue;
                                    return false;
                                }
                            }
                        } else if (nObj.getType() != 7) {
                            if (conversionHandler != null && nObj instanceof CosDictionary) {
                                CosObject asObj;
                                CosDictionary nDict = (CosDictionary)nObj;
                                CosObject nTemp = null;
                                if (nDict.size() == 1) {
                                    nTemp = nDict.get(nDict.getKeys().get(0));
                                } else if (annot.dictionaryContains(ASName.k_AS) && (asObj = annot.getCosDictionary().get(ASName.k_AS)) instanceof CosName) {
                                    ASName key = ((CosName)asObj).nameValue();
                                    nTemp = nDict.get(key);
                                }
                                if (nTemp instanceof CosStream) {
                                    nObj = nTemp;
                                    ap.getCosDictionary().put(ASName.k_N, nObj);
                                    if (!conversionHandler.normalAPDictConvertedToStream(annot)) {
                                        return false;
                                    }
                                }
                            }
                            if (nObj.getType() != 7) {
                                errorCodes.addErrorCode(new PDFA2AnnotationErrorNormalAppearanceAsStreamExpected(subType, flags, objectNumber, genNumber));
                            }
                        }
                        if (nObj.getType() == 7 && !XObjectProcessor.process(ASName.k_N, xObject = PDFXObjectForm.getInstance(nObj), docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null, transparencyInfo)) {
                            return false;
                        }
                    }
                    if (!appearanceReset && (ap.dictionaryContains(ASName.k_D) || ap.dictionaryContains(ASName.k_R))) {
                        if (conversionHandler != null && conversionOptions.getRemoveNonNormalAnnotApperances()) {
                            if (ap.dictionaryContains(ASName.k_D)) {
                                ap.removeValue(ASName.k_D);
                                if (!conversionHandler.nonNormalAnnotAppearanceRemoved(annot, ASName.k_D)) {
                                    return false;
                                }
                            }
                            if (ap.dictionaryContains(ASName.k_R)) {
                                ap.removeValue(ASName.k_R);
                                if (!conversionHandler.nonNormalAnnotAppearanceRemoved(annot, ASName.k_R)) {
                                    return false;
                                }
                            }
                        } else {
                            errorCodes.addErrorCode(new PDFA2AnnotationErrorNonNormalAppearancesPresent(subType, flags, objectNumber, genNumber));
                        }
                    }
                }
                if (annot.hasAction()) {
                    PDFAction action;
                    if (annot instanceof PDFAnnotationWidget) {
                        if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                            action = annot.getAction();
                            annot.removeValue(ASName.k_A);
                            if (!conversionHandler.illegalActionRemoved(action)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(new PDFA2AnnotationErrorActionNotAllowed(subType, flags, objectNumber, genNumber));
                        }
                    } else {
                        action = annot.getAction();
                        PDFAction.TreeIterator actionIter = action.treeIterator();
                        while (actionIter.hasNext()) {
                            action = actionIter.next();
                            ASName subtype = action.getSubtype();
                            if (subtype == ASName.k_Named) {
                                PDFActionNamed namedAction = (PDFActionNamed)action;
                                ASName actionName = namedAction.getName();
                                if (actionName == ASName.create("NextPage") || actionName == ASName.create("PrevPage") || actionName == ASName.create("FirstPage") || actionName == ASName.create("LastPage")) continue;
                                if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                    annot.removeValue(ASName.k_A);
                                    if (conversionHandler.illegalActionRemoved(action)) continue;
                                    return false;
                                }
                                errorCodes.addErrorCode(new PDFA2AnnotationErrorNonPermittedNamedActionFound(actionName != null ? actionName.toString() : null, subType, flags, objectNumber, genNumber));
                                continue;
                            }
                            PDFA2AbstractAnnotationErrorCode ec = AnnotationProcessor.getErrorCode(subtype, objectNumber, genNumber, flags, subType);
                            if (ec == null) continue;
                            if (conversionHandler != null && conversionOptions.getRemoveIllegalActions()) {
                                annot.removeValue(ASName.k_A);
                                if (conversionHandler.illegalActionRemoved(action)) continue;
                                return false;
                            }
                            errorCodes.addErrorCode(ec);
                        }
                    }
                }
                if (annot instanceof PDFAnnotationWidget && (aa = annot.getAdditionalActions()) != null) {
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalAdditionalActions()) {
                        annot.getCosDictionary().remove(ASName.k_AA);
                        if (!conversionHandler.illegalAdditionalActionsRemoved(aa)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(new PDFA2AnnotationErrorAdditionalActionsNotAllowed(subType, flags, objectNumber, genNumber));
                    }
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(new PDFA2AnnotationErrorPDFGeneralFailure(subType, flags, objectNumber, genNumber));
        }
        catch (NoSuchElementException e) {
            if (e.getCause() instanceof PDFCosParseException) {
                errorCodes.addErrorCode(new PDFA2AnnotationErrorPDFGeneralFailure(subType, flags, objectNumber, genNumber));
            }
            throw e;
        }
        if (errorCodes.hasErrors() && !validationHandler.annotationError(errorCodes)) {
            return false;
        }
        return validationHandler.endAnnotationScan();
    }

    private static boolean overrideAnnotFlags(PDFAnnotation annot, int oldFlags, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int newFlags = oldFlags;
        newFlags |= 4;
        newFlags &= 0xFFFFFEDC;
        if (annot instanceof PDFAnnotationText) {
            newFlags |= 0x18;
        }
        if (newFlags != oldFlags) {
            annot.setFlags(newFlags);
            if (!conversionHandler.annotationFlagsSet(annot, oldFlags, newFlags)) {
                return false;
            }
        }
        return true;
    }

    public static PDFA2AbstractAnnotationErrorCode getErrorCode(ASName actionSubtype, int objectNumber, int genNumber, int flags, String subType) {
        if (actionSubtype == ASName.k_Launch) {
            return new PDFA2AnnotationErrorActionLaunchNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_Sound) {
            return new PDFA2AnnotationErrorActionSoundNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_Movie) {
            return new PDFA2AnnotationErrorActionMovieNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_ResetForm) {
            return new PDFA2AnnotationErrorActionResetFormNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_ImportData) {
            return new PDFA2AnnotationErrorActionImportDataNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_Hide) {
            return new PDFA2AnnotationErrorActionHideNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_SetOCGState) {
            return new PDFA2AnnotationErrorActionSetOCGStateNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_Rendition) {
            return new PDFA2AnnotationErrorActionRenditionNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_Trans) {
            return new PDFA2AnnotationErrorActionTransNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_GoTo3DView) {
            return new PDFA2AnnotationErrorActionGoTo3DViewNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if (actionSubtype == ASName.k_JavaScript) {
            return new PDFA2AnnotationErrorActionJavaScriptNotAllowed(subType, flags, objectNumber, genNumber);
        }
        String typeString = actionSubtype.asString();
        if ("set-state".equalsIgnoreCase(typeString) || "setstate".equalsIgnoreCase(typeString)) {
            return new PDFA2AnnotationErrorActionSetStateNotAllowed(subType, flags, objectNumber, genNumber);
        }
        if ("no-op".equalsIgnoreCase(typeString) || "nop".equalsIgnoreCase(typeString)) {
            return new PDFA2AnnotationErrorActionNoOpNotAllowed(subType, flags, objectNumber, genNumber);
        }
        return null;
    }

    static {
        allowedAnnotTypes.add(ASName.k_Text);
        allowedAnnotTypes.add(ASName.k_Link);
        allowedAnnotTypes.add(ASName.k_FreeText);
        allowedAnnotTypes.add(ASName.k_Line);
        allowedAnnotTypes.add(ASName.k_Square);
        allowedAnnotTypes.add(ASName.k_Circle);
        allowedAnnotTypes.add(ASName.k_Polygon);
        allowedAnnotTypes.add(ASName.k_PolyLine);
        allowedAnnotTypes.add(ASName.k_Highlight);
        allowedAnnotTypes.add(ASName.k_Underline);
        allowedAnnotTypes.add(ASName.k_Squiggly);
        allowedAnnotTypes.add(ASName.k_StrikeOut);
        allowedAnnotTypes.add(ASName.k_Stamp);
        allowedAnnotTypes.add(ASName.k_Caret);
        allowedAnnotTypes.add(ASName.k_Ink);
        allowedAnnotTypes.add(ASName.k_Popup);
        allowedAnnotTypes.add(ASName.k_FileAttachment);
        allowedAnnotTypes.add(ASName.k_Widget);
        allowedAnnotTypes.add(ASName.k_PrinterMark);
        allowedAnnotTypes.add(ASName.k_TrapNet);
        allowedAnnotTypes.add(ASName.k_Watermark);
        allowedAnnotTypes.add(ASName.k_Redact);
    }
}

