/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SchemaCollector;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLFinder;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

class SchemaInserter
extends XMLFinder {
    private static final XMLFinder.XMLSearchPath SCHEMAS_EXIST_SEARCH_PATH = new XMLFinder.XMLSearchPath(6, new XMLElement[]{XMLFinder.XMLSearchPath.WILDCARD_ZERO_OR_MORE, SchemaCollector.RDF_RDF, SchemaCollector.RDF_DESCRIPTION, SchemaCollector.PDFA_EXTENSION_SCHEMAS, SchemaCollector.RDF_BAG});
    private static final XMLFinder.XMLSearchPath SCHEMAS_DONT_EXIST_SEARCH_PATH = new XMLFinder.XMLSearchPath(4, new XMLElement[]{XMLFinder.XMLSearchPath.WILDCARD_ZERO_OR_MORE, SchemaCollector.RDF_RDF});
    private Set<PDFAXMPSchema> schemas;
    private boolean schemasExist = false;
    private boolean inserted = false;
    private boolean inInsert = false;

    public SchemaInserter(Set<PDFAXMPSchema> mergedSchemas, boolean schemasExist) {
        super(schemasExist ? SCHEMAS_EXIST_SEARCH_PATH : SCHEMAS_DONT_EXIST_SEARCH_PATH, true, true);
        this.schemas = mergedSchemas;
        this.schemasExist = schemasExist;
    }

    @Override
    protected int found(String namespaceURI, String simpleName, int findState) throws SAXException {
        if (this.schemasExist) {
            return this.schemasExistFound(findState);
        }
        return this.schemasDontExistFound();
    }

    private int schemasDontExistFound() throws SAXException {
        if (!this.inserted) {
            this.preloadNamespaceLookup();
            ContentHandler contentHandler = this.getContentHandler();
            this.writeHeader(contentHandler, this.getNamespaceSupport());
            this.writeSchemas(contentHandler, this.getNamespaceSupport(), this.schemas);
            this.writerTrailer(contentHandler, this.getNamespaceSupport());
            this.inserted = true;
        }
        return -1;
    }

    private int schemasExistFound(int findState) throws SAXException {
        if (findState == 2) {
            if (!this.inserted) {
                this.preloadNamespaceLookup();
                ContentHandler contentHandler = this.getContentHandler();
                this.writeSchemas(contentHandler, this.getNamespaceSupport(), this.schemas);
                this.inserted = true;
                this.inInsert = true;
            }
            return 0;
        }
        if (findState == 4 && this.inInsert) {
            this.inInsert = false;
            return 1;
        }
        return -1;
    }

    private void preloadNamespaceLookup() {
        NamespaceSupport ns = this.getNamespaceSupport();
        ns.declarePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }

    private void writeHeader(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
        SchemaCollector.RDF_DESCRIPTION.startElement(handler, namespaceSupport);
        SchemaCollector.PDFA_EXTENSION_SCHEMAS.startElement(handler, namespaceSupport);
        SchemaCollector.RDF_BAG.startElement(handler, namespaceSupport);
    }

    private void writerTrailer(ContentHandler handler, NamespaceSupport namespaceSupport) throws SAXException {
        SchemaCollector.RDF_BAG.endElement(handler, namespaceSupport);
        SchemaCollector.PDFA_EXTENSION_SCHEMAS.endElement(handler, namespaceSupport);
        SchemaCollector.RDF_DESCRIPTION.endElement(handler, namespaceSupport);
    }

    private void writeSchemas(ContentHandler handler, NamespaceSupport namespaceSupport, Set<PDFAXMPSchema> set) throws SAXException {
        AttributesImpl parsetypeAttribute = new AttributesImpl();
        parsetypeAttribute.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", XMLUtils.getQualifiedName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", namespaceSupport), "CDATA", "Resource");
        for (PDFAXMPSchema schema : set) {
            SchemaCollector.RDF_LI.startElement(handler, namespaceSupport, parsetypeAttribute);
            schema.writeXML(handler, namespaceSupport);
            SchemaCollector.RDF_LI.endElement(handler, namespaceSupport);
        }
    }
}

