/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;

final class ParserUtils {
    ParserUtils() {
    }

    static String readLine(InputByteStream buf) throws IOException {
        StringBuilder rslt = new StringBuilder();
        int b = buf.read();
        while (b != 13 && b != 10 && b != -1) {
            rslt.append((char)b);
            b = buf.read();
        }
        if (b == 13 && (ParserUtils.peek(buf) == 10 || ParserUtils.peek(buf) == -1)) {
            buf.read();
        }
        return rslt.toString();
    }

    static int skipBackBeforeEOL(InputByteStream buf) throws IOException {
        int skippedback = 2;
        long pos = buf.getPosition() - (long)skippedback;
        if (ParserUtils.peekAtPos(buf, pos) == 13) {
            ++skippedback;
            buf.seek(--pos);
            if (ParserUtils.peekAtPos(buf, pos) == 10) {
                ++skippedback;
                buf.seek(--pos);
            }
            return skippedback;
        }
        buf.seek(pos);
        return skippedback;
    }

    static boolean isEOLChar(byte inp) {
        return inp == 13 || inp == 10;
    }

    static long getEOFPosition(InputByteStream mBuf) throws PDFCosParseException, IOException {
        long curPos = mBuf.getPosition();
        long ret = ParserUtils.getEOFPositionImpl(mBuf);
        mBuf.seek(curPos);
        return ret;
    }

    private static long getEOFPositionImpl(InputByteStream mBuf) throws PDFCosParseException, IOException {
        String eof = "%%EOF";
        long bufPos = mBuf.length();
        int eofPos = 4;
        while (eofPos != -1) {
            if (--bufPos < 0L) {
                throw new PDFCosParseException("could not find %%EOF");
            }
            mBuf.seek(bufPos);
            byte ch = (byte)mBuf.read();
            if ("%%EOF".charAt(eofPos) == ch) {
                --eofPos;
                continue;
            }
            if (ch == 70) {
                eofPos = 3;
                continue;
            }
            eofPos = 4;
        }
        return bufPos;
    }

    static int peek(InputByteStream buf) throws IOException {
        int inp = buf.read();
        if (inp != -1) {
            buf.unget();
        }
        return inp;
    }

    static int peekAtPos(InputByteStream buf, long pos) throws IOException {
        long curpos = buf.getPosition();
        buf.seek(pos);
        int inp = buf.read();
        buf.seek(curpos);
        return inp;
    }

    static Number readNumber(InputByteStream buf, byte b) throws PDFCosParseException, IOException {
        return ParserUtils.readNumber(buf, b, false);
    }

    static Number readNumber(InputByteStream buf, byte b, boolean requireNumber) throws PDFCosParseException, IOException {
        int sign = 1;
        long left = 0L;
        long right = 0L;
        long divisor = 1L;
        boolean decimal = false;
        if (b == 45) {
            sign = -1;
            b = (byte)buf.read();
        }
        if (b == 43) {
            sign = 1;
            b = (byte)buf.read();
        }
        if (requireNumber && !ByteOps.isDigit(b)) {
            buf.unget();
            throw new PDFCosParseException("Expected number. Only " + (char)b + "is present");
        }
        while (ByteOps.isDigit(b)) {
            left *= 10L;
            left += (long)(b - 48);
            b = (byte)buf.read();
        }
        if (b == 46) {
            decimal = true;
            b = (byte)buf.read();
            while (ByteOps.isDigit(b)) {
                right *= 10L;
                right += (long)(b - 48);
                divisor *= 10L;
                b = (byte)buf.read();
            }
        }
        Number rslt = !decimal ? (Number)(left >= Integer.MIN_VALUE && left <= Integer.MAX_VALUE ? (Number)((int)left * sign) : (Number)(left * (long)sign)) : (Number)new Double(((double)left + (double)right / (double)divisor) * (double)sign);
        if (ByteOps.isRegular(b)) {
            throw new PDFCosParseException("Unexpected character at position " + Long.toString(buf.getPosition() - 1L));
        }
        buf.unget();
        return rslt;
    }

    static String readString(InputByteStream buf, int len) throws IOException {
        StringBuilder rslt = new StringBuilder();
        byte b = (byte)buf.read();
        for (int i = 0; i < len; ++i) {
            rslt.append((char)b);
            b = (byte)buf.read();
        }
        buf.unget();
        return rslt.toString();
    }

    static boolean readAndCheck(InputByteStream buf, String arg) throws IOException {
        String str = ParserUtils.readString(buf, arg.length());
        return str.equals(arg);
    }

    static boolean readAndCheck(InputByteStream buf, byte b) throws IOException {
        byte inp = (byte)buf.read();
        return inp == b;
    }

    static boolean isPreviousCharEOL(InputByteStream buf) throws IOException {
        long curPos = buf.getPosition();
        buf.seek(curPos - 1L);
        byte peekChar = (byte)ParserUtils.peek(buf);
        buf.seek(curPos);
        return peekChar == 10 || peekChar == 13;
    }

    static boolean skipEOL(InputByteStream buf) throws IOException {
        byte peekChar = (byte)ParserUtils.peek(buf);
        if (peekChar == 13) {
            buf.seek(buf.getPosition() + 1L);
            peekChar = (byte)ParserUtils.peek(buf);
            if (peekChar == 10) {
                buf.seek(buf.getPosition() + 1L);
            }
            return true;
        }
        if (peekChar == 10) {
            buf.seek(buf.getPosition() + 1L);
            return true;
        }
        return false;
    }

    static long getLastXRefSectionPosition(InputByteStream mBuf) throws PDFCosParseException, IOException {
        byte b;
        long pos = ParserUtils.getEOFPositionImpl(mBuf);
        do {
            mBuf.seek(--pos);
        } while (!ByteOps.isDigit(b = (byte)mBuf.read()));
        long rslt = 0L;
        long multiplier = 1L;
        do {
            rslt += (long)((char)b - 48) * multiplier;
            multiplier *= 10L;
            mBuf.seek(--pos);
        } while (ByteOps.isDigit(b = (byte)mBuf.read()));
        return rslt;
    }

    static void skipWhiteCharacters(InputByteStream mBuf) throws IOException {
        while (!mBuf.eof() && ByteOps.isWhitespace((byte)mBuf.read())) {
        }
        if (!mBuf.eof()) {
            mBuf.seek(mBuf.getPosition() - 1L);
        }
    }
}

