/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations.impl;

import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFCosObjectRefAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LimittedAllocationMap {
    private static int mapSize = 64065;
    private static int mapLimit = 64000;
    private static float loadFactor = 0.999f;
    private ArrayList<HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter>> maps = new ArrayList();

    public int size() {
        if (this.maps.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (int arrayInd = 0; arrayInd < this.maps.size(); ++arrayInd) {
            HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> curMap = this.maps.get(arrayInd);
            size += curMap.size();
        }
        return size;
    }

    public boolean isEmpty() {
        if (this.maps.isEmpty()) {
            return true;
        }
        for (int arrayInd = 0; arrayInd < this.maps.size(); ++arrayInd) {
            HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> curMap = this.maps.get(arrayInd);
            if (curMap.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(PDFCosObject arg0) {
        if (this.maps.isEmpty()) {
            return false;
        }
        for (int arrayInd = 0; arrayInd < this.maps.size(); ++arrayInd) {
            HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> curMap = this.maps.get(arrayInd);
            if (!curMap.containsKey(PDFCosObjectRefAdapter.newInstance(arg0))) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(PDFCosObject arg0) {
        if (this.maps.isEmpty()) {
            return false;
        }
        for (int arrayInd = 0; arrayInd < this.maps.size(); ++arrayInd) {
            HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> curMap = this.maps.get(arrayInd);
            if (!curMap.containsValue(PDFCosObjectRefAdapter.newInstance(arg0))) continue;
            return true;
        }
        return false;
    }

    public Object get(PDFCosObject arg0) {
        if (this.maps.isEmpty()) {
            return null;
        }
        for (int arrayInd = 0; arrayInd < this.maps.size(); ++arrayInd) {
            HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> curMap = this.maps.get(arrayInd);
            PDFCosObjectRefAdapter returned = curMap.get(PDFCosObjectRefAdapter.newInstance(arg0));
            if (returned == null) continue;
            return returned.getObject();
        }
        return null;
    }

    public Object put(PDFCosObject arg0, PDFCosObject arg1) {
        HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> curMap;
        if (this.maps.isEmpty()) {
            this.maps.add(this.makeMap());
        }
        if ((curMap = this.maps.get(this.maps.size() - 1)).size() >= mapLimit) {
            this.maps.add(this.makeMap());
            curMap = this.maps.get(this.maps.size() - 1);
        }
        Object returned = this.get(arg0);
        curMap.put(PDFCosObjectRefAdapter.newInstance(arg0), PDFCosObjectRefAdapter.newInstance(arg1));
        return returned;
    }

    private HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> makeMap() {
        return new HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter>(mapSize, loadFactor);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("########## LimitedAllocationMap\n");
        for (int i = 0; i < this.maps.size(); ++i) {
            builder.append("@@@@@ Map #" + i + "\n");
            HashMap<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> m = this.maps.get(i);
            for (Map.Entry<PDFCosObjectRefAdapter, PDFCosObjectRefAdapter> e : m.entrySet()) {
                builder.append(e.getKey().hashCode());
                builder.append(", ");
                builder.append(e.getKey());
                builder.append(", ");
                builder.append(e.getValue());
                builder.append("\n");
            }
        }
        builder.append("###############");
        return builder.toString();
    }
}

