/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCIntentList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCListMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderLabel;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderListContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCRGBGroupsList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageApp;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageAppList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCVExpression;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectAltImageList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageMask;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PMMOCManager {
    private PDFDocument mTargetDoc = null;
    private PDFDocument mSrcDoc = null;
    private CosCloneMgr mCloneMgr = null;
    private boolean mCopyOCGs = false;
    private boolean mCopySourceConfig = false;
    private boolean mMergeConfig = false;
    private PMMOptions mOptions;
    private Map<PDFOCGroup, PDFOCGroup> mClonedOCGs;
    private Map<PDFCosObject, PDFCosObject> mClonedOCGList;
    private Map<PDFOCMembership, PDFOCMembership> mClonedOCMDs;
    private Map<PDFOCUsageAppList, PDFOCUsageAppList> mClonedOCUsageAppList;
    private Map<PDFOCUsageApp, PDFOCUsageApp> mClonedOCUsageApp;
    private Map<PDFOCRGBGroupsList, PDFOCRGBGroupsList> mClonedOCRBGroups;
    private PDFOCProperties mTargetProperties;
    private PDFOCProperties mSrcProperties;
    private static final ASName[] specialOCMDKeys = new ASName[]{ASName.k_OCGs, ASName.k_VE};

    public PMMOCManager(PDFDocument srcDoc, PDFDocument targetDoc, CosCloneMgr cloneManager, PMMOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.mSrcDoc = srcDoc;
        this.mTargetDoc = targetDoc;
        this.mTargetProperties = this.mTargetDoc.requireCatalog().getOCProperties();
        this.mSrcProperties = this.mSrcDoc.requireCatalog().getOCProperties();
        if (this.mTargetProperties != null && this.mTargetProperties.getDefaultOCConfigDict() == null) {
            this.mTargetProperties.setDefaultOCConfigDict(PDFOCConfig.newInstance(this.mTargetDoc));
        }
        this.mCloneMgr = cloneManager;
        this.mClonedOCGs = new HashMap<PDFOCGroup, PDFOCGroup>(100);
        this.mClonedOCGList = new HashMap<PDFCosObject, PDFCosObject>(100);
        this.mClonedOCMDs = new HashMap<PDFOCMembership, PDFOCMembership>(100);
        this.mClonedOCUsageAppList = new HashMap<PDFOCUsageAppList, PDFOCUsageAppList>(100);
        this.mClonedOCUsageApp = new HashMap<PDFOCUsageApp, PDFOCUsageApp>(100);
        this.mClonedOCRBGroups = new HashMap<PDFOCRGBGroupsList, PDFOCRGBGroupsList>(100);
        this.mOptions = options;
        this.mCopyOCGs = this.mOptions.contains(PMMOptions.CopyAllOCGs);
        this.mCopySourceConfig = this.mOptions.contains(PMMOptions.UseTargetOCConfig) ^ true;
        this.mMergeConfig = this.mOptions.contains(PMMOptions.MergeOCConfig);
    }

    public CosCloneMgr getCloneMgr() {
        return this.mCloneMgr;
    }

    PDFOCProperties getTargetOCProperties() {
        return this.mTargetProperties;
    }

    PDFOCProperties getSourceOCProperties() {
        return this.mSrcProperties;
    }

    private PDFOCProperties makeTargetOCProperties() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mTargetProperties == null) {
            this.mTargetProperties = PDFOCProperties.newInstance(this.mTargetDoc);
        }
        return this.mTargetProperties;
    }

    public void mergePageOC(Map<PDFPage, PDFPage> pageMap, Map<PDFAnnotation, PDFAnnotation> annotMap, String[] wrapNames) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (wrapNames != null) {
            this.mMergeConfig = true;
        }
        if (this.mSrcDoc.equals(this.mTargetDoc)) {
            this.mCopyOCGs = true;
            this.mCopySourceConfig = false;
            this.mMergeConfig = false;
        }
        if (this.mMergeConfig) {
            this.mCopyOCGs = true;
            this.mCopySourceConfig = true;
        }
        if (this.mSrcProperties.getDefaultOCConfigDict() == null) {
            this.mCopySourceConfig = false;
        }
        HashMap seenObjectsList = new HashMap();
        if (pageMap != null && !pageMap.isEmpty()) {
            for (Map.Entry<PDFPage, PDFPage> entry : pageMap.entrySet()) {
                this.mergePageResources(entry.getKey(), entry.getValue(), seenObjectsList);
            }
        }
        if (annotMap != null && !annotMap.isEmpty()) {
            for (Map.Entry<PDFAnnotation, PDFAnnotation> entry : annotMap.entrySet()) {
                this.mergePageAnnotationOC(entry.getKey(), entry.getValue(), seenObjectsList);
            }
        }
        if (this.mTargetProperties != null && this.mCopySourceConfig) {
            PDFOCConfig clonedConfig;
            PDFOCConfig pDFOCConfig = clonedConfig = this.mMergeConfig ? this.mergeSourceDefaultConfig(wrapNames, seenObjectsList) : this.copySourceDefaultConfig(seenObjectsList);
            if (clonedConfig != null) {
                this.mTargetProperties.setDefaultOCConfigDict(clonedConfig);
            }
        }
        if (this.mTargetProperties != null) {
            this.mTargetDoc.requireCatalog().setOCProperties(this.mTargetProperties);
        }
        this.mCopyOCGs = this.mOptions.contains(PMMOptions.CopyAllOCGs);
        this.mCopySourceConfig = this.mOptions.contains(PMMOptions.UseTargetOCConfig) ^ true;
        this.mMergeConfig = this.mOptions.contains(PMMOptions.MergeOCConfig);
    }

    public void mergeContentResourcesOC(PDFResources sourceResources, PDFResources targetResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        HashMap seenResources = new HashMap();
        this.mergeResourcesOC(sourceResources, targetResources, seenResources);
    }

    private void mergePageAnnotationOC(PDFAnnotation sourceAnnot, PDFAnnotation targetAnnot, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        PDFOCObject ocObj;
        PDFOCObject ocObjClone;
        if (sourceAnnot.dictionaryContains(ASName.k_OC) && (ocObjClone = this.cloneOCGMD(ocObj = PDFOCObject.getInstance(obj = sourceAnnot.getDictionaryCosObjectValue(ASName.k_OC)), seenObjectsList)) != null) {
            targetAnnot.setDictionaryValue(ASName.k_OC, ocObjClone);
        }
    }

    private void mergePageResources(PDFPage sourcePage, PDFPage targetPage, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources sourceResources = sourcePage.getResources();
        if (sourceResources != null) {
            PDFResources targetResources = targetPage.getResources();
            if (targetResources == null) {
                targetResources = PDFResources.newInstance(targetPage.getPDFDocument());
                targetPage.setDictionaryValue(ASName.k_Resources, targetResources);
            }
            this.mergeResourcesOC(sourceResources, targetResources, seenObjectsList);
        }
    }

    private void mergeResourcesOC(PDFResources sourceResources, PDFResources targetResources, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap sourceXObjMap;
        if (seenObjectsList.get(sourceResources) == targetResources) {
            return;
        }
        seenObjectsList.put(sourceResources, targetResources);
        if (sourceResources == targetResources) {
            return;
        }
        PDFDocument targetDoc = targetResources.getPDFDocument();
        PDFMCPropertyMap sourceProps = sourceResources.getMCPropertyMap();
        if (sourceProps != null) {
            PDFMCPropertyMap targetProps = targetResources.getMCPropertyMap();
            if (targetProps == null) {
                targetProps = PDFMCPropertyMap.newInstance(targetDoc);
                targetResources.setDictionaryValue(ASName.k_Properties, targetProps);
            }
            this.cloneOCPropertyValues(sourceProps.getCosDictionary(), targetProps.getCosDictionary(), seenObjectsList);
        }
        if (sourceResources.dictionaryContains(ASName.k_XObject) && !(sourceXObjMap = sourceResources.getXObjectMap()).isEmpty()) {
            List<ASName> sourceKeys = sourceXObjMap.getCosDictionary().getKeys();
            PDFXObjectMap targetXObjMap = targetResources.getXObjectMap();
            for (ASName xKey : sourceKeys) {
                PDFXObject sourceObj = sourceXObjMap.get(xKey);
                PDFXObject targetObj = targetXObjMap.get(xKey);
                this.mergeXObjectOCs(sourceObj, targetObj, seenObjectsList);
            }
        }
    }

    private void mergeXObjectOCs(PDFXObject sourceXO, PDFXObject targetXO, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj;
        PDFOCObject ocObj;
        PDFOCObject ocObjClone;
        if (seenObjectsList.get(sourceXO) == targetXO) {
            return;
        }
        seenObjectsList.put(sourceXO, targetXO);
        if (sourceXO == targetXO) {
            return;
        }
        PDFDocument targetDoc = targetXO.getPDFDocument();
        if (sourceXO.dictionaryContains(ASName.k_OC) && (ocObjClone = this.cloneOCGMD(ocObj = PDFOCObject.getInstance(obj = sourceXO.getDictionaryCosObjectValue(ASName.k_OC)), seenObjectsList)) != null) {
            targetXO.setDictionaryValue(ASName.k_OC, ocObjClone);
        }
        if (sourceXO instanceof PDFXObjectForm) {
            PDFXObjectForm sourceFormXO;
            PDFResources sourceResources;
            if (sourceXO.dictionaryContains(ASName.k_Resources) && (sourceResources = (sourceFormXO = (PDFXObjectForm)sourceXO).getResources()) != null) {
                PDFXObjectForm targetFormXO = (PDFXObjectForm)targetXO;
                PDFResources targetResources = targetFormXO.getResources();
                if (targetResources == null) {
                    targetResources = PDFResources.newInstance(targetDoc);
                    targetFormXO.setDictionaryValue(ASName.k_Resources, targetResources);
                }
                this.mergeResourcesOC(sourceResources, targetResources, seenObjectsList);
            }
        } else if (sourceXO instanceof PDFXObjectImage) {
            PDFXObjectImage sourceSMask;
            PDFXObjectImage sourceMask;
            PDFXObjectImageMask sourceImageMask;
            PDFXObjectImage sourceImageXO = (PDFXObjectImage)sourceXO;
            PDFXObjectImage targetImageXO = (PDFXObjectImage)targetXO;
            if (sourceXO.dictionaryContains(ASName.k_Alternates)) {
                PDFXObjectAltImageList sourceAlts = sourceImageXO.getAlternatesList();
                PDFXObjectAltImageList targetAlts = targetImageXO.getAlternatesList();
                for (int indx = 0; indx < sourceAlts.size(); ++indx) {
                    PDFXObjectAltImage sourceImage = (PDFXObjectAltImage)sourceAlts.get(indx);
                    PDFXObjectAltImage targetImage = (PDFXObjectAltImage)targetAlts.get(indx);
                    this.mergeXObjectOCs(sourceImage.getImage(), targetImage.getImage(), seenObjectsList);
                }
            }
            if ((sourceImageMask = sourceImageXO.getMask()) != null && (sourceMask = sourceImageMask.getImageMask()) != null) {
                PDFXObjectImage targetMask = targetImageXO.getMask().getImageMask();
                this.mergeXObjectOCs(sourceMask, targetMask, seenObjectsList);
            }
            if ((sourceSMask = sourceImageXO.getSMask()) != null) {
                PDFXObjectImage targetSMask = targetImageXO.getSMask();
                this.mergeXObjectOCs(sourceSMask, targetSMask, seenObjectsList);
            }
        }
    }

    PDFOCConfig mergeSourceDefaultConfig(String[] wrapNames, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCConfig srcConfig;
        PDFOCOrderList clonedOrder = null;
        PDFOCConfig pDFOCConfig = srcConfig = this.mSrcProperties == null ? null : this.mSrcProperties.getDefaultOCConfigDict();
        if (srcConfig != null) {
            clonedOrder = this.cloneOrderList(srcConfig.getOrderList(), seenObjectsList);
        }
        PDFOCOrderList mergedOrder = wrapNames != null ? this.wrapOrder(this.mTargetProperties.getDefaultOCConfigDict().getOrderList(), clonedOrder, wrapNames) : this.mergeOrder(this.mTargetProperties.getDefaultOCConfigDict().getOrderList(), clonedOrder);
        return this.mergeConfig(this.mTargetProperties.getDefaultOCConfigDict(), srcConfig, mergedOrder);
    }

    private PDFOCConfig mergeConfig(PDFOCConfig targetConfig, PDFOCConfig srcConfig, PDFOCOrderList newOrder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCBaseState targetState;
        PDFOCBaseState srcState;
        PDFOCListMode mode;
        PDFOCIntentList intent;
        PDFOCBaseState state;
        String name;
        if (srcConfig == null) {
            return targetConfig;
        }
        PDFOCConfig mergedConfig = PDFOCConfig.newInstance(targetConfig.getPDFDocument());
        if (this.mCopySourceConfig) {
            name = srcConfig.getName();
            if (name != null) {
                mergedConfig.setName(name);
            }
            if ((name = srcConfig.getCreator()) != null) {
                mergedConfig.setCreator(name);
            }
            if ((state = srcConfig.getBaseState()) != null) {
                mergedConfig.setBaseState(state);
            }
            if ((intent = srcConfig.getIntent()) != null) {
                mergedConfig.setIntent(PDFOCIntentList.getInstance(this.mCloneMgr.clone(intent.getCosObject())));
            }
            if ((mode = srcConfig.getListMode()) != null) {
                mergedConfig.setListMode(mode);
            }
        }
        if ((name = mergedConfig.getName()) == null) {
            name = targetConfig.getName();
        }
        if (name != null) {
            mergedConfig.setName(name);
        }
        if ((name = mergedConfig.getCreator()) == null) {
            name = targetConfig.getName();
        }
        if (name != null) {
            mergedConfig.setCreator(name);
        }
        if ((state = mergedConfig.getBaseState()) == null) {
            state = targetConfig.getBaseState();
        }
        if (state != null) {
            mergedConfig.setBaseState(state);
        }
        if ((intent = mergedConfig.getIntent()) == null) {
            intent = targetConfig.getIntent();
        }
        if (intent != null) {
            mergedConfig.setIntent(intent);
        }
        if ((mode = mergedConfig.getListMode()) == null) {
            mode = targetConfig.getListMode();
        }
        if (mode != null) {
            mergedConfig.setListMode(mode);
        }
        if ((srcState = srcConfig.getBaseState()) == null) {
            srcState = PDFOCBaseState.ON;
        }
        if ((targetState = targetConfig.getBaseState()) == null) {
            targetState = PDFOCBaseState.ON;
        }
        PDFOCGroupArray to = PDFOCGroupArray.newInstance(mergedConfig.getPDFDocument());
        this.copyOCGList(to, targetConfig.getONList(), null, false);
        PDFOCGroupArray from = srcConfig.getONList();
        PDFOCGroupArray all = null;
        if (!srcState.equals((Object)targetState)) {
            all = this.mSrcProperties.getOCGs();
        }
        this.copyOCGList(to, from, all, true);
        if (!to.isEmpty()) {
            mergedConfig.setONList(to);
        }
        to = PDFOCGroupArray.newInstance(mergedConfig.getPDFDocument());
        this.copyOCGList(to, targetConfig.getOFFList(), null, false);
        from = srcConfig.getOFFList();
        all = null;
        if (!srcState.equals((Object)targetState)) {
            all = this.mSrcProperties.getOCGs();
        }
        this.copyOCGList(to, from, all, true);
        if (!to.isEmpty()) {
            mergedConfig.setOFFList(to);
        }
        PDFOCUsageAppList toAs = PDFOCUsageAppList.newInstance(mergedConfig.getPDFDocument());
        toAs.addList(targetConfig.getASList());
        toAs.addList(this.cloneUsageAppList(srcConfig.getASList()));
        if (!toAs.isEmpty()) {
            mergedConfig.setASList(toAs);
        }
        PDFOCRGBGroupsList toRB = PDFOCRGBGroupsList.newInstance(mergedConfig.getPDFDocument());
        toRB.addList(targetConfig.getRBGroups());
        toRB.addList(this.cloneRGBGroupList(srcConfig.getRBGroups()));
        if (!toRB.isEmpty()) {
            mergedConfig.setRBGroups(toRB);
        }
        PDFOCGroupArray toLocked = PDFOCGroupArray.newInstance(mergedConfig.getPDFDocument());
        this.copyOCGList(toLocked, targetConfig.getLocked(), null, false);
        PDFOCGroupArray locked = srcConfig.getLocked();
        if (locked != null) {
            Iterator lockIter = locked.iterator();
            while (lockIter.hasNext()) {
                PDFOCGroup ocg = this.cloneOCG((PDFOCGroup)lockIter.next());
                if (ocg == null) continue;
                toLocked.add(ocg);
            }
        }
        if (!toLocked.isEmpty()) {
            mergedConfig.setLocked(toLocked);
        }
        mergedConfig.setOrderList(newOrder);
        return mergedConfig;
    }

    private PDFOCOrderList mergeOrder(PDFOCOrderList targetOrder, PDFOCOrderList srcOrder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcOrder == null) {
            return targetOrder;
        }
        if (targetOrder == null) {
            return srcOrder;
        }
        PDFOCOrderList mergedOrder = PDFOCOrderList.newInstance(targetOrder.getPDFDocument());
        Iterator orderIter = targetOrder.iterator();
        while (orderIter.hasNext()) {
            mergedOrder.add((PDFCosObjectContainer)orderIter.next());
        }
        orderIter = srcOrder.iterator();
        while (orderIter.hasNext()) {
            mergedOrder.add((PDFCosObjectContainer)orderIter.next());
        }
        return mergedOrder;
    }

    private PDFOCOrderList wrapOrder(PDFOCOrderList targetOrder, PDFOCOrderList srcOrder, String[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcOrder == null) {
            return targetOrder;
        }
        if (targetOrder == null) {
            return srcOrder;
        }
        PDFOCOrderList mergedOrder = null;
        PDFOCOrderList wrappedTarget = PDFOCOrderList.newInstance(targetOrder.getPDFDocument());
        if (names[0] != null) {
            PDFOCOrderLabel targetLabel = PDFOCOrderLabel.newInstance(targetOrder.getPDFDocument(), names[0]);
            wrappedTarget.setLabel(targetLabel);
        } else {
            mergedOrder = wrappedTarget;
        }
        wrappedTarget.addOrderList(targetOrder);
        PDFOCOrderList wrappedSrc = PDFOCOrderList.newInstance(targetOrder.getPDFDocument());
        if (names[1] != null) {
            PDFOCOrderLabel srcLabel = PDFOCOrderLabel.newInstance(targetOrder.getPDFDocument(), names[1]);
            wrappedSrc.setLabel(srcLabel);
        }
        wrappedSrc.addOrderList(srcOrder);
        if (mergedOrder == null) {
            mergedOrder = PDFOCOrderList.newInstance(targetOrder.getPDFDocument());
        }
        if (names[0] != null) {
            mergedOrder.add(wrappedTarget);
        }
        mergedOrder.add(wrappedSrc);
        return mergedOrder;
    }

    private PDFOCGroupList cloneOCGList(PDFOCGroupList sourceList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mClonedOCGList.containsKey(sourceList)) {
            return (PDFOCGroupList)this.mClonedOCGList.get(sourceList);
        }
        CosArray targetClone = this.mTargetDoc.getCosDocument().createCosArray();
        Iterator iter = sourceList.iterator();
        while (iter.hasNext()) {
            PDFOCGroup ocg = (PDFOCGroup)iter.next();
            PDFOCGroup clonedOCG = this.cloneOCG(ocg);
            if (clonedOCG == null) continue;
            targetClone.add(clonedOCG.getCosObject());
        }
        PDFOCGroupList clonedOCGList = PDFOCGroupList.getInstance(targetClone);
        if (clonedOCGList != null) {
            this.mClonedOCGList.put(sourceList, clonedOCGList);
        }
        return clonedOCGList;
    }

    private PDFOCGroupArray cloneOCGList(PDFOCGroupArray sourceList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mClonedOCGList.containsKey(sourceList)) {
            return (PDFOCGroupArray)this.mClonedOCGList.get(sourceList);
        }
        CosArray targetClone = this.mTargetDoc.getCosDocument().createCosArray();
        for (PDFOCGroup ocg : sourceList) {
            PDFOCGroup clonedOCG = this.cloneOCG(ocg);
            if (clonedOCG == null) continue;
            targetClone.add(clonedOCG.getCosObject());
        }
        PDFOCGroupArray clonedOCGList = PDFOCGroupArray.getInstance(targetClone);
        if (clonedOCGList != null) {
            this.mClonedOCGList.put(sourceList, clonedOCGList);
        }
        return clonedOCGList;
    }

    private PDFOCObject cloneOCGMD(PDFOCObject srcOCGMD, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return srcOCGMD.isOCG() ? this.cloneOCG((PDFOCGroup)srcOCGMD) : this.cloneOCMD((PDFOCMembership)srcOCGMD, seenObjectsList);
    }

    private PDFOCGroup cloneOCG(PDFOCGroup srcOCG) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcOCG == null) {
            return null;
        }
        PDFOCGroup clonedOCG = this.mClonedOCGs.get(srcOCG);
        if (clonedOCG != null) {
            return clonedOCG;
        }
        String sourceName = srcOCG.getName();
        this.makeTargetOCProperties();
        if (this.mMergeConfig || !this.mCopyOCGs || !this.mTargetProperties.containsOCG(sourceName)) {
            clonedOCG = PDFOCGroup.getInstance(this.mCloneMgr.clone(srcOCG.getCosObject()));
            if (clonedOCG != null) {
                this.makeTargetOCProperties().addOCG(clonedOCG);
                this.mClonedOCGs.put(srcOCG, clonedOCG);
            }
        } else {
            clonedOCG = this.mTargetProperties.getOCGs().getOCGByName(sourceName);
        }
        return clonedOCG;
    }

    private PDFOCVExpression cloneVExpression(PDFOCVExpression srcVExp, HashMap seenOCVExpressions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray targetClone = (CosArray)seenOCVExpressions.get(srcVExp);
        if (targetClone != null) {
            return PDFOCVExpression.getInstance(targetClone);
        }
        targetClone = this.mTargetDoc.getCosDocument().createCosArray();
        seenOCVExpressions.put(srcVExp, targetClone);
        CosObject elemClone = null;
        Iterator<CosObject> iter = srcVExp.getCosArray().iterator();
        while (iter.hasNext()) {
            CosObject elem = iter.next();
            if (elem.getType() == 6) {
                PDFOCGroup ocg = PDFOCGroup.getInstance(elem);
                PDFOCGroup clonedOCG = this.cloneOCG(ocg);
                elemClone = clonedOCG.getCosObject();
            } else if (elem.getType() == 5) {
                PDFOCVExpression vE = PDFOCVExpression.getInstance(elem);
                PDFOCVExpression clonedVE = this.cloneVExpression(vE, seenOCVExpressions);
                elemClone = clonedVE.getCosObject();
            } else if (elem.getType() == 3) {
                elemClone = this.mCloneMgr.clone(elem);
            } else {
                throw new PDFInvalidDocumentException("Invalid VE entry");
            }
            targetClone.add(elemClone);
        }
        return PDFOCVExpression.getInstance(targetClone);
    }

    private PDFOCMembership cloneOCMD(PDFOCMembership srcOCMD, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCVExpression sourceVE;
        PDFOCMembership clonedOCMD = this.mClonedOCMDs.get(srcOCMD);
        if (clonedOCMD != null) {
            return clonedOCMD;
        }
        CosDictionary clonedCosDict = CosUtils.cloneOrdinaryKeys(this.mTargetDoc.getCosDocument(), this.mCloneMgr, srcOCMD.getCosDictionary(), specialOCMDKeys);
        PDFOCGroupList sourceList = srcOCMD.getOCGs();
        if (sourceList != null) {
            PDFOCGroupList cloneList = this.cloneOCGList(sourceList);
            clonedCosDict.put(ASName.k_OCGs, cloneList.getCosArray());
        }
        if ((sourceVE = srcOCMD.getVisibilityExpression()) != null) {
            PDFOCVExpression cloneVE = this.cloneVExpression(sourceVE, seenObjectsList);
            CosArray cloneVEObj = cloneVE.getCosArray();
            clonedCosDict.put(ASName.k_VE, cloneVEObj);
        }
        clonedOCMD = PDFOCMembership.getInstance(clonedCosDict);
        this.mClonedOCMDs.put(srcOCMD, clonedOCMD);
        return clonedOCMD;
    }

    private void cloneOCPropertyValues(CosDictionary source, CosDictionary target, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (source == null) {
            return;
        }
        if (!source.isEmpty()) {
            List<ASName> keys = source.getKeys();
            for (ASName key : keys) {
                PDFOCObject ocObj;
                CosObject obj = source.get(key);
                if (!PDFOCObject.isOCObject(obj) || (ocObj = PDFOCObject.getInstance(obj)) == null) continue;
                PDFOCObject ocObjClone = this.cloneOCGMD(ocObj, seenObjectsList);
                target.put(key, ocObjClone.getCosObject());
            }
        }
    }

    private PDFOCOrderList cloneOrderList(PDFOCOrderList orderList, HashMap seenOCOrderLists) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (orderList == null) {
            return null;
        }
        PDFOCOrderList result = (PDFOCOrderList)seenOCOrderLists.get(orderList);
        if (result != null) {
            return result;
        }
        CosArray targetClone = this.mTargetDoc.getCosDocument().createCosArray();
        result = PDFOCOrderList.getInstance(targetClone);
        seenOCOrderLists.put(orderList, result);
        CosObject elemClone = null;
        Iterator<CosObject> iter = orderList.getCosArray().iterator();
        while (iter.hasNext()) {
            CosObject elem = iter.next();
            if (elem instanceof CosArray) {
                PDFOCOrderList oList = PDFOCOrderList.getInstance(elem);
                elemClone = this.cloneOrderList(oList, seenOCOrderLists).getCosObject();
                targetClone.add(elemClone);
                continue;
            }
            if (elem instanceof CosDictionary) {
                PDFOCGroup ocg = PDFOCGroup.getInstance(elem);
                elemClone = this.cloneOCG(ocg).getCosObject();
                targetClone.add(elemClone);
                continue;
            }
            elemClone = this.mCloneMgr.clone(elem);
            targetClone.add(elemClone);
        }
        return result;
    }

    private PDFOCConfig cloneOCConfig(PDFOCConfig sourceConfig, HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sourceConfig == null) {
            return null;
        }
        CosDictionary targetClone = this.mTargetDoc.getCosDocument().createCosDictionary();
        PDFOCConfig result = PDFOCConfig.getInstance(targetClone);
        CosDictionary source = sourceConfig.getCosDictionary();
        List<ASName> keys = source.getKeys();
        keys.remove(ASName.k_OCGs);
        boolean hasOrder = false;
        if (source.containsKey(ASName.k_Order)) {
            hasOrder = true;
            keys.remove(ASName.k_Order);
        }
        boolean hasRBGroups = false;
        if (source.containsKey(ASName.k_RBGroups)) {
            hasRBGroups = true;
            keys.remove(ASName.k_RBGroups);
        }
        boolean hasLocked = false;
        if (source.containsKey(ASName.k_Locked)) {
            hasLocked = true;
            keys.remove(ASName.k_Locked);
        }
        boolean hasAS = false;
        if (source.containsKey(ASName.k_AS)) {
            hasAS = true;
            keys.remove(ASName.k_AS);
        }
        boolean hasON = false;
        if (source.containsKey(ASName.k_ON)) {
            hasON = true;
            keys.remove(ASName.k_ON);
        }
        boolean hasOFF = false;
        if (source.containsKey(ASName.k_OFF)) {
            hasOFF = true;
            keys.remove(ASName.k_OFF);
        }
        for (ASName key : keys) {
            CosObject value = source.get(key);
            targetClone.put(key, this.mCloneMgr.clone(value));
        }
        if (hasOrder) {
            PDFOCOrderList sourceOlist = sourceConfig.getOrderList();
            PDFOCOrderList cloneOlist = this.cloneOrderList(sourceOlist, seenObjectsList);
            CosArray cloneOlistObj = cloneOlist.getCosArray();
            targetClone.put(ASName.k_Order, cloneOlistObj);
        }
        if (hasRBGroups) {
            PDFOCRGBGroupsList sourceRBlist = sourceConfig.getRBGroups();
            PDFOCRGBGroupsList cloneRBlist = this.cloneRGBGroupList(sourceRBlist);
            CosArray cloneRBlistObj = cloneRBlist.getCosArray();
            targetClone.put(ASName.k_RBGroups, cloneRBlistObj);
        }
        if (hasLocked) {
            PDFOCGroupArray sourceLockedlist = sourceConfig.getLocked();
            PDFOCGroupArray cloneLockedlist = this.cloneOCGList(sourceLockedlist);
            CosArray cloneLockedlistObj = cloneLockedlist.getCosArray();
            targetClone.put(ASName.k_Locked, cloneLockedlistObj);
        }
        if (hasAS) {
            PDFOCUsageAppList sourceASlist = sourceConfig.getASList();
            PDFOCUsageAppList cloneASlist = this.cloneUsageAppList(sourceASlist);
            CosArray cloneASlistObj = cloneASlist.getCosArray();
            targetClone.put(ASName.k_AS, cloneASlistObj);
        }
        if (hasON) {
            PDFOCGroupArray sourceONlist = sourceConfig.getONList();
            PDFOCGroupArray cloneONlist = this.cloneOCGList(sourceONlist);
            CosArray cloneONlistObj = cloneONlist.getCosArray();
            targetClone.put(ASName.k_ON, cloneONlistObj);
        }
        if (hasOFF) {
            PDFOCGroupArray sourceOFFlist = sourceConfig.getOFFList();
            PDFOCGroupArray cloneOFFlist = this.cloneOCGList(sourceOFFlist);
            CosArray cloneOFFlistObj = cloneOFFlist.getCosArray();
            targetClone.put(ASName.k_OFF, cloneOFFlistObj);
        }
        return result;
    }

    private PDFOCRGBGroupsList cloneRGBGroupList(PDFOCRGBGroupsList sourceList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sourceList == null) {
            return null;
        }
        if (this.mClonedOCRBGroups.containsKey(sourceList)) {
            return this.mClonedOCRBGroups.get(sourceList);
        }
        CosArray targetClone = this.mTargetDoc.getCosDocument().createCosArray();
        PDFOCRGBGroupsList clonedRBList = PDFOCRGBGroupsList.getInstance(targetClone);
        for (PDFOCGroupArray ocgList : sourceList) {
            targetClone.add(this.cloneOCGList(ocgList).getCosObject());
        }
        if (!clonedRBList.isEmpty()) {
            this.mClonedOCRBGroups.put(sourceList, clonedRBList);
        }
        return clonedRBList;
    }

    private PDFOCUsageAppList cloneUsageAppList(PDFOCUsageAppList sourceList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sourceList == null) {
            return null;
        }
        if (this.mClonedOCUsageAppList.containsKey(sourceList)) {
            return this.mClonedOCUsageAppList.get(sourceList);
        }
        PDFOCUsageAppList clonedAppList = PDFOCUsageAppList.newInstance(this.mTargetDoc);
        for (PDFOCUsageApp usageApp : sourceList) {
            clonedAppList.add(this.cloneOCUsageApp(usageApp));
        }
        if (!clonedAppList.isEmpty()) {
            this.mClonedOCUsageAppList.put(sourceList, clonedAppList);
        }
        return clonedAppList;
    }

    private PDFOCUsageApp cloneOCUsageApp(PDFOCUsageApp sourceUsageApp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCUsageApp clonedApp;
        if (this.mClonedOCUsageApp.containsKey(sourceUsageApp)) {
            return this.mClonedOCUsageApp.get(sourceUsageApp);
        }
        CosDictionary targetClone = this.mTargetDoc.getCosDocument().createCosDictionary();
        CosDictionary source = sourceUsageApp.getCosDictionary();
        List<ASName> keys = source.getKeys();
        boolean hasOCGs = false;
        if (source.containsKey(ASName.k_OCGs)) {
            hasOCGs = true;
            keys.remove(ASName.k_OCGs);
        }
        for (ASName key : keys) {
            CosObject value = source.get(key);
            targetClone.put(key, this.mCloneMgr.clone(value));
        }
        if (hasOCGs) {
            PDFOCGroupArray sourceOCGs = sourceUsageApp.getOCGs();
            PDFOCGroupArray cloneOCGs = this.cloneOCGList(sourceOCGs);
            CosArray cloneOCGsObj = cloneOCGs.getCosArray();
            targetClone.put(ASName.k_OCGs, cloneOCGsObj);
        }
        if (!(clonedApp = PDFOCUsageApp.getInstance(targetClone)).isEmpty()) {
            this.mClonedOCUsageApp.put(sourceUsageApp, clonedApp);
        }
        return clonedApp;
    }

    private PDFOCConfig copySourceDefaultConfig(HashMap seenObjectsList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.mSrcProperties == null) {
            return null;
        }
        PDFOCConfig sourceConfig = this.mSrcProperties.getDefaultOCConfigDict();
        PDFOCConfig targetConfig = this.cloneOCConfig(sourceConfig, seenObjectsList);
        return targetConfig;
    }

    private void copyOCGList(PDFOCGroupArray to, PDFOCGroupArray srcFrom, PDFOCGroupArray srcAll, boolean cloned) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        Iterator fromIter = null;
        if (srcFrom != null) {
            fromIter = srcFrom.iterator();
        }
        boolean check = false;
        if (srcAll != null) {
            fromIter = srcAll.iterator();
            check = true;
        }
        if (fromIter == null) {
            return;
        }
        while (fromIter.hasNext()) {
            PDFOCGroup srcOCG = (PDFOCGroup)fromIter.next();
            PDFOCGroup clonedOCG = cloned ? this.mClonedOCGs.get(srcOCG) : srcOCG;
            if (clonedOCG == null || check && (srcFrom == null || srcFrom.contains(srcOCG))) continue;
            to.add(clonedOCG);
        }
    }

    static void collectRepeatingOCGs(PDFOCOrderList order, Map<PDFOCOrderListContent, PDFOCGroup> ocgs, Set<PDFOCOrderList> seenOCOrders) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (order == null) {
            return;
        }
        if (seenOCOrders.contains(order)) {
            return;
        }
        seenOCOrders.add(order);
        Iterator orderIter = order.iterator();
        ArrayList<PDFOCGroup> firstOcgs = new ArrayList<PDFOCGroup>(order.size());
        while (orderIter.hasNext()) {
            PDFOCOrderListContent curItem = (PDFOCOrderListContent)orderIter.next();
            if (curItem instanceof PDFOCOrderList) {
                PMMOCManager.collectRepeatingOCGs((PDFOCOrderList)curItem, ocgs, seenOCOrders);
                continue;
            }
            if (!(curItem instanceof PDFOCGroup)) continue;
            PDFOCGroup oldOCG = PMMOCManager.findOCGInList(firstOcgs, ((PDFOCGroup)curItem).getName());
            if (oldOCG == null) {
                firstOcgs.add((PDFOCGroup)curItem);
                continue;
            }
            if (PDFUtil.isPDFCosObjectRefEqual(oldOCG, (PDFOCGroup)curItem)) continue;
            ocgs.put(curItem, oldOCG);
        }
    }

    private static PDFOCGroup findOCGInList(List<PDFOCGroup> firstOCGs, String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (PDFOCGroup curOCG : firstOCGs) {
            if (!name.equals(curOCG.getName())) continue;
            return curOCG;
        }
        return null;
    }

    static void replaceResourcesOC(Map ocgs, PDFResources sourceResources, HashSet seenReplacedObjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap sourceXObjMap;
        if (sourceResources == null) {
            return;
        }
        if (seenReplacedObjects.contains(sourceResources)) {
            return;
        }
        seenReplacedObjects.add(sourceResources);
        PDFMCPropertyMap sourceProps = sourceResources.getMCPropertyMap();
        if (sourceProps != null) {
            LinkedHashMap<ASName, PDFCosObject> replacedOCGs = new LinkedHashMap<ASName, PDFCosObject>(sourceProps.size());
            for (ASName key : sourceProps.keySet()) {
                PDFCosObject value = (PDFCosObject)sourceProps.get((Object)key);
                if (!PDFOCObject.isOCObject(value.getCosObject())) continue;
                value = PDFOCObject.getInstance(value.getCosObject());
                if ((value = PMMOCManager.replaceOCObject(ocgs, (PDFOCObject)value, seenReplacedObjects)) == null) continue;
                replacedOCGs.put(key, value);
            }
            if (!replacedOCGs.isEmpty()) {
                for (Map.Entry entry : replacedOCGs.entrySet()) {
                    sourceProps.set((ASName)entry.getKey(), PDFMCProperty.getInstance(((PDFCosObject)entry.getValue()).getCosObject()));
                }
            }
        }
        if (sourceResources.dictionaryContains(ASName.k_XObject) && !(sourceXObjMap = sourceResources.getXObjectMap()).isEmpty()) {
            for (ASName xKey : sourceXObjMap.keySet()) {
                PDFXObject xObj = (PDFXObject)sourceXObjMap.get((Object)xKey);
                PMMOCManager.replaceXObjectOCGs(ocgs, xObj, seenReplacedObjects);
            }
        }
    }

    static void replacePageAnnotationOC(Map ocgs, PDFAnnotation sourceAnnot, HashSet seenReplacedObjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCObject replacedOCG = null;
        PDFOCObject ocObj = PDFOCObject.getInstance(sourceAnnot.getDictionaryCosObjectValue(ASName.k_OC));
        replacedOCG = PMMOCManager.replaceOCObject(ocgs, ocObj, seenReplacedObjects);
        if (replacedOCG != null) {
            sourceAnnot.setDictionaryValue(ASName.k_OC, replacedOCG);
        }
    }

    private static void replaceXObjectOCGs(Map ocgs, PDFXObject sourceXO, HashSet seenReplacedObjects) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (sourceXO == null) {
            return;
        }
        if (seenReplacedObjects.contains(sourceXO)) {
            return;
        }
        seenReplacedObjects.add(sourceXO);
        PDFOCObject ocObj = PDFOCObject.getInstance(sourceXO.getDictionaryCosObjectValue(ASName.k_OC));
        PDFOCObject replacedOCG = PMMOCManager.replaceOCObject(ocgs, ocObj, seenReplacedObjects);
        if (replacedOCG != null) {
            sourceXO.setDictionaryValue(ASName.k_OC, replacedOCG);
        }
        if (sourceXO instanceof PDFXObjectForm) {
            PDFXObjectForm sourceFormXO = (PDFXObjectForm)sourceXO;
            PDFResources sourceResources = sourceFormXO.getResources();
            PMMOCManager.replaceResourcesOC(ocgs, sourceResources, seenReplacedObjects);
        } else if (sourceXO instanceof PDFXObjectImage) {
            PDFXObjectImageMask sourceImageMask;
            PDFXObjectImage sourceImageXO = (PDFXObjectImage)sourceXO;
            PDFXObjectAltImageList sourceAlts = sourceImageXO.getAlternatesList();
            if (sourceAlts != null) {
                for (int indx = 0; indx < sourceAlts.size(); ++indx) {
                    PDFXObjectAltImage sourceImage = (PDFXObjectAltImage)sourceAlts.get(indx);
                    PMMOCManager.replaceXObjectOCGs(ocgs, sourceImage.getImage(), seenReplacedObjects);
                }
            }
            if ((sourceImageMask = sourceImageXO.getMask()) != null) {
                PDFXObjectImage sourceMask = sourceImageMask.getImageMask();
                PMMOCManager.replaceXObjectOCGs(ocgs, sourceMask, seenReplacedObjects);
            }
            PDFXObjectImage sourceSMask = sourceImageXO.getSMask();
            PMMOCManager.replaceXObjectOCGs(ocgs, sourceSMask, seenReplacedObjects);
        }
    }

    private static PDFOCObject replaceOCObject(Map<PDFOCObject, PDFOCObject> ocgs, PDFOCObject ocgmd, HashSet seenOCgmds) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (ocgmd == null) {
            return null;
        }
        if (ocgmd.isOCG()) {
            return ocgs.get(ocgmd);
        }
        if (seenOCgmds.contains(ocgmd)) {
            return null;
        }
        seenOCgmds.add(ocgmd);
        PDFOCMembership ocmd = (PDFOCMembership)ocgmd;
        PDFOCGroupList ocgList = ocmd.getOCGs();
        ArrayList<PDFOCObject> newOCGList = new ArrayList<PDFOCObject>(ocgList.size());
        boolean replaced = false;
        Iterator ocgIter = ocgList.iterator();
        while (ocgIter.hasNext()) {
            PDFOCGroup curOCG = (PDFOCGroup)ocgIter.next();
            PDFOCObject replacedOCG = PMMOCManager.replaceOCObject(ocgs, curOCG, seenOCgmds);
            if (replacedOCG == null) {
                newOCGList.add(curOCG);
                continue;
            }
            replaced = true;
            newOCGList.add(replacedOCG);
        }
        PDFOCMembership returnedOCMD = null;
        if (replaced) {
            if (newOCGList.size() == 1) {
                ocmd.setOCGS((PDFOCGroup)newOCGList.get(0));
            } else {
                PDFOCGroupList newOCGs = PDFOCGroupList.newInstance(ocgList.getPDFDocument());
                ocgIter = newOCGList.iterator();
                while (ocgIter.hasNext()) {
                    try {
                        newOCGs.add((PDFOCGroup)ocgIter.next());
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new RuntimeException(e);
                    }
                }
                ocmd.setOCGS(newOCGs);
            }
            returnedOCMD = ocmd;
        }
        return returnedOCMD;
    }

    static void cleanupDocumentOCGs(Map ocgs, PDFOCProperties props) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCUsageAppList usages;
        if (props == null) {
            return;
        }
        PDFOCConfig config = props.getDefaultOCConfigDict();
        PMMOCManager.cleanupReplacedOCGs(ocgs, props.getOCGs());
        if (config == null) {
            return;
        }
        PDFOCOrderList order = config.getOrderList();
        PMMOCManager.cleanupReplacedOCGs(ocgs, order);
        if (order != null && order.get(order.size() - 1) instanceof PDFOCOrderLabel) {
            order.remove(order.size() - 1);
        }
        PMMOCManager.cleanupReplacedOCGs(ocgs, config.getONList());
        PMMOCManager.cleanupReplacedOCGs(ocgs, config.getOFFList());
        PMMOCManager.cleanupReplacedOCGs(ocgs, config.getLocked());
        PDFOCRGBGroupsList rbGroup = config.getRBGroups();
        if (rbGroup != null) {
            Iterator itemIter = rbGroup.iterator();
            while (itemIter.hasNext()) {
                PMMOCManager.cleanupReplacedOCGs(ocgs, (PDFOCGroupArray)itemIter.next());
            }
        }
        if ((usages = config.getASList()) != null) {
            for (PDFOCUsageApp curUsage : usages) {
                if (curUsage == null) continue;
                PMMOCManager.cleanupReplacedOCGs(ocgs, curUsage.getOCGs());
            }
        }
    }

    private static void cleanupReplacedOCGs(Map ocgs, PDFCosArrayList ocgList) {
        if (ocgList == null) {
            return;
        }
        ArrayList replaceOCGs = new ArrayList(ocgList.size());
        Iterator itemIter = ocgList.iterator();
        while (itemIter.hasNext()) {
            Object curItem = itemIter.next();
            if (!(curItem instanceof PDFOCGroup) || !ocgs.containsKey(curItem)) continue;
            if (!ocgList.contains(ocgs.get(curItem))) {
                replaceOCGs.add(ocgs.get(curItem));
            }
            itemIter.remove();
        }
        if (!replaceOCGs.isEmpty()) {
            for (int itemInd = 0; itemInd < replaceOCGs.size(); ++itemInd) {
                ocgList.add((PDFCosObjectContainer)replaceOCGs.get(itemInd));
            }
        }
    }
}

