/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.javascript.Certificate;
import com.adobe.internal.pdftoolkit.services.javascript.JSStateListener;
import com.adobe.internal.pdftoolkit.services.javascript.RDN;
import com.adobe.internal.pdftoolkit.services.javascript.Util;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.model.manual.CertificateSpecifierParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class CertificateSpecifier
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("CertificateSpecifier.class", new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, new HashMap<String, Property>(8){
        private static final long serialVersionUID = 1L;
        {
            this.put("keyUsage", new Property(CertificateSpecifier.class, "keyUsage", "getKeyUsage", "setKeyUsage", CertificateSpecifierParams.keyUsage, false, false));
            this.put("url", new Property(CertificateSpecifier.class, "url", "getUrl", "setUrl", CertificateSpecifierParams.url, false, false));
            this.put("issuer", new Property(CertificateSpecifier.class, "issuer", "getIssuer", "setIssuer", CertificateSpecifierParams.issuer, false, false));
            this.put("subject", new Property(CertificateSpecifier.class, "subject", "getSubject", "setSubject", CertificateSpecifierParams.subject, false, false));
            this.put("oid", new Property(CertificateSpecifier.class, "oid", "getOid", "setOid", CertificateSpecifierParams.oid, false, false));
            this.put("flags", new Property(CertificateSpecifier.class, "flags", "getFlags", "setFlags", CertificateSpecifierParams.flags, false, false));
            this.put("urlType", new Property(CertificateSpecifier.class, "urlType", "getUrlType", "setUrlType", CertificateSpecifierParams.urlType, false, false));
            this.put("subjectDN", new Property(CertificateSpecifier.class, "subjectDN", "getSubjectDN", "setSubjectDN", CertificateSpecifierParams.subjectDN, false, false));
        }
    });
    private static final long serialVersionUID = -762147576421458363L;
    private JSStateListener.SeedValueCache.CertificateSpecifierCache certificateSpecifier = null;
    static final String className = "CertificateSpecifier";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    @Override
    public String getClassName() {
        return className;
    }

    public Object getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Integer flags = this.certificateSpecifier.flags;
        if (flags != null) {
            return flags;
        }
        return Undefined.instance;
    }

    public void setFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.certificateSpecifier.flags = flags;
    }

    public Object getIssuer() {
        byte[][] issuer = this.certificateSpecifier.issuer;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        if (issuer != null && issuer.length > 0) {
            Scriptable scope = this.getParentScope();
            for (int i = 0; i < issuer.length; ++i) {
                Certificate cert = (Certificate)ESObject.create(this.getParentScope(), true, "Certificate", false, null);
                cert.setCertificate(issuer[i]);
                certificates.add(cert);
            }
            Scriptable array = Context.getCurrentContext().newArray(scope, certificates.toArray());
            return new Delegator(array){

                @Override
                public void put(int index, Scriptable start, Object value) {
                    byte[][] issuer = ((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.issuer;
                    if (issuer != null) {
                        ((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.issuer = CertificateSpecifier.this.processDelegator(issuer, index, value);
                    }
                }
            };
        }
        return Undefined.instance;
    }

    public void setIssuer(Object issuer) {
        Object[] fromJS = Context.getCurrentContext().getElements((Scriptable)issuer);
        Certificate[] jsCerts = new Certificate[fromJS.length];
        byte[][] issuers = new byte[jsCerts.length][];
        for (int i = 0; i < fromJS.length; ++i) {
            if (!(fromJS[i] instanceof Certificate)) continue;
            jsCerts[i] = (Certificate)fromJS[i];
            issuers[i] = jsCerts[i].getDEREncoding();
        }
        this.certificateSpecifier.issuer = issuers;
    }

    public Object getKeyUsage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] certspeckeyUsage = this.certificateSpecifier.keyUsage;
        if (certspeckeyUsage != null && certspeckeyUsage.length > 0) {
            StringBuilder keyUsage = new StringBuilder();
            for (int i = 0; i < certspeckeyUsage.length; ++i) {
                keyUsage.append(certspeckeyUsage[i]);
            }
            return keyUsage.toString();
        }
        return Undefined.instance;
    }

    public void setKeyUsage(Object keyUsage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String[] jsKeyUsage = new String[String.valueOf(keyUsage).length()];
        this.certificateSpecifier.keyUsage = this.changeToStringArray(String.valueOf(keyUsage), jsKeyUsage);
    }

    public Object getOid() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] certspecoId = this.certificateSpecifier.oid;
        ArrayList<String> valList = new ArrayList<String>();
        Scriptable scope = this.getParentScope();
        if (certspecoId != null) {
            valList.addAll(Arrays.asList(certspecoId));
            Scriptable array = Context.getCurrentContext().newArray(scope, valList.toArray());
            return new Delegator(array){

                @Override
                public void put(int index, Scriptable start, Object value) {
                    ((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.oid = Util.processDelegator(((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.oid, index, value);
                }
            };
        }
        return Undefined.instance;
    }

    public void setOid(Object id) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.certificateSpecifier.oid = Util.inputValidation(id);
    }

    public Object getSubject() {
        byte[][] subjects = this.certificateSpecifier.subject;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        if (subjects != null && subjects.length > 0) {
            Scriptable scope = this.getParentScope();
            for (int i = 0; i < subjects.length; ++i) {
                Certificate cert = (Certificate)ESObject.create(this.getParentScope(), true, "Certificate", false, null);
                cert.setCertificate(subjects[i]);
                certificates.add(cert);
            }
            Scriptable array = Context.getCurrentContext().newArray(scope, certificates.toArray());
            return new Delegator(array){

                @Override
                public void put(int index, Scriptable start, Object value) {
                    ((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.subject = CertificateSpecifier.this.processDelegator(((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.subject, index, value);
                }
            };
        }
        return Undefined.instance;
    }

    public void setSubject(Object subject) {
        Object[] fromJS = Context.getCurrentContext().getElements((Scriptable)subject);
        Certificate[] jsCerts = new Certificate[fromJS.length];
        byte[][] subjects = new byte[jsCerts.length][];
        for (int i = 0; i < fromJS.length; ++i) {
            if (!(fromJS[i] instanceof Certificate)) continue;
            jsCerts[i] = (Certificate)fromJS[i];
            subjects[i] = jsCerts[i].getDEREncoding();
        }
        this.certificateSpecifier.subject = subjects;
    }

    public Object getSubjectDN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<Map<String, String>> actualSubjectDN = this.certificateSpecifier.subjectDN;
        ArrayList<RDN> rdnLists = new ArrayList<RDN>();
        if (actualSubjectDN != null && !actualSubjectDN.isEmpty()) {
            Iterator<Map<String, String>> subjectDNIterator = actualSubjectDN.iterator();
            Scriptable scope = this.getParentScope();
            while (subjectDNIterator.hasNext()) {
                Map<String, String> sdnMap = subjectDNIterator.next();
                RDN rdn = (RDN)ESObject.create(this.getParentScope(), true, "RDN", false, null);
                rdn.setRDNMap(sdnMap);
                rdnLists.add(rdn);
            }
            Scriptable array = Context.getCurrentContext().newArray(scope, rdnLists.toArray());
            return new Delegator(array){

                @Override
                public void put(int index, Scriptable start, Object value) {
                    if (value instanceof RDN) {
                        RDN rdn = (RDN)value;
                        Map<String, String> rdnMap = rdn.getRDNMap();
                        List<Map<String, String>> subjectDNList = ((CertificateSpecifier)CertificateSpecifier.this).certificateSpecifier.subjectDN;
                        if (subjectDNList != null) {
                            subjectDNList.add(index, rdnMap);
                        }
                    }
                }
            };
        }
        return Undefined.instance;
    }

    public void setSubjectDN(Object subjectDN) {
        if (subjectDN == null) {
            return;
        }
        Object[] fromJS = Context.getCurrentContext().getElements((Scriptable)subjectDN);
        RDN[] rdn = new RDN[fromJS.length];
        Map<String, String> rdnMap = null;
        for (int i = 0; i < fromJS.length; ++i) {
            if (!(fromJS[i] instanceof RDN)) continue;
            rdn[i] = (RDN)fromJS[i];
            rdnMap = rdn[i].getRDNMap();
            this.certificateSpecifier.subjectDN.add(rdnMap);
        }
    }

    public Object getUrl() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String url = this.certificateSpecifier.url;
        if (url != null) {
            return url;
        }
        return Undefined.instance;
    }

    public void setUrl(Object url) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.certificateSpecifier.url = String.valueOf(url);
    }

    public Object getUrlType() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName urlType = this.certificateSpecifier.urlType;
        if (urlType != null) {
            return urlType.asString();
        }
        return Undefined.instance;
    }

    public void setUrlType(Object urlType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.certificateSpecifier.urlType = ASName.create(String.valueOf(urlType));
    }

    private String[] changeToStringArray(String inputString, String[] outputStrings) {
        StringBuilder stringBuilder = new StringBuilder(inputString);
        for (int i = 0; i < inputString.length(); ++i) {
            outputStrings[i] = stringBuilder.substring(i, i + 1);
        }
        return outputStrings;
    }

    void setCurrentCertificateSeedValue(JSStateListener.SeedValueCache.CertificateSpecifierCache certificateSpecifier) {
        this.certificateSpecifier = certificateSpecifier;
    }

    JSStateListener.SeedValueCache.CertificateSpecifierCache getCertificateSpecifier() {
        return this.certificateSpecifier;
    }

    private byte[][] processDelegator(byte[][] input, int index, Object value) {
        if (input != null) {
            Certificate certificate = null;
            if (value instanceof Certificate) {
                certificate = (Certificate)value;
                if (index >= input.length) {
                    byte[][] inputArray = new byte[index + 1][];
                    System.arraycopy(input, 0, inputArray, 0, input.length);
                    inputArray[index] = certificate.getDEREncoding();
                    return inputArray;
                }
                input[index] = certificate.getDEREncoding();
                return input;
            }
        }
        return null;
    }
}

