/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import java.util.ArrayList;

public final class FDFIconFit
extends PDFCosDictionary {
    public static final ASName k_SW = ASName.create("SW");
    public static final ASName k_FB = ASName.create("FB");

    private FDFIconFit(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFIconFit getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        FDFIconFit pdfObject = (FDFIconFit)PDFCosObject.getCachedInstance(cosObject, FDFIconFit.class);
        if (pdfObject == null) {
            pdfObject = new FDFIconFit(cosObject);
        }
        return pdfObject;
    }

    public ASName getScaleCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(k_SW);
    }

    public void setScaleCondition(ASName condition) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_SW, condition);
    }

    public ASName getScaleType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    public void setScaleType(ASName type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, type);
    }

    public ArrayList<Object> getScalePosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_A).getValue();
    }

    public void setScalePosition(ArrayList<? extends Object> pos) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_A, pos);
    }

    public boolean getScaleFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_FB);
    }

    public void setScaleFit(boolean type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_FB, type);
    }
}

