/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.DispatchItem;
import com.adobe.internal.pdftoolkit.core.traverser.Dispatcher;
import com.adobe.internal.pdftoolkit.core.traverser.Traverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalBaseWarning;
import com.adobe.internal.pdftoolkit.services.digsig.impl.LegalWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class LegalBaseDispatch
implements Dispatcher {
    protected Map<ASName, Object> dispatchKeyMap;
    protected Map<ASName, Object> dispatchValueMap;
    protected Map<LegalBaseWarning, Integer> warnings;
    protected static final ASName k_identityKey = ASName.create("Identity");
    protected static final ASName k_defaultKey = ASName.create("Default");
    protected static final ASName k_NoneKey = ASName.create("None");

    public LegalBaseDispatch(Map<LegalBaseWarning, Integer> legalWarnings) {
        this.warnings = legalWarnings;
        this.dispatchKeyMap = new HashMap<ASName, Object>();
        this.dispatchKeyMap.put(ASName.k_Alternates, new DispatchAlternates());
        this.dispatchKeyMap.put(ASName.k_OPI, new DispatchOPI());
        this.dispatchValueMap = new HashMap<ASName, Object>();
        this.dispatchValueMap.put(ASName.k_JavaScript, new DispatchJavaScriptAction());
        this.dispatchValueMap.put(ASName.k_Launch, new DispatchLaunchAction());
        this.dispatchValueMap.put(ASName.k_URI, new DispatchURIAction());
        this.dispatchValueMap.put(ASName.k_GoToR, new DispatchGoToRAction());
        this.dispatchValueMap.put(ASName.k_Rendition, new DispatchRenditionAction());
    }

    @Override
    public boolean isCandidate(ASName containerKey, CosObject containerItem) {
        return this.dispatchKeyMap.containsKey(containerKey) || containerItem.getType() == 3 && this.dispatchValueMap.containsKey(containerItem.nameValue());
    }

    @Override
    public boolean dispatchObject(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        Object dispatch;
        ASName objKey = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainerKey();
        if (this.dispatchKeyMap.containsKey(objKey)) {
            dispatch = this.dispatchKeyMap.get(objKey);
        } else if (obj.getType() == 3 && this.dispatchValueMap.containsKey(obj.nameValue())) {
            dispatch = this.dispatchValueMap.get(obj.nameValue());
        } else {
            return this.badReturn();
        }
        if (dispatch instanceof DispatchItem) {
            DispatchItem dispatchItem = (DispatchItem)dispatch;
            if (dispatchItem.verifyIdentity(objKey, obj, curStack)) {
                return dispatchItem.visit(obj, curStack);
            }
            return true;
        }
        if (dispatch instanceof ArrayList) {
            ArrayList dispatchArray = (ArrayList)dispatch;
            Iterator dispatchIterator = dispatchArray.iterator();
            boolean visitOK = true;
            while (dispatchIterator.hasNext() && visitOK) {
                DispatchItem dispatchItem = (DispatchItem)dispatchIterator.next();
                if (!dispatchItem.verifyIdentity(objKey, obj, curStack)) continue;
                visitOK = dispatchItem.visit(obj, curStack);
            }
            return visitOK;
        }
        return true;
    }

    public void incrementCounter(LegalBaseWarning key) {
        int counter = 0;
        if (this.warnings.containsKey(key)) {
            counter = this.warnings.get(key);
        }
        this.warnings.put(key, ++counter);
    }

    protected ASName safeGetName(CosDictionary dict, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosName) {
            return ((CosName)obj).nameValue();
        }
        return null;
    }

    protected CosArray safeGetArray(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosArray) {
            return (CosArray)obj;
        }
        return null;
    }

    protected CosDictionary safeGetDict(CosDictionary dict, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosDictionary) {
            return (CosDictionary)obj;
        }
        return null;
    }

    protected CosDictionary safeGetStream(CosDictionary dict, ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosStream) {
            return (CosStream)obj;
        }
        return null;
    }

    private boolean badReturn() {
        return false;
    }

    class DispatchSoundAction
    extends DispatchAction
    implements DispatchItem {
        DispatchSoundAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer soundAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (soundAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_SoundActions);
            }
            return true;
        }
    }

    class DispatchMovieAction
    extends DispatchAction
    implements DispatchItem {
        DispatchMovieAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer movieAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (movieAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_MovieActions);
            }
            return true;
        }
    }

    private class DispatchRenditionAction
    extends DispatchAction
    implements DispatchItem {
        private DispatchRenditionAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer renditionAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (renditionAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalWarning.k_RenditionAction);
            }
            return true;
        }
    }

    class DispatchGoToRAction
    extends DispatchAction
    implements DispatchItem {
        DispatchGoToRAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer goToRAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (goToRAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_GoToRActions);
            }
            return true;
        }
    }

    class DispatchURIAction
    extends DispatchAction
    implements DispatchItem {
        DispatchURIAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer uriAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (uriAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_URIActions);
            }
            return true;
        }
    }

    class DispatchLaunchAction
    extends DispatchAction
    implements DispatchItem {
        DispatchLaunchAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer launchAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (launchAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_LaunchActions);
            }
            return true;
        }
    }

    class DispatchJavaScriptAction
    extends DispatchAction
    implements DispatchItem {
        DispatchJavaScriptAction() {
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer javaScriptAction = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            if (javaScriptAction != null) {
                LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_JavaScriptActions);
            }
            return true;
        }
    }

    abstract class DispatchAction
    implements DispatchItem {
        DispatchAction() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) {
            return objKey == ASName.k_S;
        }
    }

    abstract class DispatchAnnotArray
    implements DispatchItem {
        DispatchAnnotArray() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer objContainer = null;
            ASName pdfType = null;
            if (!curStack.isEmpty()) {
                objContainer = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
                pdfType = LegalBaseDispatch.this.safeGetName((CosDictionary)objContainer, ASName.k_Type);
            }
            return pdfType == ASName.k_Page;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            PDFAnnotationList annotList = PDFAnnotationList.getInstance(obj);
            PDFAnnotationIterator annotsIter = annotList.iterator();
            boolean visitOK = true;
            while (annotsIter.hasNext() && visitOK) {
                PDFAnnotation annot = annotsIter.next();
                if (annot == null) continue;
                visitOK = this.visitAnnotation(annot, curStack);
            }
            return visitOK;
        }

        abstract boolean visitAnnotation(PDFAnnotation var1, ArrayList<?> var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;
    }

    abstract class DispatchExtGState
    implements DispatchItem {
        DispatchExtGState() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return true;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            List<ASName> extGStateKeys = ((CosDictionary)obj).getKeys();
            Iterator<ASName> extGStateIter = extGStateKeys.iterator();
            ASName extGStateKey = null;
            CosObject extGState = null;
            boolean visitOK = true;
            while (extGStateIter.hasNext() && visitOK) {
                extGStateKey = extGStateIter.next();
                extGState = ((CosDictionary)obj).get(extGStateKey);
                if (extGState == null) continue;
                visitOK = this.visitExtGState(extGState, curStack);
            }
            if (!visitOK) {
                visitOK = this.visitExtGState(obj, curStack);
            }
            return visitOK;
        }

        abstract boolean visitExtGState(CosObject var1, ArrayList<?> var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;
    }

    class DispatchOPI
    implements DispatchItem {
        DispatchOPI() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer objContainer = null;
            ASName pdfSubType = null;
            if (!curStack.isEmpty()) {
                objContainer = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
                pdfSubType = LegalBaseDispatch.this.safeGetName((CosDictionary)objContainer, ASName.k_Subtype);
            }
            return pdfSubType == ASName.k_Form || pdfSubType == ASName.k_Image;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            LegalBaseDispatch.this.incrementCounter(LegalBaseWarning.k_ExternalOPIdicts);
            return true;
        }
    }

    class DispatchAlternates
    implements DispatchItem {
        DispatchAlternates() {
        }

        @Override
        public boolean verifyIdentity(ASName objKey, CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosContainer xobjImage = ((Traverser.TraverserStackItem)curStack.get(curStack.size() - 1)).getContainer();
            ASName xobjSubtype = LegalBaseDispatch.this.safeGetName((CosDictionary)xobjImage, ASName.k_Subtype);
            return xobjSubtype == ASName.k_Image;
        }

        @Override
        public boolean visit(CosObject obj, ArrayList<?> curStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            int alternateImagesArrayLength = ((CosArray)obj).size();
            int counter = 0;
            if (LegalBaseDispatch.this.warnings.containsKey(LegalBaseWarning.k_AlternateImages)) {
                counter = LegalBaseDispatch.this.warnings.get(LegalBaseWarning.k_AlternateImages);
            }
            LegalBaseDispatch.this.warnings.put(LegalBaseWarning.k_AlternateImages, counter += alternateImagesArrayLength);
            return true;
        }
    }
}

