/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.pdf.digsig.PDFAppBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.services.digsig.ObjectDigestMode;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceOptions;
import com.adobe.internal.pdftoolkit.services.digsig.UserInfo;
import com.adobe.internal.pdftoolkit.services.digsig.XFAChangeLogger;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzer;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DefaultDocModAnalyzer;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import com.adobe.internal.pdftoolkit.services.digsig.spi.XFASnapshotInterface;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import java.util.EnumSet;

public class SignatureOptions {
    private PDFSignatureSubFilter subFilter = null;
    private UserInfo userInfo;
    private PDFSaveOptions saveOptions;
    private SignatureAppearanceOptions appearanceOptions = SignatureAppearanceOptions.newInstance();
    private String digestMethod;
    private ObjectDigestMode odMode = ObjectDigestMode.Dummy;
    private String encryptionAlgorithm;
    private String signatureAlgorithm;
    private TimeStampProvider tsProvider;
    private RevocationInfoProvider revInfoProvider;
    private PDFAppBuildData appBuildData;
    private SignatureServiceProvider signatureServiceProvider;
    private boolean a9Validation = true;
    private XFAChangeLogger xfaChangeLogger = new XFAChangeLogger();
    private boolean recordXFAChanges;
    private boolean lockDocument = false;
    private DocModAnalyzer mDocModAnalyzer;
    protected EnumSet<XFAProcessingOptions.SigningEvent> signingEventsList = EnumSet.allOf(XFAProcessingOptions.SigningEvent.class);
    private XFASnapshotInterface snapshotGenerator = null;
    private boolean snapshotGenerationEnabled = true;
    private SigningUtils.SigningType signingType = null;

    protected SignatureOptions() {
    }

    public static SignatureOptions newInstance() {
        return new SignatureOptions();
    }

    public boolean getSnapshotGenerationEnabled() {
        return this.snapshotGenerationEnabled;
    }

    public void setSnapshotGenerationEnabled(boolean snapshotGenerationEnabled) {
        this.snapshotGenerationEnabled = snapshotGenerationEnabled;
    }

    public XFASnapshotInterface getSnapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void setSnapshotGenerator(XFASnapshotInterface snapshotGenerator) {
        this.snapshotGenerator = snapshotGenerator;
    }

    public EnumSet<XFAProcessingOptions.SigningEvent> getSigningEventsList() {
        return this.signingEventsList;
    }

    public void setSigningEventsList(EnumSet<XFAProcessingOptions.SigningEvent> signingEventsList) {
        this.signingEventsList = signingEventsList;
    }

    public PDFSignatureSubFilter getSubFilter() {
        return this.subFilter;
    }

    public void setSubFilter(PDFSignatureSubFilter subFilter) {
        this.subFilter = subFilter;
    }

    public boolean hasUserInfo() {
        return this.userInfo != null;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public boolean hasSaveOptions() {
        return this.saveOptions != null;
    }

    public PDFSaveOptions getSaveOptions() {
        return this.saveOptions;
    }

    public void setSaveOptions(PDFSaveOptions saveOptions) {
        this.saveOptions = saveOptions;
    }

    public boolean hasSignatureAppearanceOptions() {
        return this.appearanceOptions != null;
    }

    public SignatureAppearanceOptions getSignatureAppearanceOptions() {
        return this.appearanceOptions;
    }

    public void setSignatureAppearanceOptions(SignatureAppearanceOptions appearanceOptions) {
        this.appearanceOptions = appearanceOptions == null ? SignatureAppearanceOptions.newInstance() : appearanceOptions;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestToApply) {
        this.digestMethod = digestToApply;
    }

    public boolean hasObjectDigestMode() {
        return this.odMode != null;
    }

    public ObjectDigestMode getObjectDigestMode() {
        return this.odMode;
    }

    public void setObjectDigestMode(ObjectDigestMode mode) {
        this.odMode = mode;
    }

    public String getEncryptionAlgorithm() {
        if (this.encryptionAlgorithm == null) {
            return "RSA";
        }
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public boolean isApplyTimestamp() {
        return this.tsProvider != null;
    }

    public void registerTimeStampProvider(TimeStampProvider timeStampProvider) {
        this.tsProvider = timeStampProvider;
    }

    public TimeStampProvider getTimeStampProvider() {
        return this.tsProvider;
    }

    public boolean embedRevocationInfo() {
        return this.revInfoProvider != null;
    }

    public void registerRevocationInfoProvider(RevocationInfoProvider revInfoProvider) {
        this.revInfoProvider = revInfoProvider;
    }

    public RevocationInfoProvider getRevocationInfoProvider() {
        return this.revInfoProvider;
    }

    public void setAppBuildData(PDFAppBuildData appDict) {
        this.appBuildData = appDict;
    }

    public PDFAppBuildData getAppBuildData() {
        return this.appBuildData;
    }

    public SignatureServiceProvider getSignatureServiceProvider() {
        return this.signatureServiceProvider;
    }

    public void registerSignatureServiceProvider(SignatureServiceProvider cryptoProvider) {
        this.signatureServiceProvider = cryptoProvider;
    }

    public void enableA9Validation() {
        this.a9Validation = true;
    }

    public void disableA9Validation() {
        this.a9Validation = false;
    }

    public boolean useA9Validation() {
        return this.a9Validation;
    }

    public void enableXFAChangeRecording() {
        this.recordXFAChanges = true;
    }

    public void disableXFAChangeRecording() {
        this.recordXFAChanges = false;
    }

    public boolean XFAChangeRecordingEnabled() {
        return this.recordXFAChanges;
    }

    public XFAChangeLogger getXFAChangeLogger() {
        return this.xfaChangeLogger;
    }

    public void setLockDocument(boolean lockDocument) {
        this.lockDocument = lockDocument;
    }

    public boolean isLockDocument() {
        return this.lockDocument;
    }

    public void registerDocModAnalyzer(DocModAnalyzer docModAnalyzer) {
        this.mDocModAnalyzer = docModAnalyzer;
    }

    public DocModAnalyzer getDocModAnalyzer() {
        if (this.mDocModAnalyzer == null) {
            this.mDocModAnalyzer = new DefaultDocModAnalyzer();
        }
        return this.mDocModAnalyzer;
    }

    public void setSigningType(SigningUtils.SigningType signingType) {
        this.signingType = signingType;
    }

    public SigningUtils.SigningType getSigningType() {
        return this.signingType;
    }
}

