/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVPDict;

public class PDF3DMeasurementRD3
extends PDF3DMeasurement {
    public static final ASName k_RD3 = ASName.create("RD3");
    public static final ASName k_AP = ASName.create("AP");
    public static final ASName k_A1 = ASName.create("A1");
    public static final ASName k_A2 = ASName.create("A2");
    public static final ASName k_N2 = ASName.create("N2");
    public static final ASName k_A3 = ASName.create("A3");
    public static final ASName k_A4 = ASName.create("A4");
    public static final ASName k_TP = ASName.create("TP");
    public static final ASName k_TX = ASName.create("TX");
    public static final ASName k_TY = ASName.create("TY");
    public static final ASName k_TS = ASName.create("TS");
    public static final ASName k_C = ASName.create("C");
    public static final ASName k_V = ASName.create("V");
    public static final ASName k_P = ASName.create("P");
    public static final ASName k_UT = ASName.create("UT");
    public static final ASName k_EL = ASName.create("EL");
    public static final ASName k_U = ASName.create("U");
    public static final ASName k_S = ASName.create("S");
    public static final ASName k_SC = ASName.create("SC");
    public static final ASName k_R = ASName.create("R");

    PDF3DMeasurementRD3(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DMeasurementRD3 newInstance(PDFDocument pdfDocument, double[] ap, double[] a1, double[] a2, double[] tp, double[] tx, double[] ty, double v) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDF3DMeasurementRD3 pdfObject = new PDF3DMeasurementRD3(cosObject);
        try {
            pdfObject.setSubtype(k_RD3);
        }
        catch (PDFInvalidParameterException pDFInvalidParameterException) {
            // empty catch block
        }
        pdfObject.setAP(ap);
        pdfObject.setA1(a1);
        pdfObject.setA2(a2);
        pdfObject.setTP(tp);
        pdfObject.setTX(tx);
        pdfObject.setTY(ty);
        pdfObject.setV(v);
        return pdfObject;
    }

    public static PDF3DMeasurementRD3 newInstance(PDFDocument pdfDocument, double[] ap, double[] a1, double[] a2, double[] a3, double[] a4, double[] tp, double[] tx, double[] ty, double v) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDF3DMeasurementRD3 pdfObject = PDF3DMeasurementRD3.newInstance(pdfDocument, ap, a1, a2, tp, tx, ty, v);
        pdfObject.setA3(a3);
        pdfObject.setA4(a4);
        return pdfObject;
    }

    public static PDF3DMeasurementRD3 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DMeasurementRD3 pdfObject = (PDF3DMeasurementRD3)PDFCosObject.getCachedInstance(cosObject, PDF3DMeasurementRD3.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DMeasurementRD3(cosObject);
        }
        return pdfObject;
    }

    public double[] getAP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_AP);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setAP(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("AP is a required key.");
        }
        this.setDictionaryArrayValue(k_AP, value);
    }

    public boolean hasAP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_AP);
    }

    public double[] getA1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(k_A1);
        if (cosObject != null) {
            return cosObject.getArrayDouble();
        }
        return null;
    }

    public void setA1(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("A1 is a required key.");
        }
        this.setDictionaryArrayValue(k_A1, value);
    }

    public boolean hasA1() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A1);
    }

    public double[] getA2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_A2);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setA2(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("A2 is a required key.");
        }
        this.setDictionaryArrayValue(k_A2, value);
    }

    public boolean hasA2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A2);
    }

    public double[] getA3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_A3);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setA3(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("A3 is a required key.");
        }
        this.setDictionaryArrayValue(k_A3, value);
    }

    public boolean hasA3() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A3);
    }

    public double[] getA4() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_A4);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setA4(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(k_A4, value);
    }

    public boolean hasA4() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_A4);
    }

    public PDFText getN2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_N2));
    }

    public void setN2(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryTextValue(k_N2, value);
    }

    public boolean hasN2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_N2);
    }

    public double[] getTP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_TP);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setTP(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TP is a required key.");
        }
        this.setDictionaryArrayValue(k_TP, value);
    }

    public boolean hasTP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TP);
    }

    public double[] getTX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_TX);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setTX(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TX is a required key.");
        }
        this.setDictionaryArrayValue(k_TX, value);
    }

    public boolean hasTX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TX);
    }

    public double[] getTY() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_TY);
        if (cosObject instanceof CosArray) {
            return ((CosArray)cosObject).getArrayDouble();
        }
        return null;
    }

    public void setTY(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            throw new PDFInvalidDocumentException("TY is a required key.");
        }
        this.setDictionaryArrayValue(k_TY, value);
    }

    public boolean hasTY() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TY);
    }

    public double getTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_TS);
    }

    public void setTS(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_TS, value);
    }

    public boolean hasTS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_TS);
    }

    public double[] getC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = this.getDictionaryArrayValue(ASName.k_C);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getArrayDouble(1, 3);
    }

    public void setC(double[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(k_C);
        } else {
            CosArray array = this.setDictionaryArrayValue(k_C, 1, value);
            array.setName(0, ASName.k_DeviceRGB);
        }
    }

    public boolean hasC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_C);
    }

    public double getV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_V);
    }

    public void setV(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_V, value);
    }

    public boolean hasV() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_V);
    }

    public boolean getSC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_SC);
    }

    public void setSC(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_SC, value);
    }

    public boolean hasSC() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_SC);
    }

    public boolean getR() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_R);
    }

    public void setR(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_R, value);
    }

    public boolean hasR() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_R);
    }

    public int getP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(k_P);
    }

    public void setP(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_P, value);
    }

    public boolean hasP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_P);
    }

    public double getEL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(k_EL);
    }

    public void setEL(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(k_EL, value);
    }

    public boolean hasEL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_EL);
    }

    public PDFText getUT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_UT));
    }

    public void setUT(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryTextValue(k_UT, value);
    }

    public boolean hasUT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_UT);
    }

    public PDF3DVPDict getS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DVPDict.getInstance(this.getDictionaryCosObjectValue(k_S));
    }

    public void setS(CosDictionary cosDictionary) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_S, cosDictionary);
    }

    public boolean hasS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_S);
    }

    public PDFText getU() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_U));
    }

    public void setU(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryTextValue(k_U, value);
    }

    public boolean hasU() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_U);
    }
}

