/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.documentparts;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPart;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPartNode;

public class PDFDPartRoot
extends PDFDPartNode {
    protected PDFDPartRoot(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDPartRoot newInstance(PDFDocument pdfDocument, PDFDPart pdfDPartRootNode, ASName[] nodeNameList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfDPartRootNode == null) {
            throw new PDFInvalidParameterException("An indirect reference to the DPart dictionary is required when creating newInstance of PDFDPartRoot.");
        }
        if (nodeNameList == null) {
            throw new PDFInvalidParameterException("nodeNameList is required when creating newInstance of PDFDPartRoot.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFDPartRoot pdfObject = new PDFDPartRoot(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_DPartRoot);
        pdfObject.setDPartRootNode(pdfDPartRootNode);
        pdfObject.setNodeNameList(nodeNameList);
        return pdfObject;
    }

    public static PDFDPartRoot getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDPartRoot pdfObject = (PDFDPartRoot)PDFCosObject.getCachedInstance(cosObject, PDFDPartRoot.class);
        if (pdfObject == null) {
            pdfObject = new PDFDPartRoot(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public PDFDPart getDPartRootNode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDPart.getInstance(this.getDictionaryDictionaryValue(ASName.k_DPartRootNode));
    }

    public void setDPartRootNode(PDFDPart pdfDPartRootNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfDPartRootNode == null) {
            throw new PDFInvalidParameterException("PDFDPartRootNode is required entry of PDFDPartRoot.");
        }
        this.setDictionaryValue(ASName.k_DPartRootNode, pdfDPartRootNode);
    }

    public Integer getRecordLevel() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_RecordLevel);
    }

    public void setRecordLevel(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_RecordLevel);
        } else {
            this.setDictionaryIntValue(ASName.k_RecordLevel, value.intValue());
        }
    }

    public ASName[] getNodeNameList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_NodeNameList).getArrayName();
    }

    public void setNodeNameList(ASName[] names) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (names == null) {
            throw new PDFInvalidParameterException("nodeNameList is required entry of PDFDPartRoot.");
        }
        this.setDictionaryArrayValue(ASName.k_NodeNameList, 0, names);
    }
}

