/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithQuadPoints;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;

public class PDFAnnotationRedaction
extends PDFAnnotationMarkup
implements PDFAnnotationWithQuadPoints {
    public static final ASName k_OVERLAYTEXT = ASName.create("OverlayText");
    public static final ASName k_RA = ASName.create("RA");
    public static final ASName k_REPEAT = ASName.create("Repeat");
    public static final ASName k_RO = ASName.create("RO");

    private PDFAnnotationRedaction(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationRedaction getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationRedaction pdfObject = (PDFAnnotationRedaction)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationRedaction.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationRedaction(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationRedaction(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Redact);
    }

    public static PDFAnnotationRedaction newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationRedaction(pdfDocument);
    }

    @Override
    public boolean hasQuadPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_QuadPoints);
    }

    @Override
    public double[] getQuadPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosQuadPoints = this.getDictionaryArrayValue(ASName.k_QuadPoints);
        if (cosQuadPoints == null) {
            return null;
        }
        return cosQuadPoints.getArrayDouble();
    }

    @Override
    public void setQuadPoints(double[] quadPoints) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (quadPoints == null) {
            this.removeValue(ASName.k_QuadPoints);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < quadPoints.length; ++i) {
                cosArray.addDouble(quadPoints[i]);
            }
            this.setDictionaryArrayValue(ASName.k_QuadPoints, cosArray);
        }
    }

    @Override
    public void setQuadPoints(String points, String separator) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_QuadPoints, PDFUtil.parseNumbers(points, separator));
    }

    @Override
    public void transformQuadPoints(ASMatrix matrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasQuadPoints()) {
            double[] quadPoints = this.getQuadPoints();
            double[] newQuagPoints = new double[quadPoints.length];
            for (int i = 0; i < quadPoints.length; i += 2) {
                ASCoordinate point = new ASCoordinate(quadPoints[i], quadPoints[i + 1]);
                ASCoordinate newPoint = point.transform(matrix);
                newQuagPoints[i] = newPoint.x();
                newQuagPoints[i + 1] = newPoint.y();
            }
            this.setQuadPoints(newQuagPoints);
        }
    }

    public boolean hasInteriorColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_IC);
    }

    public double[] getInteriorColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosColor = this.getDictionaryArrayValue(ASName.k_IC);
        if (cosColor == null) {
            return null;
        }
        return cosColor.getArrayDouble();
    }

    public void setInteriorColor(double red, double green, double blue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosColor = PDFCosObject.newCosArray(this.getPDFDocument());
        cosColor.addDouble(red);
        cosColor.addDouble(green);
        cosColor.addDouble(blue);
        this.setDictionaryArrayValue(ASName.k_IC, cosColor);
    }

    public boolean hasOverlayText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_OVERLAYTEXT);
    }

    public String getOverlayText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringOrStreamValue(k_OVERLAYTEXT);
    }

    public void setOverlayText(String text) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringOrStreamValue(k_OVERLAYTEXT, text);
    }

    public boolean hasRepeat() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_REPEAT);
    }

    public boolean getRepeat() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_REPEAT);
    }

    public void setRepeat(boolean repeat) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_REPEAT, repeat);
    }

    public boolean hasDA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_DA);
    }

    public String getDA() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString asStr = this.getDictionaryStringValue(ASName.k_DA);
        return asStr != null ? asStr.asString() : null;
    }

    public void setDA(String text) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DA, text);
    }

    public void setDA(String text, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_DA, text, unicode);
    }

    public boolean hasRO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_RO);
    }

    public PDFXObjectForm getRO() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFXObjectForm.getInstance(this.getCosDictionary().get(k_RO));
    }

    public void setRO(PDFXObjectForm overlayAppearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_RO, overlayAppearance);
    }

    public boolean hasJustification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Q);
    }

    public int getJustification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Q);
    }

    public void setJustification(int justification) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Q, justification);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.transformQuadPoints(matrix);
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }

    private PDFRectangle getRedactionBBoxForQuadPoint(double[] quadPoint) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double maxY;
        double maxX;
        double minX = maxX = quadPoint[0];
        double minY = maxY = quadPoint[1];
        for (int i = 2; i < quadPoint.length; i += 2) {
            if (quadPoint[i] > maxX) {
                maxX = quadPoint[i];
            } else if (quadPoint[i] < minX) {
                minX = quadPoint[i];
            }
            if (quadPoint[i + 1] > maxY) {
                maxY = quadPoint[i + 1];
                continue;
            }
            if (!(quadPoint[i + 1] < minY)) continue;
            minY = quadPoint[i + 1];
        }
        return PDFRectangle.newInstance(this.getPDFDocument(), minX, minY, maxX, maxY);
    }

    public PDFRectangle getRedactionAreaBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] quadPoints;
        PDFRectangle rectangle = null;
        if (this.hasQuadPoints() && (quadPoints = this.getQuadPoints()) != null && quadPoints.length > 0 && quadPoints.length % 8 == 0) {
            rectangle = this.getRedactionBBoxForQuadPoint(this.getQuadPoints());
        }
        if (rectangle == null) {
            rectangle = this.getRect();
        }
        return rectangle;
    }

    @Override
    public void applyRotation(PDFRectangle cropBox, int rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (rotationAngle == 0) {
            rotationAngle = this.getRotation();
        }
        double height = cropBox.height();
        double width = cropBox.width();
        double[] transformedRect = null;
        double[] transformedPopupRect = null;
        double[] transformedQuadPoints = null;
        PDFAnnotationPopup popup = this.getPopup();
        transformedRect = PDFAnnotationUtils.transfromRectangle(this.getRect().getValues(), width, height, rotationAngle);
        transformedQuadPoints = PDFAnnotationUtils.transfromRectangle(this.getQuadPoints(), width, height, rotationAngle);
        if (popup != null) {
            transformedPopupRect = PDFAnnotationUtils.transfromRectangle(this.getPopup().getRect().getValues(), width, height, rotationAngle);
        }
        this.setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedRect[0], transformedRect[1], transformedRect[2], transformedRect[3]));
        this.setQuadPoints(transformedQuadPoints);
        if (popup != null) {
            this.getPopup().setRect(PDFRectangle.newInstance(this.getPDFDocument(), transformedPopupRect[0], transformedPopupRect[1], transformedPopupRect[2], transformedPopupRect[3]));
        }
    }
}

