/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;

public class PDFAdditionalActionsDocument
extends PDFAdditionalActions {
    static final ASName k_WC = ASName.create("WC");
    static final ASName k_WS = ASName.create("WS");
    static final ASName k_DS = ASName.create("DS");
    static final ASName k_WP = ASName.create("WP");
    static final ASName k_DP = ASName.create("DP");

    private PDFAdditionalActionsDocument(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFAdditionalActionsDocument(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFAdditionalActionsDocument getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAdditionalActionsDocument pdfObject = (PDFAdditionalActionsDocument)PDFCosObject.getCachedInstance(cosObject, PDFAdditionalActionsDocument.class);
        if (pdfObject == null) {
            pdfObject = new PDFAdditionalActionsDocument(cosObject);
        }
        return pdfObject;
    }

    public static PDFAdditionalActionsDocument newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAdditionalActionsDocument(pdfDocument);
    }

    @Override
    protected PDFAction itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(cosObject);
    }

    public PDFAction getActionOnClosing() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_WC));
    }

    public void setActionOnClosing(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_WC, action);
    }

    public PDFAction getActionOnSaving() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_WS));
    }

    public void setActionOnSaving(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_WS, action);
    }

    public PDFAction getActionAfterSaving() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_DS));
    }

    public void setActionAfterSaving(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_DS, action);
    }

    public PDFAction getActionOnPrinting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_WP));
    }

    public void setActionOnPrinting(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_WP, action);
    }

    public PDFAction getActionAfterPrinting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        return PDFActionFactory.getInstance(this.getDictionaryDictionaryValue(k_DP));
    }

    public void setActionAfterPrinting(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_DP, action);
    }
}

