/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;

public class PDFActionNoOp
extends PDFAction {
    private PDFActionNoOp(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    private PDFActionNoOp(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.create("no-op"));
    }

    public static PDFActionNoOp getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionNoOp pdfObject = (PDFActionNoOp)PDFCosObject.getCachedInstance(cosObject, PDFActionNoOp.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionNoOp(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionNoOp newInstance(PDFDocument pdfDocument) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new PDFActionNoOp(pdfDocument);
    }
}

