/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.action;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;

public class PDFActionGoToRemote
extends PDFAction {
    protected PDFActionGoToRemote(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFActionGoToRemote(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
    }

    private PDFActionGoToRemote(PDFDocument pdfDocument, PDFDestination pdfDestination, PDFFileSpecification pdfFileSpecification) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDocument);
        this.setSubtype(ASName.k_GoToR);
        this.setDestination(pdfDestination);
        this.setFileSpecification(pdfFileSpecification);
    }

    public static PDFActionGoToRemote getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFActionGoToRemote pdfObject = (PDFActionGoToRemote)PDFCosObject.getCachedInstance(cosObject, PDFActionGoToRemote.class);
        if (pdfObject == null) {
            pdfObject = new PDFActionGoToRemote(cosObject);
        }
        return pdfObject;
    }

    public static PDFActionGoToRemote newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosActionGoTo = PDFCosObject.newCosDictionary(pdfDocument);
        cosActionGoTo.put(ASName.k_Type, ASName.k_Action);
        cosActionGoTo.put(ASName.k_S, ASName.k_GoToR);
        return new PDFActionGoToRemote(cosActionGoTo);
    }

    public static PDFActionGoToRemote newInstance(PDFDocument pdfDocument, PDFDestination pdfDestination, PDFFileSpecification pdfFileSpecification) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFActionGoToRemote(pdfDocument, pdfDestination, pdfFileSpecification);
    }

    public boolean hasDestination() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_D);
    }

    public PDFDestination getDestination() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFDestination.getInstance(this.getDictionaryCosObjectValue(ASName.k_D));
    }

    public void setDestination(PDFDestination pdfDestination) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_D, pdfDestination);
    }

    public boolean hasFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification pdfFileSpecification) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_F, pdfFileSpecification);
    }

    public boolean hasNewWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_NewWindow);
    }

    public boolean getNewWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(ASName.k_NewWindow);
    }

    public void setNewWindow(boolean newWindow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_NewWindow, newWindow);
    }
}

