/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.types.ASName;

public final class PDFRenderingIntent {
    private final ASName intent;
    public static final PDFRenderingIntent ABSOLUTE_COLORIMETRIC = new PDFRenderingIntent(ASName.k_AbsoluteColorimetric);
    public static final PDFRenderingIntent RELATIVE_COLORIMETRIC = new PDFRenderingIntent(ASName.k_RelativeColorimetric);
    public static final PDFRenderingIntent SATURATION = new PDFRenderingIntent(ASName.k_Saturation);
    public static final PDFRenderingIntent PERCEPTUAL = new PDFRenderingIntent(ASName.k_Perceptual);

    private PDFRenderingIntent(ASName intent) {
        this.intent = intent;
    }

    public String toString() {
        return this.intent.asString(true);
    }

    public ASName getValue() {
        return this.intent;
    }

    public static PDFRenderingIntent getIntentForValue(ASName intentValue) {
        if (intentValue == ASName.k_AbsoluteColorimetric) {
            return ABSOLUTE_COLORIMETRIC;
        }
        if (intentValue == ASName.k_RelativeColorimetric) {
            return RELATIVE_COLORIMETRIC;
        }
        if (intentValue == ASName.k_Saturation) {
            return SATURATION;
        }
        if (intentValue == ASName.k_Perceptual) {
            return PERCEPTUAL;
        }
        return new PDFRenderingIntent(intentValue);
    }
}

