/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.core.util.UTF8Support;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;

public class ASString
extends ASObject
implements Comparable {
    private byte[] bytes;
    private char[] chars;
    private int hash;

    private void init(byte[] bytes) {
        this.bytes = bytes;
        this.hash = ASString.generateHash(bytes, 0, bytes.length);
    }

    public ASString(byte[] bytes) {
        this.init(bytes);
    }

    public ASString(String javaString) {
        this.init(UTF8Support.toUTF8(javaString));
    }

    public ASString(String javaString, CharsetEncoder cse) throws PDFInvalidParameterException {
        ByteBuffer nameBuf = null;
        CharBuffer charBuf = CharBuffer.wrap(javaString.toCharArray());
        try {
            nameBuf = cse.encode(charBuf);
        }
        catch (CharacterCodingException e) {
            throw new PDFInvalidParameterException("cannot encode string", e);
        }
        byte[] trimmedBytes = new byte[nameBuf.limit()];
        nameBuf.get(trimmedBytes, 0, nameBuf.limit());
        this.init(trimmedBytes);
    }

    public ASString(int[] numbers, int bytesToUse, int bytesToPad) throws PDFInvalidParameterException {
        this(ASString.convertIntegersToBytes(numbers, 0, numbers.length - 1, bytesToUse, bytesToPad));
    }

    public ASString(int[] numbers, int startIndex, int endIndex, int bytesToUse, int bytesToPad) throws PDFInvalidParameterException {
        this(ASString.convertIntegersToBytes(numbers, startIndex, endIndex, bytesToUse, bytesToPad));
    }

    protected static byte[] convertIntegersToBytes(int[] numbers, int startIndex, int endIndex, int bytesToUse, int bytesToPad) throws PDFInvalidParameterException {
        if (bytesToUse < 1 || bytesToUse > 4) {
            throw new PDFInvalidParameterException("Bytes to use must be from 1 to 4.");
        }
        int position = 0;
        int length = endIndex - startIndex + 1;
        byte[] bytes = new byte[length * (bytesToUse + bytesToPad)];
        for (int i = startIndex; i <= endIndex; ++i) {
            position = (i - startIndex) * (bytesToPad + bytesToUse) + bytesToPad;
            for (int digit = bytesToUse; digit > 0; --digit) {
                bytes[position++] = (byte)(numbers[i] >>> (digit - 1) * 8 & 0xFF);
            }
        }
        return bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public char[] getChars() {
        if (this.chars == null) {
            this.chars = new char[this.bytes.length / 2];
            for (int i = 0; i < this.chars.length; ++i) {
                this.chars[i] = this.getChar(i * 2);
            }
        }
        return this.chars;
    }

    public char getChar(int index) {
        return (char)(((this.bytes[index] & 0xFF) << 8) + (this.bytes[index + 1] & 0xFF));
    }

    public String asString() {
        return PDFDocEncoding.toAcrobatString(this.bytes);
    }

    public String toString() {
        return this.asString();
    }

    public int compareTo(Object anotherString) {
        if (!(anotherString instanceof ASString)) {
            throw new RuntimeException("Expected ASString");
        }
        byte[] v1 = this.getBytes();
        byte[] v2 = ((ASString)anotherString).getBytes();
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        for (int k = 0; k < n; ++k) {
            if (v1[k] == v2[k]) continue;
            return (v1[k] & 0xFF) - (v2[k] & 0xFF);
        }
        return len1 - len2;
    }

    public boolean equals(ASString anotherString) {
        return this.compareTo(anotherString) == 0;
    }

    public boolean equals(Object anotherString) {
        if (this == anotherString) {
            return true;
        }
        if (anotherString instanceof ASString) {
            return this.compareTo(anotherString) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private static final int generateHash(byte[] b, int start, int length) {
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = hash * 31 + b[i + start];
        }
        return hash;
    }

    public int indexOf(byte[] key) {
        if (this.bytes == null) {
            return -1;
        }
        int[] next = Utility.ComputeKMPNextArray(key);
        return Utility.KMPFindFirst(key, next, this.bytes);
    }

    public int lastIndexOf(int target) {
        for (int byteInd = this.bytes.length - 1; byteInd >= 0; --byteInd) {
            if (this.bytes[byteInd] != target) continue;
            return byteInd;
        }
        return -1;
    }

    public ASString substring(int begin) {
        return this.substring(begin, this.bytes.length);
    }

    public ASString substring(int begin, int end) {
        if (begin < 0) {
            begin = 0;
        }
        if (end > this.bytes.length) {
            end = this.bytes.length;
        }
        if (begin >= end) {
            return null;
        }
        byte[] subStr = new byte[end - begin];
        System.arraycopy(this.bytes, begin, subStr, 0, end - begin);
        return new ASString(subStr);
    }

    public ASString concat(ASString addStr) {
        if (addStr == null || addStr.getBytes().length == 0) {
            return this;
        }
        byte[] addBytes = addStr.getBytes();
        byte[] concatStr = new byte[this.bytes.length + addBytes.length];
        System.arraycopy(this.bytes, 0, concatStr, 0, this.bytes.length);
        System.arraycopy(addBytes, 0, concatStr, this.bytes.length, addBytes.length);
        return new ASString(concatStr);
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(40);
            byte[] outValue = this.getBytes();
            for (int i = 0; i < outValue.length; ++i) {
                byte b = outValue[i];
                if (b == 13 && i + 1 < outValue.length && outValue[i + 1] == 10) {
                    outputByteStream.write(b);
                    ++i;
                    continue;
                }
                if (b == 10) {
                    outputByteStream.write(92);
                    outputByteStream.write(110);
                    continue;
                }
                if (b == 13) {
                    outputByteStream.write(92);
                    outputByteStream.write(114);
                    continue;
                }
                if (b == 40) {
                    outputByteStream.write(92);
                    outputByteStream.write(40);
                    continue;
                }
                if (b == 41) {
                    outputByteStream.write(92);
                    outputByteStream.write(41);
                    continue;
                }
                if (b == 92) {
                    outputByteStream.write(92);
                    outputByteStream.write(92);
                    continue;
                }
                outputByteStream.write(b);
            }
            outputByteStream.write(41);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

