/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ASArray
extends ASObject
implements List<ASObject> {
    private ArrayList<ASObject> list = new ArrayList();

    public String toString() {
        StringBuilder value = new StringBuilder("[ ");
        ASObject valueAtIndex = null;
        for (int i = 0; i < this.list.size(); ++i) {
            valueAtIndex = this.list.get(i);
            if (valueAtIndex != null) {
                value.append(valueAtIndex.toString());
            } else {
                value.append("null");
            }
            value.append(" ");
        }
        value.append("]");
        return value.toString();
    }

    public ASNumber getNumber(int index) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.list.get(index);
        if (obj != null && !(obj instanceof ASNumber)) {
            throw new PDFUnableToCompleteOperationException("ASNumber Expected");
        }
        return (ASNumber)obj;
    }

    public ASBoolean getBoolean(int index) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.list.get(index);
        if (obj != null && !(obj instanceof ASBoolean)) {
            throw new PDFUnableToCompleteOperationException("ASBoolean Expected");
        }
        return (ASBoolean)obj;
    }

    public ASName getName(int index) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.list.get(index);
        if (obj != null && !(obj instanceof ASName)) {
            throw new PDFUnableToCompleteOperationException("ASName Expected");
        }
        return (ASName)obj;
    }

    public ASString getString(int index) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.list.get(index);
        if (obj != null && !(obj instanceof ASString)) {
            throw new PDFUnableToCompleteOperationException("ASString Expected");
        }
        return (ASString)obj;
    }

    public ASArray getArray(int index) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.list.get(index);
        if (obj != null && !(obj instanceof ASArray)) {
            throw new PDFUnableToCompleteOperationException("ASArray Expected");
        }
        return (ASArray)obj;
    }

    public ASDictionary getDictionary(int index) throws PDFUnableToCompleteOperationException {
        ASObject obj = this.list.get(index);
        if (obj != null && !(obj instanceof ASDictionary)) {
            throw new PDFUnableToCompleteOperationException("ASDictionary Expected");
        }
        return (ASDictionary)obj;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public ASObject get(int index) {
        return this.list.get(index);
    }

    @Override
    public ASObject remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public void add(int index, ASObject element) {
        this.list.add(index, element);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public boolean add(ASObject o) {
        return this.list.add(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ASObject> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection<? extends ASObject> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public Iterator<ASObject> iterator() {
        return this.list.iterator();
    }

    @Override
    public List<ASObject> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public ListIterator<ASObject> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<ASObject> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public ASObject set(int index, ASObject element) {
        return this.list.set(index, element);
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(91);
            Iterator<ASObject> iter = this.iterator();
            while (iter.hasNext()) {
                ASObject value = iter.next();
                value.write(outputByteStream);
                if (!iter.hasNext()) continue;
                outputByteStream.write(32);
            }
            outputByteStream.write(93);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

