/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.fontset.impl;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontResolver;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontSearchAttributes;
import com.adobe.fontengine.fontmanagement.postscript.PSNameResolver;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.FallbackFontSet;
import com.adobe.fontengine.inlineformatting.PDF16RichTextFormatter;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontSet;
import com.adobe.fontengine.inlineformatting.css20.CSS20GenericFontFamily;
import com.adobe.fontengine.inlineformatting.css20.FamilyNameNormalizer;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.CoreFontUtils;
import com.adobe.internal.pdftoolkit.core.fontset.impl.FontNameResolver;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class PDFFontSetImpl
implements PDFFontSet {
    private static final long serialVersionUID = 2L;
    private final CSS20FontSet cssFontSet;
    private final PSNameResolver psFontSet;
    private final FallbackFontSet fallbackFontSet;
    private final PlatformFontResolver platformFontSet;
    private boolean ignoreFontLoadingErrors;
    private HashMap<String, Font> resolvedNamesMap = new HashMap();

    public PDFFontSetImpl() throws PDFFontException {
        this(FontResolutionPriority.INTELLIGENT_LAST);
    }

    public PDFFontSetImpl(FontResolutionPriority priority) throws PDFFontException {
        this.fallbackFontSet = new FallbackFontSet();
        this.cssFontSet = PDF16RichTextFormatter.getFontSetInstance();
        this.cssFontSet.setResolutionPriority(priority);
        this.cssFontSet.setFallbackFonts(this.fallbackFontSet);
        this.psFontSet = FontLoader.getPSNameResolverInstance();
        this.psFontSet.setResolutionPriority(priority);
        this.platformFontSet = FontLoader.getPlatformFontResolverInstance(new AcrobatPlatformNameMangler());
        this.platformFontSet.setResolutionPriority(priority);
    }

    public PDFFontSetImpl(PDFFontSetImpl original) throws PDFFontException {
        if (original == null) {
            this.fallbackFontSet = new FallbackFontSet();
            this.cssFontSet = PDF16RichTextFormatter.getFontSetInstance();
            this.cssFontSet.setResolutionPriority(FontResolutionPriority.INTELLIGENT);
            this.cssFontSet.setFallbackFonts(this.fallbackFontSet);
            this.psFontSet = FontLoader.getPSNameResolverInstance();
            this.psFontSet.setResolutionPriority(FontResolutionPriority.INTELLIGENT);
            this.platformFontSet = FontLoader.getPlatformFontResolverInstance(new AcrobatPlatformNameMangler());
            this.platformFontSet.setResolutionPriority(FontResolutionPriority.INTELLIGENT);
        } else {
            this.cssFontSet = PDF16RichTextFormatter.getFontSetInstance(original.cssFontSet);
            this.psFontSet = FontLoader.getPSNameResolverInstance(original.psFontSet);
            this.fallbackFontSet = new FallbackFontSet(original.fallbackFontSet);
            this.platformFontSet = FontLoader.getPlatformFontResolverInstance(original.platformFontSet);
            this.cssFontSet.setFallbackFonts(this.fallbackFontSet);
            this.ignoreFontLoadingErrors = original.ignoreFontLoadingErrors;
            if (!original.resolvedNamesMap.isEmpty()) {
                this.resolvedNamesMap.putAll(original.resolvedNamesMap);
            }
        }
    }

    @Override
    public boolean hasRootFallback() throws PDFFontException {
        Iterator iter = this.getFallbackFontSet().getFallbackFonts(ULocale.ROOT);
        return iter.hasNext();
    }

    @Override
    public void addFont(Font font, Platform platForm, ULocale locale) throws PDFFontException {
        block11: {
            platForm = platForm == null ? Platform.WINDOWS : platForm;
            locale = locale == null ? ULocale.getDefault() : locale;
            try {
                this.cssFontSet.addFont(font);
                this.psFontSet.addFont(font);
                try {
                    this.platformFontSet.addFont(font);
                }
                catch (UnsupportedFontException unsupportedFontException) {
                    // empty catch block
                }
                Set<String> resolvedNames = FontNameResolver.doNameMangling(font, platForm, locale);
                Iterator<String> itr = resolvedNames.iterator();
                while (itr.hasNext()) {
                    this.resolvedNamesMap.put(itr.next(), font);
                }
            }
            catch (UnsupportedCharsetException e) {
                if (!this.ignoreFontLoadingErrors) {
                    throw new PDFFontException("Charset for font is not supported.", e);
                }
            }
            catch (UnsupportedFontException e) {
                if (!this.ignoreFontLoadingErrors) {
                    throw new PDFFontException("Font is not supported.", e);
                }
            }
            catch (InvalidFontException e) {
                if (!this.ignoreFontLoadingErrors) {
                    throw new PDFFontException("The Font is invalid.", e);
                }
            }
            catch (FontLoadingException e) {
                if (this.ignoreFontLoadingErrors) break block11;
                throw new PDFFontException("Problems in loading the font.", e);
            }
        }
    }

    @Override
    public void addFont(Font font, PostscriptFontDescription[] psDescriptions, CSS20FontDescription[] cssDescriptions) throws PDFFontException {
        block9: {
            if (!(psDescriptions != null && psDescriptions.length != 0 && cssDescriptions != null && cssDescriptions.length != 0 || this.ignoreFontLoadingErrors)) {
                throw new PDFFontException("Invalid font descriptions.");
            }
            try {
                int i;
                if (psDescriptions != null) {
                    for (i = 0; i < psDescriptions.length; ++i) {
                        this.psFontSet.addFont(psDescriptions[i], font);
                    }
                }
                if (cssDescriptions != null) {
                    for (i = 0; i < cssDescriptions.length; ++i) {
                        this.cssFontSet.addFont(cssDescriptions[i], font);
                    }
                }
            }
            catch (UnsupportedCharsetException e) {
                if (!this.ignoreFontLoadingErrors) {
                    throw new PDFFontException("Font could not be added to PDFFontSet.", e);
                }
            }
            catch (FontEngineException e) {
                if (this.ignoreFontLoadingErrors) break block9;
                throw new PDFFontException("Font could not be added to PDFFontSet.", e);
            }
        }
    }

    @Override
    public void addFont(Font[] fonts, Platform platForm, ULocale locale) throws PDFFontException {
        for (int i = 0; i < fonts.length; ++i) {
            this.addFont(fonts[i], platForm, locale);
        }
    }

    @Override
    public void addFallbackFont(Locale locale, Font font) throws PDFFontException {
        this.fallbackFontSet.addFallbackFont(ULocale.forLocale(locale), font);
    }

    @Override
    public void addFallbackFont(Locale locale, Font[] fonts) throws PDFFontException {
        for (int i = 0; i < fonts.length; ++i) {
            this.addFallbackFont(locale, fonts[i]);
        }
    }

    @Override
    public void setGenericFontFamilyName(CSS20GenericFontFamily family, String[] replacements) throws PDFFontException {
        this.cssFontSet.setGenericFont(family, replacements);
    }

    public CSS20FontSet getCSS20FontSet() throws PDFFontException {
        return this.cssFontSet;
    }

    public PSNameResolver getPSFontSet() throws PDFFontException {
        return this.psFontSet;
    }

    @Override
    public FallbackFontSet getFallbackFontSet() throws PDFFontException {
        return this.fallbackFontSet;
    }

    public Font getPSFont(PostscriptFontDescription fontDescription, Locale locale, boolean substitute) throws PDFFontException {
        String[] standardFontNames;
        Font font = this.psFontSet.findFont(fontDescription);
        String psName = fontDescription.getPSName();
        if (font == null) {
            PlatformFontSearchAttributes searchAttributes = new PlatformFontSearchAttributes(psName);
            font = this.platformFontSet.findFont(searchAttributes);
        }
        if (font == null) {
            font = this.resolvedNamesMap.get(psName);
        }
        if (substitute && font == null) {
            font = this.getFallbackFont(locale);
        }
        if (font == null && (standardFontNames = CoreFontUtils.getStandardFontNames(ASName.create(psName))) != null) {
            for (int i = 0; i < standardFontNames.length && font == null; ++i) {
                font = this.getPSFontSet().findFont(new PostscriptFontDescription(standardFontNames[i]));
                if (font != null) continue;
                PlatformFontSearchAttributes searchAttributes = new PlatformFontSearchAttributes(standardFontNames[i]);
                font = this.platformFontSet.findFont(searchAttributes);
            }
        }
        return font;
    }

    public Font getFallbackFont(Locale locale) {
        Iterator iter = this.fallbackFontSet.getFallbackFonts(ULocale.forLocale(locale));
        while (iter.hasNext()) {
            Font font = (Font)iter.next();
            if (font == null) continue;
            return font;
        }
        return null;
    }

    public Font getPSFont(String fontName, Locale locale, boolean substitute) throws PDFFontException {
        return this.getPSFont(new PostscriptFontDescription(fontName), locale, substitute);
    }

    public void setResolutionPriority(FontResolutionPriority priority) {
        this.cssFontSet.setResolutionPriority(priority);
        this.psFontSet.setResolutionPriority(priority);
        this.platformFontSet.setResolutionPriority(priority);
    }

    public String toString() {
        StringBuilder message = new StringBuilder(140);
        message.append("==== PDFFontSet ====\n\n=== CSS Font Set ===\n");
        message.append(this.cssFontSet.toString());
        message.append("\n\n=== PS Font Set ===\n");
        message.append(this.psFontSet.toString());
        message.append("\n\n=== Platform Font Set ===\n");
        message.append(this.platformFontSet.toString());
        message.append("\n\n=== Fallback Font Set ===\n");
        message.append(this.fallbackFontSet.toString());
        return message.toString();
    }

    @Override
    public void addFont(Font font) throws PDFFontException {
        this.addFont(font, Platform.WINDOWS, ULocale.getDefault());
    }

    @Override
    public void addFont(Font[] fonts) throws PDFFontException {
        this.addFont(fonts, Platform.WINDOWS, ULocale.getDefault());
    }

    @Override
    public void setIgnoreFontLoadingErrors(boolean ignoreFontLoadingErrors) {
        this.ignoreFontLoadingErrors = ignoreFontLoadingErrors;
    }

    private static final class AcrobatPlatformNameMangler
    implements FamilyNameNormalizer {
        private static final long serialVersionUID = 1L;

        private AcrobatPlatformNameMangler() {
        }

        @Override
        public String normalize(String familyName) {
            StringBuilder strBuilder = new StringBuilder();
            char[] chars = familyName.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == ' ' || chars[i] == '-') continue;
                strBuilder.append(chars[i]);
            }
            return strBuilder.toString();
        }
    }
}

