/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFilterFormatException;
import com.adobe.internal.pdftoolkit.core.filter.DCTError;
import com.adobe.internal.pdftoolkit.core.filter.DCTStripPtrRec;
import com.adobe.internal.pdftoolkit.core.filter.DCTdec_code_struct;
import com.adobe.internal.pdftoolkit.core.filter.DCTjframe;
import com.adobe.internal.pdftoolkit.core.filter.DCTjscan;
import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.IOException;
import java.io.InputStream;

public class DCTInputStream
extends DecodeInputStream {
    int dg_bs_byte;
    int dg_byteAhead;
    int dg_unused;
    int dg_state;
    short[] dg_bigcolorline;
    int dg_hFast;
    int dg_vFast;
    int dg_stripv;
    int dg_stripmv;
    int dg_out_lines_processed;
    int dg_in_lines_processed;
    int dg_old_in_lines_processed;
    int dg_maxh;
    int dg_maxv;
    int dg_resyncmod8;
    int dg_resync;
    int dg_resync_count;
    int dg_lx;
    int dg_ly;
    int dg_raster_size_in;
    int dg_raster_size_out;
    int dg_framecn;
    int dg_cn;
    int dg_encoding;
    int dg_colorconv;
    int dg_blend;
    boolean dg_haveQCoefRaster;
    int dg_scansCompleted;
    int dg_scansInImage;
    boolean dg_eoiDecoded;
    int dg_scanTabGroup;
    int dg_blockSmooth;
    int dg_ss;
    int dg_se;
    int dg_ah;
    int dg_al;
    int dg_nmdus_per_strip;
    int dg_nstrips_this_scan;
    int dg_nblocks;
    int dg_nsamps;
    int dg_cnmaxh;
    int[] dg_UGtab;
    int[] dg_VGtab;
    int[][] dg_equant;
    DCTjframe[] dg_jpframe;
    DCTjscan[] dg_jpscan;
    int dg_frameqn;
    int dg_framehn;
    int dg_ps_version;
    int dg_ps_flags;
    double dg_qfactor;
    int dg_qTableCount;
    boolean[] dg_qFitsIn8;
    boolean dg_relax;
    boolean dg_picky;
    int dg_lastp;
    int dg_scanDirBytePos;
    int dg_numLoggedScans;
    int[] dg_progScanBytes;
    byte[] dg_progScanNumber;
    DCTdec_code_struct[] dg_dts;
    DCTdec_code_struct[] dg_ats;
    short[][] dg_qtizers;
    int dgCount = 0;
    int dgPos = 0;
    boolean UngetAvail = false;
    int UngetByte;
    private int[] qstrip;
    private int[][] last_qcoef_ptr;
    private static int[] WMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private byte[] DCTunzigzag = new byte[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    private static final byte[] DCTMin8BitQuant = new byte[]{9, 8, 8, 8, 7, 8, 8, 7, 7, 8, 9, 7, 7, 7, 9, 8, 8, 7, 7, 8, 8, 8, 7, 8, 7, 8, 7, 8, 8, 7, 7, 8, 8, 7, 7, 8, 7, 7, 7, 9, 7, 7, 7, 7, 7, 8, 8, 7, 7, 7, 8, 7, 8, 7, 8, 7, 7, 8, 7, 7, 7, 7, 7, 7};
    private static final long C4p16 = 46341L;
    private static final long C6p16 = 25080L;
    private static final long C2pC6p16 = 85627L;
    private static final long C2mC6p16 = 35468L;
    private static int[] DCTDQScale = new int[]{32768, 23624, 23624, 25080, 17032, 25080, 27867, 18081, 18081, 27867, 32768, 20091, 19195, 20091, 32768, 41706, 23624, 21328, 21328, 23624, 41706, 60547, 30068, 25080, 23699, 25080, 30068, 60547, 118768, 43652, 31920, 27867, 27867, 31920, 43652, 118768, 85627, 46341, 35468, 32768, 35468, 46341, 85627, 90901, 51491, 41706, 41706, 51491, 90901, 101004, 60547, 53081, 60547, 101004, 118768, 77062, 77062, 118768, 151163, 111877, 151163, 219455, 219455, 430476};
    private static final int UG = 45107;
    private static final int UB = 116130;
    private static final int VR = 91881;
    private static final int VG = 93603;
    private static final int CTBRRND = 262144;
    private static final int CT128 = 1024;
    private static final int CTBRFF = 133693440;
    private static final int CT128UB = 118917120;
    private static final int CT128VR = 94086144;
    private static final int CT128UG = 0x2C0CC00;
    private static final int CT128VG = 95849472;
    private static final int CTLOOPCOUNT = 2048;
    private static final int CTGRND = 524288;
    private static final int CTGFF = 0xFF00000;

    private void initDCTgvl() {
        this.dg_state = 0;
        this.dg_picky = false;
        this.dg_colorconv = 16383;
        this.dg_jpframe = new DCTjframe[4];
        this.dg_jpscan = new DCTjscan[4];
        this.dg_qFitsIn8 = new boolean[4];
        this.dg_dts = new DCTdec_code_struct[4];
        this.dg_ats = new DCTdec_code_struct[4];
        this.dg_qtizers = new short[4][64];
    }

    public DCTInputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 0, diparams);
        this.initDCTgvl();
    }

    public DCTInputStream(InputStream in, FilterParams p) {
        super(in, 0, p);
        this.initDCTgvl();
    }

    public DCTInputStream(InputStream in) {
        this(in, null);
    }

    @Override
    public void fill() {
        if (this.dg_state == 0) {
            try {
                while (this.DCTDNextScan() == 0) {
                }
            }
            catch (PDFFilterFormatException fe) {
                this.pendingException = fe;
                return;
            }
            catch (Exception e) {
                this.pendingException = new PDFFilterFormatException("DCT Error: " + e.getMessage());
                return;
            }
        }
        while (this.outCount < this.outBuf.length) {
            if (this.dgPos >= this.dgCount) {
                try {
                    if (this.DCTDFilBuf()) {
                        this.pendingEOF = true;
                        return;
                    }
                    this.dgCount = this.dg_lx * this.dg_framecn;
                    this.dgPos = 0;
                }
                catch (PDFFilterFormatException e) {
                    return;
                }
                catch (IOException io) {
                    this.pendingException = new PDFFilterFormatException("DCT IO Error: " + io.getMessage());
                }
            }
            int count = Math.min(this.outBuf.length - this.outCount, this.dgCount - this.dgPos);
            for (int i = 0; i < count; ++i) {
                short ub;
                this.outBuf[this.outCount++] = ((ub = this.dg_bigcolorline[this.dgPos++]) & 0xF800) != 0 ? (byte)(~(ub >> 15)) : (byte)(ub >>> 3);
            }
        }
    }

    private int FGETC() {
        if (this.UngetAvail) {
            this.UngetAvail = false;
            return this.UngetByte;
        }
        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
            return -1;
        }
        return this.inBuf[this.inPos++] & 0xFF;
    }

    private int UNGETC(int theByte) {
        this.UngetAvail = true;
        this.UngetByte = theByte;
        return theByte;
    }

    private int DCTDGetFrameParms() throws PDFFilterFormatException {
        int framecn;
        int frameSize = this.DCTDSGet16();
        int dataPrecision = this.DCTDSGet8();
        if (dataPrecision != 8) {
            DCTError.err("Precision > 8 bits/color disallowed", "Precision > 8 bits/color disallowed", "Decode filter processed an out-of-range data item or an incorrect data structure");
        }
        this.dg_ly = this.DCTDSGet16();
        this.dg_lx = this.DCTDSGet16();
        if (this.dg_lx == 0) {
            DCTError.err("Image width is 0", "Image width is 0", "Decode filter processed an item whose length was outside its legal range");
        }
        if (this.dg_ly == 0) {
            DCTError.err("Image height is 0", "Image height is 0", "Decode filter processed an item whose length was outside its legal range");
        }
        if ((framecn = (this.dg_framecn = this.DCTDSGet8())) < 1 || framecn > 4) {
            DCTError.err("Number of colors is not [1..4]", "Number of colors is not [1..4]", "Decode filter processed an out-of-range data item or an incorrect data structure");
        }
        for (int i = 0; i < framecn; ++i) {
            DCTjframe jpframe = this.dg_jpframe[i] = new DCTjframe();
            jpframe.frameComponentId = this.DCTDSGet8();
            int hs = this.DCTDSGet8();
            jpframe.hs = hs >> 4;
            jpframe.vs = hs & 0xF;
            jpframe.frameQTNum = this.DCTDSGet8();
            frameSize -= 3;
        }
        return frameSize - 8;
    }

    private int DCTDGetDQT() throws PDFFilterFormatException {
        int count;
        int tcount = 65;
        boolean sgetq = false;
        for (count = this.dg_frameqn = this.DCTDSGet16() - 2; count > 0; count -= tcount) {
            int inbyte = this.DCTDSGet8();
            int qTableID = inbyte & 0xF;
            int precision = inbyte >> 4;
            if (precision != 0) {
                if (this.dg_picky) {
                    DCTError.err("QuantTable precision is not 8 bits", "QuantTable precision is not 8 bits", "Decode filter processed an out-of-range data item or an incorrect data structure");
                } else {
                    sgetq = true;
                    tcount = 129;
                }
            }
            if (qTableID + 1 > this.dg_qTableCount) {
                this.dg_qTableCount = qTableID + 1;
                if (qTableID > 3) {
                    DCTError.err("QuantTable number is not [0..3]", "QuantTable number is not [0..3]", "Decode filter processed an out-of-range data item or an incorrect data structure");
                }
            }
            short[] q = this.dg_qtizers[qTableID];
            for (int i = 0; i < 64; ++i) {
                int temp;
                int n = temp = sgetq ? this.DCTDSGet16() : this.DCTDSGet8();
                if (temp == 0) {
                    DCTError.err("Quantizer is 0", "Quantizer is 0", "Decode filter processed an out-of-range data item or an incorrect data structure");
                }
                q[i] = (short)temp;
            }
        }
        return count;
    }

    private int DCTDGetDRI() throws PDFFilterFormatException {
        int seglen = this.DCTDSGet16();
        this.dg_resync = this.DCTDSGet16();
        this.dg_resyncmod8 = 0;
        this.dg_resync_count = this.dg_resync + 1;
        return seglen - 4;
    }

    private void DCTDNoSOI() throws PDFFilterFormatException {
        DCTError.err("Input did not begin with a JPEG SOI marker", "Input did not begin with a JPEG SOI marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
    }

    private int DCTDAdobeMarker(int segSize) throws PDFFilterFormatException {
        segSize -= 7;
        this.dg_ps_version = this.DCTDSGet16();
        this.dg_ps_flags = this.DCTDSGet32();
        this.dg_colorconv = this.DCTDSGet8();
        if (this.dg_picky && ((this.dg_ps_flags & 0xFFFF) != 0 || this.dg_colorconv > 2)) {
            DCTError.err("Invalid JPEG APPE marker", "Invalid JPEG APPE marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
        }
        if (this.dg_state != 1) {
            this.DCTDNoSOI();
        }
        block8: while (segSize > 3) {
            int propertyID = this.DCTDSGet8();
            int propertyLen = 0;
            if (propertyID >= 3) {
                propertyLen = this.DCTDSGet16();
                if ((segSize -= propertyLen + 3) < 0) {
                    DCTError.err("Invalid JPEG APPE marker", "Invalid JPEG APPE marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
                }
            } else {
                --segSize;
            }
            switch (propertyID) {
                case 1: 
                case 2: {
                    propertyID = 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    propertyID = 0;
                }
            }
            switch (propertyID) {
                case 3: {
                    if (propertyLen < 5) {
                        DCTError.err("Invalid JPEG APPE marker", "Invalid JPEG APPE marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
                    }
                    this.dg_numLoggedScans = this.DCTDSGet8();
                    if ((propertyLen -= this.dg_numLoggedScans * 5 + 1) < 0) {
                        DCTError.err("Invalid JPEG APPE marker", "Invalid JPEG APPE marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
                    }
                    this.dg_progScanNumber = this.DCTDSFRead(this.dg_numLoggedScans);
                    this.dg_progScanBytes = new int[this.dg_numLoggedScans];
                    for (int ii = 0; ii < this.dg_numLoggedScans; ++ii) {
                        this.dg_progScanBytes[ii] = this.DCTDSGet32();
                    }
                    while (propertyLen > 0) {
                        this.DCTDSGet8();
                        --propertyLen;
                    }
                    continue block8;
                }
            }
            while (propertyLen > 0) {
                this.DCTDSGet8();
                --propertyLen;
            }
        }
        return segSize;
    }

    private int DCTDGetDHT() throws PDFFilterFormatException {
        int count;
        for (count = this.dg_framehn = this.DCTDSGet16() - 2; count > 0; count -= 17 + this.dg_lastp) {
            int cTableId = this.DCTDSGet8();
            int tableNumb = cTableId & 0xF;
            if ((cTableId & 0xEC) != 0 || (cTableId & 2) != 0 && this.dg_encoding == 0) {
                DCTError.err("Invalid table number in JPEG DHT marker", "Invalid table number in JPEG DHT marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
            }
            if ((cTableId & 0x10) != 0) {
                DCTdec_code_struct acc = this.dg_ats[tableNumb];
                if (acc == null) {
                    acc = this.dg_ats[tableNumb] = DCTdec_code_struct.newACdecode();
                }
                this.DCTDMakeHuffDec(acc, true);
                continue;
            }
            DCTdec_code_struct dcc = this.dg_dts[tableNumb];
            if (dcc == null) {
                dcc = this.dg_dts[tableNumb] = DCTdec_code_struct.newDCdecode();
            }
            this.DCTDMakeHuffDec(dcc, false);
        }
        return count;
    }

    private int DCTDGetScanParms() throws PDFFilterFormatException {
        int scanSize = this.DCTDSGet16();
        this.dg_cn = this.DCTDSGet8();
        int cn = this.dg_cn;
        if (cn == 0 || cn > this.dg_framecn) {
            DCTError.err("Invalid number of colors in JPEG SOS marker", "Invalid number of colors in JPEG SOS marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
        }
        if ((scanSize -= cn + cn + 6) < 0) {
            return scanSize;
        }
        int jj = 0;
        for (int ii = 0; ii < cn; ++ii) {
            DCTjframe jpframe;
            DCTjscan jpscan = this.dg_jpscan[ii];
            if (jpscan == null) {
                jpscan = this.dg_jpscan[ii] = new DCTjscan();
            }
            int scanComponentId = this.DCTDSGet8();
            int acdcid = this.DCTDSGet8();
            jpscan.DCCodeTableId = acdcid >> 4;
            jpscan.ACCodeTableId = acdcid & 0xF;
            do {
                jpframe = this.dg_jpframe[jj++];
            } while (jpframe.frameComponentId != scanComponentId && jj < this.dg_framecn);
            if (jj > this.dg_framecn) {
                DCTError.err("JPEG SOS marker component ID matches no frame ID", "JPEG SOS marker component ID matches no frame ID", "Decode filter processed an out-of-range data item or an incorrect data structure");
            }
            if (jpframe.frameQTNum >= this.dg_qTableCount) {
                DCTError.err("Invalid QuantTable number in JPEG SOF marker", "Invalid QuantTable number in JPEG SOF marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
            }
            jpscan.jpframe = jpframe;
        }
        int ss = this.DCTDSGet8();
        int se = this.DCTDSGet8();
        int ah = this.DCTDSGet8();
        int al = ah & 0xF;
        ah >>= 4;
        switch (this.dg_encoding) {
            case 0: 
            case 1: {
                if (!this.dg_picky || ss == 0 && se == 63 && ah == 0 && al == 0) break;
                DCTError.err("Invalid Ss Se Ah or Al field in JPEG SOS marker", "Invalid Ss Se Ah or Al field in JPEG SOS marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
                break;
            }
            case 2: {
                if (se > 63 || se < ss || ss == 0 && se != 0 || ah > 0 && ah <= al || al > 11) {
                    DCTError.err("Invalid Ss Se Ah or Al field in JPEG SOS marker", "Invalid Ss Se Ah or Al field in JPEG SOS marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
                }
                if (ss != 0 && cn != 1) {
                    DCTError.err("More than 1 AC scan color is invalid", "More than 1 AC scan color is invalid", "Decode filter processed an out-of-range data item or an incorrect data structure");
                }
                this.dg_ss = ss;
                this.dg_se = se;
                this.dg_ah = ah;
                this.dg_al = al;
            }
        }
        if (scanSize > 0 && !this.dg_picky) {
            do {
                this.DCTDSGet8();
            } while (--scanSize > 0);
        }
        return scanSize;
    }

    /*
     * Unable to fully structure code
     */
    private void DCTDDecodeImage() throws PDFFilterFormatException {
        segSize = 0;
        block13: while (true) {
            reportMarkerError = true;
            origmCode = mCode = this.DCTDMarkerSGet();
            if (mCode <= 239 && mCode >= 224) {
                mCode = 224;
            } else if (mCode >= 208 && mCode <= 215) {
                mCode = 208;
            }
            switch (mCode) {
                case 216: {
                    if (this.dg_state != 0) {
                        DCTError.err("Second SOI or SOFn JPEG marker is disallowed", "Second SOI or SOFn JPEG marker is disallowed", "Decode filter processed an out-of-range data item or an incorrect data structure");
                    }
                    this.dg_state = 1;
                    this.dg_resync_count = 1;
                    this.dg_resyncmod8 = 0;
                    this.dg_resync = 0;
                    segSize = 0;
                    break;
                }
                case 192: 
                case 193: 
                case 194: {
                    if (mCode == 192) {
                        this.dg_encoding = 0;
                    } else if (mCode == 193) {
                        this.dg_encoding = 1;
                        this.dg_relax = true;
                    } else {
                        this.dg_encoding = 2;
                        this.dg_haveQCoefRaster = true;
                        this.dg_relax = true;
                    }
                    if (this.dg_jpframe[0] != null) {
                        DCTError.err("Second SOI or SOFn JPEG marker is disallowed", "Second SOI or SOFn JPEG marker is disallowed", "Decode filter processed an out-of-range data item or an incorrect data structure");
                    }
                    segSize = this.DCTDGetFrameParms();
                    this.DCTInitCommon(0);
                    break;
                }
                case 224: 
                case 254: {
                    c0 = 0;
                    c1 = 0;
                    segSize = this.DCTDSGet16() - 2;
                    reportMarkerError = false;
                    jj = 0;
                    if (origmCode != 238 || segSize < 12) break;
                    segSize -= 5;
                    c0 = this.DCTDSGet32();
                    c1 = this.DCTDSGet8();
                    if (c0 == 1097101154 && c1 == 101) {
                        segSize = this.DCTDAdobeMarker(segSize);
                        break;
                    }
                    jj = 5;
                    break;
                }
                case 196: {
                    if (this.dg_state == 0) {
                        this.DCTDNoSOI();
                    }
                    segSize = this.DCTDGetDHT();
                    break;
                }
                case 219: {
                    if (this.dg_encoding == 2 && this.dg_scansCompleted > 0) {
                        DCTError.err("JPEG DQT marker is invalid after first scan", "JPEG DQT marker is invalid after first scan", "Decode filter processed an out-of-range data item or an incorrect data structure");
                    }
                    if (this.dg_state == 0) {
                        this.DCTDNoSOI();
                    }
                    segSize = this.DCTDGetDQT();
                    break;
                }
                case 218: {
                    if (this.dg_state == 0) {
                        this.DCTDNoSOI();
                    }
                    if (this.dg_framecn == 0 || this.dg_frameqn == 0 || this.dg_framehn == 0) {
                        DCTError.err("JPEG SOFn DQT or DHT marker missing before SOS marker", "JPEG SOFn DQT or DHT marker missing before SOS marker", "Decode filter processed an out-of-range data item or an incorrect data structure");
                    }
                    if ((segSize = this.DCTDGetScanParms()) != 0) break;
                    if (this.dg_scansCompleted == 0) {
                        this.DCTAllocate(this.dg_raster_size_out);
                        for (jj = 0; jj < this.dg_qTableCount; ++jj) {
                            this.DCTDScaleQT(this.dg_equant[jj], jj);
                        }
                        if (this.dg_colorconv != 0) {
                            this.DCTDInitCTBig();
                        }
                    }
                    if (this.dg_haveQCoefRaster) {
                        this.DCTInitForScan();
                        this.DCTDDecodeScanToRaster();
                        ++this.dg_scansCompleted;
                        this.dg_cn = this.dg_framecn;
                    }
                    this.DCTInitForScan();
                    this.dg_out_lines_processed = 0;
                    this.dg_nblocks = 0;
                    this.DCTResetDC();
                    this.dg_resync_count = this.dg_resync + 1;
                    this.dg_state = 4;
                    return;
                }
                case 256: {
                    if (this.dg_state != 0) ** GOTO lbl92
                    this.DCTDNoSOI();
                    ** GOTO lbl94
lbl92:
                    // 1 sources

                    if (this.dg_picky) {
                        this.DCTDReportEOF();
                    }
                }
lbl94:
                // 5 sources

                case 217: {
                    if (this.dg_state == 0) {
                        this.DCTDNoSOI();
                    }
                    this.dg_eoiDecoded = true;
                    if (this.dg_scansCompleted <= this.dg_scansInImage) {
                        this.dg_state = 2;
                    }
                    return;
                }
                case 221: {
                    segSize = this.DCTDGetDRI();
                    break;
                }
                case 195: {
                    DCTError.err("Spatial/lossless JPEG disallowed", "Spatial/lossless JPEG disallowed", "Specified variation is legal but unimplemented");
                }
                case 208: {
                    if (this.dg_picky) {
                        this.DCTDInvalidMarker(origmCode);
                    }
                    this.dg_resyncmod8 = origmCode + 1 & 7;
                    break;
                }
                default: {
                    if (origmCode >= 201 && origmCode <= 207) {
                        DCTError.err("Arithmetic-coded JPEG disallowed", "Arithmetic-coded JPEG disallowed", "Specified variation is legal but unimplemented");
                        break;
                    }
                    if (origmCode >= 197 && origmCode <= 199) {
                        DCTError.err("Differential JPEG disallowed", "Differential JPEG disallowed", "Specified variation is legal but unimplemented");
                        break;
                    }
                    if (origmCode >= 240 && origmCode <= 253) {
                        DCTError.err("JPEG extension marker 0x%X disallowed", "JPEG extension marker " + origmCode + " disallowed", "Specified variation is legal but unimplemented");
                        break;
                    }
                    DCTError.err("Unknown or invalid JPEG marker = 0x%X", "Unknown or invalid JPEG marker = " + origmCode, "Decode filter processed an out-of-range data item or an incorrect data structure");
                }
            }
            if (segSize == 0) continue;
            if (segSize < 0) {
                DCTError.err("JPEG 0x%X marker too short", "JPEG " + origmCode + " marker too short", "Decode filter processed an out-of-range data item or an incorrect data structure");
            }
            if (!reportMarkerError || !this.dg_picky) {
                while (true) {
                    if (segSize-- <= 0) continue block13;
                    this.DCTDSGet8();
                }
            }
            DCTError.err("JPEG 0x%X marker too long", "JPEG " + origmCode + " marker too long", "Decode filter processed an out-of-range data item or an incorrect data structure");
        }
    }

    public int DCTDNextScan() throws Exception {
        switch (this.dg_state) {
            case 4: 
            case 5: {
                if (!this.dg_eoiDecoded && this.dg_haveQCoefRaster) break;
                return 1;
            }
            case 0: {
                this.DCTDInitSGet();
                break;
            }
            case 1: {
                if (this.dg_haveQCoefRaster) break;
                return 1;
            }
            case 2: 
            case 3: {
                this.DCTFree();
                return 1;
            }
        }
        this.DCTDDecodeImage();
        if (this.dg_state >= 4 && !this.dg_eoiDecoded) {
            return 0;
        }
        return 1;
    }

    private boolean DCTDFilBuf() throws IOException {
        switch (this.dg_state) {
            case 0: {
                this.DCTDInitSGet();
            }
            case 1: {
                this.DCTDDecodeImage();
            }
            case 4: {
                if (this.dg_state == 4) {
                    this.DCTDDecodeStrip();
                }
            }
            case 2: 
            case 3: {
                if (this.dg_state < 4) {
                    this.DCTFree();
                    return true;
                }
                this.dg_stripmv = 0;
                this.dg_stripv = 0;
                this.dg_state = 5;
            }
            case 5: {
                this.DCTPutNCLine(this.dg_stripv, this.dg_stripmv);
                if (++this.dg_stripmv >= this.dg_maxv) {
                    this.dg_stripmv = 0;
                    if (++this.dg_stripv >= 8) {
                        this.dg_state = 4;
                    }
                }
                if (++this.dg_out_lines_processed < this.dg_ly) break;
                if (!this.dg_haveQCoefRaster) {
                    ++this.dg_scansCompleted;
                }
                this.dg_scansInImage = this.dg_scansCompleted;
                this.dg_state = this.dg_eoiDecoded ? 2 : 1;
            }
        }
        return false;
    }

    private void DCTDInvalidMarker(int marker) throws PDFFilterFormatException {
        if (marker >= 208 && marker < 216) {
            DCTError.err("Invalid JPEG RST%X marker in scan %ld block %ld", "Invalid JPEG RST" + (marker & 7) + " marker in scan " + this.dg_scansCompleted + " block " + this.dg_nblocks, "Decode filter processed an out-of-range data item or an incorrect data structure");
        } else {
            DCTError.err("Invalid JPEG marker 0x%2X in scan %ld 8x8 block %ld", "Invalid JPEG marker " + marker + " in scan " + this.dg_scansCompleted + " 8x8 block " + this.dg_nblocks, "Decode filter processed an out-of-range data item or an incorrect data structure");
        }
    }

    private void DCTDBadHuff() throws PDFFilterFormatException {
        DCTError.err("Huffcode too big in scan %ld 8x8 block %ld", "Huffcode too big in scan " + this.dg_scansCompleted + " 8x8 block " + this.dg_nblocks, "Decode filter processed an out-of-range data item or an incorrect data structure");
    }

    private void DCTDReportEOF() throws PDFFilterFormatException {
        DCTError.err("Source error or end in scan %ld 8x8 block %ld", "Source error or end in scan " + this.dg_scansCompleted + " 8x8 block " + this.dg_nblocks, "Decode filter source terminated prematurely");
    }

    private void DCTDTruncateError() throws PDFFilterFormatException {
        int byteAhead = this.FGETC();
        if (byteAhead > 0) {
            this.DCTDInvalidMarker(byteAhead);
        }
        this.DCTDReportEOF();
    }

    private void DCTDNoMarker() throws PDFFilterFormatException {
        DCTError.err("Missing marker before scan %ld 8x8 block %ld", "Missing marker before scan " + this.dg_scansCompleted + " 8x8 block " + this.dg_nblocks, "Decode filter processed an out-of-range data item or an incorrect data structure");
    }

    private int DCTDMCUPreSGet(int unusedminusnbits) throws PDFFilterFormatException {
        int byteAhead;
        block4: while (true) {
            byteAhead = this.FGETC();
            switch (byteAhead) {
                case 0: {
                    return 0;
                }
                case 255: {
                    continue block4;
                }
            }
            break;
        }
        if (unusedminusnbits < 0) {
            this.DCTDTruncateError();
        }
        return this.UNGETC(byteAhead);
    }

    private int DCTDSGet8() throws PDFFilterFormatException {
        int bs_byte = this.dg_byteAhead;
        this.dg_byteAhead = this.FGETC();
        if (bs_byte < 0) {
            this.DCTDReportEOF();
        }
        return bs_byte;
    }

    private byte[] DCTDSFRead(int len) throws PDFFilterFormatException {
        byte[] inStr = new byte[len];
        inStr[0] = (byte)this.dg_byteAhead;
        for (int i = 1; i < len; ++i) {
            int cb = this.FGETC();
            if (cb < 0) {
                this.DCTDReportEOF();
                break;
            }
            inStr[i] = (byte)cb;
        }
        this.DCTDSGet8();
        return inStr;
    }

    private short[] DCTDSFReadShort(int len) throws PDFFilterFormatException {
        short[] inStr = new short[len];
        inStr[0] = (short)this.dg_byteAhead;
        for (int i = 1; i < len; ++i) {
            int cb = this.FGETC();
            if (cb < 0) {
                this.DCTDReportEOF();
                break;
            }
            inStr[i] = (short)cb;
        }
        this.DCTDSGet8();
        return inStr;
    }

    private int DCTDSGet16() throws PDFFilterFormatException {
        int bs_byte = this.DCTDSGet8();
        return (bs_byte << 8) + this.DCTDSGet8();
    }

    private int DCTDSGet32() throws PDFFilterFormatException {
        int valHi = this.DCTDSGet16() << 16;
        return valHi + this.DCTDSGet16();
    }

    private int DCTDMarkerSGet() throws PDFFilterFormatException {
        int bs_byte;
        int garb_bytes = this.dg_unused >> 3;
        this.dg_unused = 0;
        while (true) {
            if (this.dg_picky && garb_bytes > 0 || garb_bytes > 10000) {
                this.DCTDNoMarker();
            }
            if ((bs_byte = this.DCTDSGet8Marker()) == 255 && this.dg_byteAhead != 0) break;
            if (bs_byte == 256) {
                return bs_byte;
            }
            ++garb_bytes;
        }
        while ((bs_byte = this.dg_byteAhead) >= 255) {
            if (bs_byte >= 256) {
                bs_byte = 256;
                return bs_byte;
            }
            this.DCTDSGet8();
        }
        if (bs_byte != 217) {
            this.DCTDSGet8();
        }
        return bs_byte;
    }

    private int DCTDSGet8Marker() throws PDFFilterFormatException {
        int bs_byte = this.dg_byteAhead;
        this.dg_byteAhead = this.FGETC();
        if (bs_byte < 0) {
            bs_byte = 256;
        }
        return bs_byte;
    }

    private void DCTDInitSGet() throws IOException {
        this.dg_unused = 0;
        this.dg_byteAhead = this.FGETC();
    }

    private int VALOF(int nb) {
        int xfval = this.dg_bs_byte >>> this.dg_unused & (nb = WMASK[nb]);
        if (xfval <= nb >>> 1) {
            xfval -= nb;
        }
        return xfval;
    }

    private int DCTDHuffSGet(DCTdec_code_struct acc) throws PDFFilterFormatException {
        int hufc;
        int MAX_CODE_LEN;
        int[] maxcode;
        block4: {
            block2: {
                block5: {
                    block3: {
                        maxcode = acc.maxcode;
                        MAX_CODE_LEN = 16;
                        if (this.dg_unused >= MAX_CODE_LEN) break block2;
                        hufc = this.dg_byteAhead;
                        if (255 != (hufc & 0xFF) || this.DCTDMCUPreSGet(this.dg_unused - 1) == 0) break block3;
                        hufc = this.dg_bs_byte << MAX_CODE_LEN - this.dg_unused & WMASK[MAX_CODE_LEN];
                        break block4;
                    }
                    this.dg_bs_byte = (this.dg_bs_byte << 8) + hufc;
                    hufc = this.FGETC();
                    if (255 != (hufc & 0xFF) || this.DCTDMCUPreSGet(this.dg_unused + 8 - 1) == 0) break block5;
                    this.dg_byteAhead = hufc;
                    if ((this.dg_unused += 8) >= MAX_CODE_LEN) break block2;
                    hufc = this.dg_bs_byte << MAX_CODE_LEN - this.dg_unused & WMASK[MAX_CODE_LEN];
                    break block4;
                }
                this.dg_bs_byte = (this.dg_bs_byte << 8) + hufc;
                this.dg_byteAhead = this.FGETC();
                this.dg_unused += 16;
            }
            hufc = this.dg_bs_byte >>> this.dg_unused - MAX_CODE_LEN & WMASK[MAX_CODE_LEN];
        }
        int i = 0;
        if (hufc >= acc.biggest) {
            this.DCTDBadHuff();
        }
        while (hufc > maxcode[i++]) {
        }
        this.dg_unused -= i;
        return acc.huffval[acc.valptr[i - 1] + (hufc >>>= MAX_CODE_LEN - i)] & 0xFF;
    }

    private void DCTDFillHuffBits(int nbits) throws PDFFilterFormatException {
        this.dg_unused -= nbits;
        if (this.dg_unused < 0) {
            int work = this.dg_byteAhead;
            if (255 == (work & 0xFF)) {
                this.DCTDMCUPreSGet(this.dg_unused);
            }
            this.dg_bs_byte = (this.dg_bs_byte << 8) + work;
            work = this.FGETC();
            if (255 == (work & 0xFF) && this.DCTDMCUPreSGet(this.dg_unused + 8) != 0) {
                this.dg_byteAhead = work;
                this.dg_unused += 8;
                return;
            }
            this.dg_bs_byte = (this.dg_bs_byte << 8) + work;
            this.dg_byteAhead = this.FGETC();
            this.dg_unused += 16;
        }
    }

    private void DCTDGetHuffDec(DCTdec_code_struct acc, int[] huffcode) {
        int ms = 0;
        int p = 0;
        for (int ss = 0; ss < 16; ++ss) {
            if (acc.huffbits[ss] != 0) {
                acc.valptr[ss] = p - huffcode[p];
                acc.maxcode[ss] = (huffcode[(p += acc.huffbits[ss]) - 1] + 1 << 16 - ss - 1) - 1;
                ms = ss;
                continue;
            }
            acc.maxcode[ss] = -1;
        }
        acc.biggest = acc.maxcode[ms] + 1;
    }

    private void DCTDMakeHuffDec(DCTdec_code_struct acc, boolean ac) throws PDFFilterFormatException {
        int[] huffcode = new int[177];
        int[] huffsize = new int[177];
        acc.huffbits = this.DCTDSFReadShort(16);
        this.DCTSizeCodes(acc.huffbits, huffsize, huffcode, ac);
        int nvals = this.dg_lastp;
        acc.huffval = this.DCTDSFRead(nvals);
        for (int i = 0; i < nvals; ++i) {
            int val = acc.huffval[i] & 0xFF;
            if (ac) {
                int magcat = val & 0xF;
                int zrunlen = val >> 4;
                if (magcat < 11 && (magcat != 0 || zrunlen == 0 || zrunlen == 15 || this.dg_encoding == 2)) continue;
                this.DCTUnusableACCode("Decode filter processed an out-of-range data item or an incorrect data structure", val);
                continue;
            }
            if (val < 12) continue;
            this.DCTUnusableDCCode("Decode filter processed an out-of-range data item or an incorrect data structure", val);
        }
        this.DCTDGetHuffDec(acc, huffcode);
    }

    private void DCTUnusableACCode(String err, int huffCode) throws PDFFilterFormatException {
        DCTError.err("Unusable value 0x%X in AC HuffTable", "Unusable value " + huffCode + " in AC HuffTable", err);
    }

    private void DCTUnusableDCCode(String err, int huffCode) throws PDFFilterFormatException {
        DCTError.err("Unusable value 0x%X in DC HuffTable", "Unusable value " + huffCode + " in DC HuffTable", err);
    }

    private void DCTQFitsIn8() {
        for (int ii = 0; ii < this.dg_qTableCount; ++ii) {
            short[] qtizers = this.dg_qtizers[ii];
            boolean quantCoefFitsIn8 = true;
            for (int jj = 0; jj < 64; ++jj) {
                if (qtizers[jj] >= DCTMin8BitQuant[jj]) continue;
                quantCoefFitsIn8 = false;
                break;
            }
            this.dg_qFitsIn8[ii] = quantCoefFitsIn8;
        }
    }

    private void DCTInitQCPtrs(int[] last_qcoef_ptr, DCTjframe jpframe, int stripNo) {
        int coefPerMCU = (jpframe.coefx << 3) + (jpframe.coefx >>> 3);
        int ncoef = jpframe.vs * stripNo * coefPerMCU;
        for (int ii = 0; ii < jpframe.vs; ++ii) {
            last_qcoef_ptr[ii] = ncoef + ii * coefPerMCU;
        }
    }

    private void DCTInitStripPtrs(DCTjframe jpframe, int stripNo) {
        DCTStripPtrRec[] stripPtrs = jpframe.stripPtrs;
        int coefPerStrip = (jpframe.coefx << 3) + (jpframe.coefx >> 3);
        stripPtrs[0].last_qcoef_ptr = stripNo * jpframe.vs * coefPerStrip;
        int padx8 = jpframe.padx << 3;
        stripPtrs[0].last_ptr = 0;
        for (int i = 1; i < jpframe.vs; ++i) {
            stripPtrs[i].last_ptr = stripPtrs[i - 1].last_ptr + padx8;
            stripPtrs[i].last_qcoef_ptr = stripPtrs[i - 1].last_qcoef_ptr + coefPerStrip;
        }
    }

    private void DCTResetDC() {
        for (int i = 0; i < this.dg_framecn; ++i) {
            this.dg_jpscan[i].prev_dc = 0;
        }
    }

    private void DCTInitCommon(int encInit) throws PDFFilterFormatException {
        int verMCUsTimes8;
        int maxv_x8;
        DCTjframe jpframe;
        int ii;
        String strucerr;
        String rcerr;
        if (encInit != 0) {
            rcerr = "Open parameter out-of-range";
            strucerr = "Open parameter out-of-range";
        } else {
            rcerr = "Decode filter processed an out-of-range data item or an incorrect data structure";
            strucerr = "Open option combination is incompatible";
        }
        int maxv = 1;
        int maxh = 1;
        int nblks_per_mdu = 0;
        for (ii = 0; ii < this.dg_framecn; ++ii) {
            jpframe = this.dg_jpframe[ii];
            int hs = jpframe.hs;
            int vs = jpframe.vs;
            int nbc = hs * vs;
            if (nbc == 0 || hs > 4 || vs > 4) {
                DCTError.err("Invalid sampling", "Invalid sampling", rcerr);
            }
            if (hs > maxh) {
                maxh = hs;
            }
            if (vs > maxv) {
                maxv = vs;
            }
            nblks_per_mdu += nbc;
        }
        if (nblks_per_mdu > 10) {
            if (!this.dg_relax) {
                DCTError.err("Sum(HSamples * VSamples) > 10 limit", "Sum(HSamples * VSamples) > 10 limit", strucerr);
            } else if (this.dg_encoding == 0) {
                this.dg_encoding = 1;
            }
        }
        this.dg_maxh = maxh;
        this.dg_maxv = maxv;
        int maxh_x8 = maxh * 8;
        this.dg_cnmaxh = this.dg_framecn * maxh;
        this.dg_nsamps = (this.dg_lx + maxh - 1) / maxh * this.dg_cnmaxh;
        this.dg_raster_size_out = this.dg_lx * this.dg_framecn;
        if (this.dg_encoding != 0) {
            this.dg_relax = true;
        }
        if (this.dg_colorconv != 0) {
            if (this.dg_colorconv != 16383) {
                if (this.dg_colorconv == 1) {
                    if (this.dg_framecn == 4) {
                        this.dg_colorconv = 2;
                    } else if (this.dg_framecn < 3) {
                        this.dg_colorconv = 0;
                    }
                } else if (this.dg_colorconv != 2 || this.dg_framecn != 4) {
                    DCTError.err("Unusable ColorTransform=%ld", "Unusable ColorTransform=" + this.dg_colorconv, rcerr);
                }
            } else {
                this.dg_colorconv = this.dg_framecn == 3 ? 1 : 0;
            }
        }
        this.dg_hFast = 0;
        if (this.dg_framecn >= 3 && this.dg_jpframe[1].hs == 1 && this.dg_jpframe[2].hs == 1) {
            if (this.dg_jpframe[0].hs == 1 && this.dg_colorconv != 0) {
                this.dg_hFast = this.dg_framecn == 3 ? 2 : 4;
            } else if (this.dg_jpframe[0].hs == 2) {
                if (this.dg_framecn == 3) {
                    this.dg_hFast = this.dg_colorconv != 0 ? 3 : 1;
                } else if (this.dg_framecn >= 4 && this.dg_jpframe[3].hs == 2 && this.dg_colorconv != 0) {
                    this.dg_hFast = 5;
                }
            }
        }
        for (ii = 0; ii < this.dg_framecn; ++ii) {
            DCTjframe jpframe2 = this.dg_jpframe[ii];
            jpframe2.maxSampling = jpframe2.hs == maxh && jpframe2.vs == maxv;
        }
        this.dg_vFast = 0;
        if (maxv >> 2 != 0 && this.dg_jpframe[0].maxSampling && this.dg_jpframe[1].vs == 1 && (this.dg_framecn == 2 || this.dg_jpframe[2].vs == 1 && (this.dg_framecn == 3 || this.dg_colorconv != 0 && this.dg_jpframe[3].maxSampling))) {
            this.dg_vFast = 1;
        }
        if (this.dg_framecn >= 2) {
            int horMCUsTimes8 = (this.dg_lx + maxh_x8 - 1) / maxh_x8 * 8;
            maxv_x8 = maxv * 8;
            verMCUsTimes8 = (this.dg_ly + maxv_x8 - 1) / maxv_x8 * 8;
            for (ii = 0; ii < this.dg_framecn; ++ii) {
                int horWidth;
                jpframe = this.dg_jpframe[ii];
                jpframe.padx = horWidth = horMCUsTimes8 * jpframe.hs;
                if (!this.dg_haveQCoefRaster) continue;
                jpframe.coefy = verMCUsTimes8 * jpframe.vs;
                jpframe.coefx = horWidth;
            }
        } else {
            int horMCUsTimes8 = (this.dg_lx * this.dg_jpframe[0].hs + maxh_x8 - 1) / maxh_x8 * 8;
            maxv_x8 = maxv * 8;
            verMCUsTimes8 = (this.dg_ly * this.dg_jpframe[0].vs + maxv_x8 - 1) / maxv_x8 * 8;
            if (this.dg_haveQCoefRaster) {
                this.dg_jpframe[0].coefy = verMCUsTimes8;
                this.dg_jpframe[0].coefx = horMCUsTimes8;
            }
            this.dg_jpframe[0].padx = horMCUsTimes8;
        }
    }

    private void DCTInitForScan() {
        int nstrips_this_scan;
        int nmdus_per_strip;
        int maxhx8 = this.dg_maxh * 8;
        int maxvx8 = this.dg_maxv * 8;
        if (this.dg_cn == 1) {
            DCTjframe jpframe = this.dg_jpscan[0].jpframe;
            nmdus_per_strip = this.dg_lx * jpframe.hs;
            nstrips_this_scan = this.dg_ly * jpframe.vs;
        } else {
            nmdus_per_strip = this.dg_lx;
            nstrips_this_scan = this.dg_ly;
        }
        this.dg_nmdus_per_strip = (nmdus_per_strip + maxhx8 - 1) / maxhx8;
        this.dg_nstrips_this_scan = (nstrips_this_scan + maxvx8 - 1) / maxvx8;
        for (int ii = 0; ii < this.dg_cn; ++ii) {
            DCTjscan jpscan = this.dg_jpscan[ii];
            jpscan.acc = this.dg_ats[jpscan.ACCodeTableId];
            jpscan.dcc = this.dg_dts[jpscan.DCCodeTableId];
        }
    }

    private void DCTSizeCodes(short[] huffbits, int[] huffsize, int[] huffcode, boolean ac) throws PDFFilterFormatException {
        int sizelim = ac ? 176 : 12;
        int nvals = 2;
        int p = 0;
        for (int i = 0; i < 16; ++i) {
            if ((nvals = nvals - huffbits[i] << 1) < 2) {
                String strucerr = "Decode filter processed an out-of-range data item or an incorrect data structure";
                DCTError.err("Over-committed Huffman specification", "Over-committed Huffman specification", strucerr);
            }
            for (int j = 1; j <= huffbits[i]; ++j) {
                if (p >= sizelim) {
                    String lengerr = "Decode filter processed an item whose length was outside its legal range";
                    DCTError.err("HuffTable exceeds %ld entry limit", "HuffTable exceeds " + sizelim + " entry limit", lengerr);
                }
                huffsize[p++] = i + 1;
            }
        }
        huffsize[p] = 0;
        this.dg_lastp = p;
        int code = 0;
        p = 0;
        int si = huffsize[0];
        while (true) {
            huffcode[p++] = code++;
            if (huffsize[p] == si) continue;
            if (huffsize[p] == 0) {
                return;
            }
            do {
                code <<= 1;
            } while (huffsize[p] != ++si);
        }
    }

    private int DCTStripBytes(DCTjframe jpframe, int maxv) {
        if (jpframe.hs <= 0) {
            return 0;
        }
        return jpframe.padx * (7 * jpframe.vs + maxv) + 8;
    }

    private void DCTAllocate(int raster_size) {
        DCTjframe jpframe;
        int j;
        if (this.dg_haveQCoefRaster) {
            this.DCTQFitsIn8();
            for (j = 0; j < this.dg_framecn; ++j) {
                jpframe = this.dg_jpframe[j];
                jpframe.qcSmall = this.dg_qFitsIn8[jpframe.frameQTNum];
                int coefst = jpframe.coefx * jpframe.coefy;
                coefst = coefst + (coefst >> 6) + 14;
                jpframe.qcoef = jpframe.qcSmall ? (Object)new byte[coefst] : (Object)new short[coefst];
            }
        }
        this.dg_equant = new int[this.dg_qTableCount][64];
        for (j = 0; j < this.dg_framecn; ++j) {
            jpframe = this.dg_jpframe[j];
            jpframe.qmat = this.dg_equant[jpframe.frameQTNum];
            jpframe.strip = new short[this.DCTStripBytes(jpframe, this.dg_maxv)];
            jpframe.stripPtrs = new DCTStripPtrRec[jpframe.vs];
            for (int i = 0; i < jpframe.vs; ++i) {
                jpframe.stripPtrs[i] = new DCTStripPtrRec();
            }
        }
        this.qstrip = new int[65];
        this.last_qcoef_ptr = new int[4][4];
        this.dg_bigcolorline = new short[raster_size + 3 * this.dg_framecn + 8];
    }

    private void DCTFree() {
        for (int j = 0; j < this.dg_framecn; ++j) {
            DCTjframe jpframe = this.dg_jpframe[j];
            jpframe.qcoef = null;
            jpframe.qmat = null;
            jpframe.strip = null;
        }
        this.dg_equant = null;
        this.dg_bigcolorline = null;
    }

    private void DCTDBadZRun() throws PDFFilterFormatException {
        DCTError.err("Missing EOB Huffcode in scan %ld 8x8 block %ld", "Missing EOB Huffcode in scan " + this.dg_scansCompleted + " 8x8 block " + this.dg_nblocks, "Decode filter processed an out-of-range data item or an incorrect data structure");
    }

    private int DCTDDecodeProgMCU(int vblks, int hblks, DCTjscan jpscan, int[] last_qcoef_ptr, int nEOB) throws PDFFilterFormatException {
        boolean qcSmall = jpscan.jpframe.qcSmall;
        Object qcoefObj = jpscan.jpframe.qcoef;
        byte[] qcoefB = null;
        short[] qcoefS = null;
        if (qcSmall) {
            qcoefB = (byte[])qcoefObj;
        } else {
            qcoefS = (short[])qcoefObj;
        }
        if (this.dg_ss == 0) {
            if (this.dg_ah == 0) {
                for (int jj = 0; jj < vblks; ++jj) {
                    DCTdec_code_struct dcc = jpscan.dcc;
                    int ii = hblks;
                    while (ii-- > 0) {
                        int xfval;
                        int qcoefBase = last_qcoef_ptr[jj];
                        int nbits = this.DCTDHuffSGet(dcc);
                        if (nbits != 0) {
                            this.DCTDFillHuffBits(nbits);
                            xfval = this.VALOF(nbits);
                            jpscan.prev_dc += xfval;
                        } else {
                            xfval = 0;
                        }
                        int qcoef = jpscan.prev_dc << this.dg_al;
                        if (qcSmall) {
                            qcoefB[qcoefBase] = (byte)qcoef;
                        } else {
                            qcoefS[qcoefBase] = (short)qcoef;
                        }
                        int n = jj;
                        last_qcoef_ptr[n] = last_qcoef_ptr[n] + 65;
                        ++this.dg_nblocks;
                    }
                }
            } else {
                for (int jj = 0; jj < vblks; ++jj) {
                    int ii = hblks;
                    while (ii-- > 0) {
                        int qcoefBase = last_qcoef_ptr[jj];
                        this.DCTDFillHuffBits(1);
                        int work = (this.dg_bs_byte >> this.dg_unused & 1) << this.dg_al;
                        if (qcSmall) {
                            int n = qcoefBase;
                            qcoefB[n] = (byte)(qcoefB[n] + (byte)work);
                        } else {
                            int n = qcoefBase;
                            qcoefS[n] = (short)(qcoefS[n] + (short)work);
                        }
                        int n = jj;
                        last_qcoef_ptr[n] = last_qcoef_ptr[n] + 65;
                        ++this.dg_nblocks;
                    }
                }
            }
        } else {
            DCTdec_code_struct acc = jpscan.acc;
            if (this.dg_ah == 0) {
                int ii = hblks;
                while (ii-- > 0) {
                    int qcoefBase = last_qcoef_ptr[0];
                    if (nEOB > 0) {
                        --nEOB;
                        last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                        ++this.dg_nblocks;
                        continue;
                    }
                    int index = this.dg_ss - 1;
                    do {
                        int ac_dist = this.DCTDHuffSGet(acc);
                        int nbits = ac_dist & 0xF;
                        ac_dist >>= 4;
                        if (nbits == 0) {
                            int work;
                            if (ac_dist == 15) {
                                index += 16;
                                continue;
                            }
                            if (ac_dist != 0) {
                                this.DCTDFillHuffBits(ac_dist);
                                work = this.dg_bs_byte >> this.dg_unused;
                                work &= WMASK[ac_dist];
                                work += 1 << ac_dist;
                            } else {
                                work = 1;
                            }
                            nEOB = work - 1;
                            break;
                        }
                        index += ac_dist + 1;
                        this.DCTDFillHuffBits(nbits);
                        int xfval = this.VALOF(nbits);
                        xfval <<= this.dg_al;
                        if (qcSmall) {
                            qcoefB[qcoefBase + index] = (byte)xfval;
                            continue;
                        }
                        qcoefS[qcoefBase + index] = (short)xfval;
                    } while (index < this.dg_se);
                    if (index > this.dg_se) {
                        if (this.dg_picky) {
                            this.DCTDBadZRun();
                        }
                        index = this.dg_se;
                    }
                    if (qcSmall) {
                        if (index > qcoefB[qcoefBase + 64]) {
                            qcoefB[qcoefBase + 64] = (byte)index;
                        }
                    } else if (index > qcoefS[qcoefBase + 64]) {
                        qcoefS[qcoefBase + 64] = (short)index;
                    }
                    last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                    ++this.dg_nblocks;
                }
            } else {
                int ii = hblks;
                block6: while (ii-- > 0) {
                    int xfval;
                    int qcoef;
                    int qcoefBase = last_qcoef_ptr[0];
                    int index = this.dg_ss - 1;
                    if (nEOB > 0) {
                        --nEOB;
                        if (qcSmall) {
                            while (index < this.dg_se) {
                                if ((qcoef = qcoefB[qcoefBase + ++index]) == 0) continue;
                                this.DCTDFillHuffBits(1);
                                xfval = this.dg_bs_byte >> this.dg_unused & 1;
                                if (xfval == 0) continue;
                                qcoef = qcoef > 0 ? (qcoef += xfval) : (qcoef -= (xfval <<= this.dg_al));
                                qcoefB[qcoefBase + index] = (byte)qcoef;
                            }
                            last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                        } else {
                            while (index < this.dg_se) {
                                if ((qcoef = qcoefS[qcoefBase + ++index]) == 0) continue;
                                this.DCTDFillHuffBits(1);
                                xfval = this.dg_bs_byte >> this.dg_unused & 1;
                                if (xfval == 0) continue;
                                qcoef = qcoef > 0 ? (qcoef += xfval) : (qcoef -= (xfval <<= this.dg_al));
                                qcoefS[qcoefBase + index] = (short)qcoef;
                            }
                            last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                        }
                        ++this.dg_nblocks;
                        continue;
                    }
                    do {
                        int ac_dist = this.DCTDHuffSGet(acc);
                        int nbits = ac_dist & 0xF;
                        if (nbits == 0 && (ac_dist >>= 4) == 15) {
                            xfval = 0;
                        } else {
                            if (nbits == 0) {
                                int work;
                                if (ac_dist == 0) {
                                    work = 1;
                                } else {
                                    this.DCTDFillHuffBits(ac_dist);
                                    work = this.dg_bs_byte >> this.dg_unused;
                                    work &= WMASK[ac_dist];
                                    work += 1 << ac_dist;
                                }
                                nEOB = work - 1;
                                if (index > (qcSmall ? (short)qcoefB[qcoefBase + 64] : qcoefS[qcoefBase + 64])) break;
                                if (qcSmall) {
                                    while (index < this.dg_se) {
                                        if ((qcoef = qcoefB[qcoefBase + ++index]) == 0) continue;
                                        this.DCTDFillHuffBits(1);
                                        xfval = this.dg_bs_byte >> this.dg_unused & 1;
                                        if (xfval == 0) continue;
                                        qcoef = qcoef > 0 ? (qcoef += xfval) : (qcoef -= (xfval <<= this.dg_al));
                                        qcoefB[qcoefBase + index] = (byte)qcoef;
                                    }
                                    last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                                } else {
                                    while (index < this.dg_se) {
                                        if ((qcoef = qcoefS[qcoefBase + ++index]) == 0) continue;
                                        this.DCTDFillHuffBits(1);
                                        xfval = this.dg_bs_byte >> this.dg_unused & 1;
                                        if (xfval == 0) continue;
                                        qcoef = qcoef > 0 ? (qcoef += xfval) : (qcoef -= (xfval <<= this.dg_al));
                                        qcoefS[qcoefBase + index] = (short)qcoef;
                                    }
                                    last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                                }
                                ++this.dg_nblocks;
                                continue block6;
                            }
                            this.DCTDFillHuffBits(nbits);
                            xfval = this.VALOF(nbits);
                            xfval <<= this.dg_al;
                        }
                        if (qcSmall) {
                            while (true) {
                                if (++index > this.dg_se) {
                                    this.DCTDBadZRun();
                                }
                                if ((qcoef = qcoefB[qcoefBase + index]) != 0) {
                                    this.DCTDFillHuffBits(1);
                                    nbits = this.dg_bs_byte >> this.dg_unused & 1;
                                    if (nbits == 0) continue;
                                    qcoef = qcoef > 0 ? (qcoef += nbits) : (qcoef -= (nbits <<= this.dg_al));
                                    qcoefB[qcoefBase + index] = (byte)qcoef;
                                    continue;
                                }
                                if (ac_dist == 0) break;
                                --ac_dist;
                            }
                            qcoefB[qcoefBase + index] = (byte)xfval;
                            continue;
                        }
                        while (true) {
                            if (++index > this.dg_se) {
                                this.DCTDBadZRun();
                            }
                            if ((qcoef = qcoefS[qcoefBase + index]) != 0) {
                                this.DCTDFillHuffBits(1);
                                nbits = this.dg_bs_byte >> this.dg_unused & 1;
                                if (nbits == 0) continue;
                                qcoef = qcoef > 0 ? (qcoef += nbits) : (qcoef -= (nbits <<= this.dg_al));
                                qcoefS[qcoefBase + index] = (short)qcoef;
                                continue;
                            }
                            if (ac_dist == 0) break;
                            --ac_dist;
                        }
                        qcoefS[qcoefBase + index] = (short)xfval;
                    } while (index < this.dg_se);
                    if (qcSmall) {
                        if (index > qcoefB[qcoefBase + 64]) {
                            qcoefB[qcoefBase + 64] = (byte)index;
                            last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                        }
                    } else if (index > qcoefS[qcoefBase + 64]) {
                        qcoefS[qcoefBase + 64] = (short)index;
                        last_qcoef_ptr[0] = last_qcoef_ptr[0] + 65;
                    }
                    ++this.dg_nblocks;
                }
            }
        }
        return nEOB;
    }

    private void DCTDDecodeSeqMCU(int vblks, int hblks, DCTjscan jpscan, int[] last_qcoef_ptr) throws PDFFilterFormatException {
        boolean qcSmall = jpscan.jpframe.qcSmall;
        Object qcoefObj = jpscan.jpframe.qcoef;
        byte[] qcoefB = null;
        short[] qcoefS = null;
        if (qcSmall) {
            qcoefB = (byte[])qcoefObj;
        } else {
            qcoefS = (short[])qcoefObj;
        }
        int vv = 0;
        while (vv < vblks) {
            int ii = hblks;
            while (ii-- > 0) {
                int xfval;
                int qcoefBase = last_qcoef_ptr[vv];
                DCTdec_code_struct dcc = jpscan.dcc;
                int nbits = this.DCTDHuffSGet(dcc);
                if (nbits != 0) {
                    this.DCTDFillHuffBits(nbits);
                    xfval = this.VALOF(nbits);
                    jpscan.prev_dc += xfval;
                }
                if (qcSmall) {
                    qcoefB[qcoefBase] = (byte)jpscan.prev_dc;
                } else {
                    qcoefS[qcoefBase] = (short)jpscan.prev_dc;
                }
                DCTdec_code_struct acc = jpscan.acc;
                int index = 0;
                do {
                    int ac_dist = this.DCTDHuffSGet(acc);
                    nbits = ac_dist & 0xF;
                    ac_dist >>= 4;
                    if (nbits == 0) {
                        if (ac_dist == 0) break;
                        index += 16;
                        continue;
                    }
                    index += ac_dist + 1;
                    this.DCTDFillHuffBits(nbits);
                    xfval = this.VALOF(nbits);
                    if (qcSmall) {
                        qcoefB[qcoefBase + index] = (byte)xfval;
                        continue;
                    }
                    qcoefS[qcoefBase + index] = (short)xfval;
                } while (index < 63);
                if (index >= 64) {
                    if (this.dg_picky) {
                        this.DCTDBadZRun();
                    }
                    index = 63;
                }
                if (qcSmall) {
                    qcoefB[qcoefBase + 64] = (byte)index;
                    int n = vv;
                    last_qcoef_ptr[n] = last_qcoef_ptr[n] + 65;
                } else {
                    qcoefS[qcoefBase + 64] = (short)index;
                    int n = vv;
                    last_qcoef_ptr[n] = last_qcoef_ptr[n] + 65;
                }
                ++this.dg_nblocks;
            }
            int n = vv++;
            last_qcoef_ptr[n] = last_qcoef_ptr[n] + 1;
        }
    }

    private void DCTDStripFromRaster(int vblks, int hblks, DCTjframe jpframe) {
        int[] qmat = jpframe.qmat;
        boolean qcSmall = jpframe.qcSmall;
        Object qcoefObj = jpframe.qcoef;
        DCTStripPtrRec[] stripPtrs = jpframe.stripPtrs;
        byte[] qcoefB = null;
        short[] qcoefS = null;
        if (qcSmall) {
            qcoefB = (byte[])qcoefObj;
        } else {
            qcoefS = (short[])qcoefObj;
        }
        for (int vv = 0; vv < vblks; ++vv) {
            int ii = hblks;
            while (ii-- > 0) {
                int pos;
                short qcoef;
                short lnz;
                int jj = this.qstrip.length;
                while (jj-- > 0) {
                    this.qstrip[jj] = 0;
                }
                int maxCol = 0;
                int maxPos = 0;
                int qcoefBase = stripPtrs[vv].last_qcoef_ptr;
                if (qcSmall) {
                    lnz = qcoefB[qcoefBase + 64];
                    jj = lnz + 1;
                    while (jj-- > 0) {
                        qcoef = qcoefB[qcoefBase + jj];
                        if (qcoef == 0) continue;
                        pos = this.DCTunzigzag[jj];
                        this.qstrip[pos] = qmat[jj] * qcoef;
                        if (pos > maxPos) {
                            maxPos = pos;
                        }
                        if ((pos &= 7) <= maxCol) continue;
                        maxCol = pos;
                    }
                    stripPtrs[vv].last_qcoef_ptr += 65;
                } else {
                    lnz = qcoefS[qcoefBase + 64];
                    jj = lnz + 1;
                    while (jj-- > 0) {
                        qcoef = qcoefS[qcoefBase + jj];
                        if (qcoef == 0) continue;
                        pos = this.DCTunzigzag[jj];
                        this.qstrip[pos] = qmat[jj] * qcoef;
                        if (pos > maxPos) {
                            maxPos = pos;
                        }
                        if ((pos &= 7) <= maxCol) continue;
                        maxCol = pos;
                    }
                    stripPtrs[vv].last_qcoef_ptr += 65;
                }
                this.DCTRevTransform(this.qstrip, stripPtrs[vv].last_ptr, maxCol, maxPos >> 3, jpframe);
                stripPtrs[vv].last_ptr += 8;
                ++this.dg_nblocks;
            }
        }
    }

    private void DCTDDecodeColor(int vblks, int hblks, DCTjscan jpscan) throws PDFFilterFormatException {
        DCTjframe jpframe = jpscan.jpframe;
        DCTStripPtrRec[] stripPtrs = jpframe.stripPtrs;
        int[] qmat = jpframe.qmat;
        for (int vv = 0; vv < vblks; ++vv) {
            int ii = hblks;
            while (ii-- > 0) {
                int xfval;
                int jj = this.qstrip.length;
                while (jj-- > 0) {
                    this.qstrip[jj] = 0;
                }
                DCTdec_code_struct dcc = jpscan.dcc;
                int nbits = this.DCTDHuffSGet(dcc);
                if (nbits != 0) {
                    this.DCTDFillHuffBits(nbits);
                    xfval = this.VALOF(nbits);
                    jpscan.prev_dc += xfval;
                }
                this.qstrip[0] = qmat[0] * jpscan.prev_dc;
                DCTdec_code_struct acc = jpscan.acc;
                int index = 0;
                int maxCol = 0;
                int maxPos = 0;
                do {
                    int ac_dist = this.DCTDHuffSGet(acc);
                    nbits = ac_dist & 0xF;
                    ac_dist >>= 4;
                    if (nbits == 0) {
                        if (ac_dist == 0) break;
                        index += 16;
                        continue;
                    }
                    int pos = this.DCTunzigzag[index += ac_dist + 1];
                    this.DCTDFillHuffBits(nbits);
                    xfval = this.VALOF(nbits);
                    this.qstrip[pos] = qmat[index > 63 ? 63 : index] * xfval;
                    if (pos > maxPos) {
                        maxPos = pos;
                    }
                    if ((pos &= 7) <= maxCol) continue;
                    maxCol = pos;
                } while (index < 63);
                if (index >= 64) {
                    if (this.dg_picky) {
                        this.DCTDBadZRun();
                    } else {
                        maxPos = 63;
                        maxCol = 7;
                    }
                }
                this.DCTRevTransform(this.qstrip, stripPtrs[vv].last_ptr, maxCol, maxPos >> 3, jpframe);
                stripPtrs[vv].last_ptr += 8;
                ++this.dg_nblocks;
            }
        }
    }

    private void DCTDDecodeResync() throws PDFFilterFormatException {
        if (--this.dg_resync_count <= 0) {
            this.dg_resync_count = this.dg_resync;
            this.DCTResetDC();
            int marker = this.DCTDMarkerSGet();
            if (marker == 256) {
                this.DCTDReportEOF();
            }
            if (this.dg_picky && marker != 208 + this.dg_resyncmod8) {
                this.DCTDInvalidMarker(marker);
            }
            this.dg_resyncmod8 = this.dg_resyncmod8 + 1 & 7;
        }
    }

    private void DCTDDecodeScanToRaster() throws PDFFilterFormatException {
        int nEOB = 0;
        this.dg_nblocks = 0;
        if (this.dg_cn == 1) {
            DCTjscan jpscan = this.dg_jpscan[0];
            DCTjframe jpframe = jpscan.jpframe;
            int coefPerStrip = (jpframe.coefx << 3) + (jpframe.coefx >> 3);
            for (int jj = 0; jj < this.dg_nstrips_this_scan; ++jj) {
                int ii;
                int sd;
                int ncoef;
                this.last_qcoef_ptr[0][0] = ncoef = jj * coefPerStrip;
                if (this.dg_encoding == 2) {
                    for (ii = this.dg_nmdus_per_strip; ii > 0; ii -= sd) {
                        sd = ii;
                        if (this.dg_resync != 0) {
                            this.DCTDDecodeResync();
                            if (this.dg_resync_count < ii) {
                                sd = this.dg_resync_count;
                            }
                            this.dg_resync_count -= sd - 1;
                        }
                        nEOB = this.DCTDDecodeProgMCU(1, sd, jpscan, this.last_qcoef_ptr[0], nEOB);
                    }
                    continue;
                }
                for (ii = this.dg_nmdus_per_strip; ii > 0; ii -= sd) {
                    sd = ii;
                    if (this.dg_resync != 0) {
                        this.DCTDDecodeResync();
                        if (this.dg_resync_count < ii) {
                            sd = this.dg_resync_count;
                        }
                        this.dg_resync_count -= sd - 1;
                    }
                    this.DCTDDecodeSeqMCU(1, sd, jpscan, this.last_qcoef_ptr[0]);
                }
            }
        } else {
            for (int jj = 0; jj < this.dg_nstrips_this_scan; ++jj) {
                int ii;
                for (ii = 0; ii < this.dg_framecn; ++ii) {
                    this.DCTInitQCPtrs(this.last_qcoef_ptr[ii], this.dg_jpframe[ii], jj);
                }
                ii = this.dg_nmdus_per_strip;
                while (ii-- > 0) {
                    DCTjframe jpframe;
                    DCTjscan jpscan;
                    int kk;
                    if (this.dg_resync != 0) {
                        this.DCTDDecodeResync();
                    }
                    if (this.dg_encoding == 2) {
                        for (kk = 0; kk < this.dg_cn; ++kk) {
                            jpscan = this.dg_jpscan[kk];
                            jpframe = jpscan.jpframe;
                            nEOB = this.DCTDDecodeProgMCU(jpframe.vs, jpframe.hs, jpscan, this.last_qcoef_ptr[kk], nEOB);
                        }
                        continue;
                    }
                    for (kk = 0; kk < this.dg_cn; ++kk) {
                        jpscan = this.dg_jpscan[kk];
                        jpframe = jpscan.jpframe;
                        this.DCTDDecodeSeqMCU(jpframe.vs, jpframe.hs, jpscan, this.last_qcoef_ptr[kk]);
                    }
                }
            }
        }
    }

    private void DCTDDecodeStrip() throws PDFFilterFormatException {
        int ii;
        if (this.dg_cn == 1) {
            DCTjscan jpscan = this.dg_jpscan[0];
            DCTjframe jpframe = jpscan.jpframe;
            int coefPerStrip = (jpframe.coefx << 3) + (jpframe.coefx >> 3);
            int stripNo = (this.dg_out_lines_processed + 7) / 8;
            int lastp = 0;
            for (int jj = 0; jj < jpframe.vs; ++jj) {
                if (this.dg_out_lines_processed + 8 * jj >= this.dg_ly) {
                    return;
                }
                jpframe.stripPtrs[0].last_ptr = lastp;
                if (this.dg_haveQCoefRaster) {
                    int disp;
                    jpframe.stripPtrs[0].last_qcoef_ptr = disp = (stripNo + jj) * coefPerStrip;
                    this.DCTDStripFromRaster(1, this.dg_nmdus_per_strip, jpframe);
                } else {
                    int sd;
                    for (int ii2 = this.dg_nmdus_per_strip; ii2 > 0; ii2 -= sd) {
                        sd = ii2;
                        if (this.dg_resync != 0) {
                            this.DCTDDecodeResync();
                            if (this.dg_resync_count < ii2) {
                                sd = this.dg_resync_count;
                            }
                            this.dg_resync_count -= sd - 1;
                        }
                        this.DCTDDecodeColor(1, sd, jpscan);
                    }
                }
                lastp += jpframe.padx << 3;
            }
            return;
        }
        int maxv8 = this.dg_maxv * 8;
        int stripNo = (this.dg_out_lines_processed + maxv8 - 1) / maxv8;
        for (ii = 0; ii < this.dg_framecn; ++ii) {
            this.DCTInitStripPtrs(this.dg_jpframe[ii], stripNo);
        }
        if (this.dg_haveQCoefRaster) {
            int nmdus = this.dg_nmdus_per_strip;
            for (ii = 0; ii < this.dg_framecn; ++ii) {
                DCTjframe jpframe = this.dg_jpframe[ii];
                this.DCTDStripFromRaster(jpframe.vs, jpframe.hs * nmdus, jpframe);
            }
        } else {
            ii = this.dg_nmdus_per_strip;
            while (ii-- > 0) {
                if (this.dg_resync != 0) {
                    this.DCTDDecodeResync();
                }
                for (int jj = 0; jj < this.dg_cn; ++jj) {
                    DCTjscan jpscan = this.dg_jpscan[jj];
                    DCTjframe jpframe = jpscan.jpframe;
                    this.DCTDDecodeColor(jpframe.vs, jpframe.hs, jpscan);
                }
            }
        }
    }

    private void DCTDScaleQT(int[] dqarray, int qtabnum) {
        short[] qtizers = this.dg_qtizers[qtabnum];
        for (int i = 0; i < 64; ++i) {
            dqarray[i] = qtizers[i] * DCTDQScale[i];
        }
    }

    private void DCTRevTransform(int[] xform, int lastPtr, int maxCol, int maxRow, DCTjframe jpframe) {
        int a3;
        int b1;
        int a1;
        int a2;
        int a0;
        int a4;
        int a6;
        int a5;
        int a7;
        int xformx = maxCol;
        int padx = jpframe.padx;
        xform[0] = xform[0] + 0x2004000;
        if (maxRow < 4) {
            if (maxRow < 2) {
                if (maxRow < 1) {
                    do {
                        int n = xform[xformx];
                        xform[xformx + 56] = n;
                        xform[xformx + 48] = n;
                        xform[xformx + 40] = n;
                        xform[xformx + 32] = n;
                        xform[xformx + 24] = n;
                        xform[xformx + 16] = n;
                        xform[xformx + 8] = n;
                    } while (--xformx >= 0);
                } else {
                    do {
                        a7 = xform[xformx + 8];
                        a5 = (int)((long)a7 * 46341L >> 16);
                        a6 = (int)((long)a7 * 85627L >> 16);
                        a4 = (int)((long)a7 * 25080L >> 16);
                        a7 += (a6 -= a4);
                        a6 += a5;
                        a0 = xform[xformx];
                        xform[xformx + 8] = a0 + a6;
                        xform[xformx + 48] = a0 - a6;
                        xform[xformx + 16] = a0 + (a5 += a4);
                        xform[xformx + 40] = a0 - a5;
                        xform[xformx + 24] = a0 + a4;
                        xform[xformx + 32] = a0 - a4;
                        xform[xformx] = a0 + a7;
                        xform[xformx + 56] = a0 - a7;
                    } while (--xformx >= 0);
                }
            } else if (maxRow == 2) {
                do {
                    a7 = xform[xformx + 8];
                    a5 = (int)((long)a7 * 46341L >> 16);
                    a6 = (int)((long)a7 * 85627L >> 16);
                    a4 = (int)((long)a7 * 25080L >> 16);
                    a7 += (a6 -= a4);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    a1 = xform[xformx + 16];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a2 + a1;
                    a3 = a2 - a1;
                    a1 = a2 + b1;
                    xform[xformx + 8] = a1 + a6;
                    xform[xformx + 48] = a1 - a6;
                    xform[xformx + 16] = (a2 -= b1) + a5;
                    xform[xformx + 40] = a2 - a5;
                    xform[xformx + 24] = a3 + a4;
                    xform[xformx + 32] = a3 - a4;
                    xform[xformx] = a0 + a7;
                    xform[xformx + 56] = a0 - a7;
                } while (--xformx >= 0);
            } else {
                do {
                    a4 = xform[xformx + 24];
                    a3 = xform[xformx + 8];
                    a5 = a3 - a4;
                    a5 = (int)((long)a5 * 46341L >> 16);
                    a7 = a3 + a4;
                    a6 = (int)((long)a3 * 85627L >> 16);
                    a3 -= a4;
                    a3 = (int)((long)a3 * 25080L >> 16);
                    a4 = (int)((long)a4 * 35468L >> 16);
                    a4 = a3 - a4;
                    a7 += (a6 -= a3);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    a1 = xform[xformx + 16];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a2 + a1;
                    a3 = a2 - a1;
                    a1 = a2 + b1;
                    xform[xformx + 8] = a1 + a6;
                    xform[xformx + 48] = a1 - a6;
                    xform[xformx + 16] = (a2 -= b1) + a5;
                    xform[xformx + 40] = a2 - a5;
                    xform[xformx + 24] = a3 + a4;
                    xform[xformx + 32] = a3 - a4;
                    xform[xformx] = a0 + a7;
                    xform[xformx + 56] = a0 - a7;
                } while (--xformx >= 0);
            }
        } else if (maxRow < 6) {
            if (maxRow <= 4) {
                do {
                    a4 = xform[xformx + 24];
                    a3 = xform[xformx + 8];
                    a5 = a3 - a4;
                    a5 = (int)((long)a5 * 46341L >> 16);
                    a7 = a3 + a4;
                    a6 = (int)((long)a3 * 85627L >> 16);
                    a3 -= a4;
                    a3 = (int)((long)a3 * 25080L >> 16);
                    a4 = (int)((long)a4 * 35468L >> 16);
                    a4 = a3 - a4;
                    a7 += (a6 -= a3);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    b1 = xform[xformx + 32];
                    a3 = a2 + b1;
                    a2 -= b1;
                    a1 = xform[xformx + 16];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a3 + a1;
                    a3 -= a1;
                    a1 = a2 + b1;
                    xform[xformx + 8] = a1 + a6;
                    xform[xformx + 48] = a1 - a6;
                    xform[xformx + 16] = (a2 -= b1) + a5;
                    xform[xformx + 40] = a2 - a5;
                    xform[xformx + 24] = a3 + a4;
                    xform[xformx + 32] = a3 - a4;
                    xform[xformx] = a0 + a7;
                    xform[xformx + 56] = a0 - a7;
                } while (--xformx >= 0);
            } else if (maxRow == 5) {
                do {
                    a4 = xform[xformx + 24];
                    a6 = xform[xformx + 40];
                    a7 = a4 + a6;
                    a4 -= a6;
                    a3 = xform[xformx + 8];
                    a5 = a3 - a7;
                    a5 = (int)((long)a5 * 46341L >> 16);
                    a7 = a3 + a7;
                    a6 = (int)((long)a3 * 85627L >> 16);
                    a3 -= a4;
                    a3 = (int)((long)a3 * 25080L >> 16);
                    a4 = (int)((long)a4 * 35468L >> 16);
                    a4 = a3 - a4;
                    a7 += (a6 -= a3);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    b1 = xform[xformx + 32];
                    a3 = a2 + b1;
                    a2 -= b1;
                    a1 = xform[xformx + 16];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a3 + a1;
                    a3 -= a1;
                    a1 = a2 + b1;
                    xform[xformx + 8] = a1 + a6;
                    xform[xformx + 48] = a1 - a6;
                    xform[xformx + 16] = (a2 -= b1) + a5;
                    xform[xformx + 40] = a2 - a5;
                    xform[xformx + 24] = a3 + a4;
                    xform[xformx + 32] = a3 - a4;
                    xform[xformx] = a0 + a7;
                    xform[xformx + 56] = a0 - a7;
                } while (--xformx >= 0);
            }
        } else {
            do {
                a4 = xform[xformx + 24];
                a6 = xform[xformx + 40];
                a7 = a4 + a6;
                a4 -= a6;
                a3 = xform[xformx + 8];
                a5 = xform[xformx + 56];
                a6 = a3 + a5;
                a3 -= a5;
                a5 = a6 - a7;
                a5 = (int)((long)a5 * 46341L >> 16);
                a7 = a6 + a7;
                a6 = (int)((long)a3 * 85627L >> 16);
                a3 -= a4;
                a3 = (int)((long)a3 * 25080L >> 16);
                a4 = (int)((long)a4 * 35468L >> 16);
                a4 = a3 - a4;
                a7 += (a6 -= a3);
                a6 += a5;
                a5 += a4;
                a2 = xform[xformx];
                b1 = xform[xformx + 32];
                a3 = a2 + b1;
                a2 -= b1;
                a0 = xform[xformx + 48];
                b1 = xform[xformx + 16];
                a1 = b1 + a0;
                b1 -= a0;
                b1 = (int)((long)b1 * 46341L >> 16);
                a1 = b1 + a1;
                a0 = a3 + a1;
                a3 -= a1;
                a1 = a2 + b1;
                xform[xformx + 8] = a1 + a6;
                xform[xformx + 48] = a1 - a6;
                xform[xformx + 16] = (a2 -= b1) + a5;
                xform[xformx + 40] = a2 - a5;
                xform[xformx + 24] = a3 + a4;
                xform[xformx + 32] = a3 - a4;
                xform[xformx] = a0 + a7;
                xform[xformx + 56] = a0 - a7;
            } while (--xformx >= 0);
        }
        xformx = 0;
        int ix = lastPtr;
        short[] cstrip = jpframe.strip;
        if (maxCol < 4) {
            if (maxCol < 2) {
                if (maxCol < 1) {
                    do {
                        a0 = xform[xformx] >> 15;
                        short s = (short)a0;
                        cstrip[ix + 7] = s;
                        cstrip[ix + 6] = s;
                        cstrip[ix + 5] = s;
                        cstrip[ix + 4] = s;
                        cstrip[ix + 3] = s;
                        cstrip[ix + 2] = s;
                        cstrip[ix + 1] = s;
                        cstrip[ix] = s;
                        ix += padx;
                    } while ((xformx += 8) < 64);
                } else {
                    do {
                        a7 = xform[xformx + 1];
                        a5 = (int)((long)a7 * 46341L >> 16);
                        a6 = (int)((long)a7 * 85627L >> 16);
                        a4 = (int)((long)a7 * 25080L >> 16);
                        a6 += a5;
                        a0 = xform[xformx];
                        cstrip[ix] = (short)(a0 + (a7 += (a6 -= a4)) >> 15);
                        cstrip[ix + 1] = (short)(a0 + a6 >> 15);
                        cstrip[ix + 2] = (short)(a0 + (a5 += a4) >> 15);
                        cstrip[ix + 3] = (short)(a0 + a4 >> 15);
                        cstrip[ix + 4] = (short)(a0 - a4 >> 15);
                        cstrip[ix + 5] = (short)(a0 - a5 >> 15);
                        cstrip[ix + 6] = (short)(a0 - a6 >> 15);
                        cstrip[ix + 7] = (short)(a0 - a7 >> 15);
                        ix += padx;
                    } while ((xformx += 8) < 64);
                }
            } else if (maxCol == 2) {
                do {
                    a7 = xform[xformx + 1];
                    a5 = (int)((long)a7 * 46341L >> 16);
                    a6 = (int)((long)a7 * 85627L >> 16);
                    a4 = (int)((long)a7 * 25080L >> 16);
                    a7 += (a6 -= a4);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    a1 = xform[xformx + 2];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a2 + a1;
                    a3 = a2 - a1;
                    a1 = a2 + b1;
                    cstrip[ix] = (short)(a0 + a7 >> 15);
                    cstrip[ix + 1] = (short)(a1 + a6 >> 15);
                    cstrip[ix + 2] = (short)((a2 -= b1) + a5 >> 15);
                    cstrip[ix + 3] = (short)(a3 + a4 >> 15);
                    cstrip[ix + 4] = (short)(a3 - a4 >> 15);
                    cstrip[ix + 5] = (short)(a2 - a5 >> 15);
                    cstrip[ix + 6] = (short)(a1 - a6 >> 15);
                    cstrip[ix + 7] = (short)(a0 - a7 >> 15);
                    ix += padx;
                } while ((xformx += 8) < 64);
            } else {
                do {
                    a4 = xform[xformx + 3];
                    a3 = xform[xformx + 1];
                    a5 = a3 - a4;
                    a5 = (int)((long)a5 * 46341L >> 16);
                    a7 = a3 + a4;
                    a6 = (int)((long)a3 * 85627L >> 16);
                    a3 -= a4;
                    a3 = (int)((long)a3 * 25080L >> 16);
                    a4 = (int)((long)a4 * 35468L >> 16);
                    a4 = a3 - a4;
                    a7 += (a6 -= a3);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    a1 = xform[xformx + 2];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a2 + a1;
                    a3 = a2 - a1;
                    a1 = a2 + b1;
                    cstrip[ix] = (short)(a0 + a7 >> 15);
                    cstrip[ix + 1] = (short)(a1 + a6 >> 15);
                    cstrip[ix + 2] = (short)((a2 -= b1) + a5 >> 15);
                    cstrip[ix + 3] = (short)(a3 + a4 >> 15);
                    cstrip[ix + 4] = (short)(a3 - a4 >> 15);
                    cstrip[ix + 5] = (short)(a2 - a5 >> 15);
                    cstrip[ix + 6] = (short)(a1 - a6 >> 15);
                    cstrip[ix + 7] = (short)(a0 - a7 >> 15);
                    ix += padx;
                } while ((xformx += 8) < 64);
            }
        } else if (maxCol < 6) {
            if (maxCol < 5) {
                do {
                    a4 = xform[xformx + 3];
                    a3 = xform[xformx + 1];
                    a5 = a3 - a4;
                    a5 = (int)((long)a5 * 46341L >> 16);
                    a7 = a3 + a4;
                    a6 = (int)((long)a3 * 85627L >> 16);
                    a3 -= a4;
                    a3 = (int)((long)a3 * 25080L >> 16);
                    a4 = (int)((long)a4 * 35468L >> 16);
                    a4 = a3 - a4;
                    a7 += (a6 -= a3);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    b1 = xform[xformx + 4];
                    a3 = a2 + b1;
                    a2 -= b1;
                    a1 = xform[xformx + 2];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a3 + a1;
                    a3 -= a1;
                    a1 = a2 + b1;
                    cstrip[ix] = (short)(a0 + a7 >> 15);
                    cstrip[ix + 1] = (short)(a1 + a6 >> 15);
                    cstrip[ix + 2] = (short)((a2 -= b1) + a5 >> 15);
                    cstrip[ix + 3] = (short)(a3 + a4 >> 15);
                    cstrip[ix + 4] = (short)(a3 - a4 >> 15);
                    cstrip[ix + 5] = (short)(a2 - a5 >> 15);
                    cstrip[ix + 6] = (short)(a1 - a6 >> 15);
                    cstrip[ix + 7] = (short)(a0 - a7 >> 15);
                    ix += padx;
                } while ((xformx += 8) < 64);
            } else {
                do {
                    a4 = xform[xformx + 3];
                    a6 = xform[xformx + 5];
                    a7 = a4 + a6;
                    a4 -= a6;
                    a3 = xform[xformx + 1];
                    a5 = a3 - a7;
                    a5 = (int)((long)a5 * 46341L >> 16);
                    a7 = a3 + a7;
                    a6 = (int)((long)a3 * 85627L >> 16);
                    a3 -= a4;
                    a3 = (int)((long)a3 * 25080L >> 16);
                    a4 = (int)((long)a4 * 35468L >> 16);
                    a4 = a3 - a4;
                    a7 += (a6 -= a3);
                    a6 += a5;
                    a5 += a4;
                    a2 = xform[xformx];
                    b1 = xform[xformx + 4];
                    a3 = a2 + b1;
                    a2 -= b1;
                    a1 = xform[xformx + 2];
                    b1 = (int)((long)a1 * 46341L >> 16);
                    a1 = b1 + a1;
                    a0 = a3 + a1;
                    a3 -= a1;
                    a1 = a2 + b1;
                    cstrip[ix] = (short)(a0 + a7 >> 15);
                    cstrip[ix + 1] = (short)(a1 + a6 >> 15);
                    cstrip[ix + 2] = (short)((a2 -= b1) + a5 >> 15);
                    cstrip[ix + 3] = (short)(a3 + a4 >> 15);
                    cstrip[ix + 4] = (short)(a3 - a4 >> 15);
                    cstrip[ix + 5] = (short)(a2 - a5 >> 15);
                    cstrip[ix + 6] = (short)(a1 - a6 >> 15);
                    cstrip[ix + 7] = (short)(a0 - a7 >> 15);
                    ix += padx;
                } while ((xformx += 8) < 64);
            }
        } else {
            do {
                a4 = xform[xformx + 3];
                a6 = xform[xformx + 5];
                a7 = a4 + a6;
                a4 -= a6;
                a3 = xform[xformx + 1];
                a5 = xform[xformx + 7];
                a6 = a3 + a5;
                a3 -= a5;
                a5 = a6 - a7;
                a5 = (int)((long)a5 * 46341L >> 16);
                a7 = a6 + a7;
                a6 = (int)((long)a3 * 85627L >> 16);
                a3 -= a4;
                a3 = (int)((long)a3 * 25080L >> 16);
                a4 = (int)((long)a4 * 35468L >> 16);
                a4 = a3 - a4;
                a7 += (a6 -= a3);
                a6 += a5;
                a5 += a4;
                a2 = xform[xformx];
                b1 = xform[xformx + 4];
                a3 = a2 + b1;
                a2 -= b1;
                a0 = xform[xformx + 6];
                b1 = xform[xformx + 2];
                a1 = b1 + a0;
                b1 -= a0;
                b1 = (int)((long)b1 * 46341L >> 16);
                a1 = b1 + a1;
                a0 = a3 + a1;
                a3 -= a1;
                a1 = a2 + b1;
                cstrip[ix] = (short)(a0 + a7 >> 15);
                cstrip[ix + 1] = (short)(a1 + a6 >> 15);
                cstrip[ix + 2] = (short)((a2 -= b1) + a5 >> 15);
                cstrip[ix + 3] = (short)(a3 + a4 >> 15);
                cstrip[ix + 4] = (short)(a3 - a4 >> 15);
                cstrip[ix + 5] = (short)(a2 - a5 >> 15);
                cstrip[ix + 6] = (short)(a1 - a6 >> 15);
                cstrip[ix + 7] = (short)(a0 - a7 >> 15);
                ix += padx;
            } while ((xformx += 8) < 64);
        }
    }

    private void DCTDInitCTBig() {
        int VGconst;
        int UGconst;
        int VRconst;
        int UBconst;
        this.dg_UGtab = new int[2048];
        int[] UGtab = this.dg_UGtab;
        this.dg_VGtab = new int[2048];
        int[] VGtab = this.dg_VGtab;
        if (this.dg_colorconv == 1) {
            UBconst = -118622208;
            VRconst = -93791232;
            UGconst = -46615552;
            VGconst = -95816704;
        } else {
            UBconst = -252839936;
            VRconst = -228008960;
            UGconst = 221819904;
            VGconst = -95816704;
        }
        for (int j = 0; j < 2048; ++j) {
            UGtab[j] = (UGconst & 0xFFFF0000) + (UBconst >> 16 & 0xFFFF);
            VGtab[j] = (VGconst & 0xFFFF0000) + (VRconst >> 16 & 0xFFFF);
            VGconst += 93603;
            VRconst += 91881;
            UGconst += 45107;
            UBconst += 116130;
        }
    }

    private int DCTPointStrip(int stripv, int stripmv, int maxv, int vs) {
        if (vs <= 1) {
            return stripv;
        }
        int linex = stripmv;
        if (maxv == 4) {
            if (vs == 3) {
                linex = stripmv + 1 >>> 1;
            } else if (vs == 2) {
                linex = stripmv >>> 1;
            }
        } else if (vs == maxv - 1) {
            linex = stripmv >>> 1;
        }
        return linex + stripv * vs;
    }

    private void DCTPutNCLine(int stripv, int stripmv) {
        short[] rbfr = this.dg_bigcolorline;
        int rblast = this.dg_nsamps;
        int colorconv = this.dg_colorconv;
        int cn = this.dg_framecn;
        short[] k_strip = null;
        short[] v_strip = null;
        short[] u_strip = null;
        short[] y_strip = null;
        int k_ptr = 0;
        int v_ptr = 0;
        int u_ptr = 0;
        int y_ptr = 0;
        int ix = 0;
        DCTjframe jpframe = this.dg_jpframe[0];
        int maxv = this.dg_maxv;
        y_strip = jpframe.strip;
        y_ptr = this.DCTPointStrip(stripv, stripmv, maxv, jpframe.vs) * jpframe.padx;
        if (cn > 1) {
            jpframe = this.dg_jpframe[1];
            u_strip = jpframe.strip;
            u_ptr = this.DCTPointStrip(stripv, stripmv, maxv, jpframe.vs) * jpframe.padx;
        }
        if (cn > 2) {
            jpframe = this.dg_jpframe[2];
            v_strip = jpframe.strip;
            v_ptr = this.DCTPointStrip(stripv, stripmv, maxv, jpframe.vs) * jpframe.padx;
        }
        if (cn > 3) {
            jpframe = this.dg_jpframe[3];
            k_strip = jpframe.strip;
            k_ptr = this.DCTPointStrip(stripv, stripmv, maxv, jpframe.vs) * jpframe.padx;
        }
        if (stripmv > 0 && this.dg_vFast != 0) {
            switch (cn) {
                case 2: {
                    do {
                        rbfr[ix] = y_strip[y_ptr];
                        rbfr[ix + 2] = y_strip[y_ptr + 1];
                        rbfr[ix + 4] = y_strip[y_ptr + 2];
                        rbfr[ix + 6] = y_strip[y_ptr + 3];
                        y_ptr += 4;
                    } while ((ix += 8) < rblast);
                    return;
                }
                case 3: {
                    if (colorconv != 0) {
                        u_ptr = y_ptr - this.dg_jpframe[0].padx;
                        do {
                            int rb = y_strip[y_ptr] - y_strip[u_ptr];
                            int n = ix;
                            rbfr[n] = (short)(rbfr[n] + rb);
                            int n2 = ix + 1;
                            rbfr[n2] = (short)(rbfr[n2] + rb);
                            int n3 = ix + 2;
                            rbfr[n3] = (short)(rbfr[n3] + rb);
                            rb = y_strip[y_ptr + 1] - y_strip[u_ptr + 1];
                            int n4 = ix + 3;
                            rbfr[n4] = (short)(rbfr[n4] + rb);
                            int n5 = ix + 4;
                            rbfr[n5] = (short)(rbfr[n5] + rb);
                            int n6 = ix + 5;
                            rbfr[n6] = (short)(rbfr[n6] + rb);
                            rb = y_strip[y_ptr + 2] - y_strip[u_ptr + 2];
                            int n7 = ix + 6;
                            rbfr[n7] = (short)(rbfr[n7] + rb);
                            int n8 = ix + 7;
                            rbfr[n8] = (short)(rbfr[n8] + rb);
                            int n9 = ix + 8;
                            rbfr[n9] = (short)(rbfr[n9] + rb);
                            rb = y_strip[y_ptr + 3] - y_strip[u_ptr + 3];
                            int n10 = ix + 9;
                            rbfr[n10] = (short)(rbfr[n10] + rb);
                            int n11 = ix + 10;
                            rbfr[n11] = (short)(rbfr[n11] + rb);
                            int n12 = ix + 11;
                            rbfr[n12] = (short)(rbfr[n12] + rb);
                            y_ptr += 4;
                            u_ptr += 4;
                        } while ((ix += 12) < rblast);
                        return;
                    }
                    do {
                        rbfr[ix] = y_strip[y_ptr];
                        rbfr[ix + 3] = y_strip[y_ptr + 1];
                        rbfr[ix + 6] = y_strip[y_ptr + 2];
                        rbfr[ix + 9] = y_strip[y_ptr + 3];
                        y_ptr += 4;
                    } while ((ix += 12) < rblast);
                    return;
                }
                case 4: {
                    u_ptr = y_ptr - this.dg_jpframe[0].padx;
                    do {
                        int ry = y_strip[y_ptr] - y_strip[u_ptr];
                        int n = ix;
                        rbfr[n] = (short)(rbfr[n] + ry);
                        int n13 = ix + 1;
                        rbfr[n13] = (short)(rbfr[n13] + ry);
                        int n14 = ix + 2;
                        rbfr[n14] = (short)(rbfr[n14] + ry);
                        rbfr[ix + 3] = k_strip[k_ptr];
                        ry = y_strip[y_ptr + 1] - y_strip[u_ptr + 1];
                        int n15 = ix + 4;
                        rbfr[n15] = (short)(rbfr[n15] + ry);
                        int n16 = ix + 5;
                        rbfr[n16] = (short)(rbfr[n16] + ry);
                        int n17 = ix + 6;
                        rbfr[n17] = (short)(rbfr[n17] + ry);
                        rbfr[ix + 7] = k_strip[k_ptr + 1];
                        y_ptr += 2;
                        u_ptr += 2;
                        k_ptr += 2;
                    } while ((ix += 8) < rblast);
                    return;
                }
            }
        }
        if (this.dg_hFast != 0) {
            int[] UGtab = this.dg_UGtab;
            int[] VGtab = this.dg_VGtab;
            switch (this.dg_hFast) {
                case 1: {
                    do {
                        rbfr[ix] = y_strip[y_ptr];
                        short s = u_strip[u_ptr];
                        rbfr[ix + 4] = s;
                        rbfr[ix + 1] = s;
                        short s2 = v_strip[v_ptr];
                        rbfr[ix + 5] = s2;
                        rbfr[ix + 2] = s2;
                        rbfr[ix + 3] = y_strip[y_ptr + 1];
                        rbfr[ix + 6] = y_strip[y_ptr + 2];
                        short s3 = u_strip[u_ptr + 1];
                        rbfr[ix + 10] = s3;
                        rbfr[ix + 7] = s3;
                        short s4 = v_strip[v_ptr + 1];
                        rbfr[ix + 11] = s4;
                        rbfr[ix + 8] = s4;
                        rbfr[ix + 9] = y_strip[y_ptr + 3];
                        y_ptr += 4;
                        u_ptr += 2;
                        v_ptr += 2;
                    } while ((ix += 12) < rblast);
                    return;
                }
                case 2: {
                    do {
                        short rb = y_strip[y_ptr];
                        int ub = u_strip[u_ptr];
                        int vr = v_strip[v_ptr];
                        if ((ub & 0xFFFFF800) != 0) {
                            ub = ~ub >>> 21;
                        }
                        if ((vr & 0xFFFFF800) != 0) {
                            vr = ~vr >>> 21;
                        }
                        ub = UGtab[ub];
                        vr = VGtab[vr];
                        int uvg = ub + vr >> 17;
                        rbfr[ix] = (short)(rb + vr);
                        rbfr[ix + 1] = (short)(rb - uvg);
                        rbfr[ix + 2] = (short)(rb + ub);
                        ++y_ptr;
                        ++u_ptr;
                        ++v_ptr;
                    } while ((ix += 3) < rblast);
                    return;
                }
                case 3: {
                    do {
                        int ub = u_strip[u_ptr];
                        int vr = v_strip[v_ptr];
                        if ((ub & 0xFFFFF800) != 0) {
                            ub = ~ub >>> 21;
                        }
                        if ((vr & 0xFFFFF800) != 0) {
                            vr = ~vr >>> 21;
                        }
                        ub = UGtab[ub];
                        vr = VGtab[vr];
                        int uvg = ub + vr >> 17;
                        short rb = y_strip[y_ptr];
                        rbfr[ix] = (short)(rb + vr);
                        rbfr[ix + 1] = (short)(rb - uvg);
                        rbfr[ix + 2] = (short)(rb + ub);
                        rb = y_strip[y_ptr + 1];
                        rbfr[ix + 3] = (short)(rb + vr);
                        rbfr[ix + 4] = (short)(rb - uvg);
                        rbfr[ix + 5] = (short)(rb + ub);
                        y_ptr += 2;
                        ++u_ptr;
                        ++v_ptr;
                    } while ((ix += 6) < rblast);
                    return;
                }
                case 4: {
                    do {
                        short ry = -y_strip[y_ptr];
                        int ub = u_strip[u_ptr];
                        int vr = v_strip[v_ptr];
                        if ((ub & 0xFFFFF800) != 0) {
                            ub = ~ub >>> 21;
                        }
                        if ((vr & 0xFFFFF800) != 0) {
                            vr = ~vr >>> 21;
                        }
                        ub = UGtab[ub];
                        vr = VGtab[vr];
                        int uvg = ub + vr >> 17;
                        rbfr[ix] = (short)(ry - vr);
                        rbfr[ix + 1] = (short)(ry + uvg);
                        rbfr[ix + 2] = (short)(ry - ub);
                        rbfr[ix + 3] = k_strip[k_ptr];
                        ++y_ptr;
                        ++u_ptr;
                        ++v_ptr;
                        ++k_ptr;
                    } while ((ix += 4) < rblast);
                    return;
                }
                case 5: {
                    do {
                        int ub = u_strip[u_ptr];
                        int vr = v_strip[v_ptr];
                        if ((ub & 0xFFFFF800) != 0) {
                            ub = ~ub >>> 21;
                        }
                        if ((vr & 0xFFFFF800) != 0) {
                            vr = ~vr >>> 21;
                        }
                        ub = UGtab[ub];
                        vr = VGtab[vr];
                        int uvg = ub + vr >> 17;
                        short ry = -y_strip[y_ptr];
                        rbfr[ix] = (short)(ry - vr);
                        rbfr[ix + 1] = (short)(ry + uvg);
                        rbfr[ix + 2] = (short)(ry - ub);
                        rbfr[ix + 3] = k_strip[k_ptr];
                        ry = -y_strip[y_ptr + 1];
                        rbfr[ix + 4] = (short)(ry - vr);
                        rbfr[ix + 5] = (short)(ry + uvg);
                        rbfr[ix + 6] = (short)(ry - ub);
                        rbfr[ix + 7] = k_strip[k_ptr + 1];
                        y_ptr += 2;
                        ++u_ptr;
                        ++v_ptr;
                        k_ptr += 2;
                    } while ((ix += 8) < rblast);
                    return;
                }
            }
        }
        int hk = 0;
        int hv = 0;
        int hu = 0;
        int hy = 0;
        hy = this.dg_jpframe[0].hs;
        if (cn > 1) {
            hu = this.dg_jpframe[1].hs;
        }
        if (cn > 2) {
            hv = this.dg_jpframe[2].hs;
        }
        if (cn > 3) {
            hk = this.dg_jpframe[3].hs;
        }
        switch ((this.dg_maxh << 2) + cn - 5) {
            case 0: 
            case 4: 
            case 8: 
            case 12: {
                System.arraycopy(y_strip, y_ptr, rbfr, ix, this.dg_nsamps);
                return;
            }
            case 3: {
                do {
                    rbfr[ix] = y_strip[y_ptr];
                    rbfr[ix + 4] = y_strip[y_ptr + 1];
                    rbfr[ix + 8] = y_strip[y_ptr + 2];
                    rbfr[ix + 12] = y_strip[y_ptr + 3];
                    y_ptr += 4;
                    rbfr[ix + 1] = u_strip[u_ptr];
                    rbfr[ix + 5] = u_strip[u_ptr + 1];
                    rbfr[ix + 9] = u_strip[u_ptr + 2];
                    rbfr[ix + 13] = u_strip[u_ptr + 3];
                    u_ptr += 4;
                    rbfr[ix + 2] = v_strip[v_ptr];
                    rbfr[ix + 6] = v_strip[v_ptr + 1];
                    rbfr[ix + 10] = v_strip[v_ptr + 2];
                    rbfr[ix + 14] = v_strip[v_ptr + 3];
                    v_ptr += 4;
                    rbfr[ix + 3] = k_strip[k_ptr];
                    rbfr[ix + 7] = k_strip[k_ptr + 1];
                    rbfr[ix + 11] = k_strip[k_ptr + 2];
                    rbfr[ix + 15] = k_strip[k_ptr + 3];
                    k_ptr += 4;
                } while ((ix += 16) < rblast);
                return;
            }
            case 2: {
                do {
                    rbfr[ix] = y_strip[y_ptr];
                    rbfr[ix + 3] = y_strip[y_ptr + 1];
                    rbfr[ix + 6] = y_strip[y_ptr + 2];
                    rbfr[ix + 9] = y_strip[y_ptr + 3];
                    y_ptr += 4;
                    rbfr[ix + 1] = u_strip[u_ptr];
                    rbfr[ix + 4] = u_strip[u_ptr + 1];
                    rbfr[ix + 7] = u_strip[u_ptr + 2];
                    rbfr[ix + 10] = u_strip[u_ptr + 3];
                    u_ptr += 4;
                    rbfr[ix + 2] = v_strip[v_ptr];
                    rbfr[ix + 5] = v_strip[v_ptr + 1];
                    rbfr[ix + 8] = v_strip[v_ptr + 2];
                    rbfr[ix + 11] = v_strip[v_ptr + 3];
                    v_ptr += 4;
                } while ((ix += 12) < rblast);
                return;
            }
            case 1: {
                do {
                    rbfr[ix] = y_strip[y_ptr];
                    rbfr[ix + 2] = y_strip[y_ptr + 1];
                    rbfr[ix + 4] = y_strip[y_ptr + 2];
                    rbfr[ix + 6] = y_strip[y_ptr + 3];
                    y_ptr += 4;
                    rbfr[ix + 1] = u_strip[u_ptr];
                    rbfr[ix + 3] = u_strip[u_ptr + 1];
                    rbfr[ix + 5] = u_strip[u_ptr + 2];
                    rbfr[ix + 7] = u_strip[u_ptr + 3];
                    u_ptr += 4;
                } while ((ix += 8) < rblast);
                return;
            }
            case 7: {
                do {
                    rbfr[ix] = y_strip[y_ptr];
                    rbfr[ix + 1] = u_strip[u_ptr];
                    rbfr[ix + 2] = v_strip[v_ptr];
                    rbfr[ix + 3] = k_strip[k_ptr];
                    rbfr[ix + 4] = y_strip[(y_ptr += hy) - 1];
                    rbfr[ix + 5] = u_strip[(u_ptr += hu) - 1];
                    rbfr[ix + 6] = v_strip[(v_ptr += hv) - 1];
                    rbfr[ix + 7] = k_strip[(k_ptr += hk) - 1];
                } while ((ix += 8) < rblast);
                break;
            }
            case 6: {
                do {
                    rbfr[ix] = y_strip[y_ptr];
                    rbfr[ix + 1] = u_strip[u_ptr];
                    rbfr[ix + 2] = v_strip[v_ptr];
                    rbfr[ix + 3] = y_strip[(y_ptr += hy) - 1];
                    rbfr[ix + 4] = u_strip[(u_ptr += hu) - 1];
                    rbfr[ix + 5] = v_strip[(v_ptr += hv) - 1];
                } while ((ix += 6) < rblast);
                break;
            }
            case 5: {
                do {
                    rbfr[ix] = y_strip[y_ptr];
                    rbfr[ix + 1] = u_strip[u_ptr];
                    rbfr[ix + 2] = y_strip[(y_ptr += hy) - 1];
                    rbfr[ix + 3] = u_strip[(u_ptr += hu) - 1];
                } while ((ix += 4) < rblast);
                return;
            }
            case 13: 
            case 14: 
            case 15: {
                short v2;
                short u1;
                short y0;
                do {
                    short u3;
                    short u2;
                    short y3;
                    short y2;
                    short y1;
                    int n = ix++;
                    short s = y_strip[y_ptr++];
                    rbfr[n] = s;
                    y0 = s;
                    switch (hy) {
                        case 4: {
                            y1 = y_strip[y_ptr++];
                            y2 = y_strip[y_ptr++];
                            y3 = y_strip[y_ptr++];
                            break;
                        }
                        case 3: {
                            y2 = y1 = y_strip[y_ptr++];
                            y3 = y_strip[y_ptr++];
                            break;
                        }
                        case 2: {
                            y1 = y0;
                            y3 = y2 = y_strip[y_ptr++];
                            break;
                        }
                        default: {
                            y2 = y1 = y0;
                            y3 = y1;
                        }
                    }
                    int n18 = ix++;
                    short s5 = u_strip[u_ptr++];
                    rbfr[n18] = s5;
                    short u0 = s5;
                    switch (hu) {
                        case 4: {
                            u1 = u_strip[u_ptr++];
                            u2 = u_strip[u_ptr++];
                            u3 = u_strip[u_ptr++];
                            break;
                        }
                        case 3: {
                            u2 = u1 = u_strip[u_ptr++];
                            u3 = u_strip[u_ptr++];
                            break;
                        }
                        case 2: {
                            u1 = u0;
                            u3 = u2 = u_strip[u_ptr++];
                            break;
                        }
                        default: {
                            u2 = u1 = u0;
                            u3 = u1;
                        }
                    }
                    if (cn >= 3) {
                        short v3;
                        short v1;
                        int n19 = ix++;
                        short s6 = v_strip[v_ptr++];
                        rbfr[n19] = s6;
                        short v0 = s6;
                        switch (hv) {
                            case 4: {
                                v1 = v_strip[v_ptr++];
                                v2 = v_strip[v_ptr++];
                                v3 = v_strip[v_ptr++];
                                break;
                            }
                            case 3: {
                                v2 = v1 = v_strip[v_ptr++];
                                v3 = v_strip[v_ptr++];
                                break;
                            }
                            case 2: {
                                v1 = v0;
                                v3 = v2 = v_strip[v_ptr++];
                                break;
                            }
                            default: {
                                v2 = v1 = v0;
                                v3 = v1;
                            }
                        }
                        if (cn >= 4) {
                            short k3;
                            short k2;
                            short k1;
                            int n20 = ix++;
                            short s7 = k_strip[k_ptr++];
                            rbfr[n20] = s7;
                            short k0 = s7;
                            switch (hk) {
                                case 4: {
                                    k1 = k_strip[k_ptr++];
                                    k2 = k_strip[k_ptr++];
                                    k3 = k_strip[k_ptr++];
                                    break;
                                }
                                case 3: {
                                    k2 = k1 = k_strip[k_ptr++];
                                    k3 = k_strip[k_ptr++];
                                    break;
                                }
                                case 2: {
                                    k1 = k0;
                                    k3 = k2 = k_strip[k_ptr++];
                                    break;
                                }
                                default: {
                                    k2 = k1 = k0;
                                    k3 = k1;
                                }
                            }
                            rbfr[ix] = y1;
                            rbfr[ix + 1] = u1;
                            rbfr[ix + 2] = v1;
                            rbfr[ix + 3] = k1;
                            rbfr[ix + 4] = y2;
                            rbfr[ix + 5] = u2;
                            rbfr[ix + 6] = v2;
                            rbfr[ix + 7] = k2;
                            rbfr[ix + 8] = y3;
                            rbfr[ix + 9] = u3;
                            rbfr[ix + 10] = v3;
                            rbfr[ix + 11] = k3;
                            ix += 12;
                            continue;
                        }
                        rbfr[ix] = y1;
                        rbfr[ix + 1] = u1;
                        rbfr[ix + 2] = v1;
                        rbfr[ix + 3] = y2;
                        rbfr[ix + 4] = u2;
                        rbfr[ix + 5] = v2;
                        rbfr[ix + 6] = y3;
                        rbfr[ix + 7] = u3;
                        rbfr[ix + 8] = v3;
                        ix += 9;
                        continue;
                    }
                    rbfr[ix] = y1;
                    rbfr[ix + 1] = u1;
                    rbfr[ix + 2] = y2;
                    rbfr[ix + 3] = u2;
                    rbfr[ix + 4] = y3;
                    rbfr[ix + 5] = u3;
                    ix += 6;
                } while (ix < rblast);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                short v2;
                short u1;
                short y0;
                do {
                    short u2;
                    short y2;
                    short y1;
                    int n = ix++;
                    short s = y_strip[y_ptr++];
                    rbfr[n] = s;
                    y0 = s;
                    switch (hy) {
                        case 3: {
                            y1 = y_strip[y_ptr++];
                            y2 = y_strip[y_ptr++];
                            break;
                        }
                        case 1: {
                            y2 = y1 = y0;
                            break;
                        }
                        default: {
                            y2 = y_strip[y_ptr++];
                            y1 = (short)(y0 + y2 + 1 >> 1);
                        }
                    }
                    int n21 = ix++;
                    short s8 = u_strip[u_ptr++];
                    rbfr[n21] = s8;
                    short u0 = s8;
                    switch (hu) {
                        case 3: {
                            u1 = u_strip[u_ptr++];
                            u2 = u_strip[u_ptr++];
                            break;
                        }
                        case 1: {
                            u2 = u1 = u0;
                            break;
                        }
                        default: {
                            u2 = u_strip[u_ptr++];
                            u1 = (short)(u0 + u2 + 1 >> 1);
                        }
                    }
                    if (cn >= 3) {
                        short v1;
                        int n22 = ix++;
                        short s9 = v_strip[v_ptr++];
                        rbfr[n22] = s9;
                        short v0 = s9;
                        switch (hv) {
                            case 3: {
                                v1 = v_strip[v_ptr++];
                                v2 = v_strip[v_ptr++];
                                break;
                            }
                            case 1: {
                                v2 = v1 = v0;
                                break;
                            }
                            default: {
                                v2 = v_strip[v_ptr++];
                                v1 = (short)(v0 + v2 + 1 >> 1);
                            }
                        }
                        if (cn >= 4) {
                            short k2;
                            short k1;
                            int n23 = ix++;
                            short s10 = k_strip[k_ptr++];
                            rbfr[n23] = s10;
                            short k0 = s10;
                            switch (hk) {
                                case 3: {
                                    k1 = k_strip[k_ptr++];
                                    k2 = k_strip[k_ptr++];
                                    break;
                                }
                                case 1: {
                                    k2 = k1 = k0;
                                    break;
                                }
                                default: {
                                    k2 = k_strip[k_ptr++];
                                    k1 = (short)(k0 + k2 + 1 >> 1);
                                }
                            }
                            rbfr[ix] = y1;
                            rbfr[ix + 1] = u1;
                            rbfr[ix + 2] = v1;
                            rbfr[ix + 3] = k1;
                            rbfr[ix + 4] = y2;
                            rbfr[ix + 5] = u2;
                            rbfr[ix + 6] = v2;
                            rbfr[ix + 7] = k2;
                            ix += 8;
                            continue;
                        }
                        rbfr[ix] = y1;
                        rbfr[ix + 1] = u1;
                        rbfr[ix + 2] = v1;
                        rbfr[ix + 3] = y2;
                        rbfr[ix + 4] = u2;
                        rbfr[ix + 5] = v2;
                        ix += 6;
                        continue;
                    }
                    rbfr[ix] = y1;
                    rbfr[ix + 1] = u1;
                    rbfr[ix + 2] = y2;
                    rbfr[ix + 3] = u2;
                    ix += 4;
                } while (ix < rblast);
            }
        }
        if (colorconv != 0) {
            int[] UGtab = this.dg_UGtab;
            int[] VGtab = this.dg_VGtab;
            ix = 0;
            switch (colorconv) {
                case 1: {
                    do {
                        short rb = rbfr[ix];
                        int ub = rbfr[ix + 1];
                        int vr = rbfr[ix + 2];
                        if ((ub & 0xFFFFF800) != 0) {
                            ub = ~ub >>> 21;
                        }
                        if ((vr & 0xFFFFF800) != 0) {
                            vr = ~vr >>> 21;
                        }
                        ub = UGtab[ub];
                        vr = VGtab[vr];
                        int uvg = ub + vr >> 17;
                        rbfr[ix] = (short)(rb + vr);
                        rbfr[ix + 1] = (short)(rb - uvg);
                        rbfr[ix + 2] = (short)(rb + ub);
                    } while ((ix += 3) < rblast);
                    break;
                }
                case 2: {
                    do {
                        short ry = -rbfr[ix];
                        int ub = rbfr[ix + 1];
                        int vr = rbfr[ix + 2];
                        if ((ub & 0xFFFFF800) != 0) {
                            ub = ~ub >>> 21;
                        }
                        if ((vr & 0xFFFFF800) != 0) {
                            vr = ~vr >>> 21;
                        }
                        ub = UGtab[ub];
                        vr = VGtab[vr];
                        int uvg = ub + vr >> 17;
                        rbfr[ix] = (short)(ry - vr);
                        rbfr[ix + 1] = (short)(ry + uvg);
                        rbfr[ix + 2] = (short)(ry - ub);
                    } while ((ix += 4) < rblast);
                }
            }
        }
    }
}

